/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.CumulativeDuration;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;

public class CumulativeDurationToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected CumulativeDuration cumulativeDuration;
    protected AJLJButton buttonApplyCumulativeDuration;
    protected JTextField textFieldThresholdLevel;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public CumulativeDurationToolManager(SeisGram2KFrame seisGram2KFrame) {
        String string;
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        double d = 0.5;
        double d2 = 0.1;
        double d3 = -1.0;
        double d4 = 0.0;
        this.cumulativeDuration = new CumulativeDuration(SeisGramText.getLocaleString(), d, d2, d3, d4);
        try {
            string = null;
            string = seisGram2KFrame.getParameter("pick.cumdur.threshold");
            if (string != null) {
                this.cumulativeDuration.setThresholdLevel(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = seisGram2KFrame.getParameter("pick.cumdur.cutoff");
            if (string != null) {
                this.cumulativeDuration.setCutoffLevel(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = seisGram2KFrame.getParameter("pick.cumdur.durfract");
            if (string != null) {
                this.cumulativeDuration.setDurationFraction(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = seisGram2KFrame.getParameter("pick.cumdur.durmin");
            if (string != null) {
                this.cumulativeDuration.setDurationMin(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        this.commandNames = new String[]{"cumdur"};
        this.commandNamesShort = new String[]{"cdur"};
    }

    public void updateLabel() {
        this.label = SeisGramText.CUMULATIVE_DURATION;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyCumulativeDuration = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyCumulativeDuration);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.MIN_AMPLITUDE + ":", 4));
        this.textFieldThresholdLevel = SwingExt.newJTextField(this, this, String.valueOf(this.cumulativeDuration.thresholdLevel), 5);
        jToolBar.add(this.textFieldThresholdLevel);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyCumulativeDuration)) {
            boolean bl = false;
            try {
                this.cumulativeDuration.setThresholdLevel(this.textFieldThresholdLevel.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldThresholdLevel.setText(String.valueOf(this.cumulativeDuration.thresholdLevel));
            if (bl) {
                return;
            }
            try {
                this.cumulativeDuration.checkSettings();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldThresholdLevel)) {
            try {
                this.cumulativeDuration.setThresholdLevel(this.textFieldThresholdLevel.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldThresholdLevel.setText(String.valueOf(this.cumulativeDuration.thresholdLevel));
            return;
        }
    }

    protected void setPicks() {
        Vector vector = this.cumulativeDuration.getPickData();
        String string = "T";
        string = string + String.valueOf(this.cumulativeDuration.thresholdLevel);
        for (int i = 0; i < vector.size(); ++i) {
            PickData pickData = (PickData)vector.elementAt(i);
            this.seisFrame.getActiveGather().setPickFromPickData(pickData, string);
        }
        this.seisFrame.writePicks();
    }

    protected void apply() throws TimeDomainException {
        this.cumulativeDuration.checkSettings();
        this.seisFrame.applyTimeDomainProcess(this.cumulativeDuration, this.getCommandString());
        this.setPicks();
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("th")) {
                        this.cumulativeDuration.setThresholdLevel(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("cu")) {
                        this.cumulativeDuration.setCutoffLevel(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("du")) {
                        this.cumulativeDuration.setDurationFraction(stringTokenizer.nextToken());
                        this.cumulativeDuration.setDurationMin(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " thres " + this.cumulativeDuration.thresholdLevel;
        string = string + " cutoff " + this.cumulativeDuration.cutoffLevel;
        string = string + " durfract " + this.cumulativeDuration.durationFraction + " " + this.cumulativeDuration.durationMin;
        return string;
    }
}

