/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.freq.Convolve;
import net.alomax.freq.FilterException;
import net.alomax.math.TimeSeries;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;

public class ConvolveToolManager
extends JToolManager {
    public static final String REF_CENTER = "WINDOW_CENTER";
    public static final String REF_START = "WINDOW_START";
    public static final String REF_ZERO_TO_PEAK_MAX = "0-P_max";
    protected String[] masterReferenceNames;
    protected String masterReferenceName;
    protected SeisGram2KFrame seisFrame;
    protected Convolve convolve;
    protected AJLJButton buttonApplyConvolve;
    protected JTextField textFieldMasterIndex;
    protected JComboBox choiceType;
    protected JComboBox masterReference;
    protected JTextField textFieldWaterLevel;
    protected int masterIndex;
    protected int masterIndexSeis;
    protected double masterRefTime;
    protected String[] typeNames;
    protected double waterLevel;
    protected static final int DEFAULT = 0;
    protected String[] commandNames;
    protected String[] commandNamesShort;
    protected int variant;
    protected String argumentString;

    public ConvolveToolManager(SeisGram2KFrame seisGram2KFrame) {
        block11: {
            String string;
            String string2;
            this.masterReferenceNames = new String[]{REF_CENTER, REF_START, REF_ZERO_TO_PEAK_MAX};
            this.masterReferenceName = REF_CENTER;
            this.seisFrame = null;
            this.masterIndex = 0;
            this.masterIndexSeis = 0;
            this.masterRefTime = 0.0;
            this.typeNames = new String[]{"CONVOLUTION", "DECONVOLUTION"};
            this.waterLevel = -1.0;
            this.commandNames = new String[0];
            this.commandNamesShort = new String[0];
            this.variant = 0;
            this.argumentString = "";
            this.seisFrame = seisGram2KFrame;
            this.updateLabel();
            this.convolve = new Convolve(SeisGramText.getLocaleString(), null);
            try {
                string2 = null;
                string2 = seisGram2KFrame.getParameter("freq.convolve.type");
                if (string2 != null) {
                    this.convolve.setType(string2);
                }
            }
            catch (FilterException filterException) {
                seisGram2KFrame.writeMessage("ERROR: " + filterException.toString());
            }
            string2 = null;
            string2 = seisGram2KFrame.getParameter("freq.convolve.master.ref");
            if (string2 != null) {
                this.masterReferenceName = string2;
            }
            try {
                string = null;
                string = seisGram2KFrame.getParameter("freq.convolve.master.index");
                if (string != null) {
                    this.masterIndex = Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                seisGram2KFrame.writeMessage("ERROR: " + exception.toString());
                this.masterIndex = 0;
            }
            try {
                string = null;
                string = seisGram2KFrame.getParameter("freq.convolve.waterlevel");
                if (string == null) break block11;
                try {
                    this.waterLevel = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    this.waterLevel = -1.0;
                }
                this.convolve.setWaterLevel(this.waterLevel);
                this.waterLevel = this.convolve.getWaterLevel();
            }
            catch (FilterException filterException) {
                seisGram2KFrame.writeMessage("ERROR: " + filterException.toString());
            }
        }
        this.commandNames = new String[]{"convolve"};
        this.commandNamesShort = new String[]{"con"};
    }

    public void updateLabel() {
        this.label = SeisGramText.CONVOLVE;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyConvolve = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyConvolve);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.MASTER_INDEX + ":", 4));
        this.textFieldMasterIndex = SwingExt.newJTextField(this, this, String.valueOf(this.masterIndex), 5);
        jToolBar.add(this.textFieldMasterIndex);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.TYPE + ":", 4));
        this.choiceType = SwingExt.newChoice(this, this.typeNames);
        this.choiceType.setSelectedItem(this.convolve.getType());
        jToolBar.add(this.choiceType);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.MASTER_REF_TIME + ":", 4));
        this.masterReference = SwingExt.newChoice(this, this.masterReferenceNames);
        this.masterReference.setEditable(true);
        this.masterReference.setSelectedItem(this.masterReferenceName);
        jToolBar.add(this.masterReference);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.WATER_LEVEL + ":", 4));
        this.textFieldWaterLevel = SwingExt.newJTextField(this, this, String.valueOf(this.convolve.getWaterLevel()), 5);
        jToolBar.add(this.textFieldWaterLevel);
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyConvolve)) {
            boolean bl = false;
            int n = -1;
            try {
                n = Integer.parseInt(this.textFieldMasterIndex.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (this.seisFrame.getGatherListElementAt(n) == null) {
                this.seisFrame.writeMessage(SeisGramText.ERROR_MASTER_INDEX_NOT_FOUND);
                bl = true;
            } else {
                this.masterIndex = n;
            }
            this.textFieldMasterIndex.setText(String.valueOf(this.masterIndex));
            try {
                this.convolve.setType((String)this.choiceType.getSelectedItem());
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
                bl = true;
            }
            this.masterReferenceName = (String)this.masterReference.getSelectedItem();
            this.masterRefTime = this.seisFrame.getGatherListElementAt(this.masterIndex).getOffsetToFeature(this.masterIndexSeis, this.masterReferenceName.trim());
            if (Double.isNaN(this.masterRefTime)) {
                this.seisFrame.writeMessage(SeisGramText.ERROR_MASTER_FEATURE_NOT_FOUND);
                bl = true;
            }
            try {
                this.waterLevel = Double.parseDouble(this.textFieldWaterLevel.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.convolve.setWaterLevel(this.waterLevel);
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
                bl = true;
            }
            this.waterLevel = this.convolve.getWaterLevel();
            if (bl) {
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldMasterIndex)) {
            try {
                this.masterIndex = Integer.parseInt(this.textFieldMasterIndex.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.textFieldMasterIndex.setText(String.valueOf(this.masterIndex));
            return;
        }
        if (actionEvent.getSource().equals(this.masterReference)) {
            this.masterReferenceName = (String)this.masterReference.getSelectedItem();
            this.masterRefTime = this.seisFrame.getGatherListElementAt(this.masterIndex).getOffsetToFeature(this.masterIndexSeis, this.masterReferenceName.trim());
            if (Double.isNaN(this.masterRefTime)) {
                this.seisFrame.writeMessage(SeisGramText.ERROR_MASTER_FEATURE_NOT_FOUND);
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldWaterLevel)) {
            try {
                this.waterLevel = Double.parseDouble(this.textFieldWaterLevel.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.convolve.setWaterLevel(this.waterLevel);
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
            }
            this.waterLevel = this.convolve.getWaterLevel();
            return;
        }
    }

    protected void apply() throws FilterException {
        GatherPanel gatherPanel = this.seisFrame.getGatherListElementAt(this.masterIndex);
        TimeSeries[] timeSeriesArray = gatherPanel.getAllTimeSeries();
        this.convolve.setMasterTimeSeries(timeSeriesArray);
        this.masterRefTime = gatherPanel.getOffsetToFeature(this.masterIndexSeis, this.masterReferenceName.trim());
        if (Double.isNaN(this.masterRefTime)) {
            this.seisFrame.writeMessage(SeisGramText.ERROR_MASTER_FEATURE_NOT_FOUND);
            return;
        }
        this.convolve.checkSettings();
        Object[] objectArray = new Object[2];
        objectArray[0] = this.convolve.getType() == "CONVOLUTION" ? new Double(-this.masterRefTime) : new Double(this.masterRefTime);
        this.seisFrame.applyFreqProcess(this.convolve, objectArray, this.getCommandString());
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("ma")) {
                        this.masterIndex = Integer.parseInt(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("ty")) {
                        this.convolve.setType(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("re")) {
                        this.masterReferenceName = stringTokenizer.nextToken();
                        this.masterRefTime = this.seisFrame.getGatherListElementAt(this.masterIndex).getOffsetToFeature(this.masterIndexSeis, this.masterReferenceName);
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("wa")) {
                        this.convolve.setWaterLevel(Double.parseDouble(stringTokenizer.nextToken()));
                        this.waterLevel = this.convolve.getWaterLevel();
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (FilterException filterException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + filterException.toString(), string, string2);
        }
        catch (Exception exception) {
            throw new JToolManagerException("Parsing or applying command: " + exception.getMessage(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " master " + this.masterIndex + " type " + this.convolve.getType() + " ref " + this.masterReferenceName.trim() + " wa " + this.convolve.getWaterLevel();
        return string;
    }
}

