/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.monitor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.alomax.util.NumberFormat;

public class MonitorStatusPanel
extends JPanel {
    protected JLabel dataLatencyLabel = null;
    protected JLabel feedLatencyLabel = null;
    protected double[] latencyLimits = new double[0];
    protected int nStatusDec = 0;
    protected Color[] latencyColors = new Color[0];
    protected Color nullLatencyColor = Color.gray;
    protected Color negativeLatencyColor = Color.white;
    protected Font fixedWidthFont = null;
    protected double lastDataLatency = -1.7976931348623157E308;
    protected double lastFeedLatency = -1.7976931348623157E308;
    protected String lastDataLatencyLabelText = "";
    protected String lastDataFeedLabelText = "";
    protected String nullString = "?????";

    public MonitorStatusPanel(double[] dArray, int n) {
        this.latencyLimits = dArray;
        this.nStatusDec = n;
        int n2 = dArray.length + 1;
        this.latencyColors = new Color[n2];
        int n3 = 0;
        int n4 = 255;
        int n5 = 0;
        int n6 = 510 / (n2 - 1);
        for (int i = 0; i < n2; ++i) {
            this.latencyColors[i] = new Color(n3, n4, n5);
            if (i < n2 / 2 && (n3 += n6) > 255) {
                n3 = 255;
            }
            if (i < n2 / 2 || (n4 -= n6) >= 0) continue;
            n4 = 0;
        }
        this.setLayout(new GridLayout(0, 1));
        this.dataLatencyLabel = new JLabel();
        this.setDataLatency(Double.NaN);
        this.add(this.dataLatencyLabel);
        this.dataLatencyLabel.setBackground(this.nullLatencyColor);
        this.dataLatencyLabel.setOpaque(true);
        this.feedLatencyLabel = new JLabel();
        this.setFeedLatency(Double.NaN);
        this.add(this.feedLatencyLabel);
        this.feedLatencyLabel.setBackground(this.nullLatencyColor);
        this.feedLatencyLabel.setOpaque(true);
    }

    public String setDataLatency(double d) {
        if (d == this.lastDataLatency) {
            return this.lastDataLatencyLabelText;
        }
        String string = null;
        if (d == Double.NaN) {
            this.dataLatencyLabel.setBackground(this.nullLatencyColor);
            string = "Ld=" + this.getLatencyText(Double.NaN);
        } else if (d < 0.0) {
            this.dataLatencyLabel.setBackground(this.negativeLatencyColor);
            string = "Ld=" + this.getLatencyText(d);
        } else {
            int n;
            for (n = 0; n < this.latencyLimits.length && !(d <= this.latencyLimits[n]); ++n) {
            }
            this.dataLatencyLabel.setBackground(this.latencyColors[n]);
            string = "Ld=" + this.getLatencyText(d);
        }
        this.dataLatencyLabel.setText(string);
        this.lastDataLatency = d;
        this.lastDataLatencyLabelText = string;
        return string;
    }

    public String setFeedLatency(double d) {
        if (d == this.lastFeedLatency) {
            return this.lastDataFeedLabelText;
        }
        String string = null;
        if (d == Double.NaN) {
            this.feedLatencyLabel.setBackground(this.nullLatencyColor);
            string = "Lf=" + this.getLatencyText(Double.NaN);
        } else if (d < 0.0) {
            this.feedLatencyLabel.setBackground(this.negativeLatencyColor);
            string = "Lf=" + this.getLatencyText(d);
        } else {
            int n;
            for (n = 0; n < this.latencyLimits.length && !(d <= this.latencyLimits[n]); ++n) {
            }
            this.feedLatencyLabel.setBackground(this.latencyColors[n]);
            string = "Lf=" + this.getLatencyText(d);
        }
        this.feedLatencyLabel.setText(string);
        this.lastFeedLatency = d;
        this.lastDataFeedLabelText = string;
        return this.lastDataFeedLabelText;
    }

    public String getLatencyText(double d) {
        Object var3_2 = null;
        if (d == Double.NaN) {
            return this.nullString;
        }
        double d2 = d;
        String string = "";
        if (d2 < 0.0) {
            string = "-";
            d2 *= -1.0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (d2 >= 60.0) {
            d2 -= 60.0;
            ++n;
        }
        if (d2 == -0.0) {
            d2 = 0.0;
        }
        while (d2 < 0.0) {
            d2 += 60.0;
            --n;
        }
        while (n >= 60) {
            n -= 60;
            ++n2;
        }
        while (n < 0) {
            n += 60;
            --n2;
        }
        while (n2 >= 24) {
            n2 -= 24;
            ++n3;
        }
        while (n2 < 0) {
            n2 += 24;
            --n3;
        }
        if (n3 > 0) {
            return new String(string + NumberFormat.intString(n3, 3) + "d" + NumberFormat.intString(n2, 2) + "h");
        }
        if (n2 > 0) {
            return new String(string + NumberFormat.intString(n2, 2) + "h" + NumberFormat.intString(n, 2) + "m");
        }
        String string2 = null;
        string2 = this.nStatusDec > 0 ? NumberFormat.decimalString(d2, 3 + this.nStatusDec, this.nStatusDec, true) + "s" : NumberFormat.intString((int)d2, 2) + "s";
        if (n > 0) {
            return new String(string + NumberFormat.intString(n, 2) + "m" + string2);
        }
        return new String(string + string2);
    }

    public void paint(Graphics graphics) {
        try {
            if (this.fixedWidthFont == null) {
                try {
                    Font font = graphics.getFont();
                    this.fixedWidthFont = new Font("Monospaced", font.getStyle(), font.getSize());
                    this.dataLatencyLabel.setFont(this.fixedWidthFont);
                    this.feedLatencyLabel.setFont(this.fixedWidthFont);
                    this.validate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.paint(graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

