/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.monitor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.IndicatorJPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.monitor.MonitorClient;
import net.alomax.seisgram2k.monitor.MonitorStatusPanel;
import net.alomax.util.Clock;
import net.alomax.util.SystemClock;

public abstract class MonitorManager
implements ActionListener {
    public static String CLASS_NAME;
    protected static String className;
    protected static final GatherPanel CLOSED_GATHER;
    protected static Clock activeClock;
    protected static int numberManagers;
    protected static final int READ_SEG = 0;
    protected static final int APPEND_SEG = 1;
    protected MonitorClient monitorClient = null;
    protected Runnable runnableClient = null;
    protected Thread clientThread = null;
    protected Hashtable gatherTable = new Hashtable();
    protected SeisGram2KFrame seisFrame = null;
    protected boolean groupMode = true;
    protected int windowLength = 600;
    public boolean windowMode = false;
    public boolean closed = false;
    protected double minPeakToPeakAmplitude = -1.0;
    protected double maxPeakToPeakAmplitude = Double.MAX_VALUE;
    public double multiplier = Double.MAX_VALUE;
    public String onReadCommands = null;
    public String title = "";
    protected double[] latencyLimits = new double[0];
    protected int nStatusDec = 0;
    protected boolean dumpStatus = true;

    public MonitorManager(SeisGram2KFrame seisGram2KFrame, boolean bl, double[] dArray) throws Exception {
        this(seisGram2KFrame, bl, dArray, 0, false);
    }

    public MonitorManager(SeisGram2KFrame seisGram2KFrame, boolean bl, double[] dArray, int n, boolean bl2) throws Exception {
        this.seisFrame = seisGram2KFrame;
        activeClock = new SystemClock();
        seisGram2KFrame.setClock(activeClock);
        this.groupMode = bl;
        this.latencyLimits = dArray;
        this.nStatusDec = n;
        this.dumpStatus = bl2;
        className = CLASS_NAME + "[" + (numberManagers + 1) + "]";
    }

    public void start() throws Exception {
        if (!this.windowMode) {
            this.seisFrame.addRealtimeTimerActionListener(this);
        }
        this.clientThread = new Thread(this.runnableClient);
        this.clientThread.start();
    }

    public void close(String string) {
        block5: {
            this.seisFrame.removeRealtimeActionListener(this);
            if (string != null) {
                System.out.println("ERROR: " + className + ": " + string);
            }
            try {
                this.monitorClient.close();
            }
            catch (Exception exception) {
                if (!SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) break block5;
                exception.printStackTrace();
            }
        }
        if (this.clientThread != null) {
            this.clientThread.stop();
        }
        this.closed = true;
        if (--numberManagers < 0) {
            numberManagers = 0;
        }
    }

    public double getNominalWindowLength() {
        return this.windowLength;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isWindowMode() {
        return this.windowMode;
    }

    protected synchronized void doPreDisplay(GatherPanel gatherPanel) {
        double d;
        double d2;
        double d3;
        if (this.minPeakToPeakAmplitude > 0.0 && gatherPanel.ampMax - gatherPanel.ampMin < this.minPeakToPeakAmplitude) {
            d3 = (gatherPanel.ampMin + gatherPanel.ampMax) / 2.0;
            d2 = d3 - this.minPeakToPeakAmplitude / 2.0;
            d = d3 + this.minPeakToPeakAmplitude / 2.0;
            gatherPanel.setAmpRange(d2, d);
        }
        if (this.maxPeakToPeakAmplitude > 0.0 && gatherPanel.ampMax - gatherPanel.ampMin > this.maxPeakToPeakAmplitude) {
            d3 = (gatherPanel.ampMin + gatherPanel.ampMax) / 2.0;
            d2 = d3 - this.maxPeakToPeakAmplitude / 2.0;
            d = d3 + this.maxPeakToPeakAmplitude / 2.0;
            gatherPanel.setAmpRange(d2, d);
        }
        gatherPanel.setGatherTitle(this.title);
    }

    protected synchronized void doPreProcessing(Seismogram seismogram) {
        if (this.multiplier != Double.MAX_VALUE) {
            seismogram.multiply(this.multiplier);
        }
    }

    public int getChannelIndex(String string) {
        if (string.toUpperCase().endsWith("Z")) {
            return 0;
        }
        if (string.toUpperCase().endsWith("N")) {
            return 1;
        }
        if (string.toUpperCase().endsWith("E")) {
            return 2;
        }
        if (string.toUpperCase().endsWith("0")) {
            return 0;
        }
        if (string.toUpperCase().endsWith("1")) {
            return 1;
        }
        if (string.toUpperCase().endsWith("2")) {
            return 2;
        }
        return 0;
    }

    public GatherPanel findRelatedGather(String string) {
        Enumeration enumeration = this.gatherTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.substring(0, string2.length() - 1).equals(string.substring(0, string.length() - 1))) continue;
            return (GatherPanel)this.gatherTable.get(string2);
        }
        return null;
    }

    public void gatherClosing(GatherPanel gatherPanel) {
        Enumeration enumeration = this.gatherTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.gatherTable.get(string) != gatherPanel) continue;
            this.gatherTable.put(string, CLOSED_GATHER);
        }
    }

    protected void updateStatusPanel(GatherPanel gatherPanel) {
        if (gatherPanel.getNumberSeismograms() < 1) {
            return;
        }
        String string = null;
        String string2 = null;
        try {
            MonitorStatusPanel monitorStatusPanel = (MonitorStatusPanel)gatherPanel.getAuxilliaryPanel();
            if (monitorStatusPanel == null) {
                return;
            }
            string = monitorStatusPanel.setDataLatency(gatherPanel.getDataLatency());
            string2 = monitorStatusPanel.setFeedLatency(gatherPanel.getFeedLatency());
        }
        catch (Exception exception) {
            return;
        }
        this.dumpStatus(gatherPanel, string, string2);
    }

    protected void dumpStatus(GatherPanel gatherPanel, String string, String string2) {
        if (!this.dumpStatus) {
            return;
        }
        String string3 = null;
        try {
            string3 = gatherPanel.getSeismogram(0).getStaInstID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = null;
        try {
            string4 = activeClock.getTimeUTCString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(string3 + ": " + string4 + ": " + string + ", " + string2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.seisFrame.getRealtimeTimer()) {
            try {
                boolean bl;
                Enumeration enumeration = this.gatherTable.elements();
                boolean bl2 = bl = this.gatherTable.size() > 0;
                while (enumeration.hasMoreElements()) {
                    GatherPanel gatherPanel = (GatherPanel)enumeration.nextElement();
                    if (gatherPanel == CLOSED_GATHER) continue;
                    this.updateStatusPanel(gatherPanel);
                    bl = false;
                }
                if (bl) {
                    this.seisFrame.closeMonitorManager(this);
                }
                if (this.monitorClient != null && !this.monitorClient.isConnected()) {
                    this.seisFrame.setIndicator(IndicatorJPanel.INDICATOR_ERROR);
                } else {
                    this.seisFrame.setIndicator(IndicatorJPanel.INDICATOR_OFF);
                }
            }
            catch (Exception exception) {
                if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                    exception.printStackTrace();
                }
                System.out.println("INFO: " + className + ": actionPerformed(): Exception ignored: " + exception);
            }
        }
    }

    static {
        className = CLASS_NAME = "MonitorManager";
        CLOSED_GATHER = new GatherPanel(null);
        activeClock = null;
        numberManagers = 0;
    }
}

