/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.commandmenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.commandmenu.SyntheticDialog;
import net.alomax.swing.JCommandMenu;
import net.alomax.swing.JCommandMenuException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.FunctionGenerator;
import net.alomax.timedom.TimeDomainException;

public class SyntheticCommandMenu
extends JCommandMenu
implements ActionListener {
    protected SeisGram2KFrame seisFrame = null;
    protected JMenuItem menuItemInsertSynthetic_Impulse;
    protected JMenuItem menuItemInsertSynthetic_Sine;
    protected FunctionGenerator funcGen = null;
    protected double sampleInt = 0.01;
    protected int numberPoints = 1024;
    protected static int cmd_count = 0;
    protected static final int CMD_FUNCGEN = cmd_count++;
    protected String[] commandNames = new String[]{"funcgen"};
    protected String[] commandNamesShort = new String[]{"fgen"};
    protected int variant = 0;
    protected String argumentString = "";

    public SyntheticCommandMenu(SeisGram2KFrame seisGram2KFrame) {
        super(SeisGramText.SYNTHETIC_TRACE);
        this.seisFrame = seisGram2KFrame;
        this.menuItemInsertSynthetic_Impulse = SwingExt.newJMenuItem(this, "Impulse");
        this.add(this.menuItemInsertSynthetic_Impulse);
        this.menuItemInsertSynthetic_Sine = SwingExt.newJMenuItem(this, "Sine");
        this.add(this.menuItemInsertSynthetic_Sine);
        this.funcGen = new FunctionGenerator(SeisGramText.getLocaleString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.menuItemInsertSynthetic_Impulse)) {
            this.doInsertSyntheticDialog(0);
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemInsertSynthetic_Sine)) {
            this.doInsertSyntheticDialog(1);
            return;
        }
    }

    protected void doInsertSyntheticDialog(int n) {
        Seismogram seismogram = null;
        try {
            seismogram = this.seisFrame.getActiveGather().getSeismogram(this.seisFrame.getActiveGather().getActiveSeismogram());
        }
        catch (Exception exception) {
            seismogram = null;
        }
        SyntheticDialog syntheticDialog = new SyntheticDialog(this.seisFrame, seismogram, n);
        if (!syntheticDialog.doEdit()) {
            return;
        }
        try {
            if (n == 0) {
                this.applyCommand(this.commandNames[0] + " " + "Impulse" + " " + syntheticDialog.index + " delta " + syntheticDialog.sampleInt + " npts " + syntheticDialog.numberPoints);
            } else if (n == 1) {
                this.applyCommand(this.commandNames[0] + " " + "Sine" + " " + syntheticDialog.frequency + " " + syntheticDialog.phase + " delta " + syntheticDialog.sampleInt + " npts " + syntheticDialog.numberPoints);
            }
        }
        catch (JCommandMenuException jCommandMenuException) {
            this.seisFrame.writeMessage(jCommandMenuException.getMessage());
        }
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JCommandMenuException {
        if (!this.isCommandHandler(string)) {
            throw new JCommandMenuException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant == CMD_FUNCGEN) {
                String string3 = stringTokenizer.nextToken();
                this.funcGen.setType(string3);
                int n = this.funcGen.getType();
                double[] dArray = new double[]{};
                if (n == 0) {
                    dArray = new double[]{Double.parseDouble(stringTokenizer.nextToken())};
                } else if (n == 1) {
                    dArray = new double[]{Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())};
                }
                this.funcGen.setParams(dArray);
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("delta")) {
                        this.sampleInt = Double.parseDouble(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("npts")) {
                        this.numberPoints = Integer.parseInt(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JCommandMenuException("Parsing or applying command", string, string2);
                }
                Seismogram seismogram = new Seismogram(this.seisFrame, this.sampleInt, this.numberPoints);
                GatherPanel gatherPanel = this.seisFrame.createEmptyGatherPanel();
                gatherPanel.addSeismogram(seismogram, 0);
                this.seisFrame.addGather(gatherPanel, true, true, false);
                this.seisFrame.applyTimeDomainProcess(this.funcGen, this.getCommandString(), true, false);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JCommandMenuException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JCommandMenuException("Parsing or applying command", string, string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JCommandMenuException("Parsing or applying command", string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        if (this.variant == CMD_FUNCGEN) {
            if (this.funcGen.type == 0) {
                string = string + " " + "Impulse".toUpperCase() + " " + this.funcGen.params[0];
            } else if (this.funcGen.type == 1) {
                string = string + " " + "Sine".toUpperCase() + " " + this.funcGen.params[0] + " " + this.funcGen.params[1];
            }
            string = string + " delta " + this.sampleInt;
            string = string + " npts " + this.numberPoints;
        }
        return string;
    }
}

