/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.alomax.awt.AJLColor;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JPolygonButton;

public class SelectPanel
extends JPanel
implements ActionListener,
KeyListener {
    private GatherPanel gather;
    protected JPanel subPanel;
    protected JPolygonButton buttonDuplicate;
    protected AJLJButton buttonClose;
    protected AJLJButton buttonInfo;
    protected AJLJButton[] buttonSeis;
    protected boolean destroyed = false;
    protected boolean fontNotSet = true;

    SelectPanel(GatherPanel gatherPanel) {
        this.gather = gatherPanel;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.buttonClose = new AJLJButton(this, this, "X");
        this.buttonClose.setBorder(new EmptyBorder(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.buttonClose, gridBagConstraints);
        this.add(this.buttonClose);
        this.subPanel = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagLayout.setConstraints(this.subPanel, gridBagConstraints2);
        this.add(this.subPanel);
        this.buttonInfo = new AJLJButton(this, this, "i");
        this.buttonInfo.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.buttonInfo.setForeground(Color.white);
        this.buttonInfo.setBackground(Color.blue);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 0.01;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridwidth = 0;
        gridBagLayout.setConstraints(this.buttonInfo, gridBagConstraints3);
        this.add(this.buttonInfo);
        int[] nArray = new int[]{100, 100, 750, 750};
        int[] nArray2 = new int[]{400, 800, 800, 400};
        int[] nArray3 = new int[]{250, 250, 900, 900};
        int[] nArray4 = new int[]{200, 600, 600, 200};
        Polygon[] polygonArray = new Polygon[]{new Polygon(nArray, nArray2, nArray.length), new Polygon(nArray3, nArray4, nArray3.length)};
        this.buttonDuplicate = new JPolygonButton(polygonArray, null, this, this, false);
        this.buttonDuplicate.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.buttonDuplicate.setPolygonLineColor(AJLColor.controlLtHighlight);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 0.01;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridwidth = 0;
        gridBagLayout.setConstraints(this.buttonDuplicate, gridBagConstraints4);
        this.add(this.buttonDuplicate);
        this.createSelectSubPanel();
    }

    protected void createSelectSubPanel() {
        if (this.subPanel.getComponentCount() == this.gather.seismograms.length) {
            return;
        }
        this.subPanel.removeAll();
        this.subPanel.setLayout(new GridLayout(this.gather.seismograms.length, 1));
        this.buttonSeis = new AJLJButton[this.gather.seismograms.length];
        for (int i = 0; i < this.gather.seismograms.length; ++i) {
            this.buttonSeis[i] = new AJLJButton(this, this, "");
            this.subPanel.add(this.buttonSeis[i]);
        }
    }

    public void setSeisButtonColor(int n, Color color) {
        try {
            this.buttonSeis[n].setBackground(color);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getNumberSeisButtons() {
        return this.subPanel.getComponentCount();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontNotSet = true;
    }

    public void paint(Graphics graphics) {
        if (this.destroyed) {
            return;
        }
        try {
            if (this.fontNotSet) {
                Font font = this.getFont();
                this.buttonClose.setFont(new Font(font.getName(), 1, font.getSize()));
                this.buttonInfo.setFont(new Font(font.getName(), 3, font.getSize()));
                this.buttonDuplicate.setFont(new Font(font.getName(), 1, font.getSize()));
                double d = (double)font.getSize() / (double)graphics.getFont().getSize();
                this.buttonDuplicate.setPolygonImage(d);
                if (this.destroyed) {
                    return;
                }
                this.fontNotSet = false;
            }
            super.paint(graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        this.destroyed = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonClose)) {
            this.gather.close();
        } else if (actionEvent.getSource().equals(this.buttonInfo)) {
            this.gather.displaySeisInfo(this.gather.activeSeismogram);
        } else if (actionEvent.getSource().equals(this.buttonDuplicate)) {
            this.gather.duplicate();
        } else {
            for (int i = 0; i < this.gather.seismograms.length; ++i) {
                if (!actionEvent.getSource().equals(this.buttonSeis[i])) continue;
                this.gather.selectSeis(i);
                break;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
    }
}

