/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.IOException;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.io.BinaryInputStream;
import net.alomax.math.TimeSeries;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicChannel;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.seis.SeisException;
import net.alomax.util.BinaryType;
import net.alomax.util.PhysicalUnits;
import sdsu.io.ASCIIInputStream;

public class SeisDataKikuchi
extends SeisData {
    public static final boolean DEBUG = false;
    public static final int READ_OBS = 0;
    public static final int READ_OBS_SYN = 1;
    public static final int READ_GREEN = 2;
    protected static int readType = 1;
    protected double write_slowness = 0.0;
    protected double write_gFactor = 0.0;
    protected int write_ix0 = 0;
    protected int write_ib = 0;
    protected static String read_green_name = "";
    protected static double read_green_dt = 0.0;
    protected static int read_green_nk = 0;
    protected static int read_green_k0 = 0;
    protected static int read_green_nt = 0;
    protected static String read_green_current_staName = "";
    protected static int read_green_current_nm0 = 0;
    protected static final int NM0_MAX = 6;
    protected static int read_green_current_nk = 0;
    protected static String read_synth_id = "";
    protected static int read_synth_js = 0;
    protected static int read_synth_nt = 0;
    protected static double read_synth_dt = 0.0;
    protected static int read_synth_ne = 0;
    protected static double read_synth_t1 = 0.0;
    protected static double read_synth_t2 = 0.0;
    protected static int read_synth_ms = 0;
    protected static double[] read_synth_so = new double[0];
    protected static int read_synth_nlen = 0;
    protected static double read_synth_dk = 0.0;
    protected static int read_synth_nk = 0;
    protected static int read_synth_k0 = 0;
    protected static double[] read_synth_fr = new double[0];
    protected static double[] read_synth_ffi = new double[0];
    protected static int read_synth_ns = 0;
    protected static double read_synth_ta = 0.0;
    protected static double read_synth_ra = 0.0;
    protected static double read_synth_fi = 0.0;
    protected static double read_synth_yax = 0.0;
    protected static int read_synth_m0 = 0;
    protected static double read_synth_dm0 = 0.0;
    protected static double read_synth_stk = 0.0;
    protected static double read_synth_dp = 0.0;
    protected static double read_synth_sl = 0.0;
    protected static int read_synth_mxy = 0;
    protected static double[] read_synth_taxs = new double[3];
    protected static double read_synth_xp_over_xower = 0.0;
    protected static String[] read_synth_staName = null;
    protected static int read_synth_current_js = 0;
    protected static int[] read_synth_im = new int[0];
    protected static int[] read_synth_ib = new int[0];
    protected static int[] read_synth_ic = new int[0];
    protected static double[] read_synth_az = new double[0];
    protected static double[] read_synth_pv = new double[0];
    protected static String os_arch = "";
    protected static int binaryType = 0;
    protected static int machineBits = 32;
    protected float[] sample = null;

    public SeisDataKikuchi() {
        SeisDataKikuchi.initArchitecture();
    }

    public SeisDataKikuchi(TimeSeries timeSeries, BasicChannel basicChannel, String string, BasicHypocenter basicHypocenter, double d, double d2, double d3, double d4, int n, int n2, int n3, int n4, double d5, double d6) {
        super(timeSeries, basicChannel, string, basicHypocenter, d, d2, d3, d4, n, n2, n3, n4, d5, d6);
        SeisDataKikuchi.initArchitecture();
    }

    public static void initArchitecture() {
        machineBits = BinaryType.getArchitectureMachineBits();
        binaryType = BinaryType.getArchitectureBinaryType();
    }

    public static int canRead(BinaryInputStream binaryInputStream) {
        return 1;
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        return -1;
    }

    public static void setReadType(int n) {
        readType = n;
    }

    public static int getReadType() {
        return readType;
    }

    public void setFormatSpecificFieldsWrite(int n, double d, double d2, int n2) {
        this.write_ib = n;
        this.write_slowness = d;
        this.write_gFactor = d2;
        this.write_ix0 = n2;
    }

    public void setSeismogramFields() {
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
        this.mergeMetaData(basicSeismogram);
    }

    public void write(ASCIIOutputStream aSCIIOutputStream) throws Exception {
        double d;
        double d2;
        String string = System.getProperty("line.separator");
        this.sample = this.timeSeries.getSampleAsFloat();
        double d3 = 1.0;
        boolean bl = true;
        d3 = PhysicalUnits.scaleFactor(this.timeSeries.ampUnits, "micron");
        if (d2 > 0.0) {
            bl = true;
        } else {
            double d4;
            d3 = PhysicalUnits.scaleFactor(PhysicalUnits.timeIntegral(this.timeSeries.ampUnits), "micron");
            if (d4 > 0.0) {
                bl = false;
            } else {
                throw new SeisException("SeisDataKikuchi: cannot convert data to displacement or velocity in micrometers.");
            }
        }
        aSCIIOutputStream.writeWord(this.channel.network.replace(' ', '_') + "_" + this.channel.staName.replace(' ', '_'));
        aSCIIOutputStream.writeWord(string);
        double d5 = this.az;
        if (d5 > 180.0) {
            d5 -= 360.0;
        }
        if ((d = this.baz) > 180.0) {
            d -= 360.0;
        }
        aSCIIOutputStream.writeWord("" + (float)d5 + " ");
        aSCIIOutputStream.writeWord("" + (float)d + " ");
        aSCIIOutputStream.writeWord("" + (float)this.gcarc + " ");
        aSCIIOutputStream.writeWord("" + (float)this.write_slowness + " ");
        aSCIIOutputStream.writeWord("" + (float)this.write_gFactor + " ");
        aSCIIOutputStream.writeWord("" + this.write_ix0 + " ");
        aSCIIOutputStream.writeWord(string);
        aSCIIOutputStream.writeWord("1 ");
        aSCIIOutputStream.writeWord("" + this.write_ib + " ");
        if (this.channel.compName.equalsIgnoreCase("Z")) {
            aSCIIOutputStream.writeWord("1 ");
        } else if (this.channel.compName.equalsIgnoreCase("N")) {
            aSCIIOutputStream.writeWord("2 ");
        } else if (this.channel.compName.equalsIgnoreCase("E")) {
            aSCIIOutputStream.writeWord("3 ");
        }
        aSCIIOutputStream.writeWord(string);
        aSCIIOutputStream.writeWord("0 0 ");
        if (bl) {
            aSCIIOutputStream.writeWord("0 ");
        } else {
            aSCIIOutputStream.writeWord("1 ");
        }
        aSCIIOutputStream.writeWord(string);
        aSCIIOutputStream.writeWord("1.0 1.0 ");
        aSCIIOutputStream.writeWord(string);
        double d6 = Math.max(Math.abs(this.timeSeries.ampMin), Math.abs(this.timeSeries.ampMax));
        aSCIIOutputStream.writeWord("" + (float)(d3 * d6) + " ");
        aSCIIOutputStream.writeWord("" + this.timeSeries.sampleLength() + " ");
        aSCIIOutputStream.writeWord("" + (float)this.timeSeries.sampleInt + " ");
        double d7 = 1.0 / this.timeSeries.ampMax;
        for (int i = 0; i < this.sample.length; ++i) {
            if (i % 10 == 0) {
                aSCIIOutputStream.writeWord(string);
            }
            aSCIIOutputStream.writeWord("" + (float)(d7 * (double)this.sample[i]) + " ");
        }
        aSCIIOutputStream.writeWord(string);
        aSCIIOutputStream.flush();
    }

    public void read(BinaryInputStream binaryInputStream) throws Exception {
        if (readType == 2) {
            this.readGreensFunctions(binaryInputStream);
        } else if (readType == 1) {
            this.readObservedMinusSynthetic(binaryInputStream);
        } else if (readType == 0) {
            this.readObserved(binaryInputStream);
        }
    }

    public static void readHeader(BinaryInputStream binaryInputStream) throws Exception {
        if (readType == 2) {
            SeisDataKikuchi.readGreensFunctionsHeader(binaryInputStream);
        } else if (readType == 0 || readType == 1) {
            SeisDataKikuchi.readObservedSytheticHeader(binaryInputStream);
        }
    }

    public static void readGreensFunctionsHeader(BinaryInputStream binaryInputStream) throws Exception {
        SeisDataKikuchi.initArchitecture();
        binaryInputStream.setBinaryType(binaryType);
        int[] nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_green_name = binaryInputStream.readStringBnoTrim(40);
        float f = binaryInputStream.readFloatB();
        float f2 = binaryInputStream.readFloatB();
        read_green_dt = binaryInputStream.readFloatB();
        float f3 = binaryInputStream.readFloatB();
        float f4 = binaryInputStream.readFloatB();
        float f5 = binaryInputStream.readFloatB();
        read_green_nk = binaryInputStream.readIntB();
        read_green_k0 = binaryInputStream.readIntB();
        read_green_nt = binaryInputStream.readIntB();
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_green_current_nm0 = 0;
        read_green_current_nk = 0;
    }

    public void readGreensFunctions(BinaryInputStream binaryInputStream) throws Exception {
        binaryInputStream.setBinaryType(binaryType);
        int[] nArray = null;
        if (read_green_current_nk == 0) {
            if (read_green_current_nm0 == 0) {
                nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
                read_green_current_staName = binaryInputStream.readStringBnoTrim(12);
                nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
            }
        }
        this.channel.staName = read_green_current_staName.trim();
        this.channel.chanName = "d" + read_green_current_nk + "_M" + (read_green_current_nm0 + 1);
        this.sample = new float[read_green_nt];
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        for (int i = 0; i < this.sample.length; ++i) {
            this.sample[i] = binaryInputStream.readFloatB();
        }
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        this.timeSeries = new TimeSeriesFloat(this.sample, read_green_dt, 0.0, "micron", "sec");
        if (++read_green_current_nm0 == 6) {
            read_green_current_nm0 = 0;
            read_green_current_nk = read_green_current_nk++ % read_green_nk;
        }
    }

    public static void readObservedSytheticHeader(BinaryInputStream binaryInputStream) throws Exception {
        int n;
        SeisDataKikuchi.initArchitecture();
        binaryInputStream.setBinaryType(binaryType);
        int[] nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_synth_id = binaryInputStream.readStringBnoTrim(40);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_synth_js = binaryInputStream.readIntB();
        read_synth_nt = binaryInputStream.readIntB();
        read_synth_dt = binaryInputStream.readFloatB();
        read_synth_ne = binaryInputStream.readIntB();
        read_synth_t1 = binaryInputStream.readFloatB();
        read_synth_t2 = binaryInputStream.readFloatB();
        read_synth_ms = binaryInputStream.readIntB();
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_synth_so = new double[read_synth_nt];
        for (n = 0; n < read_synth_so.length; ++n) {
            SeisDataKikuchi.read_synth_so[n] = binaryInputStream.readFloatB();
        }
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_synth_nlen = binaryInputStream.readIntB();
        read_synth_dk = binaryInputStream.readFloatB();
        read_synth_nk = binaryInputStream.readIntB();
        read_synth_k0 = binaryInputStream.readIntB();
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_synth_fr = new double[read_synth_nlen];
        read_synth_ffi = new double[read_synth_nlen];
        for (n = 0; n < read_synth_fr.length; ++n) {
            SeisDataKikuchi.read_synth_fr[n] = binaryInputStream.readFloatB();
            SeisDataKikuchi.read_synth_ffi[n] = binaryInputStream.readFloatB();
        }
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_synth_staName = new String[read_synth_js];
        read_synth_im = new int[read_synth_js];
        read_synth_ib = new int[read_synth_js];
        read_synth_ic = new int[read_synth_js];
        read_synth_az = new double[read_synth_js];
        read_synth_pv = new double[read_synth_js];
        if (readType == 0) {
            return;
        }
        for (read_synth_current_js = 0; read_synth_current_js < read_synth_js; ++read_synth_current_js) {
            SeisDataKikuchi.readObservedSkip(binaryInputStream);
        }
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_synth_ns = binaryInputStream.readIntB();
        read_synth_ta = binaryInputStream.readFloatB();
        read_synth_ra = binaryInputStream.readFloatB();
        read_synth_fi = binaryInputStream.readFloatB();
        read_synth_yax = binaryInputStream.readFloatB();
        read_synth_m0 = binaryInputStream.readIntB();
        read_synth_dm0 = binaryInputStream.readFloatB();
        read_synth_stk = binaryInputStream.readFloatB();
        read_synth_dp = binaryInputStream.readFloatB();
        read_synth_sl = binaryInputStream.readFloatB();
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_synth_mxy = binaryInputStream.readIntB();
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        for (n = 0; n < read_synth_taxs.length; ++n) {
            SeisDataKikuchi.read_synth_taxs[n] = binaryInputStream.readFloatB();
        }
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_synth_xp_over_xower = binaryInputStream.readFloatB();
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        read_synth_current_js = 0;
    }

    public static void readObservedSkip(BinaryInputStream binaryInputStream) throws Exception {
        binaryInputStream.setBinaryType(binaryType);
        int[] nArray = null;
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        SeisDataKikuchi.read_synth_staName[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readStringBnoTrim(12);
        SeisDataKikuchi.read_synth_im[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readIntB();
        SeisDataKikuchi.read_synth_ib[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readIntB();
        SeisDataKikuchi.read_synth_ic[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readIntB();
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        SeisDataKikuchi.read_synth_az[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readFloatB();
        SeisDataKikuchi.read_synth_pv[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readFloatB();
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        for (int i = 0; i < read_synth_nt; ++i) {
            binaryInputStream.readFloatB();
        }
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
    }

    public void readObservedMinusSynthetic(BinaryInputStream binaryInputStream) throws Exception {
        System.out.println(">>>>>>>>>> readObservedMinusSynthetic");
        if (read_synth_current_js >= read_synth_js) {
            throw new IOException();
        }
        binaryInputStream.setBinaryType(binaryType);
        int[] nArray = null;
        this.channel.staName = read_synth_staName[read_synth_current_js].trim();
        this.channel.chanName = "O-S_m" + read_synth_im[read_synth_current_js] + "_b" + read_synth_ib[read_synth_current_js] + "_c" + read_synth_ic[read_synth_current_js];
        this.sample = new float[read_synth_nt];
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        for (int i = 0; i < this.sample.length; ++i) {
            this.sample[i] = binaryInputStream.readFloatB();
        }
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        this.timeSeries = new TimeSeriesFloat(this.sample, read_synth_dt, 0.0, "micron", "sec");
        ++read_synth_current_js;
    }

    public void readObserved(BinaryInputStream binaryInputStream) throws Exception {
        System.out.println(">>>>>>>>>> readObserved");
        if (read_synth_current_js >= read_synth_js) {
            throw new IOException();
        }
        binaryInputStream.setBinaryType(binaryType);
        int[] nArray = null;
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        SeisDataKikuchi.read_synth_staName[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readStringBnoTrim(12);
        SeisDataKikuchi.read_synth_im[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readIntB();
        SeisDataKikuchi.read_synth_ib[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readIntB();
        SeisDataKikuchi.read_synth_ic[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readIntB();
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        SeisDataKikuchi.read_synth_az[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readFloatB();
        SeisDataKikuchi.read_synth_pv[SeisDataKikuchi.read_synth_current_js] = binaryInputStream.readFloatB();
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        this.channel.staName = read_synth_staName[read_synth_current_js].trim();
        this.channel.chanName = "Obs_m" + read_synth_im[read_synth_current_js] + "_b" + read_synth_ib[read_synth_current_js] + "_c" + read_synth_ic[read_synth_current_js];
        this.sample = new float[read_synth_nt];
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        for (int i = 0; i < this.sample.length; ++i) {
            this.sample[i] = binaryInputStream.readFloatB();
        }
        nArray = binaryInputStream.readFortranHeaderTrailer(machineBits);
        this.timeSeries = new TimeSeriesFloat(this.sample, read_synth_dt, 0.0, "micron", "sec");
        ++read_synth_current_js;
    }
}

