/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.IOException;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.util.TimeInstant;
import sdsu.io.ASCIIInputStream;

public class SeisDataDeprem
extends SeisData {
    String staPlace;
    Double staLatitude;
    Double staLongitude;
    String dateStr;
    String directionStr;
    int numData;
    float sampleInterval;
    float maxValue;
    String eqEpicenterCoordStr;
    String eqMagnitudeStr;
    float[] sample;
    String dataUnits;

    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        try {
            String string = aSCIIInputStream.readLine();
            string = aSCIIInputStream.readLine();
            this.staPlace = string.substring(string.indexOf(58) + 1);
            string = aSCIIInputStream.readLine();
            String string2 = string.substring(string.indexOf(58) + 1);
            string = aSCIIInputStream.readLine();
            this.dateStr = string.substring(string.indexOf(58) + 1);
            string = aSCIIInputStream.readLine();
            this.directionStr = string.substring(string.indexOf(58) + 1);
            string = aSCIIInputStream.readLine();
            String string3 = string.substring(string.indexOf(58) + 1);
            this.numData = Integer.parseInt(string3.trim());
            string = aSCIIInputStream.readLine();
            String string4 = string.substring(string.indexOf(58) + 1);
            this.sampleInterval = new Float(string4).floatValue();
            string = aSCIIInputStream.readLine();
            String string5 = string.substring(string.indexOf(58) + 1);
            this.maxValue = new Float(string5).floatValue();
            this.dataUnits = "mG";
            string = aSCIIInputStream.readLine();
            this.eqEpicenterCoordStr = string.substring(string.indexOf(58) + 1);
            string = aSCIIInputStream.readLine();
            this.eqMagnitudeStr = string.substring(string.indexOf(58) + 1);
            string = aSCIIInputStream.readLine();
            string = aSCIIInputStream.readLine();
            aSCIIInputStream.flushLine();
            this.sample = new float[this.numData];
            for (int i = 0; i < this.numData && !aSCIIInputStream.eof(); ++i) {
                this.sample[i] = aSCIIInputStream.readFloat();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public void setSeismogramFields() {
        SeisDataDeprem seisDataDeprem = this;
        this.timeSeries = new TimeSeriesFloat(seisDataDeprem.sample, seisDataDeprem.sampleInterval, 0.0, this.dataUnits, "sec");
        this.timeMin = 0.0;
        String string = this.dateStr;
        int n = Integer.parseInt(string.substring(0, string.indexOf(47)).trim());
        string = string.substring(string.indexOf(47) + 1);
        int n2 = Integer.parseInt(string.substring(0, string.indexOf(47)).trim());
        string = string.substring(string.indexOf(47) + 1);
        int n3 = Integer.parseInt(string.substring(0, string.indexOf(32)).trim());
        string = string.substring(string.indexOf(32) + 1);
        int n4 = Integer.parseInt(string.substring(0, string.indexOf(58)).trim());
        string = string.substring(string.indexOf(58) + 1);
        int n5 = Integer.parseInt(string.substring(0, string.indexOf(58)).trim());
        string = string.substring(string.indexOf(58) + 1);
        double d = new Double(string.substring(0, string.indexOf(32)).trim());
        TimeInstant timeInstant = new TimeInstant(n3, n2, n);
        int n6 = timeInstant.getDoY();
        this.iyear = n3;
        this.ijday = n6;
        this.ihour = n4;
        this.imin = n5;
        this.sec = d;
        this.channel.staName = seisDataDeprem.staPlace.substring(0, this.staPlace.indexOf(32));
        this.channel.instName = BasicSeismogram.UNDEF_STRING;
        this.evtName = this.eqEpicenterCoordStr.trim() + " " + this.eqMagnitudeStr.trim();
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.directionStr.indexOf("+V") != -1) {
            d2 = 0.0;
            d3 = 0.0;
        } else if (this.directionStr.indexOf("+T") != -1) {
            d2 = 90.0;
            d3 = 90.0;
        } else if (this.directionStr.indexOf("+L") != -1) {
            d2 = 180.0;
            d3 = 90.0;
        }
        this.channel.azimuth = d2;
        this.channel.inclination = d3;
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        try {
            String string = aSCIIInputStream.readWord();
            if (string.toUpperCase().indexOf("STRONG") < 0) {
                return -1;
            }
            string = aSCIIInputStream.readWord();
            if (string.toUpperCase().indexOf("GROUND") < 0) {
                return -1;
            }
            string = aSCIIInputStream.readWord();
            if (string.toUpperCase().indexOf("MOTION") < 0) {
                return -1;
            }
            string = aSCIIInputStream.readWord();
            if (string.toUpperCase().indexOf("RECORDS") < 0) {
                return -1;
            }
            string = aSCIIInputStream.readWord();
            if (string.toUpperCase().indexOf("OF") < 0) {
                return -1;
            }
            string = aSCIIInputStream.readWord();
            if (string.toUpperCase().indexOf("TURKIYE") < 0) {
                return -1;
            }
            return 1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }
}

