/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.IOException;
import net.alomax.io.BinaryInputStream;
import net.alomax.seis.PeppClockCorr;
import net.alomax.seis.PeppDateAndTime;
import net.alomax.seis.PeppTimePick;

class PeppHeader {
    public static final int LEBE = 3737;
    public static final int LEBE_SWAPPED = 39182;
    public static final int MAXPICKS = 10;
    public static final String PHDR_VER_24 = "PEPP_HVN_02.40";
    public static final short PIUNKN = 1;
    public static final short PICNTS = 2;
    public static final short PIVOLTS = 3;
    public static final short PIDISPL = 4;
    public static final short PIVELOC = 5;
    public static final short PIACCEL = 6;
    public static final short PINUKE = 103;
    public static final short PIQUAKE = 104;
    public static final short PIQUARRY = 105;
    public static final short PICHEM = 106;
    public static final short PIOTHER = 107;
    public static final float FUNDEF = -12345.0f;
    public static final int NUNDEF = -12345;
    public static final int IUNDEF = -12345;
    public static final int LUNDEF = 0;
    public static final String KUNDEF = "-12345";
    public static final byte CUNDEF = 63;
    public int lebeByte;
    public String verno;
    public PeppDateAndTime stime;
    public float begin_time;
    public float end_time;
    public float samplingrate;
    public int npts;
    public short idep;
    public float depmin;
    public float depmax;
    public float depmen;
    public String DataType;
    public float cmpinc;
    public float cmpaz;
    public String cmpname;
    public String kcmpname;
    public String filetype;
    public float stla;
    public float stlo;
    public short stel;
    public String kstnm;
    public String snetwrk;
    public String station_loc;
    public short gain;
    public float LowLimit;
    public float HighLimit;
    public float bitweight;
    public short resolution;
    public String seismometer;
    public float sensitivity;
    public float calper;
    public PeppDateAndTime evot;
    public float evla;
    public float evlo;
    public float evdp;
    public float ev_ms;
    public float ev_mb;
    public float ev_mw;
    public float ev_ml;
    public float ev_mo;
    public short ev_type;
    public float evdistgc;
    public float evdistkm;
    public float az;
    public float baz;
    public String event_loc;
    public PeppDateAndTime timeStamp;
    public float tsOffset;
    public PeppClockCorr[] clock = new PeppClockCorr[2];
    public PeppTimePick[] picks = new PeppTimePick[10];

    PeppHeader(BinaryInputStream binaryInputStream) throws Exception {
        try {
            int n;
            this.lebeByte = binaryInputStream.readUnsignedShortB();
            if (this.lebeByte != 3737) {
                if (this.lebeByte == 39182) {
                    binaryInputStream.binaryType = binaryInputStream.binaryType == 1 ? 0 : 1;
                } else {
                    System.out.println("ERROR: Reading PEPP file: lebeByte = " + this.lebeByte + ", should be: " + 3737);
                }
            }
            if (binaryInputStream.binaryType == 0) {
                System.out.println("WARNING: Reading PEPP file: data not in PC_INTEL/LITTLE_ENDIAN byte ordering");
            }
            this.verno = binaryInputStream.readStringB(15);
            if (this.verno.compareTo(PHDR_VER_24) != 0) {
                System.out.println("WARNING: Reading PEPP file: verno = " + this.verno + ", should be: " + PHDR_VER_24);
            }
            this.stime = new PeppDateAndTime(binaryInputStream);
            this.begin_time = binaryInputStream.readFloatB();
            this.end_time = binaryInputStream.readFloatB();
            this.samplingrate = binaryInputStream.readFloatB();
            this.npts = binaryInputStream.readIntB();
            this.idep = binaryInputStream.readShortB();
            this.depmin = binaryInputStream.readFloatB();
            this.depmax = binaryInputStream.readFloatB();
            this.depmen = binaryInputStream.readFloatB();
            this.DataType = binaryInputStream.readStringB(3);
            this.cmpinc = binaryInputStream.readFloatB();
            this.cmpaz = binaryInputStream.readFloatB();
            this.cmpname = binaryInputStream.readStringB(1);
            this.kcmpname = binaryInputStream.readStringB(4);
            this.filetype = binaryInputStream.readStringB(5);
            this.stla = binaryInputStream.readFloatB();
            this.stlo = binaryInputStream.readFloatB();
            this.stel = binaryInputStream.readShortB();
            this.kstnm = binaryInputStream.readStringB(9);
            this.snetwrk = binaryInputStream.readStringB(9);
            this.station_loc = binaryInputStream.readStringB(31);
            this.gain = binaryInputStream.readShortB();
            this.LowLimit = binaryInputStream.readFloatB();
            this.HighLimit = binaryInputStream.readFloatB();
            this.bitweight = binaryInputStream.readFloatB();
            this.resolution = binaryInputStream.readShortB();
            this.seismometer = binaryInputStream.readStringB(17);
            this.sensitivity = binaryInputStream.readFloatB();
            this.calper = binaryInputStream.readFloatB();
            this.evot = new PeppDateAndTime(binaryInputStream);
            this.evla = binaryInputStream.readFloatB();
            this.evlo = binaryInputStream.readFloatB();
            this.evdp = binaryInputStream.readFloatB();
            this.ev_ms = binaryInputStream.readFloatB();
            this.ev_mb = binaryInputStream.readFloatB();
            this.ev_mw = binaryInputStream.readFloatB();
            this.ev_ml = binaryInputStream.readFloatB();
            this.ev_mo = binaryInputStream.readFloatB();
            this.ev_type = binaryInputStream.readShortB();
            this.evdistgc = binaryInputStream.readFloatB();
            this.evdistkm = binaryInputStream.readFloatB();
            this.az = binaryInputStream.readFloatB();
            this.baz = binaryInputStream.readFloatB();
            this.event_loc = binaryInputStream.readStringB(31);
            this.timeStamp = new PeppDateAndTime(binaryInputStream);
            this.tsOffset = binaryInputStream.readFloatB();
            for (n = 0; n < 2; ++n) {
                this.clock[n] = new PeppClockCorr(binaryInputStream);
            }
            for (n = 0; n < 10; ++n) {
                this.picks[n] = new PeppTimePick(binaryInputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

