/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.message;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import net.alomax.io.GeneralOutputStream;

public class FileMessagePusher
extends Thread {
    protected URL documentBase;
    protected String messageFileName;

    public FileMessagePusher(URL uRL, String string) {
        this.documentBase = uRL;
        this.messageFileName = string;
    }

    protected synchronized OutputStream openMessageFileURL(URL uRL, String string) throws Exception {
        OutputStream outputStream = null;
        int n = 5;
        while (n > 0) {
            --n;
            try {
                outputStream = GeneralOutputStream.openStream(uRL, string);
            }
            catch (Exception exception) {
                if (n <= 0) {
                    throw exception;
                }
                FileMessagePusher.sleep(100L);
            }
        }
        return outputStream;
    }

    protected synchronized void closeMessageFileURL(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized int writeMessageFileURL(OutputStream outputStream, String[] stringArray) throws Exception {
        BufferedWriter bufferedWriter = null;
        Exception exception = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        }
        catch (Exception exception2) {
            exception = exception2;
            try {
                bufferedWriter.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            bufferedWriter = null;
        }
        if (bufferedWriter == null) {
            throw new Exception(this.getClass().getName() + ": " + "ERROR: Opening message push file: " + this.messageFileName + ": " + exception);
        }
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                bufferedWriter.write(stringArray[i], 0, stringArray[i].length());
                ++n;
            }
        }
        catch (Exception exception4) {
            throw new Exception(this.getClass().getName() + ": " + "ERROR: Writing to message push file: " + this.messageFileName + ": " + exception4);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (Exception exception5) {}
        }
        return n;
    }

    public int write(String[] stringArray) throws Exception {
        OutputStream outputStream = this.openMessageFileURL(this.documentBase, this.messageFileName);
        int n = this.writeMessageFileURL(outputStream, stringArray);
        this.closeMessageFileURL(outputStream);
        return n;
    }
}

