/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.math;

import JSci.maths.LinearMath;
import JSci.maths.polynomials.RealPolynomial;
import net.alomax.freq.FrequencyDomainProcess;
import net.alomax.math.Cmplx;
import net.alomax.math.RangeDouble;
import net.alomax.math.RangeFloat;
import net.alomax.math.RangeInteger;
import net.alomax.math.TimeSeries;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainMemory;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainProcesses;
import net.alomax.util.PhysicalUnits;

public class TimeSeriesFloat
extends TimeSeries {
    public static final float RANGE_MIN = -3.4028235E38f;
    public static final float RANGE_MAX = Float.MAX_VALUE;
    public static final float NO_DATA = -3.4028235E38f;
    public Cmplx[] cdataLocal = new Cmplx[0];
    public float outOfRangeMin = -3.4028235E38f;
    public float outOfRangeMax = Float.MAX_VALUE;
    public boolean sampleChanged = true;
    public float[] sample = new float[0];
    private static final boolean DO_NOT_SAVE_CDATA = false;

    public TimeSeriesFloat() {
    }

    public TimeSeriesFloat(float[] fArray, double d, double d2, String string, String string2) {
        super(d, d2, string, string2);
        this.sample = fArray;
        this.sampleChanged = true;
        this.calculateAndSetAmplitudeRange(false);
    }

    public final void setSampleFloat(float[] fArray) {
        this.sample = fArray;
        this.sampleChanged = true;
        this.calculateAndSetAmplitudeRange(false);
    }

    public final int appendFloat(int n, float[] fArray, int n2) {
        int n3 = n2 + fArray.length - n;
        float[] fArray2 = new float[n3];
        System.arraycopy(this.sample, n, fArray2, 0, n2 - n);
        System.arraycopy(fArray, 0, fArray2, n2 - n, fArray.length);
        this.sample = fArray2;
        this.sampleChanged = true;
        this.calculateAndSetAmplitudeRange(false);
        return fArray.length;
    }

    public final float[] getSampleSubsetAsFloat(int n, int n2) {
        int n3;
        float[] fArray;
        float[] fArray2 = new float[n2 - n + 1];
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        if (n2 < 0 || n >= this.sample.length) {
            for (int i = 0; i < fArray2.length; ++i) {
                fArray2[i] = 0.0f;
            }
            return fArray2;
        }
        if (n < 0) {
            fArray = new float[-n];
            for (n3 = 0; n3 < fArray.length; ++n3) {
                fArray[n3] = 0.0f;
            }
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
            n4 = 0;
            n6 = fArray.length;
        }
        if (n2 >= this.sample.length) {
            fArray = new float[n2 - this.sample.length + 1];
            n5 = this.sample.length - 1;
            for (n3 = 0; n3 < fArray.length; ++n3) {
                fArray[n3] = 0.0f;
            }
            System.arraycopy(fArray, 0, fArray2, n6 + n5 - n4 + 1, fArray.length);
        }
        System.arraycopy(this.sample, n4, fArray2, n6, n5 - n4 + 1);
        return fArray2;
    }

    public final double calculateVariance() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < this.sample.length; ++i) {
            if (!(this.sample[i] > this.outOfRangeMin) || !(this.sample[i] < this.outOfRangeMax)) continue;
            double d3 = this.sample[i];
            d += d3;
            d2 += d3 * d3;
            ++n;
        }
        double d4 = 0.0;
        if (n > 0) {
            double d5 = d / (double)n;
            d4 = (d2 - d * d5) / (double)n;
        }
        return d4;
    }

    public final double calculateRmsAmplitude() {
        return this.calculateRmsAmplitude(0, this.sample.length);
    }

    public final double calculateRmsAmplitude(int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (!(this.sample[i] > this.outOfRangeMin) || !(this.sample[i] < this.outOfRangeMax)) continue;
            d2 = this.sample[i];
            d += d2 * d2;
            ++n3;
        }
        if (n3 > 0) {
            d /= (double)n3;
            d = Math.sqrt(d);
        }
        return d;
    }

    public final RangeDouble calculateAmplitudeRange(int n, int n2, boolean bl) {
        RangeFloat rangeFloat = new RangeFloat(Float.MAX_VALUE, -3.4028235E38f);
        for (int i = n; i < n2; ++i) {
            if (this.sample[i] > this.outOfRangeMin && this.sample[i] < this.outOfRangeMax) {
                rangeFloat.min = Math.min(this.sample[i], rangeFloat.min);
                rangeFloat.max = Math.max(this.sample[i], rangeFloat.max);
                continue;
            }
            if (!bl) continue;
            this.sample[i] = 0.0f;
            this.sampleChanged = true;
        }
        RangeDouble rangeDouble = new RangeDouble(rangeFloat.min, rangeFloat.max);
        return rangeDouble;
    }

    public final void calculateAndSetAmplitudeRange(boolean bl) {
        RangeDouble rangeDouble = this.calculateAmplitudeRange(0, this.sample.length, bl);
        if (rangeDouble.min < rangeDouble.max) {
            this.ampMin = rangeDouble.min;
            this.ampMax = rangeDouble.max;
        } else {
            this.ampMin = rangeDouble.min - 0.5;
            this.ampMax = rangeDouble.max + 0.5;
        }
    }

    public final float[] getSampleAsFloat() {
        this.sampleChanged = true;
        return this.sample;
    }

    public final int sampleLength() {
        return this.sample.length;
    }

    public long getDataMemorySize() {
        if (this.sample == null) {
            return 0L;
        }
        return this.sample.length * 4;
    }

    public final double sampleAt(int n) {
        if (n < 0 || n > this.sample.length) {
            return -1.7976931348623157E308;
        }
        if (this.sample[n] == -3.4028235E38f) {
            return -1.7976931348623157E308;
        }
        return this.sample[n];
    }

    public final void invertPolarity() {
        for (int i = 0; i < this.sample.length; ++i) {
            if (!(this.sample[i] > this.outOfRangeMin) || !(this.sample[i] < this.outOfRangeMax)) continue;
            int n = i;
            this.sample[n] = this.sample[n] * -1.0f;
        }
        this.sampleChanged = true;
        this.lastSampleMean *= -1.0;
        double d = this.ampMin;
        this.ampMin = -1.0 * this.ampMax;
        this.ampMax = -1.0 * d;
    }

    public final void removeTrend() {
        int n = 1;
        double[][] dArray = new double[2][this.sample.length];
        double d = 0.0;
        for (int i = 0; i < this.sample.length; ++i) {
            float f = this.sample[i];
            if (f < this.outOfRangeMin || f > this.outOfRangeMax) {
                f = 0.0f;
            }
            dArray[0][i] = d;
            dArray[1][i] = f;
            d += this.sampleInt;
        }
        RealPolynomial realPolynomial = LinearMath.leastSquaresFit(n, dArray);
        double d2 = realPolynomial.getCoefficientAsDouble(0);
        double d3 = realPolynomial.getCoefficientAsDouble(1);
        this.sampleChanged = true;
        this.ampMin = 3.4028234663852886E38;
        this.ampMax = -3.4028234663852886E38;
        d = 0.0;
        for (int i = 0; i < this.sample.length; ++i) {
            float f = this.sample[i];
            if (f > this.outOfRangeMin && f < this.outOfRangeMax) {
                this.sample[i] = f -= (float)(d2 + d3 * d);
                this.ampMin = Math.min((double)f, this.ampMin);
                this.ampMax = Math.max((double)f, this.ampMax);
            }
            d += this.sampleInt;
        }
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
    }

    public final void removeMean() {
        this.removeMean(this.sample.length);
        this.sampleChanged = true;
    }

    public void removeMean(int n) {
        this.removeMean(0, n - 1);
        this.sampleChanged = true;
    }

    public void removeMean(int n, int n2) {
        float f;
        int n3;
        int n4;
        int n5 = n;
        if (n5 < 0) {
            n5 = 0;
        }
        if ((n4 = n2 + 1) > this.sample.length) {
            n4 = this.sample.length;
        }
        double d = 0.0;
        int n6 = 0;
        for (n3 = n5; n3 < n4; ++n3) {
            f = this.sample[n3];
            if (!(f > this.outOfRangeMin) || !(f < this.outOfRangeMax)) continue;
            d += (double)f;
            ++n6;
        }
        if (n6 < 1) {
            return;
        }
        d /= (double)n6;
        this.lastSampleMean = -1.7976931348623157E308;
        for (n3 = 0; n3 < this.sample.length; ++n3) {
            f = this.sample[n3];
            if (!(f > this.outOfRangeMin) || !(f < this.outOfRangeMax)) continue;
            int n7 = n3;
            this.sample[n7] = this.sample[n7] - (float)d;
        }
        this.sampleChanged = true;
        this.ampMin -= d;
        this.ampMax -= d;
        this.lastSampleMean = d;
    }

    public final void unDoRemoveMean() {
        if (this.lastSampleMean == -1.7976931348623157E308) {
            return;
        }
        for (int i = 0; i < this.sample.length; ++i) {
            float f = this.sample[i];
            if (!(f > this.outOfRangeMin) || !(f < this.outOfRangeMax)) continue;
            int n = i;
            this.sample[n] = this.sample[n] + (float)this.lastSampleMean;
        }
        this.sampleChanged = true;
        this.ampMin += this.lastSampleMean;
        this.ampMax += this.lastSampleMean;
        this.lastSampleMean = -1.7976931348623157E308;
    }

    public final void cosineTaper(double d) {
        int n = (int)(d / 100.0 * (double)this.sample.length);
        if (n < 2 || n > this.sample.length / 2) {
            return;
        }
        double d2 = Math.PI / (double)n;
        for (int i = 1; i < n; ++i) {
            int n2 = i - 1;
            int n3 = this.sample.length - i;
            double d3 = 0.5 * (1.0 - Math.cos(d2 * (double)i));
            int n4 = n2;
            this.sample[n4] = (float)((double)this.sample[n4] * d3);
            int n5 = n3;
            this.sample[n5] = (float)((double)this.sample[n5] * d3);
        }
        this.sampleChanged = true;
    }

    public final void cutInMemory(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.sample.length - 1) {
            n2 = this.sample.length - 1;
        }
        float[] fArray = this.getSampleSubsetAsFloat(n, n2);
        this.sample = fArray;
        this.sampleChanged = true;
        this.ampMin = 3.4028234663852886E38;
        this.ampMax = -3.4028234663852886E38;
        for (int i = 0; i < this.sample.length; ++i) {
            float f = this.sample[i];
            if (!(f > this.outOfRangeMin) || !(f < this.outOfRangeMax)) continue;
            this.ampMin = Math.min((double)f, this.ampMin);
            this.ampMax = Math.max((double)f, this.ampMax);
        }
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
    }

    public final void test() {
        int n = 21;
        int n2 = 5;
        double d = (double)(n2 - 1) / (double)n2;
        double d2 = 1.0 / (double)n2;
        double[] dArray = new double[n];
        dArray[0] = 1.0;
        for (int i = 1; i < n; ++i) {
            dArray[i] = dArray[i - 1] / (double)i;
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 0.0;
        }
        double[] dArray3 = new double[n];
        this.ampMin = 3.4028234663852886E38;
        this.ampMax = -3.4028234663852886E38;
        double d3 = 0.0;
        for (int i = 0; i < this.sample.length; ++i) {
            int n3;
            float f = this.sample[i];
            if (f <= this.outOfRangeMin || f >= this.outOfRangeMax) {
                f = 0.0f;
            }
            this.sample[i] = f - (float)d3;
            this.ampMin = Math.min((double)this.sample[i], this.ampMin);
            this.ampMax = Math.max((double)this.sample[i], this.ampMax);
            dArray3[0] = d * dArray2[0] + d2 * (double)f;
            d3 = dArray3[0];
            for (n3 = 1; n3 < n; ++n3) {
                dArray3[n3] = dArray3[n3 - 1] - dArray2[n3 - 1];
                d3 += dArray[n3] * dArray3[n3] * (double)n2;
            }
            for (n3 = 0; n3 < n; ++n3) {
                dArray2[n3] = dArray3[n3];
            }
        }
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
        this.sampleChanged = true;
    }

    public final void integrate(float f) {
        float f2 = f;
        this.ampMin = 3.4028234663852886E38;
        this.ampMax = -3.4028234663852886E38;
        for (int i = 0; i < this.sample.length; ++i) {
            float f3 = this.sample[i];
            if (f3 <= this.outOfRangeMin || f3 >= this.outOfRangeMax) {
                f3 = 0.0f;
            }
            this.sample[i] = f2 += f3 * (float)this.sampleInt;
            this.ampMin = Math.min((double)f2, this.ampMin);
            this.ampMax = Math.max((double)f2, this.ampMax);
        }
        this.sampleChanged = true;
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
        this.ampUnits = PhysicalUnits.timeIntegral(this.ampUnits);
    }

    public final void integrateMaxOfPosNeg(boolean bl) {
        float f;
        int n;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f2 = -3.4028235E38f;
        boolean bl3 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        float f3 = -3.4028235E38f;
        float f4 = Float.MAX_VALUE;
        float f5 = -3.4028235E38f;
        float f6 = Float.MAX_VALUE;
        float f7 = -3.4028235E38f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        for (n = 0; n < this.sample.length; ++n) {
            float f10 = this.sample[n];
            if (f10 <= this.outOfRangeMin || f10 >= this.outOfRangeMax) {
                f10 = 0.0f;
            }
            if ((double)f10 >= 0.0) {
                if (bl) {
                    if (bl3) {
                        bl3 = false;
                        if (f9 > f3) {
                            f3 = f9;
                            n6 = n5;
                            n7 = n > 0 ? n - 1 : n;
                        }
                        f9 = 0.0f;
                    }
                    if (!bl2) {
                        bl2 = true;
                        n2 = n;
                    }
                }
                f4 = Math.min(f8 += f10 * (float)this.sampleInt, f4);
                f5 = Math.max(f8, f5);
                continue;
            }
            if (bl) {
                if (bl2) {
                    bl2 = false;
                    if (f8 > f2) {
                        f2 = f8;
                        n3 = n2;
                        n4 = n > 0 ? n - 1 : n;
                    }
                    f8 = 0.0f;
                }
                if (!bl3) {
                    bl3 = true;
                    n5 = n;
                }
            }
            f6 = Math.min(f9 += -f10 * (float)this.sampleInt, f6);
            f7 = Math.max(f9, f7);
        }
        if (bl) {
            if (bl3) {
                if (f9 > f3) {
                    f3 = f9;
                    n6 = n5;
                    n7 = n > 0 ? n - 1 : n;
                }
            } else if (bl2 && f8 > f2) {
                f2 = f8;
                n3 = n2;
                n4 = n > 0 ? n - 1 : n;
            }
        }
        int n8 = 0;
        int n9 = this.sample.length;
        if (bl) {
            f8 = f2;
            f9 = f3;
        }
        if (f8 > f9) {
            if (bl) {
                n8 = n3;
                n9 = n4;
            }
            f8 = 0.0f;
            for (n = 0; n < n9; ++n) {
                f = this.sample[n];
                if (f <= this.outOfRangeMin || f >= this.outOfRangeMax || bl && n < n8) {
                    f = 0.0f;
                }
                if ((double)f > 0.0) {
                    f8 += f * (float)this.sampleInt;
                }
                this.sample[n] = f8;
            }
            this.ampMin = f4;
            this.ampMax = f5;
        } else {
            if (bl) {
                n8 = n6;
                n9 = n7;
            }
            f9 = 0.0f;
            for (n = 0; n < n9; ++n) {
                f = this.sample[n];
                if (f <= this.outOfRangeMin || f >= this.outOfRangeMax || bl && n < n8) {
                    f = 0.0f;
                }
                if ((double)f < 0.0) {
                    f9 += -f * (float)this.sampleInt;
                }
                this.sample[n] = f9;
            }
            this.ampMin = f6;
            this.ampMax = f7;
        }
        if (bl && n9 < this.sample.length) {
            f = 0.0f;
            if (n9 > 0) {
                f = this.sample[n9 - 1];
            }
            for (n = n9; n < this.sample.length; ++n) {
                this.sample[n] = f;
            }
        }
        this.sampleChanged = true;
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
        this.ampUnits = PhysicalUnits.timeIntegral(this.ampUnits);
    }

    public final void differentiate(float f) {
        this.ampMin = 3.4028234663852886E38;
        this.ampMax = -3.4028234663852886E38;
        for (int i = 0; i < this.sample.length; ++i) {
            float f2 = this.sample[i];
            if (!(f2 > this.outOfRangeMin) || !(f2 < this.outOfRangeMax)) continue;
            float f3 = (f2 - f) / (float)this.sampleInt;
            f = f2;
            this.sample[i] = f3;
            this.ampMin = Math.min((double)f3, this.ampMin);
            this.ampMax = Math.max((double)f3, this.ampMax);
        }
        this.sampleChanged = true;
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
        this.ampUnits = PhysicalUnits.timeDerivative(this.ampUnits);
    }

    public void multiply(double d) {
        this.ampMin = 3.4028234663852886E38;
        this.ampMax = -3.4028234663852886E38;
        for (int i = 0; i < this.sample.length; ++i) {
            float f = this.sample[i];
            if (!(f > this.outOfRangeMin) || !(f < this.outOfRangeMax)) continue;
            int n = i;
            this.sample[n] = (float)((double)this.sample[n] * d);
            this.ampMin = Math.min((double)this.sample[i], this.ampMin);
            this.ampMax = Math.max((double)this.sample[i], this.ampMax);
        }
        this.sampleChanged = true;
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
    }

    public void sqrt() {
        this.ampMin = 3.4028234663852886E38;
        this.ampMax = -3.4028234663852886E38;
        for (int i = 0; i < this.sample.length; ++i) {
            float f = this.sample[i];
            if (!(f > this.outOfRangeMin) || !(f < this.outOfRangeMax)) continue;
            f = f > 0.0f ? (float)Math.sqrt(f) : 0.0f;
            this.ampMin = Math.min((double)f, this.ampMin);
            this.ampMax = Math.max((double)f, this.ampMax);
            this.sample[i] = f;
        }
        this.sampleChanged = true;
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
    }

    public void square() {
        this.ampMin = 3.4028234663852886E38;
        this.ampMax = -3.4028234663852886E38;
        for (int i = 0; i < this.sample.length; ++i) {
            float f = this.sample[i];
            if (!(f > this.outOfRangeMin) || !(f < this.outOfRangeMax)) continue;
            f *= f;
            this.ampMin = Math.min((double)f, this.ampMin);
            this.ampMax = Math.max((double)f, this.ampMax);
            this.sample[i] = f;
        }
        this.sampleChanged = true;
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
    }

    public void abs() {
        this.ampMin = 3.4028234663852886E38;
        this.ampMax = -3.4028234663852886E38;
        for (int i = 0; i < this.sample.length; ++i) {
            float f = this.sample[i];
            if (!(f > this.outOfRangeMin) || !(f < this.outOfRangeMax)) continue;
            f = Math.abs(f);
            this.ampMin = Math.min((double)f, this.ampMin);
            this.ampMax = Math.max((double)f, this.ampMax);
            this.sample[i] = f;
        }
        this.sampleChanged = true;
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
    }

    public void norm() {
        float f = Math.abs(this.sample[this.indexOfAmpZeroToPeakMax()]);
        if (f > 1.4E-43f) {
            this.multiply(1.0 / (double)f);
        }
        this.sampleChanged = true;
    }

    public void chop() {
        for (int i = 0; i < this.sample.length; ++i) {
            if (!(this.sample[i] < 0.0f)) continue;
            this.sample[i] = 0.0f;
        }
        this.sampleChanged = true;
    }

    public void multiplyLinear(double d, double d2) {
        this.ampMin = 3.4028234663852886E38;
        this.ampMax = -3.4028234663852886E38;
        double d3 = d2 - d;
        double d4 = this.sample.length;
        for (int i = 0; i < this.sample.length; ++i) {
            float f = this.sample[i];
            if (!(f > this.outOfRangeMin) || !(f < this.outOfRangeMax)) continue;
            int n = i;
            this.sample[n] = (float)((double)this.sample[n] * (d + d3 * (double)i / d4));
            this.ampMin = Math.min((double)this.sample[i], this.ampMin);
            this.ampMax = Math.max((double)this.sample[i], this.ampMax);
        }
        this.sampleChanged = true;
        if (this.sample.length > 0) {
            this.lastSampleMean = -1.7976931348623157E308;
        }
    }

    public final int indexOfAmpZeroToPeakMax() {
        float f = -3.4028235E38f;
        int n = -1;
        for (int i = 0; i < this.sample.length; ++i) {
            float f2;
            float f3 = this.sample[i];
            if (!(f3 > this.outOfRangeMin) || !(f3 < this.outOfRangeMax) || !((f2 = Math.abs(f3)) > f)) continue;
            f = f2;
            n = i;
        }
        return n;
    }

    public final RangeInteger indicesOfAmpPeakToPeakMax(double d) {
        int n = (int)(d / this.sampleInt);
        if (n < 1 || n >= this.sample.length) {
            n = this.sample.length - 1;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = -1;
        int n3 = -1;
        float f3 = Float.MAX_VALUE;
        float f4 = -1.4E-45f;
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < this.sample.length - n; ++i) {
            float f5 = this.sample[i];
            if (!(f5 > this.outOfRangeMin) || !(f5 < this.outOfRangeMax)) continue;
            int n6 = i + n;
            if (n4 >= i && n5 >= i) {
                if (this.sample[n6] < f3) {
                    f3 = this.sample[n6];
                    n4 = n6;
                } else {
                    if (!(this.sample[n6] > f4)) continue;
                    f4 = this.sample[n6];
                    n5 = n6;
                }
            } else {
                f3 = Float.MAX_VALUE;
                f4 = -1.4E-45f;
                n4 = -1;
                n5 = -1;
                for (int j = i; j <= n6; ++j) {
                    if (this.sample[j] < f3) {
                        f3 = this.sample[j];
                        n4 = j;
                        continue;
                    }
                    if (!(this.sample[j] > f4)) continue;
                    f4 = this.sample[j];
                    n5 = j;
                }
            }
            if (!(f4 - f3 > f2 - f)) continue;
            f = f3;
            f2 = f4;
            n2 = n4;
            n3 = n5;
        }
        return new RangeInteger(n2, n3);
    }

    public int indexOfCumulative(double d) {
        float f = this.sample[this.indexOfAmpZeroToPeakMax()];
        int n = -1;
        for (int i = 0; i < this.sample.length; ++i) {
            float f2;
            float f3 = this.sample[i];
            if (!(f3 > this.outOfRangeMin) || !(f3 < this.outOfRangeMax) || !((double)(f2 = Math.abs(f3)) >= (double)f * d)) continue;
            n = i;
            break;
        }
        return n;
    }

    public int[] indexOfPivotLimit(int n, double d, double d2, double d3) {
        int n2 = n + (int)(d / this.sampleInt) + 1;
        if (n2 >= this.sample.length) {
            return null;
        }
        float f = (this.sample[n2] - this.sample[n]) / (float)(n2 - n);
        int n3 = -1;
        int n4 = -1;
        for (int i = n2 + 1; i < this.sample.length; ++i) {
            float f2 = this.sample[i];
            if (!(f2 > this.outOfRangeMin) || !(f2 < this.outOfRangeMax)) continue;
            int n5 = i - n;
            float f3 = f * (float)n5;
            float f4 = this.sample[i] - this.sample[n];
            float f5 = (f3 - f4) / f3;
            if ((double)f5 > d2) {
                n3 = i;
                break;
            }
            float f6 = (this.sample[i] - this.sample[n]) / (float)n5;
            if (f6 > f) {
                n4 = -1;
            } else if (n4 == -1) {
                n4 = i;
            }
            f = f6 = f * ((float)(n5 - 1) / (float)n5) + f6 / (float)n5;
        }
        if (n3 < 0) {
            return null;
        }
        int[] nArray = new int[]{(n3 + n4) / 2, n4};
        return nArray;
    }

    public Cmplx[] getFFT(double d, int n) {
        float[] fArray = new float[this.sample.length + n];
        System.arraycopy(this.sample, 0, fArray, 0, this.sample.length);
        for (int i = this.sample.length; i < fArray.length; ++i) {
            fArray[i] = 0.0f;
        }
        TimeSeriesFloat timeSeriesFloat = new TimeSeriesFloat(fArray, this.sampleInt, this.lagTime, this.ampUnits, this.timeUnits);
        timeSeriesFloat.cosineTaper(d);
        Cmplx[] cmplxArray = Cmplx.fft(timeSeriesFloat.sample);
        return cmplxArray;
    }

    public void applyFreqProcess(FrequencyDomainProcess frequencyDomainProcess, double d, Object[] objectArray, boolean bl) {
        if (this.sampleChanged || this.cdataLocal.length < 1 || frequencyDomainProcess.sampleChangedInPreProcess()) {
            this.cosineTaper(d);
            this.sample = frequencyDomainProcess.preProcess(this.sampleInt, this.sample);
            this.cdataLocal = Cmplx.fft(this.sample);
        }
        this.cdataLocal = frequencyDomainProcess.apply(this.sampleInt, this.cdataLocal);
        if (bl || frequencyDomainProcess.sampleChangedInPostProcess()) {
            this.sample = Cmplx.fftInverse(this.cdataLocal, this.sample.length);
            this.sample = frequencyDomainProcess.postProcess(this.sampleInt, this.sample);
            this.cdataLocal = new Cmplx[0];
        }
        this.sampleChanged = frequencyDomainProcess.sampleChangedInPostProcess();
        this.calculateAndSetAmplitudeRange(false);
        frequencyDomainProcess.updateFields(this);
    }

    public void applyTimeDomainProcess(TimeDomainProcess timeDomainProcess) throws TimeDomainException {
        if (timeDomainProcess instanceof TimeDomainProcesses) {
            if (((TimeDomainProcesses)timeDomainProcess).processID == TimeDomainProcesses.INTEGRATE) {
                TimeDomainMemory timeDomainMemory = timeDomainProcess.getMemory();
                float f = 0.0f;
                if (timeDomainMemory != null) {
                    f = timeDomainMemory.output[0];
                }
                this.integrate(f);
                if (timeDomainMemory != null) {
                    timeDomainMemory.output[0] = this.sample[this.sampleLength() - 1];
                }
            } else if (((TimeDomainProcesses)timeDomainProcess).processID == TimeDomainProcesses.DIFFERENTIATE) {
                TimeDomainMemory timeDomainMemory = timeDomainProcess.getMemory();
                float f = 0.0f;
                if (timeDomainMemory != null) {
                    f = timeDomainMemory.output[0];
                }
                if (timeDomainMemory != null) {
                    timeDomainMemory.output[0] = this.sample[this.sampleLength() - 1];
                }
                this.differentiate(f);
            } else if (((TimeDomainProcesses)timeDomainProcess).processID == TimeDomainProcesses.MULTIPLY) {
                this.multiply(((TimeDomainProcesses)timeDomainProcess).parameters[0]);
            } else if (((TimeDomainProcesses)timeDomainProcess).processID == TimeDomainProcesses.SQRT) {
                this.sqrt();
            } else if (((TimeDomainProcesses)timeDomainProcess).processID == TimeDomainProcesses.SQUARE) {
                this.square();
            } else if (((TimeDomainProcesses)timeDomainProcess).processID == TimeDomainProcesses.ABS) {
                this.abs();
            } else {
                this.sample = timeDomainProcess.apply(this.sampleInt, this.sample);
                this.sampleChanged = true;
                this.calculateAndSetAmplitudeRange(false);
                timeDomainProcess.updateFields(this);
            }
        } else {
            this.sample = timeDomainProcess.apply(this.sampleInt, this.sample);
            this.sampleChanged = true;
            this.calculateAndSetAmplitudeRange(false);
            timeDomainProcess.updateFields(this);
        }
    }

    public String toString() {
        return new String("sample.length = " + this.sample.length + "\n" + super.toString());
    }
}

