/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics2d;

import java.awt.FontMetrics;
import java.awt.Graphics;

public abstract class Axes {
    public static FontMetrics fontMetrics;
    public static int iCharWidth;
    public static int iCharHeight;
    public static int iCharAscent;
    public int iMin;
    public int iMax;
    public double valMin;
    public double valMax;
    public String units;
    public int iPosMin;
    public int iPosMax;
    public double scale;
    public double tickSpace;
    public double tickStart;
    public static final boolean NO_LABEL = false;
    public static final boolean YES_LABEL = true;
    public static final int XAXIS_LOWER = 0;
    public static final int YAXIS_LEFT = 1;
    public static final int XAXIS_UPPER = 2;
    public static final int YAXIS_RIGHT = 3;

    public Axes(int n, int n2, double d, double d2, String string, int n3, int n4) {
        this.iMin = n;
        this.iMax = n2;
        this.valMin = d;
        this.valMax = d2;
        this.units = string;
        this.iPosMin = n3;
        this.iPosMax = n4;
        this.scale = (double)(n2 - n) / (d2 - d);
    }

    public static void setFontSizes(Graphics graphics) {
        fontMetrics = graphics.getFontMetrics();
        iCharWidth = fontMetrics.charWidth('_');
        iCharHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        iCharAscent = fontMetrics.getMaxAscent();
    }

    public static int getTickLength(int n, int n2) {
        return iCharWidth - 1;
    }

    public double getTickSpace(double d, double d2, double d3) {
        double d4 = d2 - d;
        double d5 = Math.pow(10.0, 1 + (int)(Math.log(d4) / Math.log(10.0)));
        int n = 0;
        do {
            if (d5 > d4 / d3) {
                d5 /= 2.0;
            }
            if (d5 > d4 / d3) {
                d5 /= 2.5;
            }
            if (!(d5 > d4 / d3)) continue;
            d5 /= 2.0;
        } while (d5 > d4 / d3 && n++ < 1000);
        return d5;
    }

    public double getTickStart(double d, double d2) {
        double d3 = d2 * (double)((int)(d / d2));
        if (d3 < d) {
            d3 += d2;
        }
        return d3;
    }

    public double getTickStop(double d, double d2) {
        double d3 = d2 * (double)(1 + (int)(d / d2));
        if (d3 > d) {
            d3 -= d2;
        }
        return d3;
    }

    static {
        iCharWidth = 10;
        iCharHeight = 10;
        iCharAscent = 10;
    }
}

