/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.freq;

import net.alomax.freq.FreqText;
import net.alomax.freq.FrequencyDomainProcess;
import net.alomax.freq.Response;
import net.alomax.freq.ResponseException;
import net.alomax.math.Cmplx;
import net.alomax.math.TimeSeries;

public class Transfer
implements FrequencyDomainProcess {
    protected Response responseFrom;
    protected Response responseTo;
    protected double[] freqLimits = new double[]{0.0, 0.0, Double.MAX_VALUE, Double.MAX_VALUE};
    protected String errorMessage;

    public Transfer(String string, Response response, Response response2) {
        this.responseFrom = response;
        this.responseTo = response2;
        this.errorMessage = " ";
        FreqText.setLocale(string);
    }

    public Response getFromResponse() {
        return this.responseFrom;
    }

    public Response getToResponse() {
        return this.responseTo;
    }

    public void setFromResponse(Response response) {
        this.responseFrom = response;
    }

    public void setToResponse(Response response) {
        this.responseTo = response;
    }

    public void setFreqLimits(String[] stringArray) throws ResponseException {
        if (stringArray.length != 4) {
            throw new ResponseException(FreqText.invalid_frequency_taper_values);
        }
        double[] dArray = new double[4];
        try {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = Double.valueOf(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ResponseException(FreqText.invalid_frequency_taper_values);
        }
        this.setFreqLimits(dArray);
    }

    public void setFreqLimits(double[] dArray) throws ResponseException {
        if (dArray.length != 4) {
            throw new ResponseException(FreqText.invalid_frequency_taper_values);
        }
        this.freqLimits = new double[4];
        System.arraycopy(dArray, 0, this.freqLimits, 0, 4);
    }

    public double[] getFreqLimits() {
        double[] dArray = new double[4];
        System.arraycopy(this.freqLimits, 0, dArray, 0, 4);
        return dArray;
    }

    public void checkSettings() throws ResponseException {
        String string = "";
        int n = 0;
        if (this.freqLimits[0] > this.freqLimits[1] || this.freqLimits[1] >= this.freqLimits[2] || this.freqLimits[2] > this.freqLimits[3]) {
            string = string + ": " + FreqText.invalid_frequency_taper_values;
            ++n;
        }
        if (n > 0) {
            throw new ResponseException(string + ".");
        }
    }

    public final Cmplx[] apply(double d, Cmplx[] cmplxArray) {
        Cmplx[] cmplxArray2;
        try {
            cmplxArray2 = Response.convertWave(cmplxArray, d, this.responseFrom, this.responseTo, this.freqLimits[0], this.freqLimits[1], this.freqLimits[2], this.freqLimits[3]);
        }
        catch (ResponseException responseException) {
            cmplxArray2 = null;
        }
        return cmplxArray2;
    }

    public float[] preProcess(double d, float[] fArray) {
        return fArray;
    }

    public float[] postProcess(double d, float[] fArray) {
        return fArray;
    }

    public boolean sampleChangedInPreProcess() {
        return false;
    }

    public boolean sampleChangedInPostProcess() {
        return false;
    }

    public void updateFields(TimeSeries timeSeries) {
        String string = timeSeries.ampUnits;
        if (this.responseFrom != null) {
            string = this.responseFrom.convertUnitsBackward(string);
        }
        if (this.responseTo != null) {
            string = this.responseTo.convertUnitsForward(string);
        }
        timeSeries.ampUnits = string;
    }

    public String convertName(String string) {
        String string2 = Response.UNKNOWN_NAME;
        if (this.responseFrom != null) {
            string2 = this.responseFrom.convertNameBackward(string);
        }
        if (this.responseTo != null) {
            string2 = this.responseTo.convertNameForward(string2);
        }
        return string2;
    }
}

