/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.freq;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import net.alomax.freq.FreqText;
import net.alomax.freq.PoleZeroResponse;
import net.alomax.freq.Response;
import net.alomax.freq.ResponseException;
import net.alomax.io.GeneralInputStream;
import net.alomax.math.Cmplx;
import net.alomax.math.TimeSeries;
import net.alomax.seis.BasicChannel;
import net.alomax.seis.BasicItem;
import net.alomax.util.StringExt;
import net.alomax.util.TimeInstant;
import sdsu.io.ASCIIInputStream;

public class GSEPoleZeroResponse
extends PoleZeroResponse {
    protected static final boolean DEBUG = false;
    protected static final int VERSION_UNKNOWN = -1;
    protected static final int VERSION_GSE_20 = 0;
    protected static final int VERSION_GSE_21 = 1;
    protected int gseVersion = -1;
    protected String sta = BasicItem.UNDEF_STRING;
    protected String chan = BasicItem.UNDEF_STRING;
    protected String auxid = BasicItem.UNDEF_STRING;
    protected String instype = BasicItem.UNDEF_STRING;
    protected double calib = -1.0;
    protected double calper = -1.0;
    protected double samprat = -1.0;
    protected String ondate = BasicItem.UNDEF_STRING;
    protected String ontime = BasicItem.UNDEF_STRING;
    protected String offdate = BasicItem.UNDEF_STRING;
    protected String offtime = BasicItem.UNDEF_STRING;
    protected int snum = -1;
    protected String ounits = BasicItem.UNDEF_STRING;
    protected double sfactor = -1.0;
    protected int deci = -1;
    protected double corr = -1.0;
    protected int npole = -1;
    protected int nzero = -1;
    protected String descrip = BasicItem.UNDEF_STRING;

    public GSEPoleZeroResponse() {
    }

    public GSEPoleZeroResponse(double d, Cmplx[] cmplxArray, Cmplx[] cmplxArray2, String string, String string2, int n) {
        int n2;
        this.gain = d;
        this.type = n;
        if (cmplxArray != null) {
            this.poles = new Cmplx[cmplxArray.length];
            for (n2 = 0; n2 < cmplxArray.length; ++n2) {
                this.poles[n2] = new Cmplx(cmplxArray[n2]);
            }
        }
        if (cmplxArray2 != null) {
            this.zeros = new Cmplx[cmplxArray2.length];
            for (n2 = 0; n2 < cmplxArray2.length; ++n2) {
                this.zeros[n2] = new Cmplx(cmplxArray2[n2]);
            }
        }
        if (string != null) {
            this.shortName = string;
        }
        if (string2 != null) {
            this.longName = string2;
        }
    }

    public GSEPoleZeroResponse(double d, Cmplx[] cmplxArray, Cmplx[] cmplxArray2, String string, String string2, int n, String[] stringArray, String[] stringArray2, String string3, String string4) {
        this(d, cmplxArray, cmplxArray2, string, string2, n);
        this.setBeforeUnits(stringArray);
        this.setAfterUnits(stringArray2);
        this.setBeforeName(string3);
        this.setAfterName(string4);
    }

    public GSEPoleZeroResponse(URL uRL, String string, TimeInstant timeInstant, BasicChannel basicChannel, TimeSeries timeSeries) throws ResponseException {
        try {
            String[] stringArray;
            boolean bl;
            InputStream inputStream = null;
            inputStream = GeneralInputStream.openStream(uRL, string, true);
            ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(new BufferedInputStream(inputStream));
            this.read(aSCIIInputStream, timeInstant, basicChannel, timeSeries);
            aSCIIInputStream.close();
            this.shortName = this.longName = string;
            this.gain = 1.0;
            Cmplx cmplx = this.evaluateResponse(1.0 / this.calper);
            double d = 1.0 / (this.calib * cmplx.mag());
            double d2 = this.sfactor / this.calib;
            boolean bl2 = bl = Math.abs(d2 - d) > (d2 + d) / 2000.0;
            if (bl) {
                System.out.println("WARNING: GSEPoleZeroResponse: Nominal and Calculated scale factors differ:");
            } else {
                System.out.println("INFO: GSEPoleZeroResponse: Nominal and Calculated scale factors:");
            }
            System.out.println("  " + this.sta + " " + this.chan + " " + this.auxid + " " + this.instype + " " + this.calib + " " + this.calper);
            System.out.println("  Nominal Ao=" + this.sfactor / this.calib + ", Calc Ao=" + d);
            this.gain = d;
            if (this.snum == 1) {
                stringArray = new String[]{"nm"};
                this.setBeforeUnits(stringArray);
            } else {
                stringArray = new String[]{"counts"};
                this.setBeforeUnits(stringArray);
            }
            if (this.ounits.equalsIgnoreCase("V")) {
                stringArray = new String[]{"volts"};
                this.setAfterUnits(stringArray);
            } else if (this.ounits.equalsIgnoreCase("A")) {
                stringArray = new String[]{"amps"};
                this.setAfterUnits(stringArray);
            } else if (this.ounits.equalsIgnoreCase("C")) {
                stringArray = new String[]{"counts"};
                this.setAfterUnits(stringArray);
            }
            this.setBeforeName(GROUND_DISP_NAME);
            this.setAfterName(this.instype);
            this.setType(Response.OTHER_CONVERSION);
            if (timeSeries != null) {
                this.dt = timeSeries.sampleInt;
            }
        }
        catch (IOException iOException) {
            throw new ResponseException(iOException.getMessage());
        }
        this.shortName = this.longName = string;
    }

    protected void read(ASCIIInputStream aSCIIInputStream, TimeInstant timeInstant, BasicChannel basicChannel, TimeSeries timeSeries) throws ResponseException, IOException {
        String string;
        this.gain = 1.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while ((string = aSCIIInputStream.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("DATA_TYPE")) {
                string2 = stringTokenizer.nextToken();
                if (!string2.equalsIgnoreCase("RESPONSE")) continue;
                string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("GSE2.0")) {
                    this.gseVersion = 0;
                    continue;
                }
                if (!string2.equalsIgnoreCase("GSE2.1")) continue;
                this.gseVersion = 1;
                continue;
            }
            if (string2.equalsIgnoreCase("CAL2")) {
                if (bl) {
                    return;
                }
                bl = this.readLineCAL2(string, timeInstant, basicChannel, timeSeries);
                continue;
            }
            if (!bl || string2.startsWith("*") || string2.startsWith("#") || string2.startsWith("(")) continue;
            if (string2.equalsIgnoreCase("STOP")) {
                return;
            }
            if (string2.equalsIgnoreCase("FAP2") || string2.equalsIgnoreCase("GEN2") || string2.equalsIgnoreCase("DIG2") || string2.equalsIgnoreCase("FIR2")) {
                throw new ResponseException("unsupported GSE2 response section: " + string2);
            }
            if (string2.equalsIgnoreCase("PAZ2")) {
                this.readPAZ2(string, aSCIIInputStream);
                continue;
            }
            throw new ResponseException(FreqText.invalid_keyword + ": " + string2);
        }
        if (this.snum < 1) {
            throw new ResponseException(FreqText.transfer_function_not_found + ": " + basicChannel.staName + " " + basicChannel.chanName + " " + basicChannel.compName + " " + basicChannel.instName);
        }
    }

    public boolean readLineCAL2(String string, TimeInstant timeInstant, BasicChannel basicChannel, TimeSeries timeSeries) {
        int n = 0;
        try {
            this.sta = string.substring(5, 10).trim();
            if (this.sta.length() < 1) {
                this.sta = BasicItem.UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: sta: " + exception + " in: " + string);
        }
        try {
            this.chan = string.substring(11, 14).trim();
            if (this.chan.length() < 1) {
                this.chan = BasicItem.UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: chan: " + exception + " in: " + string);
        }
        try {
            this.auxid = string.substring(15, 19).trim();
            if (this.auxid.length() < 1) {
                this.auxid = BasicItem.UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: auxid: " + exception + " in: " + string);
        }
        try {
            this.instype = string.substring(20, 26).trim();
            if (this.instype.length() < 1) {
                this.instype = BasicItem.UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: instype: " + exception + " in: " + string);
        }
        if (this.gseVersion == 0) {
            n = -5;
        }
        String string2 = BasicItem.UNDEF_STRING;
        try {
            string2 = string.substring(27, 42 + n).trim();
            this.calib = Double.parseDouble(string2);
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: calib: " + exception + " in: " + string);
        }
        if (basicChannel != null) {
            if (!(this.sta.equals(BasicItem.UNDEF_STRING) || basicChannel.staName.equals(BasicItem.UNDEF_STRING) || this.sta.equalsIgnoreCase(basicChannel.staName))) {
                return false;
            }
            if (!(this.chan.equals(BasicItem.UNDEF_STRING) || basicChannel.chanName.equals(BasicItem.UNDEF_STRING) || this.chan.equalsIgnoreCase(basicChannel.chanName))) {
                return false;
            }
            if (!(this.auxid.equals(BasicItem.UNDEF_STRING) || basicChannel.compName.equals(BasicItem.UNDEF_STRING) || this.auxid.equalsIgnoreCase(basicChannel.compName))) {
                return false;
            }
            if (!(this.instype.equals(BasicItem.UNDEF_STRING) || basicChannel.instName.equals(BasicItem.UNDEF_STRING) || this.instype.equalsIgnoreCase(basicChannel.instName))) {
                return false;
            }
            System.out.println("calibString channel.auxChannelIdName : <" + string2 + "> <" + basicChannel.auxChannelIdName);
            if (!(string2.equals(BasicItem.UNDEF_STRING) || basicChannel.auxChannelIdName.equals(BasicItem.UNDEF_STRING) || string2.equalsIgnoreCase(basicChannel.auxChannelIdName))) {
                return false;
            }
        }
        if (this.gseVersion == 0) {
            n = -6;
        }
        try {
            this.calper = Double.parseDouble(string.substring(43 + n, 50 + n).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: calper: " + exception + " in: " + string);
        }
        try {
            this.samprat = Double.parseDouble(string.substring(51 + n, 62 + n).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: samprat: " + exception + " in: " + string);
        }
        if (timeSeries != null && !(Math.abs(this.samprat - 1.0 / timeSeries.sampleInt) < this.samprat / 1000.0)) {
            return false;
        }
        try {
            this.ondate = string.substring(63 + n, 73 + n).trim();
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: ondate: " + exception + " in: " + string);
        }
        try {
            this.ontime = string.substring(74 + n, 79 + n).trim();
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: ontime: " + exception + " in: " + string);
        }
        if (timeInstant != null && this.compareDateTime(timeInstant, this.ondate, this.ontime) < 0) {
            System.out.println("INFO: GSEPoleZeroResponse: on date/time INVALID: on date/time refTimeInstant : <" + this.ondate + "-" + this.ontime + "> <" + timeInstant + "> " + " <" + this.sta + "> <" + this.chan + "> <" + this.auxid + "> <" + this.instype + ">");
            System.out.println("refTimeInstant.getMonth(): " + timeInstant.getYear());
            System.out.println("refTimeInstant.getMonth(): " + timeInstant.getMonth());
            System.out.println("refTimeInstant.getMonth(): " + timeInstant.getDate());
            return false;
        }
        if (string.length() < 90 + n) {
            return true;
        }
        try {
            this.offdate = string.substring(80 + n, 90 + n).trim();
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: offdate: " + exception + " in: " + string);
        }
        try {
            this.offtime = string.substring(91 + n, 96 + n).trim();
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: offtime: " + exception + " in: " + string);
        }
        if (timeInstant != null && this.compareDateTime(timeInstant, this.offdate, this.offtime) > 0) {
            System.out.println("INFO: GSEPoleZeroResponse: off date/time INVALID: off date/time refTimeInstant : <" + this.offdate + "-" + this.offtime + "> <" + timeInstant + "> " + " <" + this.sta + "> <" + this.chan + "> <" + this.auxid + "> <" + this.instype + ">");
            System.out.println("off date/time INVALID: <" + this.sta + "> <" + this.chan + "> <" + this.auxid + "> <" + this.instype + ">");
            return false;
        }
        return true;
    }

    public int compareDateTime(TimeInstant timeInstant, String string, String string2) {
        String[] stringArray = StringExt.parse(string, "/");
        int n = Integer.parseInt(stringArray[0]);
        if (timeInstant.getYear() < n) {
            return -1;
        }
        if (timeInstant.getYear() > n) {
            return 1;
        }
        int n2 = Integer.parseInt(stringArray[1]);
        if (timeInstant.getMonth() < n2) {
            return -1;
        }
        if (timeInstant.getMonth() > n2) {
            return 1;
        }
        int n3 = Integer.parseInt(stringArray[2]);
        if (timeInstant.getDate() < n3) {
            return -1;
        }
        if (timeInstant.getDate() > n3) {
            return 1;
        }
        String[] stringArray2 = StringExt.parse(string2, ":");
        int n4 = Integer.parseInt(stringArray2[0]);
        if (timeInstant.getHours() < n4) {
            return -1;
        }
        if (timeInstant.getHours() > n4) {
            return 1;
        }
        int n5 = Integer.parseInt(stringArray2[1]);
        if (timeInstant.getMinutes() < n5) {
            return -1;
        }
        if (timeInstant.getMinutes() > n5) {
            return 1;
        }
        return 0;
    }

    public void readPAZ2(String string, ASCIIInputStream aSCIIInputStream) throws ResponseException {
        double d;
        double d2;
        int n;
        try {
            this.snum = Integer.parseInt(string.substring(5, 7).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: snum: " + exception + " in: " + string);
        }
        try {
            this.ounits = string.substring(8, 9).trim();
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: ounits: " + exception + " in: " + string);
        }
        try {
            this.sfactor = Double.parseDouble(string.substring(10, 25).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: sfactor: " + exception + " in: " + string);
        }
        try {
            this.deci = Integer.parseInt(string.substring(26, 30).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: deci: " + exception + " in: " + string);
        }
        try {
            this.corr = Double.parseDouble(string.substring(31, 39).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: corr: " + exception + " in: " + string);
        }
        try {
            this.npole = Integer.parseInt(string.substring(40, 43).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: npole: " + exception + " in: " + string);
        }
        try {
            this.nzero = Integer.parseInt(string.substring(44, 47).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: GSEPoleZeroResponse: Parse error: nzero: " + exception + " in: " + string);
        }
        try {
            this.descrip = string.substring(48, 73).trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.poles = new Cmplx[this.npole];
            for (n = 0; n < this.npole; ++n) {
                d2 = aSCIIInputStream.readDouble();
                d = aSCIIInputStream.readDouble();
                this.poles[n] = new Cmplx(d2, d);
            }
        }
        catch (IOException iOException) {
            throw new ResponseException(FreqText.error_reading_pole + ": np= " + n + " / " + this.npole);
        }
        try {
            this.zeros = new Cmplx[this.nzero];
            for (n = 0; n < this.nzero; ++n) {
                d2 = aSCIIInputStream.readDouble();
                d = aSCIIInputStream.readDouble();
                this.zeros[n] = new Cmplx(d2, d);
            }
        }
        catch (IOException iOException) {
            throw new ResponseException(FreqText.error_reading_zero + ": nz= " + n + " / " + this.nzero);
        }
        try {
            aSCIIInputStream.flushLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        String string = super.toString();
        return string;
    }

    public static void main(String[] stringArray) {
        Cmplx[] cmplxArray;
        GSEPoleZeroResponse gSEPoleZeroResponse = null;
        try {
            gSEPoleZeroResponse = new GSEPoleZeroResponse(null, stringArray[0], null, null, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            return;
        }
        try {
            cmplxArray = (Cmplx[])gSEPoleZeroResponse.div(gSEPoleZeroResponse);
            Cmplx[] cmplxArray2 = cmplxArray.response(64, 0.1);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            return;
        }
        try {
            cmplxArray = gSEPoleZeroResponse.response(64, 0.1);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            return;
        }
    }
}

