/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.freq;

import net.alomax.freq.FilterException;
import net.alomax.freq.FreqText;
import net.alomax.freq.FrequencyDomainProcess;
import net.alomax.math.Cmplx;
import net.alomax.math.TimeSeries;

public abstract class BandpassFilter
implements FrequencyDomainProcess {
    public double highFreqCorner;
    public double lowFreqCorner;
    public int numPoles;
    public String errorMessage;
    public static final double FREQ_MIN = 1.0E-8;
    public static final double FREQ_MAX = 1.0E8;
    public static final double NUM_POLES_MIN = 2.0;
    public static final double NUM_POLES_MAX = 20.0;
    public static final double PI = Math.PI;
    public static final double TWOPI = Math.PI * 2;

    public BandpassFilter(String string, double d, double d2, int n) {
        this.highFreqCorner = d2;
        this.lowFreqCorner = d;
        this.numPoles = n;
        this.errorMessage = " ";
        FreqText.setLocale(string);
    }

    public void setHighFreqCorner(double d) throws FilterException {
        if (d < 1.0E-8 || d > 1.0E8) {
            throw new FilterException(FreqText.invalid_high_frequency_corner);
        }
        this.highFreqCorner = d;
    }

    public void setHighFreqCorner(String string) throws FilterException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FilterException(FreqText.invalid_high_frequency_corner);
        }
        this.setHighFreqCorner(d);
    }

    public void setLowFreqCorner(double d) throws FilterException {
        if (d < 1.0E-8 || d > 1.0E8) {
            throw new FilterException(FreqText.invalid_low_frequency_corner);
        }
        this.lowFreqCorner = d;
    }

    public void setLowFreqCorner(String string) throws FilterException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FilterException(FreqText.invalid_low_frequency_corner);
        }
        this.setLowFreqCorner(d);
    }

    public void setNumPoles(int n) throws FilterException {
        if ((double)n < 2.0 || (double)n > 20.0 || n % 2 != 0) {
            throw new FilterException(FreqText.invalid_number_of_poles);
        }
        this.numPoles = n;
    }

    public void setNumPoles(String string) throws FilterException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FilterException(FreqText.invalid_number_of_poles);
        }
        this.setNumPoles(n);
    }

    public void checkSettings() throws FilterException {
        String string = "";
        int n = 0;
        if (this.highFreqCorner < 1.0E-8 || this.highFreqCorner > 1.0E8) {
            string = string + ": " + FreqText.invalid_high_frequency_corner;
            ++n;
        }
        if (this.lowFreqCorner < 1.0E-8 || this.lowFreqCorner > 1.0E8) {
            string = string + ": " + FreqText.invalid_low_frequency_corner;
            ++n;
        }
        if (this.lowFreqCorner >= this.highFreqCorner) {
            string = string + ": " + FreqText.low_corner_greater_than_high_corner;
            ++n;
        }
        if ((double)this.numPoles < 2.0 || (double)this.numPoles > 20.0 || this.numPoles % 2 != 0) {
            string = string + ": " + FreqText.invalid_number_of_poles;
            ++n;
        }
        if (n > 0) {
            throw new FilterException(string + ".");
        }
    }

    public abstract Cmplx[] apply(double var1, Cmplx[] var3);

    public float[] preProcess(double d, float[] fArray) {
        return fArray;
    }

    public float[] postProcess(double d, float[] fArray) {
        return fArray;
    }

    public boolean sampleChangedInPreProcess() {
        return false;
    }

    public boolean sampleChangedInPostProcess() {
        return false;
    }

    public void updateFields(TimeSeries timeSeries) {
    }
}

