/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class SphericalSModel
extends SlownessModel
implements Serializable,
Cloneable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string;
        System.out.println("Starting main");
        VelocityModel velocityModel = new VelocityModel();
        SphericalSModel sphericalSModel = new SphericalSModel();
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            velocityModel.setFileType("tvel");
            string = File.separator + "MacintoshHD" + File.separator + "Philip" + File.separator + "TauP" + File.separator + "VModels" + File.separator + "iasp91.tvel";
        }
        boolean bl = true;
        try {
            bl = true;
            velocityModel.readVelocityFile(string);
            System.out.println("Done reading.");
            if (bl) {
                System.out.println(velocityModel);
            }
            bl = true;
            sphericalSModel.DEBUG = true;
            sphericalSModel.createSample(velocityModel);
            if (sphericalSModel.DEBUG) {
                System.out.println(sphericalSModel);
            }
            sphericalSModel.validate();
        }
        catch (IOException iOException) {
            System.out.println("Tried to read!\n Caught IOException " + iOException.getMessage() + "\n" + iOException.getClass().getName());
            iOException.printStackTrace();
        }
        catch (VelocityModelException velocityModelException) {
            System.out.println("Tried to read!\n Caught VelocityModelException " + velocityModelException.getMessage());
            velocityModelException.printStackTrace();
        }
        catch (SlownessModelException slownessModelException) {
            System.out.println(velocityModel);
            System.out.println(sphericalSModel);
            System.out.println("Tried to create slowness!\n Caught SlownessModelException " + slownessModelException.getMessage());
            slownessModelException.printStackTrace();
        }
        finally {
            System.out.println("Done!\n");
        }
    }

    public double toSlowness(double d, double d2) throws SlownessModelException {
        if (d == 0.0) {
            throw new SlownessModelException("Divide by zero in toSlowness()\ndepth = " + d2 + "\nThis likely has to do with using S velocities in the outer core");
        }
        return (this.radiusOfEarth - d2) / d;
    }

    public double toVelocity(double d, double d2) throws SlownessModelException {
        if (d == 0.0) {
            throw new SlownessModelException("Divide by zero in toVelocity()\ndepth = " + d2 + "\nPossibly this is due to depth at center of the earth?");
        }
        return (this.radiusOfEarth - d2) / d;
    }

    public SlownessLayer toSlownessLayer(VelocityLayer velocityLayer, boolean bl) throws SlownessModelException {
        return new SlownessLayer(velocityLayer, true, this.radiusOfEarth, bl);
    }

    public double interpolate(double d, double d2, double d3, double d4) throws SlownessModelException {
        double d5 = d * d4 + 1.0;
        if (d5 == 0.0) {
            double d6 = Double.MAX_VALUE;
            throw new SlownessModelException("Neg velocity gradient just balances the earth flattening! What should I do?!?!?!? topDepth= " + d3);
        }
        double d7 = (this.radiusOfEarth + d * (d3 * d4 - d2)) / d5;
        return d7;
    }

    public TimeDist layerTimeDist(double d, int n, boolean bl) throws SlownessModelException {
        TimeDist timeDist = new TimeDist(d);
        SlownessLayer slownessLayer = this.getSlownessLayer(n, bl);
        double d2 = this.radiusOfEarth - slownessLayer.topDepth;
        double d3 = this.radiusOfEarth - slownessLayer.botDepth;
        if (d > Math.max(slownessLayer.topP, slownessLayer.botP)) {
            throw new SlownessModelException("Ray cannot propagate within this layer. layerNum = " + n + " sphericalRayParam=" + d + "\n" + slownessLayer);
        }
        if (d < 0.0) {
            throw new SlownessModelException("Ray Parameter is negative!!! " + d);
        }
        if (d > Math.min(slownessLayer.topP, slownessLayer.botP)) {
            if (this.DEBUG) {
                System.out.println("Ray Turns in layer, velocities: " + d2 / d + " " + d2 / slownessLayer.topP + " " + d3 / slownessLayer.botP);
                System.out.println("depths        top " + slownessLayer.topDepth + "  bot " + slownessLayer.botDepth);
            }
            throw new SlownessModelException("Ray turns in the middle of this layer. \nlayerNum = " + n + " sphericalRayParam " + d + " sphericalLayer =  " + slownessLayer + "\n");
        }
        if (slownessLayer.topDepth == slownessLayer.botDepth) {
            timeDist.time = 0.0;
            timeDist.dist = 0.0;
            return timeDist;
        }
        if (d == 0.0 && slownessLayer.botDepth == this.radiusOfEarth) {
            if (n != this.getNumLayers(bl) - 1) {
                throw new SlownessModelException("There are layers deeper than the center of the earth!");
            }
            timeDist.dist = 1.5707963267948966;
            timeDist.time = slownessLayer.topP;
            if (this.DEBUG) {
                System.out.println("Center of Earth: dist " + timeDist.dist + " time " + timeDist.time);
            }
            if (timeDist.dist < 0.0 || timeDist.time < 0.0 || Double.isNaN(timeDist.time) || Double.isNaN(timeDist.dist)) {
                throw new SlownessModelException("CoE timedist <0.0 or NaN: sphericalRayParam= " + d + " botDepth = " + slownessLayer.botDepth + " dist=" + timeDist.dist + " time=" + timeDist.time);
            }
            return timeDist;
        }
        if (Math.abs(d2 / slownessLayer.topP - d3 / slownessLayer.botP) < this.slownessTolerance) {
            double d4 = d3 / slownessLayer.botP;
            double d5 = d2 * d2 - d * d * d4 * d4;
            if (Math.abs(d5) < this.slownessTolerance) {
                d5 = 0.0;
            }
            double d6 = d == slownessLayer.botP ? 0.0 : d3 * d3 - d * d * d4 * d4;
            double d7 = Math.sqrt(d5) - Math.sqrt(d6);
            timeDist.time = d7 / d4;
            timeDist.dist = Math.asin(d7 * d * d4 / (d2 * d3));
            if (timeDist.dist < 0.0 || timeDist.time < 0.0 || Double.isNaN(timeDist.time) || Double.isNaN(timeDist.dist)) {
                throw new SlownessModelException("CVL timedist <0.0 or NaN: \nsphericalRayParam= " + d + "\n botDepth = " + slownessLayer.botDepth + "\n topDepth = " + slownessLayer.topDepth + "\n topRadius=" + d2 + " botRadius=" + d3 + "\n dist=" + timeDist.dist + "\n time=" + timeDist.time + "\n b=" + d7 + "\n topTerm=" + d5 + "\n botTerm=" + d6 + "\n vel    =" + d4 + "\n" + "\n bR^2   =" + d3 * d3 + "\n p^2v^2 =" + d * d * d4 * d4 + "\n tR^2   =" + d2 * d2 + "\n p^2v^2 =" + d * d * d4 * d4);
            }
            return timeDist;
        }
        return slownessLayer.bullenRadialSlowness(d, this.radiusOfEarth);
    }

    public boolean validate() throws SlownessModelException {
        boolean bl = super.validate();
        double d = 0.0;
        boolean bl2 = true;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.getNumLayers(bl2); ++j) {
                SlownessLayer slownessLayer = this.getSlownessLayer(j, bl2);
                d = slownessLayer.botDepth;
                if (d > this.radiusOfEarth) {
                    bl = false;
                    throw new SlownessModelException("Slowness layer has a depth larger than the radius of the earth in a spherical model. max depth = " + d + " radiusOfEarth = " + this.radiusOfEarth);
                }
                bl |= true;
            }
            bl2 = false;
        }
        return bl;
    }

    public Object clone() {
        SphericalSModel sphericalSModel = (SphericalSModel)super.clone();
        return sphericalSModel;
    }

    public String toString() {
        String string = "spherical model:\n" + super.toString();
        return string;
    }
}

