/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.HilbertSpace;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.DoubleVector;
import JSci.maths.vectors.IntegerVector;
import JSci.maths.vectors.VectorDimensionException;

public class ComplexVector
extends AbstractComplexVector {
    protected double[] vectorRe;
    protected double[] vectorIm;

    public ComplexVector(int n) {
        super(n);
        this.vectorRe = new double[n];
        this.vectorIm = new double[n];
    }

    public ComplexVector(double[] dArray, double[] dArray2) {
        super(dArray.length);
        this.vectorRe = dArray;
        this.vectorIm = dArray2;
    }

    public ComplexVector(Complex[] complexArray) {
        this(complexArray.length);
        for (int i = 0; i < this.N; ++i) {
            this.vectorRe[i] = complexArray[i].real();
            this.vectorIm[i] = complexArray[i].imag();
        }
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof ComplexVector && this.N == ((ComplexVector)object).N) {
            ComplexVector complexVector = (ComplexVector)object;
            double d2 = 0.0;
            for (int i = 0; i < this.N; ++i) {
                double d3 = this.vectorRe[i] - complexVector.getRealComponent(i);
                double d4 = this.vectorIm[i] - complexVector.getImagComponent(i);
                d2 += d3 * d3 + d4 * d4;
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(8 * this.N);
        for (n = 0; n < this.N - 1; ++n) {
            stringBuffer.append(Complex.toString(this.vectorRe[n], this.vectorIm[n]));
            stringBuffer.append(',');
        }
        stringBuffer.append(Complex.toString(this.vectorRe[n], this.vectorIm[n]));
        return stringBuffer.toString();
    }

    public AbstractDoubleVector real() {
        return new DoubleVector(this.vectorRe);
    }

    public AbstractDoubleVector imag() {
        return new DoubleVector(this.vectorIm);
    }

    public Complex getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return new Complex(this.vectorRe[n], this.vectorIm[n]);
        }
        throw new VectorDimensionException(ComplexVector.getInvalidComponentMsg(n));
    }

    public double getRealComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vectorRe[n];
        }
        throw new VectorDimensionException(ComplexVector.getInvalidComponentMsg(n));
    }

    public double getImagComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vectorIm[n];
        }
        throw new VectorDimensionException(ComplexVector.getInvalidComponentMsg(n));
    }

    public void setComponent(int n, Complex complex) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(ComplexVector.getInvalidComponentMsg(n));
        }
        this.vectorRe[n] = complex.real();
        this.vectorIm[n] = complex.imag();
    }

    public void setComponent(int n, double d, double d2) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(ComplexVector.getInvalidComponentMsg(n));
        }
        this.vectorRe[n] = d;
        this.vectorIm[n] = d2;
    }

    public double norm() {
        double d = this.vectorRe[0] * this.vectorRe[0] + this.vectorIm[0] * this.vectorIm[0];
        for (int i = 1; i < this.N; ++i) {
            d += this.vectorRe[i] * this.vectorRe[i] + this.vectorIm[i] * this.vectorIm[i];
        }
        return Math.sqrt(d);
    }

    public double infNorm() {
        double d = this.vectorRe[0] * this.vectorRe[0] + this.vectorIm[0] * this.vectorIm[0];
        for (int i = 1; i < this.N; ++i) {
            double d2 = this.vectorRe[i] * this.vectorRe[i] + this.vectorIm[i] * this.vectorIm[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return Math.sqrt(d);
    }

    public AbelianGroup.Member negate() {
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        dArray[0] = -this.vectorRe[0];
        dArray2[0] = -this.vectorIm[0];
        for (int i = 1; i < this.N; ++i) {
            dArray[i] = -this.vectorRe[i];
            dArray2[i] = -this.vectorIm[i];
        }
        return new ComplexVector(dArray, dArray2);
    }

    public AbstractComplexVector conjugate() {
        double[] dArray = new double[this.N];
        dArray[0] = -this.vectorIm[0];
        for (int i = 1; i < this.N; ++i) {
            dArray[i] = -this.vectorIm[i];
        }
        return new ComplexVector(this.vectorRe, dArray);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof ComplexVector) {
            return this.add((ComplexVector)member);
        }
        if (member instanceof DoubleVector) {
            return this.add((DoubleVector)member);
        }
        if (member instanceof IntegerVector) {
            return this.add((IntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector add(AbstractComplexVector abstractComplexVector) {
        if (abstractComplexVector instanceof ComplexVector) {
            return this.add((ComplexVector)abstractComplexVector);
        }
        if (this.N == abstractComplexVector.N) {
            double[] dArray = new double[this.N];
            double[] dArray2 = new double[this.N];
            dArray[0] = this.vectorRe[0] + abstractComplexVector.getComponent(0).real();
            dArray2[0] = this.vectorIm[0] + abstractComplexVector.getComponent(0).imag();
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] + abstractComplexVector.getComponent(i).real();
                dArray2[i] = this.vectorIm[i] + abstractComplexVector.getComponent(i).imag();
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector add(ComplexVector complexVector) {
        if (this.N == complexVector.N) {
            double[] dArray = new double[this.N];
            double[] dArray2 = new double[this.N];
            dArray[0] = this.vectorRe[0] + complexVector.vectorRe[0];
            dArray2[0] = this.vectorIm[0] + complexVector.vectorIm[0];
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] + complexVector.vectorRe[i];
                dArray2[i] = this.vectorIm[i] + complexVector.vectorIm[i];
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.add((DoubleVector)abstractDoubleVector);
        }
        if (this.N == abstractDoubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] + abstractDoubleVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] + abstractDoubleVector.getComponent(i);
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector add(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] + doubleVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] + doubleVector.vector[i];
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector instanceof IntegerVector) {
            return this.add((IntegerVector)abstractIntegerVector);
        }
        if (this.N == abstractIntegerVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] + (double)abstractIntegerVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] + (double)abstractIntegerVector.getComponent(i);
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector add(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] + (double)integerVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] + (double)integerVector.vector[i];
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof ComplexVector) {
            return this.subtract((ComplexVector)member);
        }
        if (member instanceof DoubleVector) {
            return this.subtract((DoubleVector)member);
        }
        if (member instanceof IntegerVector) {
            return this.subtract((IntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector subtract(AbstractComplexVector abstractComplexVector) {
        if (abstractComplexVector instanceof ComplexVector) {
            return this.subtract((ComplexVector)abstractComplexVector);
        }
        if (this.N == abstractComplexVector.N) {
            double[] dArray = new double[this.N];
            double[] dArray2 = new double[this.N];
            dArray[0] = this.vectorRe[0] - abstractComplexVector.getComponent(0).real();
            dArray2[0] = this.vectorIm[0] - abstractComplexVector.getComponent(0).imag();
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] - abstractComplexVector.getComponent(i).real();
                dArray2[i] = this.vectorIm[i] - abstractComplexVector.getComponent(i).imag();
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector subtract(ComplexVector complexVector) {
        if (this.N == complexVector.N) {
            double[] dArray = new double[this.N];
            double[] dArray2 = new double[this.N];
            dArray[0] = this.vectorRe[0] - complexVector.vectorRe[0];
            dArray2[0] = this.vectorIm[0] - complexVector.vectorIm[0];
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] - complexVector.vectorRe[i];
                dArray2[i] = this.vectorIm[i] - complexVector.vectorIm[i];
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.subtract((DoubleVector)abstractDoubleVector);
        }
        if (this.N == abstractDoubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] - abstractDoubleVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] - abstractDoubleVector.getComponent(i);
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector subtract(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] - doubleVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] - doubleVector.vector[i];
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector instanceof IntegerVector) {
            return this.subtract((IntegerVector)abstractIntegerVector);
        }
        if (this.N == abstractIntegerVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] - (double)abstractIntegerVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] - (double)abstractIntegerVector.getComponent(i);
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector subtract(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] - (double)integerVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vectorRe[i] - (double)integerVector.vector[i];
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Complex) {
            return this.scalarMultiply((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        dArray[0] = this.vectorRe[0] * d - this.vectorIm[0] * d2;
        dArray2[0] = this.vectorRe[0] * d2 + this.vectorIm[0] * d;
        for (int i = 1; i < this.N; ++i) {
            dArray[i] = this.vectorRe[i] * d - this.vectorIm[i] * d2;
            dArray2[i] = this.vectorRe[i] * d2 + this.vectorIm[i] * d;
        }
        return new ComplexVector(dArray, dArray2);
    }

    public AbstractComplexVector scalarMultiply(double d) {
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        dArray[0] = d * this.vectorRe[0];
        dArray2[0] = d * this.vectorIm[0];
        for (int i = 1; i < this.N; ++i) {
            dArray[i] = d * this.vectorRe[i];
            dArray2[i] = d * this.vectorIm[i];
        }
        return new ComplexVector(dArray, dArray2);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof Complex) {
            return this.scalarDivide((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector scalarDivide(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        if (Math.abs(d) < Math.abs(d2)) {
            double d3 = d / d2;
            double d4 = d * d3 + d2;
            for (int i = 0; i < this.N; ++i) {
                dArray[i] = (this.vectorRe[i] * d3 + this.vectorIm[i]) / d4;
                dArray2[i] = (this.vectorIm[i] * d3 - this.vectorRe[i]) / d4;
            }
        } else {
            double d5 = d2 / d;
            double d6 = d + d2 * d5;
            for (int i = 0; i < this.N; ++i) {
                dArray[i] = (this.vectorRe[i] + this.vectorIm[i] * d5) / d6;
                dArray2[i] = (this.vectorIm[i] - this.vectorRe[i] * d5) / d6;
            }
        }
        return new ComplexVector(dArray, dArray2);
    }

    public AbstractComplexVector scalarDivide(double d) {
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        dArray[0] = this.vectorRe[0] / d;
        dArray2[0] = this.vectorIm[0] / d;
        for (int i = 1; i < this.N; ++i) {
            dArray[i] = this.vectorRe[i] / d;
            dArray2[i] = this.vectorIm[i] / d;
        }
        return new ComplexVector(dArray, dArray2);
    }

    public Complex scalarProduct(HilbertSpace.Member member) {
        if (member instanceof ComplexVector) {
            return this.scalarProduct((ComplexVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex scalarProduct(AbstractComplexVector abstractComplexVector) {
        if (abstractComplexVector instanceof ComplexVector) {
            return this.rawScalarProduct((ComplexVector)abstractComplexVector);
        }
        if (this.N == abstractComplexVector.N) {
            Complex complex = abstractComplexVector.getComponent(0);
            double d = this.vectorRe[0] * complex.real() + this.vectorIm[0] * complex.imag();
            double d2 = this.vectorIm[0] * complex.real() - this.vectorRe[0] * complex.imag();
            for (int i = 1; i < this.N; ++i) {
                complex = abstractComplexVector.getComponent(i);
                d += this.vectorRe[i] * complex.real() + this.vectorIm[i] * complex.imag();
                d2 += this.vectorIm[i] * complex.real() - this.vectorRe[i] * complex.imag();
            }
            return new Complex(d, d2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private Complex rawScalarProduct(ComplexVector complexVector) {
        if (this.N == complexVector.N) {
            double d = this.vectorRe[0] * complexVector.vectorRe[0] + this.vectorIm[0] * complexVector.vectorIm[0];
            double d2 = this.vectorIm[0] * complexVector.vectorRe[0] - this.vectorRe[0] * complexVector.vectorIm[0];
            for (int i = 1; i < this.N; ++i) {
                d += this.vectorRe[i] * complexVector.vectorRe[i] + this.vectorIm[i] * complexVector.vectorIm[i];
                d2 += this.vectorIm[i] * complexVector.vectorRe[i] - this.vectorRe[i] * complexVector.vectorIm[i];
            }
            return new Complex(d, d2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector mapComponents(ComplexMapping complexMapping) {
        Complex[] complexArray = new Complex[this.N];
        complexArray[0] = complexMapping.map(this.vectorRe[0], this.vectorIm[0]);
        for (int i = 1; i < this.N; ++i) {
            complexArray[i] = complexMapping.map(this.vectorRe[i], this.vectorIm[i]);
        }
        return new ComplexVector(complexArray);
    }
}

