__author__ = 'Roy'

import logging

from qpython import qconnection

logger = logging.getLogger(__name__)
logging.basicConfig(level=logging.DEBUG)


class Server:
    def __init__(self):
        self.name = ""
        self.host = ""
        self.port = 0
        self.username = ""
        self.password = ""
        self.pandas = False

    def to_string(self):
        return self.name


class KDB:
    def __init__(self, server):
        self.ds = server.name
        self.q = qconnection.QConnection(host=server.host, port=server.port, username=server.username,
                                         password=server.password,
                                         pandas=server.pandas)

    def get_conn(self):
        return self.q

    def close_conn(self):
        self.q.close()

    def query_sync(self, query, *parameters, **options):
        self.q.open()
        try:
            return self.q.sync(query, *parameters, **options)
        except Exception as e:
            logger.error("DB[%s] error code: %s, msg: %s", self.ds, str(e.args[0]), str(e.message))
            logger.error("query: %s", query)
            logger.error("parameters: %s", parameters)
            logger.error("options: %s", options)
        finally:
            self.close_conn()
