
import os
import glob
from zope.testing import doctest
import unittest
from Globals import package_home
from Testing.ZopeTestCase import FunctionalDocFileSuite as Suite

from Products.CMFCore.utils import getToolByName

from betahaus.openmember.tests.base import FunctionalTestCase
#from betahaus.openmember.catalog import OpenMemberCatalog

#from Products.CMFPlone.tests.utils import MockMailHost

#List unittests here
UNITTESTS = [] 
OPTIONFLAGS = (doctest.ELLIPSIS |
               doctest.NORMALIZE_WHITESPACE)

from betahaus.openmember.browser.baseview import OMBaseView

class TestOMCatalog(FunctionalTestCase):

    def afterSetUp(self):
        self.setRoles(('Manager',))
        self.openmember_catalog = getToolByName(self.portal, 'openmember_catalog')

        #Create some dummy content to play with
        dc = []
        ft = self.portal.invokeFactory
        ft('Folder','folder1')
        dc.append(self.portal.folder1)
        ft('Folder','folder2')
        dc.append(self.portal.folder2)
        ft('Document', 'doc1')
        dc.append(self.portal.doc1)
        ft('Document', 'doc2')
        dc.append(self.portal.doc2)
        self.dummy_portal_content = dc

    def test_isUIDLike(self):
        isUIDLike = self.openmember_catalog.isUIDLike
        #UIDs should be strings with 32 chars consisting of "a-f0-9"
        self.failUnless(isUIDLike('a903e20cea0d66eec4b7816be9a60900'))
        self.failIf(isUIDLike('K903e20cea0d66eec4b7816be9a60900'))
        self.failIf(isUIDLike('1234567890abcdef'))
        #Check regular Plone generated before
        for obj in self.dummy_portal_content:
            self.failUnless(isUIDLike( obj.UID() ))


def list_doctests():
    home = package_home(globals())
    return [filename for filename in
            glob.glob(os.path.sep.join([home, '*.txt']))
            if os.path.basename(filename) not in UNITTESTS]

def test_suite():
    filenames = list_doctests()

    functional_doctests = [Suite(os.path.basename(filename),
                          optionflags=OPTIONFLAGS,
                          package='betahaus.openmember.tests',
                          test_class=FunctionalTestCase)
                          for filename in filenames]

    suite = unittest.TestSuite(functional_doctests)
    
    suite.addTest(unittest.makeSuite(TestOMCatalog))

    return suite