from betahaus.openmember import CATALOG_ID, DATABASE_ID, logger
from Products.CMFCore.utils import getToolByName

#FIXME: This looks a bit weird, but it's needed for ZCTextIndex to work
class _extra:
    pass

def setupVarious(context):
    """Entry point for generic setup"""
    if context.readDataFile('betahaus_openmember_various.txt'):
        setup = Setup(context)
        setup.main_setup()
    if context.readDataFile('personcontent_marker.txt'):
        setup = Setup(context)
        setup.person_setup()
    if context.readDataFile('organisationcontent_marker.txt'):
        setup = Setup(context)
        setup.organisation_setup()
    return


def install(context):
    site = context.getSite()
    qi = getToolByName(site, 'portal_quickinstaller')
    ps = getToolByName(site, 'portal_setup')
    if qi.isProductInstallable('betahaus.openmember'):
        qi.installProduct('betahaus.opemember')
        ps.runAllImportStepsFromProfile('profile-betahaus.openmember:betahaus.openmember', 
                                        purge_old = False)
    
class Setup(object):
    """Setup various for different profiles"""
    
    def __init__(self, context):
        self.site = context.getSite()
        self.context = context
        self.omcatalog = getToolByName(self.site, CATALOG_ID)
        #Add property unwrapobjects = True
        #If the property isn't set the catalog might index scripts or other content as properties
        if not hasattr(self.omcatalog, 'unwrapobjects'):
            self.omcatalog._setProperty('unwrapobjects', True, 'boolean')

    def main_setup(self):
        indexes = [('membership_references','KeywordIndex', 'Memberships'),
                   ('getMappedObjectUID','FieldIndex', 'MappedUIDS')]
        self.add_indexes(indexes)
        
    def person_setup(self):
        indexes = [('first_name','ZCTextIndex', 'First Name'),
                   ('last_name','ZCTextIndex', 'Last Name'),
                   ('date_of_birth','DateIndex', 'Birthday'),
                  ]
        self.add_address_indexes()
        self.add_indexes(indexes)
            
        
    def organisation_setup(self):
        #indexes = [('membership_references','KeywordIndex')]
        #self.add_indexes(indexes)
        self.add_address_indexes()
    
    def add_address_indexes(self):
        indexes =  [('street_address','ZCTextIndex', 'Address'),
                   ('street_address2','ZCTextIndex', 'Extra Address'),
                   ('postal_area','ZCTextIndex', 'Postal Area'),
                   ('state_province','ZCTextIndex', 'State'),
                   ('postal_code','ZCTextIndex', 'Postal Code'),
                   ('country','ZCTextIndex', 'Country')
                   ]
        self.add_indexes(indexes)
    
    def add_indexes(self, indexes):
        omcatalog_indexes = self.omcatalog.indexes()
        for name, meta_type, label in indexes:
            if name in omcatalog_indexes:
                this_index = self.omcatalog.Indexes.get(name)
                if this_index.meta_type == meta_type and getattr(this_index, 'label', '') == label:
                    # no change
                    continue
                # there was change delete so that we can add it correctly
                self.omcatalog.delIndex(name)
            
            # add the index
            self.omcatalog.addIndex(name, meta_type, label = label)
                
                    
        #schema == columns for catalog
        omcatalog_columns = self.omcatalog.schema()
        for name in indexes:
            if name[0] not in omcatalog_columns:
                self.omcatalog.addColumn(name[0])
