from zope.interface import implements
from zope.formlib import form

from AccessControl import getSecurityManager

from plone.portlets.interfaces import IPortletDataProvider
from plone.app.portlets.portlets import base
from plone.app.portlets.cache import render_cachekey

from plone.memoize.compress import xhtml_compress

from Products.Five.browser.pagetemplatefile import ViewPageTemplateFile
from Products.CMFCore.utils import getToolByName

from Products.CMFPlone import utils

from betahaus.openmember.interfaces import IOpenMemberPortlet
from betahaus.openmember import MessageFactory as _
from betahaus.openmember import OPENMEMBER_SEARCH_DATABASE

class Assignment(base.Assignment):
    implements(IOpenMemberPortlet)

        
    @property
    def title(self):
        return _(u"OpenMember database")

class Renderer(base.Renderer):

    _template = ViewPageTemplateFile('openmember.pt')


#    @ram.cache(_render_cachekey)
    def render(self):
        return xhtml_compress(self._template())

    @property
    def available(self):
        sm = getSecurityManager()
        return sm.checkPermission(OPENMEMBER_SEARCH_DATABASE, self.context)
        
    
    @property
    def site_url(self):
        return getToolByName(self.context, 'portal_url').portal_url()
    
    @property
    def openmember_catalog(self):
        return getToolByName(self.context, 'openmember_catalog')
    
    def getFields(self):
        """Gets the fields that are to be show in the search portlet.
        """
        # XXX Maybe the portlet should have its own settings?
        # But is it a point to search for things if they aren't shown in the listing?
         
        portal_properties = getToolByName(self.context, 'portal_properties', None)
        openmember_properties = getattr(portal_properties, 'openmember_properties', None)
        if openmember_properties.hasProperty('title_fields'):
            fields = list(openmember_properties.getProperty('title_fields'))
            
        # getProperty returns ('',) which needs more checks to find.
        if len(fields) == 0 or len(fields) == 1 and fields[0] == '':
            fields = self.openmember_catalog.mirrorableIndexes()
            
        for index in fields:
            isKeywordIndex = self.openmember_catalog.isKeywordIndex(index)
            
            if isKeywordIndex == True:
                index_type = 'selection'
                
            else:
                index_type = 'text'
                
            yield {'id': 'omportlet-'+index, # the extra d padding i needed to not interfere with other ids in Plone, needs to be unique
                   'label': getattr(self.openmember_catalog.Indexes.get(index), 'label', index),
                   'type' : index_type,
                   }
            
    def getOptions(self, index):
        """
        """
        # since we pad the index id for uniqueness we need to remove the padding to get the real index id
        index_id = index.replace('omportlet-','')
        for item in self.openmember_catalog.Indexes.get(index_id).uniqueValues():
            yield item
            
    def getTitle(self, field, id):
        if self.openmember_catalog.isUIDLike(id):
            return self.getTitleFromUID(id)
        elif id != None:
            
            field = field.replace('omportlet-','')
            mapped_objects = self.openmember_catalog({field:id})
            if len(mapped_objects):
                mapped_brain = mapped_objects[0]
                mapped_object = mapped_brain.getObject()._getMappedObject() 
                mapped_field = mapped_object.getField(field)
                
                if mapped_field != None and len(mapped_field.Vocabulary(mapped_object)) > 0:
                    for display_info in mapped_field.Vocabulary(mapped_object).items():
                        value, title = display_info
                        if value == id:
                            id = title
                            break
        return id
            
    def selected(self, value, field):
        try:
            return value in self.request.get(field, [])
        except:
            return False
            
    def getTitleFromUID(self, uid):
        """takes a uid returns a title"""
        obj = getToolByName(self.context, 'reference_catalog').lookupObject(uid)
        if obj:
            return obj.Title()
        else:
            return _('No title')

class AddForm(base.NullAddForm):
    label = _(u"Add OpenMember portlet")
    description = _(u"")

    def create(self):
        return Assignment()


    