from zope.interface import Interface
from zope.component.interfaces import IObjectEvent
from plone.app.controlpanel.interfaces import IPloneControlPanelForm

from zope import schema

from betahaus.openmember import MessageFactory as _

class IOpenMember(Interface):
    """ This defines a content type as a potential member.
        Any content type with this interface will fire up an event.
        You can add the interface through zcml:
        <five:implements
            class=".demomember.DemoMember" 
            interface="betahaus.openmember.interfaces.IOpenMember"/> 
    """
class IOpenMemberCatalog(Interface):
    """Custom catalog
    """

class IOpenMemberPortlet(Interface):
    """Interface for portlet"""

class IFiscalYear(Interface):
    """Folder that stores members for a specific fiscal year"""
    
class IMemberData(Interface):
    """Content type that stores member data"""

class IBaseMember(Interface):
    """Mixin class for content with minimum requirements met to be a member.
    """

class IBasePerson(Interface):
    """Mixin for a member content type that is actually a person.
    """

class IBaseOrganisation(Interface):
    """Mixin for members that are organisations or companies
    """

class IMemberPerson(Interface):
    """Actual content type that inherits from BasePerson"""

class IMemberOrganisation(Interface):
    """Actual content type that inherits from BasePerson"""

class IOMBaseView(Interface):
    """Base view for listings involving OpenMember data"""

class IFiscalYearView(Interface):
    """Marker interface for browser view"""

class IOMControlPanelForm(Interface):
    """Interface for forms that are to be part of the Control Panel"""
    
    def getId():
        """ the id"""
    
    def getLabel():
        """ the label """
    
class IOMControlPanelDatabaseSchema(IOMControlPanelForm):
    """Interface for the control panel schema"""
#    member_candidate_types = schema.Tuple(
#        title=_(u'Member candidate content types'),
#        description=_(u"The content types that the member database will fetch data from."
#                       "You probably want to use the content type this site uses for member profiles."
#                       "NOTE: If all are unchecked, the database won't store any new data."),
#        required=False,
#        missing_value=set(),
#        value_type=schema.Choice(vocabulary="plone.app.vocabularies.PortalTypes"),
#        )

    fields_to_index = schema.List(
        title=_(u'Fields to index'),
        description=_(u"Store Member Data from these fields on selected content types."),
        default=[],
        value_type=schema.TextLine(),
        required=False,
        )

    
    title_fields = schema.List(
        title=_(u'Title fields'),
        description=_(u"Add the fields that should be searchable, empty means all fields."),
        missing_value = set(),
        value_type=schema.Choice(vocabulary = 'betahaus.openmember.SelectableIndexes'),
        required=False,
        )    


class IOMDataHandler(Interface):
    """Interface that handles all communication with the Open Member database
    """

    def addMember(obj):
        """obj is the member that needs to be mapped"""

    def updateMember(obj):
        """Updates member data for obj"""

class IOMemberAddedEvent(IObjectEvent):
    """A field has been modified, versioning needed"""

class IOMemberModifiedEvent(IObjectEvent):
    """A field has been modified, versioning needed"""

class IOMemberWillBeModifiedEvent(IObjectEvent):
    """A field has been modified, versioning needed"""

class IOMemberDeletedEvent(IObjectEvent):
    """A field has been modified, versioning needed"""
    
class IOpenMemberContextResults(Interface):
    """Adapter for getting results from different contenttypes.
    """
    
    def getResults():
        """Returns the results for this context.
        """
        

