from betahaus.openmember.interfaces import IMemberData
from betahaus.openmember import PROJECTNAME, CATALOG_ID

from betahaus.openmember import MessageFactory as _

from Products.Archetypes.BaseObject import BaseObject
from Products.Archetypes.CatalogMultiplex import CatalogMultiplex
from Products.CMFCore.utils import getToolByName

from OFS.History import Historical

from Products.Archetypes.ClassGen import generateClass
from Globals import InitializeClass

from zope.interface import implements

#class MemberData(CatalogMultiplex,
#                 BaseObject,
#                 Historical
#                 ):
from Products.CMFCore.PortalContent import PortalContent
from Products.Archetypes.interfaces.base import IBaseContent
from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import registerType
from Products.Archetypes.atapi import BaseContentMixin
from Products.Archetypes.atapi import Schema
from Products.Archetypes.atapi import StringField
from Products.Archetypes.atapi import IdWidget
from Products.ATContentTypes.permission import ChangeTopics
from Products.CMFCore.permissions import View


class MemberData(BaseContentMixin):
    """A minimal contenttype that is indexable by a catalog.
    """
    __implements__ = (PortalContent.__implements__,
                      IBaseContent)    

    security = ClassSecurityInfo()


    meta_type = 'MemberData'
    archetype_name = 'Member Data'
    
    schema  = Schema((
                        StringField('id',
                                    required=1,
                                    mode="r",
                                    default=None,
                                    write_permission=ChangeTopics,
                                    widget=IdWidget(
                                        label=_(u'label_short_name', default=u'Short Name'),
                                        description=_(u'help_shortname',
                                                      default=u"Should not contain spaces, underscores or mixed case. "
                                                               "Short Name is part of the item's web address."),
                                        visible={'view' : 'invisible'}
                                        ),
                                    ),
                        ))
    
    security.declareProtected(View, 'Type')
    def Type(self):
        return self.archetype_name
        
    security.declareProtected(View, 'Description')
    def Description(self):
        #Return docstring as description
        lines = [ line.strip() for line in self.__doc__.splitlines() ]
        return ' '.join( [ line for line in lines if line ] )
    
    def _getMappedObject(self):
        """ Returns the object that this MemberData is mapped from.
            The id of this object is the same as the uid of the object mapped."""
        return getToolByName(self, 'reference_catalog').lookupObject(self.id)

    def getMappedObjectUID(self):
        mapped = self._getMappedObject()
        if mapped:
            return str(mapped.UID())
        return 'orphaned'

    def omcIndexObject(self):
        getToolByName(self, CATALOG_ID).indexObject(self)

    def omcReIndexObject(self):
        getToolByName(self, CATALOG_ID).reindexObject(self)
        
    def omcUnIndexObject(self):
        getToolByName(self, CATALOG_ID).unindexObject(self)

    # catalog methods
    # This makes portal_cataog unaware of this content type 
    def indexObject(self, *args, **kwargs): pass
    def unindexObject(self, *args, **kwargs): pass
    def reindexObject(self, *args, **kwargs): pass


generateClass(MemberData)
InitializeClass(MemberData)
registerType(MemberData, PROJECTNAME)
