from zope.interface import implements, directlyProvides
from zope.component import getMultiAdapter

from AccessControl import ClassSecurityInfo

from Products.CMFCore.utils import getToolByName
from Products.CMFCore.permissions import View, ModifyPortalContent, ReviewPortalContent

from Products.Archetypes import atapi
#from Products.ATExtensions import ateapi

from Products.ATContentTypes.content.base import ATCTContent
from Products.ATContentTypes.content import schemata

from betahaus.openmember import PROJECTNAME, OPENMEMBER_SEARCH_DATABASE
from betahaus.openmember import MessageFactory as _
from betahaus.openmember.interfaces import IFiscalYear

Schema = schemata.ATContentTypeSchema.copy() + atapi.Schema((

    #FIXME: Validate start and end date. It can't collide with it self, or with other fiscal years for the same org
    atapi.StringField(name='organisation',
                      required=True,
                      read_permission = OPENMEMBER_SEARCH_DATABASE,
                      widget=atapi.StringWidget(label=_(u'Organisation name')
                                                ),
                      ),

    atapi.DateTimeField(name='startDate',
                        accessor='start',
                        required=True,
                        read_permission = OPENMEMBER_SEARCH_DATABASE, 
                        widget=atapi.CalendarWidget(label=_(u'Start of fiscal year'),
                                              show_hm = False,
                                              ),
                        ),
    atapi.DateTimeField(name='endDate',
                        accessor='end',
                        required=True,
                        read_permission = OPENMEMBER_SEARCH_DATABASE,
                        widget=atapi.CalendarWidget(label=_(u'End of fiscal year'),
                                              show_hm = False,
                                              ),
                        ),

))

Schema['description'].mode = 'r'


schemata.finalizeATCTSchema(Schema, moveDiscussion=False)

class FiscalYear(ATCTContent):
    """Fiscal Year"""
    implements(IFiscalYear)

    meta_type = portal_type = "FiscalYear"
    schema = Schema
    security = ClassSecurityInfo()
        

atapi.registerType(FiscalYear, PROJECTNAME)
