from zope.interface import implements
from zope.component import adapts



from betahaus.openmember.interfaces import IOpenMemberContextResults
from betahaus.openmember.interfaces import IFiscalYear
from Products.CMFPlone.interfaces import IPloneSiteRoot


class BaseContextResults(object):
    implements(IOpenMemberContextResults)
    
    def __init__(self, context):
        self.context = context

class FiscalYearResults(BaseContextResults):
    """Handles export from fiscalyears
    """
    adapts(IFiscalYear)

        
    def getResults(self):
        """Interface implementation"""
        view = self.context.restrictedTraverse('view')
        return view.getOpenMembers()

class SearchResults(BaseContextResults):
    """Handles export from searches
    """
    adapts(IPloneSiteRoot)

        
    def getResults(self):
        """Interface implementation"""
        view = self.context.restrictedTraverse('openmember_search')
        return view.getResults()

