from Products.Archetypes import atapi
from Products.CMFCore import utils
from Products.CMFCore.permissions import setDefaultRoles
from zope.i18nmessageid import MessageFactory

from Products.CMFCore.DirectoryView import registerDirectory

import logging

PROJECTNAME = "betahaus.openmember"
CATALOG_ID = 'openmember_catalog'
DATABASE_ID = 'openmember_database'
OPENMEMBER_MANAGE_DATABASE = 'betahaus.openmember: Manage Database'
OPENMEMBER_SEARCH_DATABASE = 'betahaus.openmember: Search Database'
setDefaultRoles(OPENMEMBER_MANAGE_DATABASE, ('Manager',))
setDefaultRoles(OPENMEMBER_SEARCH_DATABASE, ('Manager',))

GLOBALS = globals()

MessageFactory = MessageFactory(PROJECTNAME)
logger = logging.getLogger(PROJECTNAME)


DEFAULT_ADD_CONTENT_PERMISSION = "Add portal content"
setDefaultRoles(DEFAULT_ADD_CONTENT_PERMISSION, ('Manager', 'Owner'))

# Register skins directory
registerDirectory('skins', GLOBALS)

from betahaus.openmember.content.memberdata import MemberData

def initialize(context):
    """Initializer called when used as a Zope 2 product.

    This is referenced from configure.zcml. Regstrations as a "Zope 2 product"
    is necessary for GenericSetup profiles to work, for example.

    Here, we call the Archetypes machinery to register our content types
    with Zope and the CMF.
    """

    # Retrieve the content types that have been registered with Archetypes
    # This happens when the content type is imported and the registerType()
    # call in the content type's module is invoked. Actually, this happens
    # during ZCML processing, but we do it here again to be explicit. Of
    # course, even if we import the module several times, it is only run
    # once.

    content_types, constructors, ftis = atapi.process_types(
        atapi.listTypes(PROJECTNAME),
        PROJECTNAME)

    # Now initialize all these content types. The initialization process takes
    # care of registering low-level Zope 2 factories, including the relevant
    # add-permission. These are listed in config.py. We use different
    # permissions for each content type to allow maximum flexibility of who
    # can add which content types, where. The roles are set up in rolemap.xml
    # in the GenericSetup profile.

    for atype, constructor in zip(content_types, constructors):
        utils.ContentInit('%s: %s' % (PROJECTNAME, atype.portal_type),
            content_types      = (atype,),
            permission         = DEFAULT_ADD_CONTENT_PERMISSION,
            #permission         = config.ADD_PERMISSIONS[atype.portal_type],
            extra_constructors = (constructor,),
            ).initialize(context)