/*
 * Decompiled with CFR 0.152.
 */
package py4j.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import py4j.Py4JException;
import py4j.ReturnObject;
import py4j.commands.AbstractCommand;

public class StreamCommand
extends AbstractCommand {
    public static final String STREAM_COMMAND_NAME = "S";
    private final ByteBuffer streamBuffer = ByteBuffer.allocateDirect(4096);

    public StreamCommand() {
        this.commandName = STREAM_COMMAND_NAME;
    }

    private void feedException(BufferedWriter writer, ReturnObject e) throws IOException {
        writer.write(33);
        writer.write(e.getCommandPart());
        writer.write(10);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String commandName, BufferedReader reader, BufferedWriter writer) throws Py4JException, IOException {
        List<Object> arguments;
        String targetObjectId = reader.readLine();
        String methodName = reader.readLine();
        ReturnObject returnObject = this.invokeMethod(methodName, targetObjectId, arguments = this.getArguments(reader));
        if (returnObject.isError()) {
            this.feedException(writer, returnObject);
            return;
        }
        if (!returnObject.isReference()) {
            this.feedException(writer, ReturnObject.getErrorReturnObject(new ClassCastException("expected the method to return an Object")));
            return;
        }
        Object obj = this.gateway.getObject(returnObject.getName());
        if (!(obj instanceof ReadableByteChannel)) {
            this.feedException(writer, ReturnObject.getErrorReturnObject(new ClassCastException("expected the method to return a ReadableByteChannel")));
            return;
        }
        writer.write("!yv\n");
        writer.flush();
        try (ReadableByteChannel in = (ReadableByteChannel)obj;){
            WritableByteChannel out = Channels.newChannel(this.connection.getSocket().getOutputStream());
            this.streamBuffer.rewind();
            while (in.read(this.streamBuffer) != -1) {
                this.streamBuffer.flip();
                out.write(this.streamBuffer);
                this.streamBuffer.compact();
            }
            this.streamBuffer.flip();
            while (this.streamBuffer.hasRemaining()) {
                out.write(this.streamBuffer);
            }
        }
    }
}

