/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import py4j.CallbackClient;
import py4j.ClientServerConnection;
import py4j.Gateway;
import py4j.Py4JClientConnection;
import py4j.Py4JException;
import py4j.Py4JJavaServer;
import py4j.Py4JPythonClient;
import py4j.commands.Command;

public class PythonClient
extends CallbackClient {
    private Gateway gateway;
    private List<Class<? extends Command>> customCommands;
    protected final Logger logger = Logger.getLogger(PythonClient.class.getName());
    private Py4JJavaServer javaServer;

    public PythonClient(Gateway gateway, List<Class<? extends Command>> customCommands, int pythonPort, InetAddress pythonAddress, long minConnectionTime, TimeUnit minConnectionTimeUnit, SocketFactory socketFactory, Py4JJavaServer javaServer) {
        super(pythonPort, pythonAddress, minConnectionTime, minConnectionTimeUnit, socketFactory);
        this.gateway = gateway;
        this.javaServer = javaServer;
        this.customCommands = customCommands;
    }

    public Gateway getGateway() {
        return this.gateway;
    }

    public void setGateway(Gateway gateway) {
        this.gateway = gateway;
    }

    public Py4JJavaServer getJavaServer() {
        return this.javaServer;
    }

    public void setJavaServer(Py4JJavaServer javaServer) {
        this.javaServer = javaServer;
    }

    @Override
    protected void setupCleaner() {
    }

    private Socket startClientSocket() throws IOException {
        this.logger.info("Starting Python Client connection on " + this.address + " at " + this.port);
        return this.socketFactory.createSocket(this.address, this.port);
    }

    @Override
    protected Py4JClientConnection getConnection() throws IOException {
        ClientServerConnection connection = null;
        connection = ClientServerConnection.getThreadConnection();
        if (connection == null || connection.getSocket() == null) {
            Socket socket = this.startClientSocket();
            connection = new ClientServerConnection(this.gateway, socket, this.customCommands, this, this.javaServer);
            connection.setInitiatedFromClient(true);
            connection.start();
            ClientServerConnection.setThreadConnection(connection);
            this.connections.addLast(connection);
        }
        return connection;
    }

    @Override
    protected boolean shouldRetrySendCommand(Py4JClientConnection cc, Py4JException pe) {
        boolean shouldRetry = false;
        if (cc instanceof ClientServerConnection) {
            ClientServerConnection csc = (ClientServerConnection)cc;
            shouldRetry = csc.isInitiatedFromClient();
        }
        return shouldRetry;
    }

    @Override
    protected void giveBackConnection(Py4JClientConnection cc) {
    }

    @Override
    public Py4JPythonClient copyWith(InetAddress pythonAddress, int pythonPort) {
        return new PythonClient(this.gateway, this.customCommands, pythonPort, pythonAddress, this.minConnectionTime, this.minConnectionTimeUnit, this.socketFactory, this.javaServer);
    }
}

