/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.util.EPUBVersion;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;

public final class OPFData {
    public static final String OPF_MIME_TYPE = "application/oebps-package+xml";
    public static final String DC_TYPE_DICT = "dictionary";
    public static final String DC_TYPE_EDUPUB = "edupub";
    public static final String DC_TYPE_INDEX = "index";
    public static final String DC_TYPE_PREVIEW = "preview";
    private final EPUBVersion version;
    private final Set<String> types;
    private final String uniqueId;

    private OPFData(EPUBVersion version, String uniqueId, Set<String> types) {
        this.version = version;
        this.uniqueId = uniqueId;
        this.types = ImmutableSet.copyOf(types);
    }

    public EPUBVersion getVersion() {
        return this.version;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    public String getUniqueIdentifier() {
        return this.uniqueId;
    }

    public static class OPFDataBuilder {
        private EPUBVersion version;
        private Set<String> types = Sets.newHashSet();
        private String uniqueId;

        public OPFData build() {
            return new OPFData(this.version, this.uniqueId, this.types);
        }

        public OPFDataBuilder withUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public OPFDataBuilder withVersion(EPUBVersion version) {
            this.version = version;
            return this;
        }

        public OPFDataBuilder withType(String type) {
            this.types.add(type);
            return this;
        }
    }
}

