/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.CheckManager;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFChecker;
import com.adobe.epubcheck.ocf.OCFZipPackage;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.CheckUtil;
import com.adobe.epubcheck.util.DefaultReportImpl;
import com.adobe.epubcheck.util.ResourceUtil;
import com.adobe.epubcheck.util.WriterReportImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.zip.ZipFile;

public class EpubCheck
implements DocumentValidator {
    private static String VERSION = null;
    private static String BUILD_DATE = null;
    private final File epubFile;
    private final EPUBProfile profile;
    private final Report report;

    public static String version() {
        if (VERSION == null) {
            Properties prop = new Properties();
            InputStream in = EpubCheck.class.getResourceAsStream("project.properties");
            try {
                prop.load(in);
            }
            catch (Exception e) {
                System.err.println("Couldn't read project properties: " + e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            VERSION = prop.getProperty("version");
            BUILD_DATE = prop.getProperty("buildDate");
        }
        return VERSION;
    }

    public static String buildDate() {
        return BUILD_DATE;
    }

    public EpubCheck(File epubFile) {
        this(epubFile, new DefaultReportImpl(epubFile.getName()));
    }

    public EpubCheck(File epubFile, PrintWriter out) {
        this(epubFile, new WriterReportImpl(out));
    }

    public EpubCheck(File epubFile, Report report) {
        this(epubFile, report, null);
    }

    public EpubCheck(File epubFile, Report report, EPUBProfile profile) {
        this.epubFile = epubFile;
        this.report = report;
        this.profile = profile == null ? EPUBProfile.DEFAULT : profile;
    }

    public EpubCheck(InputStream inputStream, Report report, String uri) {
        this(inputStream, report, uri, EPUBProfile.DEFAULT);
    }

    public EpubCheck(InputStream inputStream, Report report, String uri, EPUBProfile profile) {
        OutputStream out = null;
        try {
            int read;
            File epubFile = File.createTempFile("epub", "." + ResourceUtil.getExtension(uri));
            epubFile.deleteOnExit();
            out = new FileOutputStream(epubFile);
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            this.epubFile = epubFile;
            this.profile = profile == null ? EPUBProfile.DEFAULT : profile;
            this.report = report;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean validate() {
        int validateResult = this.doValidate();
        return validateResult == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doValidate() {
        ZipFile zip = null;
        FileInputStream epubIn = null;
        try {
            String extension = ResourceUtil.getExtension(this.epubFile.getName());
            this.checkExtension(extension);
            if (!this.epubFile.exists()) {
                this.report.message(MessageId.PKG_018, EPUBLocation.create(this.epubFile.getName()), new Object[0]);
                int n = 2;
                return n;
            }
            epubIn = new FileInputStream(this.epubFile);
            this.checkEpubHeader(epubIn);
            zip = new ZipFile(this.epubFile);
            OCFZipPackage ocf = new OCFZipPackage(zip);
            OCFChecker checker = new OCFChecker(new ValidationContext.ValidationContextBuilder().ocf(ocf).report(this.report).profile(this.profile).build());
            checker.runChecks();
            CheckManager c = new CheckManager(zip, this.report);
            c.checkPackage();
        }
        catch (IOException e) {
            this.report.message(MessageId.PKG_008, EPUBLocation.create(this.epubFile.getName(), ""), e.getMessage());
        }
        finally {
            try {
                if (epubIn != null) {
                    epubIn.close();
                }
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {}
        }
        int returnValue = 0;
        if (this.report.getFatalErrorCount() != 0) {
            returnValue |= 4;
        }
        if (this.report.getErrorCount() != 0) {
            returnValue |= 2;
        }
        if (this.report.getWarningCount() != 0) {
            returnValue |= 1;
        }
        return returnValue;
    }

    void checkExtension(String extension) {
        if (extension != null && !extension.equals("epub")) {
            if (extension.matches("[Ee][Pp][Uu][Bb]")) {
                this.report.message(MessageId.PKG_016, EPUBLocation.create(this.epubFile.getName()), new Object[0]);
            } else {
                this.report.message(MessageId.PKG_017, EPUBLocation.create(this.epubFile.getName(), extension), new Object[0]);
            }
        }
    }

    void checkEpubHeader(FileInputStream epubIn) throws IOException {
        byte[] header = new byte[58];
        int readCount = epubIn.read(header);
        if (readCount != -1) {
            int read;
            while (readCount < header.length && (read = epubIn.read(header, readCount, header.length - readCount)) != -1) {
                readCount += read;
            }
        }
        if (readCount != header.length) {
            this.report.message(MessageId.PKG_003, EPUBLocation.create(this.epubFile.getName(), ""), new Object[0]);
        } else {
            int fnsize = this.getIntFromBytes(header, 26);
            int extsize = this.getIntFromBytes(header, 28);
            if (header[0] != 80 && header[1] != 75) {
                this.report.message(MessageId.PKG_004, EPUBLocation.create(this.epubFile.getName()), new Object[0]);
            } else if (fnsize != 8) {
                this.report.message(MessageId.PKG_006, EPUBLocation.create(this.epubFile.getName()), new Object[0]);
            } else if (extsize != 0) {
                this.report.message(MessageId.PKG_005, EPUBLocation.create(this.epubFile.getName()), extsize);
            } else if (!CheckUtil.checkString(header, 30, "mimetype")) {
                this.report.message(MessageId.PKG_006, EPUBLocation.create(this.epubFile.getName()), new Object[0]);
            }
        }
    }

    private int getIntFromBytes(byte[] bytes, int offset) {
        int hi = 0xFF & bytes[offset + 1];
        int lo = 0xFF & bytes[offset];
        return hi << 8 | lo;
    }
}

