/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.TestCase;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;

public class LauncherUtilsUnitTest
extends TestCase {
    private static String COOKIE_SUFFIX = "txt";

    public void testCopyDirectoryWithNonMatchingSuffix() throws IOException {
        File srcDir = this.makeSourceDirAndCookie();
        File destDir = this.getNonexistentDestDir();
        LauncherUtils.copyDirectory((File)srcDir, (String)(COOKIE_SUFFIX + "foo"), (File)destDir);
        LauncherUtilsUnitTest.assertTrue((boolean)destDir.exists());
        LauncherUtilsUnitTest.assertEquals((int)0, (int)destDir.listFiles().length);
        this.copyDirectoryCleanUp(srcDir, destDir);
    }

    public void testCopyDirectoryWithMatchingSuffix() throws IOException {
        File srcDir = this.makeSourceDirAndCookie();
        File destDir = this.getNonexistentDestDir();
        LauncherUtils.copyDirectory((File)srcDir, (String)COOKIE_SUFFIX, (File)destDir);
        LauncherUtilsUnitTest.assertTrue((boolean)destDir.exists());
        LauncherUtilsUnitTest.assertEquals((int)1, (int)destDir.listFiles().length);
        this.copyDirectoryCleanUp(srcDir, destDir);
    }

    private File makeSourceDirAndCookie() throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File srcDir = new File(tempDir, "rc-lut-src");
        srcDir.deleteOnExit();
        LauncherUtilsUnitTest.assertTrue((boolean)srcDir.mkdir());
        File cookieFile = File.createTempFile("testcookie", COOKIE_SUFFIX, srcDir);
        cookieFile.deleteOnExit();
        LauncherUtilsUnitTest.assertTrue((boolean)cookieFile.exists());
        return srcDir;
    }

    private File getNonexistentDestDir() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File destDir = new File(tempDir, "rc-lut-dest");
        destDir.deleteOnExit();
        LauncherUtilsUnitTest.assertFalse((boolean)destDir.exists());
        return destDir;
    }

    public void copyDirectoryCleanUp(File srcDir, File destDir) {
        LauncherUtils.deleteTryTryAgain((File)srcDir, (int)1);
        LauncherUtils.deleteTryTryAgain((File)destDir, (int)1);
        LauncherUtilsUnitTest.assertFalse((boolean)srcDir.exists());
        LauncherUtilsUnitTest.assertFalse((boolean)destDir.exists());
    }

    public void testProxyPacMaking() {
        this.doProxyPacTest(true, null, "448", "confProxy", true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n    } else {\n        return 'PROXY confProxy:448';\n    }\n}\n");
        this.doProxyPacTest(false, null, "448", "confProxy", true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n}\n");
        this.doProxyPacTest(true, null, "448", "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n}\n");
        this.doProxyPacTest(false, null, "448", "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n}\n");
        this.doProxyPacTest(true, "someHost", "448", "confProxy", true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n    } else if (shExpMatch(host, 'someHost')) {\n        return 'DIRECT';\n    } else {\n        return 'PROXY confProxy:448';\n    }\n}\n");
        this.doProxyPacTest(false, "someHost", "448", "confProxy", true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n}\n");
        this.doProxyPacTest(true, "someHost", "448", "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n}\n");
        this.doProxyPacTest(false, "someHost", "448", "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n}\n");
        this.doProxyPacTest(true, "   ", "448", "confProxy", true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n    } else {\n        return 'PROXY confProxy:448';\n    }\n}\n");
        this.doProxyPacTest(false, "   ", "448", "confProxy", true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n}\n");
        this.doProxyPacTest(true, "   ", "448", "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n}\n");
        this.doProxyPacTest(false, "   ", "448", "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy:448';\n}\n");
        this.doProxyPacTest(true, null, "448", null, true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; DIRECT';\n    }\n}\n");
        this.doProxyPacTest(false, null, "448", null, true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, null, "448", null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(false, null, "448", null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, "someHost", "448", null, true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; DIRECT';\n    } else if (shExpMatch(host, 'someHost')) {\n        return 'DIRECT';\n    }\n}\n");
        this.doProxyPacTest(false, "someHost", "448", null, true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, "someHost", "448", null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(false, "someHost", "448", null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, "   ", "448", null, true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; DIRECT';\n    }\n}\n");
        this.doProxyPacTest(false, "   ", "448", null, true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, "   ", "448", null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(false, "   ", "448", null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, null, null, "confProxy", true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; PROXY confProxy';\n    } else {\n        return 'PROXY confProxy';\n    }\n}\n");
        this.doProxyPacTest(false, null, null, "confProxy", true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy';\n}\n");
        this.doProxyPacTest(true, null, null, "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy';\n}\n");
        this.doProxyPacTest(false, null, null, "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy';\n}\n");
        this.doProxyPacTest(true, "someHost", null, "confProxy", true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; PROXY confProxy';\n    } else if (shExpMatch(host, 'someHost')) {\n        return 'DIRECT';\n    } else {\n        return 'PROXY confProxy';\n    }\n}\n");
        this.doProxyPacTest(false, "someHost", null, "confProxy", true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy';\n}\n");
        this.doProxyPacTest(true, "someHost", null, "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy';\n}\n");
        this.doProxyPacTest(false, "someHost", null, "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy';\n}\n");
        this.doProxyPacTest(true, "   ", null, "confProxy", true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; PROXY confProxy';\n    } else {\n        return 'PROXY confProxy';\n    }\n}\n");
        this.doProxyPacTest(false, "   ", null, "confProxy", true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy';\n}\n");
        this.doProxyPacTest(true, "   ", null, "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy';\n}\n");
        this.doProxyPacTest(false, "   ", null, "confProxy", false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; PROXY confProxy';\n}\n");
        this.doProxyPacTest(true, null, null, null, true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; DIRECT';\n    }\n}\n");
        this.doProxyPacTest(false, null, null, null, true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, null, null, null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(false, null, null, null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, "someHost", null, null, true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; DIRECT';\n    } else if (shExpMatch(host, 'someHost')) {\n        return 'DIRECT';\n    }\n}\n");
        this.doProxyPacTest(false, "someHost", null, null, true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, "someHost", null, null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(false, "someHost", null, null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, "   ", null, null, true, 999, "function FindProxyForURL(url, host) {\n    if(shExpMatch(url, '*/selenium-server/*')) {\n        return 'PROXY localhost:999; DIRECT';\n    }\n}\n");
        this.doProxyPacTest(false, "   ", null, null, true, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(true, "   ", null, null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
        this.doProxyPacTest(false, "   ", null, null, false, 999, "function FindProxyForURL(url, host) {\n        return 'PROXY localhost:999; DIRECT';\n}\n");
    }

    private void doProxyPacTest(boolean avoidProxy, String nonProxyHosts, String proxyPort, String configuredProxy, boolean proxySeleniumTrafficOnly, int port, String expectedProxyPac) {
        File parentDir = new File(System.getProperty("java.io.tmpdir"));
        String proxyPacPath = parentDir.getAbsolutePath() + "/proxy.pac";
        File proxyPacFile = new File(proxyPacPath);
        if (proxyPacFile.exists()) {
            proxyPacFile.delete();
        }
        try {
            LauncherUtils.makeProxyPAC((File)parentDir, (int)port, (boolean)proxySeleniumTrafficOnly, (String)configuredProxy, (String)proxyPort, (String)nonProxyHosts, (boolean)avoidProxy);
        }
        catch (FileNotFoundException e) {
            LauncherUtilsUnitTest.fail();
        }
        String actualContent = this.getFileContent(proxyPacPath);
        LauncherUtilsUnitTest.assertNotNull((Object)actualContent);
        if (!"".equals(expectedProxyPac)) {
            actualContent = actualContent.replaceAll("\r\n", "\n");
            LauncherUtilsUnitTest.assertEquals((String)expectedProxyPac, (String)actualContent);
        }
    }

    private String getFileContent(String path) {
        File f = new File(path);
        try {
            FileInputStream input = new FileInputStream(f);
            byte[] buf = new byte[2048];
            int len = input.read(buf);
            return new String(buf, 0, len);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

