/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import junit.framework.TestCase;
import org.openqa.selenium.server.BrowserResponseSequencer;

public class BrowserResponseSequencerUnitTest
extends TestCase {
    private BrowserResponseSequencer seq;
    private List<Integer> numbers;

    public BrowserResponseSequencerUnitTest(String name) {
        super(name);
    }

    public void setUp() {
        this.seq = new BrowserResponseSequencer(this.getName());
        this.numbers = new ArrayList<Integer>();
    }

    public void testBrowserResponseSequencer() throws InterruptedException, ExecutionException {
        FutureTask<Void> three = NumberWriter.launchNumberWriter(3, this.seq, this.numbers);
        NumberWriter.launchNumberWriter(2, this.seq, this.numbers);
        NumberWriter.launchNumberWriter(1, this.seq, this.numbers);
        NumberWriter.launchNumberWriter(0, this.seq, this.numbers);
        three.get();
        BrowserResponseSequencerUnitTest.assertEquals((String)"[0, 1, 2, 3]", (String)this.numbers.toString());
    }

    public void testOutOfSequence() throws InterruptedException, ExecutionException {
        long now = System.currentTimeMillis();
        FutureTask<Void> three = NumberWriter.launchNumberWriter(3, this.seq, this.numbers);
        NumberWriter.launchNumberWriter(1, this.seq, this.numbers);
        NumberWriter.launchNumberWriter(0, this.seq, this.numbers);
        three.get();
        long diff = System.currentTimeMillis() - now;
        BrowserResponseSequencerUnitTest.assertEquals((String)"[0, 1, 3]", (String)this.numbers.toString());
        BrowserResponseSequencerUnitTest.assertTrue((diff >= 4995L ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumberWriter
    implements Callable<Void> {
        final int num;
        final BrowserResponseSequencer seq;
        final List<Integer> numbers;

        public NumberWriter(int num, BrowserResponseSequencer seq, List<Integer> numbers) {
            this.num = num;
            this.seq = seq;
            this.numbers = numbers;
        }

        @Override
        public Void call() throws Exception {
            try {
                this.seq.waitUntilNumIsAtLeast(this.num);
                this.numbers.add(this.num);
                this.seq.increaseNum();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            return null;
        }

        public FutureTask<Void> launchThread() {
            FutureTask<Void> ft = new FutureTask<Void>(this);
            new Thread(ft, NumberWriter.class.getName() + '-' + this.num).start();
            return ft;
        }

        public static FutureTask<Void> launchNumberWriter(int num, BrowserResponseSequencer seq, List<Integer> numbers) {
            return new NumberWriter(num, seq, numbers).launchThread();
        }
    }
}

