// Frontend of Oneline
// @author Nadir Hamid
// @license MIT

var bson=(function(){var pkgmap={},global={},nativeRequire=typeof require!='undefined'&&require,lib,ties,main,async;function exports(){return main();};exports.main=exports;exports.module=module;exports.packages=pkgmap;exports.pkg=pkg;exports.require=function require(uri){return pkgmap.main.index.require(uri);};ties={};aliases={};return exports;function join(){return normalize(Array.prototype.join.call(arguments,"/"));};function normalize(path){var ret=[],parts=path.split('/'),cur,prev;var i=0,l=parts.length-1;for(;i<=l;i++){cur=parts[i];if(cur==="."&&prev!==undefined)continue;if(cur===".."&&ret.length&&prev!==".."&&prev!=="."&&prev!==undefined){ret.pop();prev=ret.slice(-1)[0];}else{if(prev===".")ret.pop();ret.push(cur);prev=cur;}}
return ret.join("/");};function dirname(path){return path&&path.substr(0,path.lastIndexOf("/"))||".";};function findModule(workingModule,uri){var moduleId=join(dirname(workingModule.id),/\.\/$/.test(uri)?(uri+'index'):uri).replace(/\.js$/,''),moduleIndexId=join(moduleId,'index'),pkg=workingModule.pkg,module;var i=pkg.modules.length,id;while(i-->0){id=pkg.modules[i].id;if(id==moduleId||id==moduleIndexId){module=pkg.modules[i];break;}}
return module;}
function newRequire(callingModule){function require(uri){var module,pkg;if(/^\./.test(uri)){module=findModule(callingModule,uri);}else if(ties&&ties.hasOwnProperty(uri)){return ties[uri];}else if(aliases&&aliases.hasOwnProperty(uri)){return require(aliases[uri]);}else{pkg=pkgmap[uri];if(!pkg&&nativeRequire){try{pkg=nativeRequire(uri);}catch(nativeRequireError){}
if(pkg)return pkg;}
if(!pkg){throw new Error('Cannot find module "'+uri+'" @[module: '+callingModule.id+' package: '+callingModule.pkg.name+']');}
module=pkg.index;}
if(!module){throw new Error('Cannot find module "'+uri+'" @[module: '+callingModule.id+' package: '+callingModule.pkg.name+']');}
module.parent=callingModule;return module.call();};return require;}
function module(parent,id,wrapper){var mod={pkg:parent,id:id,wrapper:wrapper},cached=false;mod.exports={};mod.require=newRequire(mod);mod.call=function(){if(cached){return mod.exports;}
cached=true;global.require=mod.require;mod.wrapper(mod,mod.exports,global,global.require);return mod.exports;};if(parent.mainModuleId==mod.id){parent.index=mod;parent.parents.length===0&&(main=mod.call);}
parent.modules.push(mod);}
function pkg(){var wrapper=arguments[arguments.length-1],parents=Array.prototype.slice.call(arguments,0,arguments.length-1),ctx=wrapper(parents);pkgmap[ctx.name]=ctx;arguments.length==1&&(pkgmap.main=ctx);return function(modules){var id;for(id in modules){module(ctx,id,modules[id]);}};}}(this));bson.pkg(function(parents){return{'name':'bson','mainModuleId':'bson','modules':[],'parents':parents};})({'binary':function(module,exports,global,require,undefined){if(typeof window==='undefined'){var Buffer=require('buffer').Buffer;}
var BSON_BINARY_SUBTYPE_DEFAULT=0;var writeStringToArray=function(data){ var buffer=typeof Uint8Array!='undefined'?new Uint8Array(new ArrayBuffer(data.length)):new Array(data.length); for(var i=0;i<data.length;i++){buffer[i]=data.charCodeAt(i);} 
return buffer;}
var convertArraytoUtf8BinaryString=function(byteArray,startIndex,endIndex){var result="";for(var i=startIndex;i<endIndex;i++){result=result+String.fromCharCode(byteArray[i]);}
return result;};function Binary(buffer,subType){if(!(this instanceof Binary))return new Binary(buffer,subType);this._bsontype='Binary';if(buffer instanceof Number){this.sub_type=buffer;this.position=0;}else{this.sub_type=subType==null?BSON_BINARY_SUBTYPE_DEFAULT:subType;this.position=0;}
if(buffer!=null&&!(buffer instanceof Number)){ if(typeof buffer=='string'){ if(typeof Buffer!='undefined'){this.buffer=new Buffer(buffer);}else if(typeof Uint8Array!='undefined'||(Object.prototype.toString.call(buffer)=='[object Array]')){this.buffer=writeStringToArray(buffer);}else{throw new Error("only String, Buffer, Uint8Array or Array accepted");}}else{this.buffer=buffer;}
this.position=buffer.length;}else{if(typeof Buffer!='undefined'){this.buffer=new Buffer(Binary.BUFFER_SIZE);}else if(typeof Uint8Array!='undefined'){this.buffer=new Uint8Array(new ArrayBuffer(Binary.BUFFER_SIZE));}else{this.buffer=new Array(Binary.BUFFER_SIZE);} 
this.position=0;}};Binary.prototype.put=function put(byte_value){ if(byte_value['length']!=null&&typeof byte_value!='number'&&byte_value.length!=1)throw new Error("only accepts single character String, Uint8Array or Array");if(typeof byte_value!='number'&&byte_value<0||byte_value>255)throw new Error("only accepts number in a valid unsigned byte range 0-255"); var decoded_byte=null;if(typeof byte_value=='string'){decoded_byte=byte_value.charCodeAt(0);}else if(byte_value['length']!=null){decoded_byte=byte_value[0];}else{decoded_byte=byte_value;}
if(this.buffer.length>this.position){this.buffer[this.position++]=decoded_byte;}else{if(typeof Buffer!='undefined'&&Buffer.isBuffer(this.buffer)){ var buffer=new Buffer(Binary.BUFFER_SIZE+this.buffer.length); this.buffer.copy(buffer,0,0,this.buffer.length);this.buffer=buffer;this.buffer[this.position++]=decoded_byte;}else{var buffer=null;if(Object.prototype.toString.call(this.buffer)=='[object Uint8Array]'){buffer=new Uint8Array(new ArrayBuffer(Binary.BUFFER_SIZE+this.buffer.length));}else{buffer=new Array(Binary.BUFFER_SIZE+this.buffer.length);} 
for(var i=0;i<this.buffer.length;i++){buffer[i]=this.buffer[i];} 
this.buffer=buffer; this.buffer[this.position++]=decoded_byte;}}};Binary.prototype.write=function write(string,offset){offset=typeof offset=='number'?offset:this.position; if(this.buffer.length<offset+string.length){var buffer=null; if(typeof Buffer!='undefined'&&Buffer.isBuffer(this.buffer)){buffer=new Buffer(this.buffer.length+string.length);this.buffer.copy(buffer,0,0,this.buffer.length);}else if(Object.prototype.toString.call(this.buffer)=='[object Uint8Array]'){ buffer=new Uint8Array(new ArrayBuffer(this.buffer.length+string.length)) 
for(var i=0;i<this.position;i++){buffer[i]=this.buffer[i];}} 
this.buffer=buffer;}
if(typeof Buffer!='undefined'&&Buffer.isBuffer(string)&&Buffer.isBuffer(this.buffer)){string.copy(this.buffer,offset,0,string.length);this.position=(offset+string.length)>this.position?(offset+string.length):this.position;}else if(typeof Buffer!='undefined'&&typeof string=='string'&&Buffer.isBuffer(this.buffer)){this.buffer.write(string,'binary',offset);this.position=(offset+string.length)>this.position?(offset+string.length):this.position;}else if(Object.prototype.toString.call(string)=='[object Uint8Array]'||Object.prototype.toString.call(string)=='[object Array]'&&typeof string!='string'){for(var i=0;i<string.length;i++){this.buffer[offset++]=string[i];}
this.position=offset>this.position?offset:this.position;}else if(typeof string=='string'){for(var i=0;i<string.length;i++){this.buffer[offset++]=string.charCodeAt(i);}
this.position=offset>this.position?offset:this.position;}};Binary.prototype.read=function read(position,length){length=length&&length>0?length:this.position; if(this.buffer['slice']){return this.buffer.slice(position,position+length);}else{ var buffer=typeof Uint8Array!='undefined'?new Uint8Array(new ArrayBuffer(length)):new Array(length);for(var i=0;i<length;i++){buffer[i]=this.buffer[position++];}} 
return buffer;};Binary.prototype.value=function value(asRaw){asRaw=asRaw==null?false:asRaw; if(typeof Buffer!='undefined'&&Buffer.isBuffer(this.buffer)){return asRaw?this.buffer.slice(0,this.position):this.buffer.toString('binary',0,this.position);}else{if(asRaw){ if(this.buffer['slice']!=null){return this.buffer.slice(0,this.position);}else{ var newBuffer=Object.prototype.toString.call(this.buffer)=='[object Uint8Array]'?new Uint8Array(new ArrayBuffer(this.position)):new Array(this.position); for(var i=0;i<this.position;i++){newBuffer[i]=this.buffer[i];} 
return newBuffer;}}else{return convertArraytoUtf8BinaryString(this.buffer,0,this.position);}}};Binary.prototype.length=function length(){return this.position;};Binary.prototype.toJSON=function(){return this.buffer!=null?this.buffer.toString('base64'):'';}
Binary.prototype.toString=function(format){return this.buffer!=null?this.buffer.slice(0,this.position).toString(format):'';}
Binary.BUFFER_SIZE=256;Binary.SUBTYPE_DEFAULT=0;Binary.SUBTYPE_FUNCTION=1;Binary.SUBTYPE_BYTE_ARRAY=2;Binary.SUBTYPE_UUID_OLD=3;Binary.SUBTYPE_UUID=4;Binary.SUBTYPE_MD5=5;Binary.SUBTYPE_USER_DEFINED=128;exports.Binary=Binary;},'binary_parser':function(module,exports,global,require,undefined){var chr=String.fromCharCode;var maxBits=[];for(var i=0;i<64;i++){maxBits[i]=Math.pow(2,i);}
function BinaryParser(bigEndian,allowExceptions){if(!(this instanceof BinaryParser))return new BinaryParser(bigEndian,allowExceptions);this.bigEndian=bigEndian;this.allowExceptions=allowExceptions;};BinaryParser.warn=function warn(msg){if(this.allowExceptions){throw new Error(msg);}
return 1;};BinaryParser.decodeFloat=function decodeFloat(data,precisionBits,exponentBits){var b=new this.Buffer(this.bigEndian,data);b.checkBuffer(precisionBits+exponentBits+1);var bias=maxBits[exponentBits-1]-1,signal=b.readBits(precisionBits+exponentBits,1),exponent=b.readBits(precisionBits,exponentBits),significand=0,divisor=2,curByte=b.buffer.length+(-precisionBits>>3)-1;do{for(var byteValue=b.buffer[++curByte],startBit=precisionBits%8||8,mask=1<<startBit;mask>>=1;(byteValue&mask)&&(significand+=1/divisor),divisor*=2);}while(precisionBits-=startBit);return exponent==(bias<<1)+1?significand?NaN:signal?-Infinity:+Infinity:(1+signal*-2)*(exponent||significand?!exponent?Math.pow(2,-bias+1)*significand:Math.pow(2,exponent-bias)*(1+significand):0);};BinaryParser.decodeInt=function decodeInt(data,bits,signed,forceBigEndian){var b=new this.Buffer(this.bigEndian||forceBigEndian,data),x=b.readBits(0,bits),max=maxBits[bits];return signed&&x>=max/2?x-max:x;};BinaryParser.encodeFloat=function encodeFloat(data,precisionBits,exponentBits){var bias=maxBits[exponentBits-1]-1,minExp=-bias+1,maxExp=bias,minUnnormExp=minExp-precisionBits,n=parseFloat(data),status=isNaN(n)||n==-Infinity||n==+Infinity?n:0,exp=0,len=2*bias+1+precisionBits+3,bin=new Array(len),signal=(n=status!==0?0:n)<0,intPart=Math.floor(n=Math.abs(n)),floatPart=n-intPart,lastBit,rounded,result,i,j;for(i=len;i;bin[--i]=0);for(i=bias+2;intPart&&i;bin[--i]=intPart%2,intPart=Math.floor(intPart/2));for(i=bias+1;floatPart>0&&i;(bin[++i]=((floatPart*=2)>=1)-0)&&--floatPart);for(i=-1;++i<len&&!bin[i];);if(bin[(lastBit=precisionBits-1+(i=(exp=bias+1-i)>=minExp&&exp<=maxExp?i+1:bias+1-(exp=minExp-1)))+1]){if(!(rounded=bin[lastBit])){for(j=lastBit+2;!rounded&&j<len;rounded=bin[j++]);}
for(j=lastBit+1;rounded&&--j>=0;(bin[j]=!bin[j]-0)&&(rounded=0));}
for(i=i-2<0?-1:i-3;++i<len&&!bin[i];);if((exp=bias+1-i)>=minExp&&exp<=maxExp){++i;}else if(exp<minExp){exp!=bias+1-len&&exp<minUnnormExp&&this.warn("encodeFloat::float underflow");i=bias+1-(exp=minExp-1);}
if(intPart||status!==0){this.warn(intPart?"encodeFloat::float overflow":"encodeFloat::"+status);exp=maxExp+1;i=bias+2;if(status==-Infinity){signal=1;}else if(isNaN(status)){bin[i]=1;}}
for(n=Math.abs(exp+bias),j=exponentBits+1,result="";--j;result=(n%2)+result,n=n>>=1);for(n=0,j=0,i=(result=(signal?"1":"0")+result+bin.slice(i,i+precisionBits).join("")).length,r=[];i;j=(j+1)%8){n+=(1<<j)*result.charAt(--i);if(j==7){r[r.length]=String.fromCharCode(n);n=0;}}
r[r.length]=n?String.fromCharCode(n):"";return(this.bigEndian?r.reverse():r).join("");};BinaryParser.encodeInt=function encodeInt(data,bits,signed,forceBigEndian){var max=maxBits[bits];if(data>=max||data<-(max/2)){this.warn("encodeInt::overflow");data=0;}
if(data<0){data+=max;}
for(var r=[];data;r[r.length]=String.fromCharCode(data%256),data=Math.floor(data/256));for(bits=-(-bits>>3)-r.length;bits--;r[r.length]="\0");return((this.bigEndian||forceBigEndian)?r.reverse():r).join("");};BinaryParser.toSmall=function(data){return this.decodeInt(data,8,true);};BinaryParser.fromSmall=function(data){return this.encodeInt(data,8,true);};BinaryParser.toByte=function(data){return this.decodeInt(data,8,false);};BinaryParser.fromByte=function(data){return this.encodeInt(data,8,false);};BinaryParser.toShort=function(data){return this.decodeInt(data,16,true);};BinaryParser.fromShort=function(data){return this.encodeInt(data,16,true);};BinaryParser.toWord=function(data){return this.decodeInt(data,16,false);};BinaryParser.fromWord=function(data){return this.encodeInt(data,16,false);};BinaryParser.toInt=function(data){return this.decodeInt(data,32,true);};BinaryParser.fromInt=function(data){return this.encodeInt(data,32,true);};BinaryParser.toLong=function(data){return this.decodeInt(data,64,true);};BinaryParser.fromLong=function(data){return this.encodeInt(data,64,true);};BinaryParser.toDWord=function(data){return this.decodeInt(data,32,false);};BinaryParser.fromDWord=function(data){return this.encodeInt(data,32,false);};BinaryParser.toQWord=function(data){return this.decodeInt(data,64,true);};BinaryParser.fromQWord=function(data){return this.encodeInt(data,64,true);};BinaryParser.toFloat=function(data){return this.decodeFloat(data,23,8);};BinaryParser.fromFloat=function(data){return this.encodeFloat(data,23,8);};BinaryParser.toDouble=function(data){return this.decodeFloat(data,52,11);};BinaryParser.fromDouble=function(data){return this.encodeFloat(data,52,11);};BinaryParser.encode_int32=function encode_int32(number,asArray){var a,b,c,d,unsigned;unsigned=(number<0)?(number+0x100000000):number;a=Math.floor(unsigned/0xffffff);unsigned&=0xffffff;b=Math.floor(unsigned/0xffff);unsigned&=0xffff;c=Math.floor(unsigned/0xff);unsigned&=0xff;d=Math.floor(unsigned);return asArray?[chr(a),chr(b),chr(c),chr(d)]:chr(a)+chr(b)+chr(c)+chr(d);};BinaryParser.encode_int64=function encode_int64(number){var a,b,c,d,e,f,g,h,unsigned;unsigned=(number<0)?(number+0x10000000000000000):number;a=Math.floor(unsigned/0xffffffffffffff);unsigned&=0xffffffffffffff;b=Math.floor(unsigned/0xffffffffffff);unsigned&=0xffffffffffff;c=Math.floor(unsigned/0xffffffffff);unsigned&=0xffffffffff;d=Math.floor(unsigned/0xffffffff);unsigned&=0xffffffff;e=Math.floor(unsigned/0xffffff);unsigned&=0xffffff;f=Math.floor(unsigned/0xffff);unsigned&=0xffff;g=Math.floor(unsigned/0xff);unsigned&=0xff;h=Math.floor(unsigned);return chr(a)+chr(b)+chr(c)+chr(d)+chr(e)+chr(f)+chr(g)+chr(h);};BinaryParser.decode_utf8=function decode_utf8(binaryStr){var len=binaryStr.length,decoded='',i=0,c=0,c1=0,c2=0,c3;while(i<len){c=binaryStr.charCodeAt(i);if(c<128){decoded+=String.fromCharCode(c);i++;}else if((c>191)&&(c<224)){c2=binaryStr.charCodeAt(i+1);decoded+=String.fromCharCode(((c&31)<<6)|(c2&63));i+=2;}else{c2=binaryStr.charCodeAt(i+1);c3=binaryStr.charCodeAt(i+2);decoded+=String.fromCharCode(((c&15)<<12)|((c2&63)<<6)|(c3&63));i+=3;}}
return decoded;};BinaryParser.encode_cstring=function encode_cstring(s){return unescape(encodeURIComponent(s))+BinaryParser.fromByte(0);};BinaryParser.encode_utf8=function encode_utf8(s){var a="",c;for(var n=0,len=s.length;n<len;n++){c=s.charCodeAt(n);if(c<128){a+=String.fromCharCode(c);}else if((c>127)&&(c<2048)){a+=String.fromCharCode((c>>6)|192);a+=String.fromCharCode((c&63)|128);}else{a+=String.fromCharCode((c>>12)|224);a+=String.fromCharCode(((c>>6)&63)|128);a+=String.fromCharCode((c&63)|128);}}
return a;};BinaryParser.hprint=function hprint(s){var number;for(var i=0,len=s.length;i<len;i++){if(s.charCodeAt(i)<32){number=s.charCodeAt(i)<=15?"0"+s.charCodeAt(i).toString(16):s.charCodeAt(i).toString(16);process.stdout.write(number+" ")}else{number=s.charCodeAt(i)<=15?"0"+s.charCodeAt(i).toString(16):s.charCodeAt(i).toString(16);process.stdout.write(number+" ")}}
process.stdout.write("\n\n");};BinaryParser.ilprint=function hprint(s){var number;for(var i=0,len=s.length;i<len;i++){if(s.charCodeAt(i)<32){number=s.charCodeAt(i)<=15?"0"+s.charCodeAt(i).toString(10):s.charCodeAt(i).toString(10);require('util').debug(number+' : ');}else{number=s.charCodeAt(i)<=15?"0"+s.charCodeAt(i).toString(10):s.charCodeAt(i).toString(10);require('util').debug(number+' : '+s.charAt(i));}}};BinaryParser.hlprint=function hprint(s){var number;for(var i=0,len=s.length;i<len;i++){if(s.charCodeAt(i)<32){number=s.charCodeAt(i)<=15?"0"+s.charCodeAt(i).toString(16):s.charCodeAt(i).toString(16);require('util').debug(number+' : ');}else{number=s.charCodeAt(i)<=15?"0"+s.charCodeAt(i).toString(16):s.charCodeAt(i).toString(16);require('util').debug(number+' : '+s.charAt(i));}}};function BinaryParserBuffer(bigEndian,buffer){this.bigEndian=bigEndian||0;this.buffer=[];this.setBuffer(buffer);};BinaryParserBuffer.prototype.setBuffer=function setBuffer(data){var l,i,b;if(data){i=l=data.length;b=this.buffer=new Array(l);for(;i;b[l-i]=data.charCodeAt(--i));this.bigEndian&&b.reverse();}};BinaryParserBuffer.prototype.hasNeededBits=function hasNeededBits(neededBits){return this.buffer.length>=-(-neededBits>>3);};BinaryParserBuffer.prototype.checkBuffer=function checkBuffer(neededBits){if(!this.hasNeededBits(neededBits)){throw new Error("checkBuffer::missing bytes");}};BinaryParserBuffer.prototype.readBits=function readBits(start,length){function shl(a,b){for(;b--;a=((a%=0x7fffffff+1)&0x40000000)==0x40000000?a*2:(a-0x40000000)*2+0x7fffffff+1);return a;}
if(start<0||length<=0){return 0;}
this.checkBuffer(start+length);var offsetLeft,offsetRight=start%8,curByte=this.buffer.length-(start>>3)-1,lastByte=this.buffer.length+(-(start+length)>>3),diff=curByte-lastByte,sum=((this.buffer[curByte]>>offsetRight)&((1<<(diff?8-offsetRight:length))-1))+(diff&&(offsetLeft=(start+length)%8)?(this.buffer[lastByte++]&((1<<offsetLeft)-1))<<(diff--<<3)-offsetRight:0);for(;diff;sum+=shl(this.buffer[lastByte++],(diff--<<3)-offsetRight));return sum;};BinaryParser.Buffer=BinaryParserBuffer;exports.BinaryParser=BinaryParser;},'bson':function(module,exports,global,require,undefined){var Long=require('./long').Long,Double=require('./double').Double,Timestamp=require('./timestamp').Timestamp,ObjectID=require('./objectid').ObjectID,Symbol=require('./symbol').Symbol,Code=require('./code').Code,MinKey=require('./min_key').MinKey,MaxKey=require('./max_key').MaxKey,DBRef=require('./db_ref').DBRef,Binary=require('./binary').Binary,BinaryParser=require('./binary_parser').BinaryParser,writeIEEE754=require('./float_parser').writeIEEE754,readIEEE754=require('./float_parser').readIEEE754

var isDate=function isDate(d){return typeof d==='object'&&Object.prototype.toString.call(d)==='[object Date]';}
function BSON(){};BSON.BSON_INT32_MAX=0x7FFFFFFF;BSON.BSON_INT32_MIN=-0x80000000;BSON.BSON_INT64_MAX=Math.pow(2,63)-1;BSON.BSON_INT64_MIN=-Math.pow(2,63);BSON.JS_INT_MAX=0x20000000000000;BSON.JS_INT_MIN=-0x20000000000000;var JS_INT_MAX_LONG=Long.fromNumber(0x20000000000000);var JS_INT_MIN_LONG=Long.fromNumber(-0x20000000000000);BSON.BSON_DATA_NUMBER=1;BSON.BSON_DATA_STRING=2;BSON.BSON_DATA_OBJECT=3;BSON.BSON_DATA_ARRAY=4;BSON.BSON_DATA_BINARY=5;BSON.BSON_DATA_OID=7;BSON.BSON_DATA_BOOLEAN=8;BSON.BSON_DATA_DATE=9;BSON.BSON_DATA_NULL=10;BSON.BSON_DATA_REGEXP=11;BSON.BSON_DATA_CODE=13;BSON.BSON_DATA_SYMBOL=14;BSON.BSON_DATA_CODE_W_SCOPE=15;BSON.BSON_DATA_INT=16;BSON.BSON_DATA_TIMESTAMP=17;BSON.BSON_DATA_LONG=18;BSON.BSON_DATA_MIN_KEY=0xff;BSON.BSON_DATA_MAX_KEY=0x7f;BSON.BSON_BINARY_SUBTYPE_DEFAULT=0;BSON.BSON_BINARY_SUBTYPE_FUNCTION=1;BSON.BSON_BINARY_SUBTYPE_BYTE_ARRAY=2;BSON.BSON_BINARY_SUBTYPE_UUID=3;BSON.BSON_BINARY_SUBTYPE_MD5=4;BSON.BSON_BINARY_SUBTYPE_USER_DEFINED=128;BSON.calculateObjectSize=function calculateObjectSize(object,serializeFunctions){var totalLength=(4+1);if(Array.isArray(object)){for(var i=0;i<object.length;i++){totalLength+=calculateElement(i.toString(),object[i],serializeFunctions)}}else{ if(object.toBSON){object=object.toBSON();} 
for(var key in object){totalLength+=calculateElement(key,object[key],serializeFunctions)}}
return totalLength;}
function calculateElement(name,value,serializeFunctions){var isBuffer=typeof Buffer!=='undefined';switch(typeof value){case'string':return 1+(!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1+4+(!isBuffer?numberOfBytes(value):Buffer.byteLength(value,'utf8'))+1;case'number':if(Math.floor(value)===value&&value>=BSON.JS_INT_MIN&&value<=BSON.JS_INT_MAX){if(value>=BSON.BSON_INT32_MIN&&value<=BSON.BSON_INT32_MAX){ return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(4+1);}else{return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(8+1);}}else{ return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(8+1);}
case'undefined':return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(1);case'boolean':return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(1+1);case'object':if(value==null||value instanceof MinKey||value instanceof MaxKey||value['_bsontype']=='MinKey'||value['_bsontype']=='MaxKey'){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(1);}else if(value instanceof ObjectID||value['_bsontype']=='ObjectID'){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(12+1);}else if(value instanceof Date||isDate(value)){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(8+1);}else if(typeof Buffer!=='undefined'&&Buffer.isBuffer(value)){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(1+4+1)+value.length;}else if(value instanceof Long||value instanceof Double||value instanceof Timestamp||value['_bsontype']=='Long'||value['_bsontype']=='Double'||value['_bsontype']=='Timestamp'){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(8+1);}else if(value instanceof Code||value['_bsontype']=='Code'){ if(value.scope!=null&&Object.keys(value.scope).length>0){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+1+4+4+(!isBuffer?numberOfBytes(value.code.toString()):Buffer.byteLength(value.code.toString(),'utf8'))+1+BSON.calculateObjectSize(value.scope,serializeFunctions);}else{return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+1+4+(!isBuffer?numberOfBytes(value.code.toString()):Buffer.byteLength(value.code.toString(),'utf8'))+1;}}else if(value instanceof Binary||value['_bsontype']=='Binary'){ if(value.sub_type==Binary.SUBTYPE_BYTE_ARRAY){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(value.position+1+4+1+4);}else{return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+(value.position+1+4+1);}}else if(value instanceof Symbol||value['_bsontype']=='Symbol'){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+((!isBuffer?numberOfBytes(value.value):Buffer.byteLength(value.value,'utf8'))+4+1+1);}else if(value instanceof DBRef||value['_bsontype']=='DBRef'){ var ordered_values={'$ref':value.namespace,'$id':value.oid}; if(null!=value.db){ordered_values['$db']=value.db;}
return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+1+BSON.calculateObjectSize(ordered_values,serializeFunctions);}else if(value instanceof RegExp||Object.prototype.toString.call(value)==='[object RegExp]'){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+1+(!isBuffer?numberOfBytes(value.source):Buffer.byteLength(value.source,'utf8'))+1
+(value.global?1:0)+(value.ignoreCase?1:0)+(value.multiline?1:0)+1}else{return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+BSON.calculateObjectSize(value,serializeFunctions)+1;}
case'function':if(value instanceof RegExp||Object.prototype.toString.call(value)==='[object RegExp]'||String.call(value)=='[object RegExp]'){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+1+(!isBuffer?numberOfBytes(value.source):Buffer.byteLength(value.source,'utf8'))+1
+(value.global?1:0)+(value.ignoreCase?1:0)+(value.multiline?1:0)+1}else{if(serializeFunctions&&value.scope!=null&&Object.keys(value.scope).length>0){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+1+4+4+(!isBuffer?numberOfBytes(value.toString()):Buffer.byteLength(value.toString(),'utf8'))+1+BSON.calculateObjectSize(value.scope,serializeFunctions);}else if(serializeFunctions){return(name!=null?((!isBuffer?numberOfBytes(name):Buffer.byteLength(name,'utf8'))+1):0)+1+4+(!isBuffer?numberOfBytes(value.toString()):Buffer.byteLength(value.toString(),'utf8'))+1;}}}
return 0;}
BSON.serializeWithBufferAndIndex=function serializeWithBufferAndIndex(object,checkKeys,buffer,index,serializeFunctions){ serializeFunctions=serializeFunctions==null?false:serializeFunctions;var size=buffer.length; buffer[index++]=size&0xff;buffer[index++]=(size>>8)&0xff;buffer[index++]=(size>>16)&0xff;buffer[index++]=(size>>24)&0xff;return serializeObject(object,checkKeys,buffer,index,serializeFunctions)-1;}
var serializeObject=function(object,checkKeys,buffer,index,serializeFunctions){ if(Array.isArray(object)){for(var i=0;i<object.length;i++){index=packElement(i.toString(),object[i],checkKeys,buffer,index,serializeFunctions);}}else{ if(object.toBSON){object=object.toBSON();} 
for(var key in object){ if(key!='$db'&&key!='$ref'&&key!='$id'){ BSON.checkKey(key,!checkKeys);} 
index=packElement(key,object[key],checkKeys,buffer,index,serializeFunctions);}} 
buffer[index++]=0;return index;}
var stringToBytes=function(str){var ch,st,re=[];for(var i=0;i<str.length;i++){ch=str.charCodeAt(i); st=[];do{st.push(ch&0xFF); ch=ch>>8;}
while(ch);
 re=re.concat(st.reverse());} 
return re;}
var numberOfBytes=function(str){var ch,st,re=0;for(var i=0;i<str.length;i++){ch=str.charCodeAt(i); st=[];do{st.push(ch&0xFF); ch=ch>>8;}
while(ch);
 re=re+st.length;} 
return re;}
var writeToTypedArray=function(buffer,string,index){var bytes=stringToBytes(string);for(var i=0;i<bytes.length;i++){buffer[index+i]=bytes[i];}
return bytes.length;}
var supportsBuffer=typeof Buffer!='undefined';var packElement=function(name,value,checkKeys,buffer,index,serializeFunctions){var startIndex=index;switch(typeof value){case'string': buffer[index++]=BSON.BSON_DATA_STRING; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; var size=supportsBuffer?Buffer.byteLength(value)+1:numberOfBytes(value)+1; buffer[index+3]=(size>>24)&0xff;buffer[index+2]=(size>>16)&0xff;buffer[index+1]=(size>>8)&0xff;buffer[index]=size&0xff; index=index+4; supportsBuffer?buffer.write(value,index,'utf8'):writeToTypedArray(buffer,value,index); index=index+size-1; buffer[index++]=0; return index;case'number': if(Math.floor(value)===value&&value>=BSON.JS_INT_MIN&&value<=BSON.JS_INT_MAX){
 if(value>=BSON.BSON_INT32_MIN&&value<=BSON.BSON_INT32_MAX){ buffer[index++]=BSON.BSON_DATA_INT; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; buffer[index++]=value&0xff;buffer[index++]=(value>>8)&0xff;buffer[index++]=(value>>16)&0xff;buffer[index++]=(value>>24)&0xff;}else if(value>=BSON.JS_INT_MIN&&value<=BSON.JS_INT_MAX){ buffer[index++]=BSON.BSON_DATA_NUMBER; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; writeIEEE754(buffer,value,index,'little',52,8); index=index+8;}else{ buffer[index++]=BSON.BSON_DATA_LONG; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0;var longVal=Long.fromNumber(value);var lowBits=longVal.getLowBits();var highBits=longVal.getHighBits(); buffer[index++]=lowBits&0xff;buffer[index++]=(lowBits>>8)&0xff;buffer[index++]=(lowBits>>16)&0xff;buffer[index++]=(lowBits>>24)&0xff; buffer[index++]=highBits&0xff;buffer[index++]=(highBits>>8)&0xff;buffer[index++]=(highBits>>16)&0xff;buffer[index++]=(highBits>>24)&0xff;}}else{ buffer[index++]=BSON.BSON_DATA_NUMBER; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; writeIEEE754(buffer,value,index,'little',52,8); index=index+8;}
return index;case'undefined': buffer[index++]=BSON.BSON_DATA_NULL; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0;return index;case'boolean': buffer[index++]=BSON.BSON_DATA_BOOLEAN; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; buffer[index++]=value?1:0;return index;case'object':if(value===null||value instanceof MinKey||value instanceof MaxKey||value['_bsontype']=='MinKey'||value['_bsontype']=='MaxKey'){ if(value===null){buffer[index++]=BSON.BSON_DATA_NULL;}else if(value instanceof MinKey){buffer[index++]=BSON.BSON_DATA_MIN_KEY;}else{buffer[index++]=BSON.BSON_DATA_MAX_KEY;} 
var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0;return index;}else if(value instanceof ObjectID||value['_bsontype']=='ObjectID'){ buffer[index++]=BSON.BSON_DATA_OID; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; supportsBuffer?buffer.write(value.id,index,'binary'):writeToTypedArray(buffer,value.id,index); index=index+12;return index;}else if(value instanceof Date||isDate(value)){ buffer[index++]=BSON.BSON_DATA_DATE; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; var dateInMilis=Long.fromNumber(value.getTime());var lowBits=dateInMilis.getLowBits();var highBits=dateInMilis.getHighBits(); buffer[index++]=lowBits&0xff;buffer[index++]=(lowBits>>8)&0xff;buffer[index++]=(lowBits>>16)&0xff;buffer[index++]=(lowBits>>24)&0xff; buffer[index++]=highBits&0xff;buffer[index++]=(highBits>>8)&0xff;buffer[index++]=(highBits>>16)&0xff;buffer[index++]=(highBits>>24)&0xff;return index;}else if(typeof Buffer!=='undefined'&&Buffer.isBuffer(value)){ buffer[index++]=BSON.BSON_DATA_BINARY; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0;var size=value.length; buffer[index++]=size&0xff;buffer[index++]=(size>>8)&0xff;buffer[index++]=(size>>16)&0xff;buffer[index++]=(size>>24)&0xff; buffer[index++]=BSON.BSON_BINARY_SUBTYPE_DEFAULT; value.copy(buffer,index,0,size); index=index+size;return index;}else if(value instanceof Long||value instanceof Timestamp||value['_bsontype']=='Long'||value['_bsontype']=='Timestamp'){ buffer[index++]=value instanceof Long?BSON.BSON_DATA_LONG:BSON.BSON_DATA_TIMESTAMP; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; var lowBits=value.getLowBits();var highBits=value.getHighBits(); buffer[index++]=lowBits&0xff;buffer[index++]=(lowBits>>8)&0xff;buffer[index++]=(lowBits>>16)&0xff;buffer[index++]=(lowBits>>24)&0xff; buffer[index++]=highBits&0xff;buffer[index++]=(highBits>>8)&0xff;buffer[index++]=(highBits>>16)&0xff;buffer[index++]=(highBits>>24)&0xff;return index;}else if(value instanceof Double||value['_bsontype']=='Double'){ buffer[index++]=BSON.BSON_DATA_NUMBER; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; writeIEEE754(buffer,value,index,'little',52,8); index=index+8;return index;}else if(value instanceof Code||value['_bsontype']=='Code'){if(value.scope!=null&&Object.keys(value.scope).length>0){ buffer[index++]=BSON.BSON_DATA_CODE_W_SCOPE; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; var scopeSize=BSON.calculateObjectSize(value.scope,serializeFunctions); var functionString=value.code.toString(); var codeSize=supportsBuffer?Buffer.byteLength(functionString)+1:numberOfBytes(functionString)+1; var totalSize=4+codeSize+scopeSize+4; buffer[index++]=totalSize&0xff;buffer[index++]=(totalSize>>8)&0xff;buffer[index++]=(totalSize>>16)&0xff;buffer[index++]=(totalSize>>24)&0xff; buffer[index++]=codeSize&0xff;buffer[index++]=(codeSize>>8)&0xff;buffer[index++]=(codeSize>>16)&0xff;buffer[index++]=(codeSize>>24)&0xff; supportsBuffer?buffer.write(functionString,index,'utf8'):writeToTypedArray(buffer,functionString,index); index=index+codeSize-1; buffer[index++]=0; var scopeObjectBuffer=supportsBuffer?new Buffer(scopeSize):new Uint8Array(new ArrayBuffer(scopeSize)); serializeObject(value.scope,checkKeys,scopeObjectBuffer,0,serializeFunctions);var scopeDocSize=scopeSize; buffer[index++]=scopeDocSize&0xff;buffer[index++]=(scopeDocSize>>8)&0xff;buffer[index++]=(scopeDocSize>>16)&0xff;buffer[index++]=(scopeDocSize>>24)&0xff; supportsBuffer?scopeObjectBuffer.copy(buffer,index,0,scopeSize):buffer.set(scopeObjectBuffer,index);index=index+scopeDocSize-5; buffer[index++]=0;return index}else{buffer[index++]=BSON.BSON_DATA_CODE; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; var functionString=value.code.toString(); var size=supportsBuffer?Buffer.byteLength(functionString)+1:numberOfBytes(functionString)+1; buffer[index++]=size&0xff;buffer[index++]=(size>>8)&0xff;buffer[index++]=(size>>16)&0xff;buffer[index++]=(size>>24)&0xff; supportsBuffer?buffer.write(functionString,index,'utf8'):writeToTypedArray(buffer,functionString,index); index=index+size-1; buffer[index++]=0;return index;}}else if(value instanceof Binary||value['_bsontype']=='Binary'){ buffer[index++]=BSON.BSON_DATA_BINARY; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; var data=value.value(true); var size=value.position; buffer[index++]=size&0xff;buffer[index++]=(size>>8)&0xff;buffer[index++]=(size>>16)&0xff;buffer[index++]=(size>>24)&0xff; buffer[index++]=value.sub_type; if(value.sub_type==Binary.SUBTYPE_BYTE_ARRAY){buffer[index++]=size&0xff;buffer[index++]=(size>>8)&0xff;buffer[index++]=(size>>16)&0xff;buffer[index++]=(size>>24)&0xff;} 
supportsBuffer?data.copy(buffer,index,0,value.position):buffer.set(data,index); index=index+value.position;return index;}else if(value instanceof Symbol||value['_bsontype']=='Symbol'){ buffer[index++]=BSON.BSON_DATA_SYMBOL; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; var size=supportsBuffer?Buffer.byteLength(value.value)+1:numberOfBytes(value.value)+1; buffer[index++]=size&0xff;buffer[index++]=(size>>8)&0xff;buffer[index++]=(size>>16)&0xff;buffer[index++]=(size>>24)&0xff; buffer.write(value.value,index,'utf8'); index=index+size-1; buffer[index++]=0x00;return index;}else if(value instanceof DBRef||value['_bsontype']=='DBRef'){ buffer[index++]=BSON.BSON_DATA_OBJECT; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; var ordered_values={'$ref':value.namespace,'$id':value.oid}; if(null!=value.db){ordered_values['$db']=value.db;} 
var size=BSON.calculateObjectSize(ordered_values,serializeFunctions); var endIndex=BSON.serializeWithBufferAndIndex(ordered_values,checkKeys,buffer,index,serializeFunctions); buffer[index++]=size&0xff;buffer[index++]=(size>>8)&0xff;buffer[index++]=(size>>16)&0xff;buffer[index++]=(size>>24)&0xff; buffer[endIndex++]=0x00; return endIndex;}else if(value instanceof RegExp||Object.prototype.toString.call(value)==='[object RegExp]'){ buffer[index++]=BSON.BSON_DATA_REGEXP; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; supportsBuffer?buffer.write(value.source,index,'utf8'):writeToTypedArray(buffer,value.source,index); index=index+(supportsBuffer?Buffer.byteLength(value.source):numberOfBytes(value.source)); buffer[index++]=0x00; if(value.global)buffer[index++]=0x73; if(value.ignoreCase)buffer[index++]=0x69; if(value.multiline)buffer[index++]=0x6d;
 buffer[index++]=0x00;return index;}else{ buffer[index++]=Array.isArray(value)?BSON.BSON_DATA_ARRAY:BSON.BSON_DATA_OBJECT; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0;var endIndex=serializeObject(value,checkKeys,buffer,index+4,serializeFunctions); var size=endIndex-index; buffer[index++]=size&0xff;buffer[index++]=(size>>8)&0xff;buffer[index++]=(size>>16)&0xff;buffer[index++]=(size>>24)&0xff;return endIndex;}
case'function':if(value instanceof RegExp||Object.prototype.toString.call(value)==='[object RegExp]'||String.call(value)=='[object RegExp]'){ buffer[index++]=BSON.BSON_DATA_REGEXP; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; buffer.write(value.source,index,'utf8'); index=index+(supportsBuffer?Buffer.byteLength(value.source):numberOfBytes(value.source)); buffer[index++]=0x00; if(value.global)buffer[index++]=0x73; if(value.ignoreCase)buffer[index++]=0x69; if(value.multiline)buffer[index++]=0x6d;
 buffer[index++]=0x00;return index;}else{if(serializeFunctions&&value.scope!=null&&Object.keys(value.scope).length>0){ buffer[index++]=BSON.BSON_DATA_CODE_W_SCOPE; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; var scopeSize=BSON.calculateObjectSize(value.scope,serializeFunctions); var functionString=value.toString(); var codeSize=supportsBuffer?Buffer.byteLength(functionString)+1:numberOfBytes(functionString)+1; var totalSize=4+codeSize+scopeSize; buffer[index++]=totalSize&0xff;buffer[index++]=(totalSize>>8)&0xff;buffer[index++]=(totalSize>>16)&0xff;buffer[index++]=(totalSize>>24)&0xff; buffer[index++]=codeSize&0xff;buffer[index++]=(codeSize>>8)&0xff;buffer[index++]=(codeSize>>16)&0xff;buffer[index++]=(codeSize>>24)&0xff; supportsBuffer?buffer.write(functionString,index,'utf8'):writeToTypedArray(buffer,functionString,index); index=index+codeSize-1; buffer[index++]=0; var scopeObjectBuffer=new Buffer(scopeSize); serializeObject(value.scope,checkKeys,scopeObjectBuffer,0,serializeFunctions);var scopeDocSize=scopeSize-4; buffer[index++]=scopeDocSize&0xff;buffer[index++]=(scopeDocSize>>8)&0xff;buffer[index++]=(scopeDocSize>>16)&0xff;buffer[index++]=(scopeDocSize>>24)&0xff; scopeObjectBuffer.copy(buffer,index,0,scopeSize);index=index+scopeDocSize-5; buffer[index++]=0;return index}else if(serializeFunctions){buffer[index++]=BSON.BSON_DATA_CODE; var numberOfWrittenBytes=supportsBuffer?buffer.write(name,index,'utf8'):writeToTypedArray(buffer,name,index); index=index+numberOfWrittenBytes+1;buffer[index-1]=0; var functionString=value.toString(); var size=supportsBuffer?Buffer.byteLength(functionString)+1:numberOfBytes(functionString)+1; buffer[index++]=size&0xff;buffer[index++]=(size>>8)&0xff;buffer[index++]=(size>>16)&0xff;buffer[index++]=(size>>24)&0xff; supportsBuffer?buffer.write(functionString,index,'utf8'):writeToTypedArray(buffer,functionString,index); index=index+size-1; buffer[index++]=0;return index;}}} 
return index;}
BSON.serialize=function(object,checkKeys,asBuffer,serializeFunctions){ if(object==null||typeof object!='object'||Array.isArray(object))
throw new Error("Only javascript objects supported"); var buffer=null; var size=BSON.calculateObjectSize(object,serializeFunctions); if(buffer=typeof Buffer!='undefined'){buffer=new Buffer(size);asBuffer=true;}else if(typeof Uint8Array!='undefined'){buffer=new Uint8Array(new ArrayBuffer(size));}else{buffer=new Array(size);} 
BSON.serializeWithBufferAndIndex(object,checkKeys,buffer,0,serializeFunctions);return buffer;}
var functionCache=BSON.functionCache={};var table=[0x00000000,0x77073096,0xEE0E612C,0x990951BA,0x076DC419,0x706AF48F,0xE963A535,0x9E6495A3,0x0EDB8832,0x79DCB8A4,0xE0D5E91E,0x97D2D988,0x09B64C2B,0x7EB17CBD,0xE7B82D07,0x90BF1D91,0x1DB71064,0x6AB020F2,0xF3B97148,0x84BE41DE,0x1ADAD47D,0x6DDDE4EB,0xF4D4B551,0x83D385C7,0x136C9856,0x646BA8C0,0xFD62F97A,0x8A65C9EC,0x14015C4F,0x63066CD9,0xFA0F3D63,0x8D080DF5,0x3B6E20C8,0x4C69105E,0xD56041E4,0xA2677172,0x3C03E4D1,0x4B04D447,0xD20D85FD,0xA50AB56B,0x35B5A8FA,0x42B2986C,0xDBBBC9D6,0xACBCF940,0x32D86CE3,0x45DF5C75,0xDCD60DCF,0xABD13D59,0x26D930AC,0x51DE003A,0xC8D75180,0xBFD06116,0x21B4F4B5,0x56B3C423,0xCFBA9599,0xB8BDA50F,0x2802B89E,0x5F058808,0xC60CD9B2,0xB10BE924,0x2F6F7C87,0x58684C11,0xC1611DAB,0xB6662D3D,0x76DC4190,0x01DB7106,0x98D220BC,0xEFD5102A,0x71B18589,0x06B6B51F,0x9FBFE4A5,0xE8B8D433,0x7807C9A2,0x0F00F934,0x9609A88E,0xE10E9818,0x7F6A0DBB,0x086D3D2D,0x91646C97,0xE6635C01,0x6B6B51F4,0x1C6C6162,0x856530D8,0xF262004E,0x6C0695ED,0x1B01A57B,0x8208F4C1,0xF50FC457,0x65B0D9C6,0x12B7E950,0x8BBEB8EA,0xFCB9887C,0x62DD1DDF,0x15DA2D49,0x8CD37CF3,0xFBD44C65,0x4DB26158,0x3AB551CE,0xA3BC0074,0xD4BB30E2,0x4ADFA541,0x3DD895D7,0xA4D1C46D,0xD3D6F4FB,0x4369E96A,0x346ED9FC,0xAD678846,0xDA60B8D0,0x44042D73,0x33031DE5,0xAA0A4C5F,0xDD0D7CC9,0x5005713C,0x270241AA,0xBE0B1010,0xC90C2086,0x5768B525,0x206F85B3,0xB966D409,0xCE61E49F,0x5EDEF90E,0x29D9C998,0xB0D09822,0xC7D7A8B4,0x59B33D17,0x2EB40D81,0xB7BD5C3B,0xC0BA6CAD,0xEDB88320,0x9ABFB3B6,0x03B6E20C,0x74B1D29A,0xEAD54739,0x9DD277AF,0x04DB2615,0x73DC1683,0xE3630B12,0x94643B84,0x0D6D6A3E,0x7A6A5AA8,0xE40ECF0B,0x9309FF9D,0x0A00AE27,0x7D079EB1,0xF00F9344,0x8708A3D2,0x1E01F268,0x6906C2FE,0xF762575D,0x806567CB,0x196C3671,0x6E6B06E7,0xFED41B76,0x89D32BE0,0x10DA7A5A,0x67DD4ACC,0xF9B9DF6F,0x8EBEEFF9,0x17B7BE43,0x60B08ED5,0xD6D6A3E8,0xA1D1937E,0x38D8C2C4,0x4FDFF252,0xD1BB67F1,0xA6BC5767,0x3FB506DD,0x48B2364B,0xD80D2BDA,0xAF0A1B4C,0x36034AF6,0x41047A60,0xDF60EFC3,0xA867DF55,0x316E8EEF,0x4669BE79,0xCB61B38C,0xBC66831A,0x256FD2A0,0x5268E236,0xCC0C7795,0xBB0B4703,0x220216B9,0x5505262F,0xC5BA3BBE,0xB2BD0B28,0x2BB45A92,0x5CB36A04,0xC2D7FFA7,0xB5D0CF31,0x2CD99E8B,0x5BDEAE1D,0x9B64C2B0,0xEC63F226,0x756AA39C,0x026D930A,0x9C0906A9,0xEB0E363F,0x72076785,0x05005713,0x95BF4A82,0xE2B87A14,0x7BB12BAE,0x0CB61B38,0x92D28E9B,0xE5D5BE0D,0x7CDCEFB7,0x0BDBDF21,0x86D3D2D4,0xF1D4E242,0x68DDB3F8,0x1FDA836E,0x81BE16CD,0xF6B9265B,0x6FB077E1,0x18B74777,0x88085AE6,0xFF0F6A70,0x66063BCA,0x11010B5C,0x8F659EFF,0xF862AE69,0x616BFFD3,0x166CCF45,0xA00AE278,0xD70DD2EE,0x4E048354,0x3903B3C2,0xA7672661,0xD06016F7,0x4969474D,0x3E6E77DB,0xAED16A4A,0xD9D65ADC,0x40DF0B66,0x37D83BF0,0xA9BCAE53,0xDEBB9EC5,0x47B2CF7F,0x30B5FFE9,0xBDBDF21C,0xCABAC28A,0x53B39330,0x24B4A3A6,0xBAD03605,0xCDD70693,0x54DE5729,0x23D967BF,0xB3667A2E,0xC4614AB8,0x5D681B02,0x2A6F2B94,0xB40BBE37,0xC30C8EA1,0x5A05DF1B,0x2D02EF8D];var crc32=function(string,start,end){var crc=0
var x=0;var y=0;crc=crc^(-1);for(var i=start,iTop=end;i<iTop;i++){y=(crc^string[i])&0xFF;x=table[y];crc=(crc>>>8)^x;}
return crc^(-1);}
BSON.deserializeStream=function(data,startIndex,numberOfDocuments,documents,docStartIndex,options){options=options!=null?options:{};var index=startIndex; for(var i=0;i<numberOfDocuments;i++){ var size=data[index]|data[index+1]<<8|data[index+2]<<16|data[index+3]<<24; options['index']=index; documents[docStartIndex+i]=BSON.deserialize(data,options); index=index+size;} 
return index;}
var isolateEvalWithHash=function(functionCache,hash,functionString,object){ var value=null; if(functionCache[hash]==null){eval("value = "+functionString);functionCache[hash]=value;} 
return functionCache[hash].bind(object);}
var isolateEval=function(functionString){ var value=null; eval("value = "+functionString);return value;}
var convertUint8ArrayToUtf8String=function(byteArray,startIndex,endIndex){return BinaryParser.decode_utf8(convertArraytoUtf8BinaryString(byteArray,startIndex,endIndex));}
var convertArraytoUtf8BinaryString=function(byteArray,startIndex,endIndex){var result="";for(var i=startIndex;i<endIndex;i++){result=result+String.fromCharCode(byteArray[i]);}
return result;};BSON.deserialize=function(buffer,options,isArray){ options=options==null?{}:options;var evalFunctions=options['evalFunctions']==null?false:options['evalFunctions'];var cacheFunctions=options['cacheFunctions']==null?false:options['cacheFunctions'];var cacheFunctionsCrc32=options['cacheFunctionsCrc32']==null?false:options['cacheFunctionsCrc32'];var promoteLongs=options['promoteLongs']||true; if(buffer.length<5)throw new Error("corrupt bson message < 5 bytes long"); var index=typeof options['index']=='number'?options['index']:0; var readCStyleString=function(){ var i=index; while(buffer[i]!==0x00){i++} 
var string=supportsBuffer&&Buffer.isBuffer(buffer)?buffer.toString('utf8',index,i):convertUint8ArrayToUtf8String(buffer,index,i); index=i+1; return string;} 
var object=isArray?[]:{}; var size=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24; if(size<5||size>buffer.length)throw new Error("corrupt bson message"); while(true){ var elementType=buffer[index++]; if(elementType==0)break; var name=readCStyleString(); switch(elementType){case BSON.BSON_DATA_OID:var string=supportsBuffer&&Buffer.isBuffer(buffer)?buffer.toString('binary',index,index+12):convertArraytoUtf8BinaryString(buffer,index,index+12); object[name]=new ObjectID(string); index=index+12;break;case BSON.BSON_DATA_STRING: var stringSize=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24; object[name]=supportsBuffer&&Buffer.isBuffer(buffer)?buffer.toString('utf8',index,index+stringSize-1):convertUint8ArrayToUtf8String(buffer,index,index+stringSize-1); index=index+stringSize;break;case BSON.BSON_DATA_INT: object[name]=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24;break;case BSON.BSON_DATA_NUMBER: object[name]=readIEEE754(buffer,index,'little',52,8); index=index+8;break;case BSON.BSON_DATA_DATE: var lowBits=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24;var highBits=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24; object[name]=new Date(new Long(lowBits,highBits).toNumber());break;case BSON.BSON_DATA_BOOLEAN: object[name]=buffer[index++]==1;break;case BSON.BSON_DATA_NULL: object[name]=null;break;case BSON.BSON_DATA_BINARY: var binarySize=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24; var subType=buffer[index++]; if(buffer['slice']!=null){ if(subType==Binary.SUBTYPE_BYTE_ARRAY){binarySize=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24;} 
object[name]=new Binary(buffer.slice(index,index+binarySize),subType);}else{var _buffer=typeof Uint8Array!='undefined'?new Uint8Array(new ArrayBuffer(binarySize)):new Array(binarySize); if(subType==Binary.SUBTYPE_BYTE_ARRAY){binarySize=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24;} 
for(var i=0;i<binarySize;i++){_buffer[i]=buffer[index+i];} 
object[name]=new Binary(_buffer,subType);} 
index=index+binarySize;break;case BSON.BSON_DATA_ARRAY:options['index']=index; var objectSize=buffer[index]|buffer[index+1]<<8|buffer[index+2]<<16|buffer[index+3]<<24; object[name]=BSON.deserialize(buffer,options,true); index=index+objectSize;break;case BSON.BSON_DATA_OBJECT:options['index']=index; var objectSize=buffer[index]|buffer[index+1]<<8|buffer[index+2]<<16|buffer[index+3]<<24; object[name]=BSON.deserialize(buffer,options,false); index=index+objectSize;break;case BSON.BSON_DATA_REGEXP: var source=readCStyleString();var regExpOptions=readCStyleString(); var optionsArray=new Array(regExpOptions.length); for(var i=0;i<regExpOptions.length;i++){switch(regExpOptions[i]){case'm':optionsArray[i]='m';break;case's':optionsArray[i]='g';break;case'i':optionsArray[i]='i';break;}}
object[name]=new RegExp(source,optionsArray.join(''));break;case BSON.BSON_DATA_LONG: var lowBits=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24;var highBits=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24; var long=new Long(lowBits,highBits); if(promoteLongs){object[name]=long.lessThanOrEqual(JS_INT_MAX_LONG)&&long.greaterThanOrEqual(JS_INT_MIN_LONG)?long.toNumber():long;}else{object[name]=long;}
break;case BSON.BSON_DATA_SYMBOL: var stringSize=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24; object[name]=new Symbol(buffer.toString('utf8',index,index+stringSize-1)); index=index+stringSize;break;case BSON.BSON_DATA_TIMESTAMP: var lowBits=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24;var highBits=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24; object[name]=new Timestamp(lowBits,highBits);break;case BSON.BSON_DATA_MIN_KEY: object[name]=new MinKey();break;case BSON.BSON_DATA_MAX_KEY: object[name]=new MaxKey();break;case BSON.BSON_DATA_CODE: var stringSize=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24; var functionString=supportsBuffer&&Buffer.isBuffer(buffer)?buffer.toString('utf8',index,index+stringSize-1):convertUint8ArrayToUtf8String(buffer,index,index+stringSize-1); if(evalFunctions){ var value=null; if(cacheFunctions){var hash=cacheFunctionsCrc32?crc32(functionString):functionString; object[name]=isolateEvalWithHash(functionCache,hash,functionString,object);}else{ object[name]=isolateEval(functionString);}}else{object[name]=new Code(functionString,{});} 
index=index+stringSize;break;case BSON.BSON_DATA_CODE_W_SCOPE: var totalSize=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24;var stringSize=buffer[index++]|buffer[index++]<<8|buffer[index++]<<16|buffer[index++]<<24; var functionString=supportsBuffer&&Buffer.isBuffer(buffer)?buffer.toString('utf8',index,index+stringSize-1):convertUint8ArrayToUtf8String(buffer,index,index+stringSize-1); index=index+stringSize; options['index']=index; var objectSize=buffer[index]|buffer[index+1]<<8|buffer[index+2]<<16|buffer[index+3]<<24; var scopeObject=BSON.deserialize(buffer,options,false); index=index+objectSize; if(evalFunctions){ var value=null; if(cacheFunctions){var hash=cacheFunctionsCrc32?crc32(functionString):functionString; object[name]=isolateEvalWithHash(functionCache,hash,functionString,object);}else{ object[name]=isolateEval(functionString);} 
object[name].scope=scopeObject;}else{object[name]=new Code(functionString,scopeObject);} 
break;}} 
if(object['$id']!=null)object=new DBRef(object['$ref'],object['$id'],object['$db']); return object;}
BSON.checkKey=function checkKey(key,dollarsAndDotsOk){if(!key.length)return;  if(!!~key.indexOf("\x00")){
throw Error("key "+key+" must not contain null bytes");}
if(!dollarsAndDotsOk){if('$'==key[0]){throw Error("key "+key+" must not start with '$'");}else if(!!~key.indexOf('.')){throw Error("key "+key+" must not contain '.'");}}};BSON.prototype.deserialize=function(data,options){return BSON.deserialize(data,options);}
BSON.prototype.deserializeStream=function(data,startIndex,numberOfDocuments,documents,docStartIndex,options){return BSON.deserializeStream(data,startIndex,numberOfDocuments,documents,docStartIndex,options);}
BSON.prototype.serialize=function(object,checkKeys,asBuffer,serializeFunctions){return BSON.serialize(object,checkKeys,asBuffer,serializeFunctions);}
BSON.prototype.calculateObjectSize=function(object,serializeFunctions){return BSON.calculateObjectSize(object,serializeFunctions);}
BSON.prototype.serializeWithBufferAndIndex=function(object,checkKeys,buffer,startIndex,serializeFunctions){return BSON.serializeWithBufferAndIndex(object,checkKeys,buffer,startIndex,serializeFunctions);}
exports.Code=Code;exports.Symbol=Symbol;exports.BSON=BSON;exports.DBRef=DBRef;exports.Binary=Binary;exports.ObjectID=ObjectID;exports.Long=Long;exports.Timestamp=Timestamp;exports.Double=Double;exports.MinKey=MinKey;exports.MaxKey=MaxKey;},'code':function(module,exports,global,require,undefined){function Code(code,scope){if(!(this instanceof Code))return new Code(code,scope);this._bsontype='Code';this.code=code;this.scope=scope==null?{}:scope;};Code.prototype.toJSON=function(){return{scope:this.scope,code:this.code};}
exports.Code=Code;},'db_ref':function(module,exports,global,require,undefined){function DBRef(namespace,oid,db){if(!(this instanceof DBRef))return new DBRef(namespace,oid,db);this._bsontype='DBRef';this.namespace=namespace;this.oid=oid;this.db=db;};DBRef.prototype.toJSON=function(){return{'$ref':this.namespace,'$id':this.oid,'$db':this.db==null?'':this.db};}
exports.DBRef=DBRef;},'double':function(module,exports,global,require,undefined){function Double(value){if(!(this instanceof Double))return new Double(value);this._bsontype='Double';this.value=value;}
Double.prototype.valueOf=function(){return this.value;};Double.prototype.toJSON=function(){return this.value;}
exports.Double=Double;},'float_parser':function(module,exports,global,require,undefined){












var readIEEE754=function(buffer,offset,endian,mLen,nBytes){var e,m,bBE=(endian==='big'),eLen=nBytes*8-mLen-1,eMax=(1<<eLen)-1,eBias=eMax>>1,nBits=-7,i=bBE?0:(nBytes-1),d=bBE?1:-1,s=buffer[offset+i];i+=d;e=s&((1<<(-nBits))-1);s>>=(-nBits);nBits+=eLen;for(;nBits>0;e=e*256+buffer[offset+i],i+=d,nBits-=8);m=e&((1<<(-nBits))-1);e>>=(-nBits);nBits+=mLen;for(;nBits>0;m=m*256+buffer[offset+i],i+=d,nBits-=8);if(e===0){e=1-eBias;}else if(e===eMax){return m?NaN:((s?-1:1)*Infinity);}else{m=m+Math.pow(2,mLen);e=e-eBias;}
return(s?-1:1)*m*Math.pow(2,e-mLen);};var writeIEEE754=function(buffer,value,offset,endian,mLen,nBytes){var e,m,c,bBE=(endian==='big'),eLen=nBytes*8-mLen-1,eMax=(1<<eLen)-1,eBias=eMax>>1,rt=(mLen===23?Math.pow(2,-24)-Math.pow(2,-77):0),i=bBE?(nBytes-1):0,d=bBE?-1:1,s=value<0||(value===0&&1/value<0)?1:0;value=Math.abs(value);if(isNaN(value)||value===Infinity){m=isNaN(value)?1:0;e=eMax;}else{e=Math.floor(Math.log(value)/Math.LN2);if(value*(c=Math.pow(2,-e))<1){e--;c*=2;}
if(e+eBias>=1){value+=rt/c;}else{value+=rt*Math.pow(2,1-eBias);}
if(value*c>=2){e++;c/=2;}
if(e+eBias>=eMax){m=0;e=eMax;}else if(e+eBias>=1){m=(value*c-1)*Math.pow(2,mLen);e=e+eBias;}else{m=value*Math.pow(2,eBias-1)*Math.pow(2,mLen);e=0;}}
for(;mLen>=8;buffer[offset+i]=m&0xff,i+=d,m/=256,mLen-=8);e=(e<<mLen)|m;eLen+=mLen;for(;eLen>0;buffer[offset+i]=e&0xff,i+=d,e/=256,eLen-=8);buffer[offset+i-d]|=s*128;};exports.readIEEE754=readIEEE754;exports.writeIEEE754=writeIEEE754;},'index':function(module,exports,global,require,undefined){try{exports.BSONPure=require('./bson');exports.BSONNative=require('../../ext');}catch(err){}
['./binary_parser','./binary','./code','./db_ref','./double','./max_key','./min_key','./objectid','./symbol','./timestamp','./long'].forEach(function(path){var module=require('./'+path);for(var i in module){exports[i]=module[i];}});exports.native=function(){var classes={};['./binary_parser','./binary','./code','./db_ref','./double','./max_key','./min_key','./objectid','./symbol','./timestamp','./long','../../ext'].forEach(function(path){var module=require('./'+path);for(var i in module){classes[i]=module[i];}}); return classes;}
exports.pure=function(){var classes={};['./binary_parser','./binary','./code','./db_ref','./double','./max_key','./min_key','./objectid','./symbol','./timestamp','./long','././bson'].forEach(function(path){var module=require('./'+path);for(var i in module){classes[i]=module[i];}}); return classes;}},'long':function(module,exports,global,require,undefined){



 function Long(low,high){if(!(this instanceof Long))return new Long(low,high);this._bsontype='Long';this.low_=low|0;this.high_=high|0;};Long.prototype.toInt=function(){return this.low_;};Long.prototype.toNumber=function(){return this.high_*Long.TWO_PWR_32_DBL_+
this.getLowBitsUnsigned();};Long.prototype.toJSON=function(){return this.toString();}
Long.prototype.toString=function(opt_radix){var radix=opt_radix||10;if(radix<2||36<radix){throw Error('radix out of range: '+radix);}
if(this.isZero()){return'0';}
if(this.isNegative()){if(this.equals(Long.MIN_VALUE)){
var radixLong=Long.fromNumber(radix);var div=this.div(radixLong);var rem=div.multiply(radixLong).subtract(this);return div.toString(radix)+rem.toInt().toString(radix);}else{return'-'+this.negate().toString(radix);}}

var radixToPower=Long.fromNumber(Math.pow(radix,6));var rem=this;var result='';while(true){var remDiv=rem.div(radixToPower);var intval=rem.subtract(remDiv.multiply(radixToPower)).toInt();var digits=intval.toString(radix);rem=remDiv;if(rem.isZero()){return digits+result;}else{while(digits.length<6){digits='0'+digits;}
result=''+digits+result;}}};Long.prototype.getHighBits=function(){return this.high_;};Long.prototype.getLowBits=function(){return this.low_;};Long.prototype.getLowBitsUnsigned=function(){return(this.low_>=0)?this.low_:Long.TWO_PWR_32_DBL_+this.low_;};Long.prototype.getNumBitsAbs=function(){if(this.isNegative()){if(this.equals(Long.MIN_VALUE)){return 64;}else{return this.negate().getNumBitsAbs();}}else{var val=this.high_!=0?this.high_:this.low_;for(var bit=31;bit>0;bit--){if((val&(1<<bit))!=0){break;}}
return this.high_!=0?bit+33:bit+1;}};Long.prototype.isZero=function(){return this.high_==0&&this.low_==0;};Long.prototype.isNegative=function(){return this.high_<0;};Long.prototype.isOdd=function(){return(this.low_&1)==1;};Long.prototype.equals=function(other){return(this.high_==other.high_)&&(this.low_==other.low_);};Long.prototype.notEquals=function(other){return(this.high_!=other.high_)||(this.low_!=other.low_);};Long.prototype.lessThan=function(other){return this.compare(other)<0;};Long.prototype.lessThanOrEqual=function(other){return this.compare(other)<=0;};Long.prototype.greaterThan=function(other){return this.compare(other)>0;};Long.prototype.greaterThanOrEqual=function(other){return this.compare(other)>=0;};Long.prototype.compare=function(other){if(this.equals(other)){return 0;}
var thisNeg=this.isNegative();var otherNeg=other.isNegative();if(thisNeg&&!otherNeg){return-1;}
if(!thisNeg&&otherNeg){return 1;} 
if(this.subtract(other).isNegative()){return-1;}else{return 1;}};Long.prototype.negate=function(){if(this.equals(Long.MIN_VALUE)){return Long.MIN_VALUE;}else{return this.not().add(Long.ONE);}};Long.prototype.add=function(other){var a48=this.high_>>>16;var a32=this.high_&0xFFFF;var a16=this.low_>>>16;var a00=this.low_&0xFFFF;var b48=other.high_>>>16;var b32=other.high_&0xFFFF;var b16=other.low_>>>16;var b00=other.low_&0xFFFF;var c48=0,c32=0,c16=0,c00=0;c00+=a00+b00;c16+=c00>>>16;c00&=0xFFFF;c16+=a16+b16;c32+=c16>>>16;c16&=0xFFFF;c32+=a32+b32;c48+=c32>>>16;c32&=0xFFFF;c48+=a48+b48;c48&=0xFFFF;return Long.fromBits((c16<<16)|c00,(c48<<16)|c32);};Long.prototype.subtract=function(other){return this.add(other.negate());};Long.prototype.multiply=function(other){if(this.isZero()){return Long.ZERO;}else if(other.isZero()){return Long.ZERO;}
if(this.equals(Long.MIN_VALUE)){return other.isOdd()?Long.MIN_VALUE:Long.ZERO;}else if(other.equals(Long.MIN_VALUE)){return this.isOdd()?Long.MIN_VALUE:Long.ZERO;}
if(this.isNegative()){if(other.isNegative()){return this.negate().multiply(other.negate());}else{return this.negate().multiply(other).negate();}}else if(other.isNegative()){return this.multiply(other.negate()).negate();} 
if(this.lessThan(Long.TWO_PWR_24_)&&other.lessThan(Long.TWO_PWR_24_)){return Long.fromNumber(this.toNumber()*other.toNumber());}
var a48=this.high_>>>16;var a32=this.high_&0xFFFF;var a16=this.low_>>>16;var a00=this.low_&0xFFFF;var b48=other.high_>>>16;var b32=other.high_&0xFFFF;var b16=other.low_>>>16;var b00=other.low_&0xFFFF;var c48=0,c32=0,c16=0,c00=0;c00+=a00*b00;c16+=c00>>>16;c00&=0xFFFF;c16+=a16*b00;c32+=c16>>>16;c16&=0xFFFF;c16+=a00*b16;c32+=c16>>>16;c16&=0xFFFF;c32+=a32*b00;c48+=c32>>>16;c32&=0xFFFF;c32+=a16*b16;c48+=c32>>>16;c32&=0xFFFF;c32+=a00*b32;c48+=c32>>>16;c32&=0xFFFF;c48+=a48*b00+a32*b16+a16*b32+a00*b48;c48&=0xFFFF;return Long.fromBits((c16<<16)|c00,(c48<<16)|c32);};Long.prototype.div=function(other){if(other.isZero()){throw Error('division by zero');}else if(this.isZero()){return Long.ZERO;}
if(this.equals(Long.MIN_VALUE)){if(other.equals(Long.ONE)||other.equals(Long.NEG_ONE)){return Long.MIN_VALUE;}else if(other.equals(Long.MIN_VALUE)){return Long.ONE;}else{var halfThis=this.shiftRight(1);var approx=halfThis.div(other).shiftLeft(1);if(approx.equals(Long.ZERO)){return other.isNegative()?Long.ONE:Long.NEG_ONE;}else{var rem=this.subtract(other.multiply(approx));var result=approx.add(rem.div(other));return result;}}}else if(other.equals(Long.MIN_VALUE)){return Long.ZERO;}
if(this.isNegative()){if(other.isNegative()){return this.negate().div(other.negate());}else{return this.negate().div(other).negate();}}else if(other.isNegative()){return this.div(other.negate()).negate();}




var res=Long.ZERO;var rem=this;while(rem.greaterThanOrEqual(other)){
var approx=Math.max(1,Math.floor(rem.toNumber()/other.toNumber()));
var log2=Math.ceil(Math.log(approx)/Math.LN2);var delta=(log2<=48)?1:Math.pow(2,log2-48);
var approxRes=Long.fromNumber(approx);var approxRem=approxRes.multiply(other);while(approxRem.isNegative()||approxRem.greaterThan(rem)){approx-=delta;approxRes=Long.fromNumber(approx);approxRem=approxRes.multiply(other);}

if(approxRes.isZero()){approxRes=Long.ONE;}
res=res.add(approxRes);rem=rem.subtract(approxRem);}
return res;};Long.prototype.modulo=function(other){return this.subtract(this.div(other).multiply(other));};Long.prototype.not=function(){return Long.fromBits(~this.low_,~this.high_);};Long.prototype.and=function(other){return Long.fromBits(this.low_&other.low_,this.high_&other.high_);};Long.prototype.or=function(other){return Long.fromBits(this.low_|other.low_,this.high_|other.high_);};Long.prototype.xor=function(other){return Long.fromBits(this.low_^other.low_,this.high_^other.high_);};Long.prototype.shiftLeft=function(numBits){numBits&=63;if(numBits==0){return this;}else{var low=this.low_;if(numBits<32){var high=this.high_;return Long.fromBits(low<<numBits,(high<<numBits)|(low>>>(32-numBits)));}else{return Long.fromBits(0,low<<(numBits-32));}}};Long.prototype.shiftRight=function(numBits){numBits&=63;if(numBits==0){return this;}else{var high=this.high_;if(numBits<32){var low=this.low_;return Long.fromBits((low>>>numBits)|(high<<(32-numBits)),high>>numBits);}else{return Long.fromBits(high>>(numBits-32),high>=0?0:-1);}}};Long.prototype.shiftRightUnsigned=function(numBits){numBits&=63;if(numBits==0){return this;}else{var high=this.high_;if(numBits<32){var low=this.low_;return Long.fromBits((low>>>numBits)|(high<<(32-numBits)),high>>>numBits);}else if(numBits==32){return Long.fromBits(high,0);}else{return Long.fromBits(high>>>(numBits-32),0);}}};Long.fromInt=function(value){if(-128<=value&&value<128){var cachedObj=Long.INT_CACHE_[value];if(cachedObj){return cachedObj;}}
var obj=new Long(value|0,value<0?-1:0);if(-128<=value&&value<128){Long.INT_CACHE_[value]=obj;}
return obj;};Long.fromNumber=function(value){if(isNaN(value)||!isFinite(value)){return Long.ZERO;}else if(value<=-Long.TWO_PWR_63_DBL_){return Long.MIN_VALUE;}else if(value+1>=Long.TWO_PWR_63_DBL_){return Long.MAX_VALUE;}else if(value<0){return Long.fromNumber(-value).negate();}else{return new Long((value%Long.TWO_PWR_32_DBL_)|0,(value/Long.TWO_PWR_32_DBL_)|0);}};Long.fromBits=function(lowBits,highBits){return new Long(lowBits,highBits);};Long.fromString=function(str,opt_radix){if(str.length==0){throw Error('number format error: empty string');}
var radix=opt_radix||10;if(radix<2||36<radix){throw Error('radix out of range: '+radix);}
if(str.charAt(0)=='-'){return Long.fromString(str.substring(1),radix).negate();}else if(str.indexOf('-')>=0){throw Error('number format error: interior "-" character: '+str);}

var radixToPower=Long.fromNumber(Math.pow(radix,8));var result=Long.ZERO;for(var i=0;i<str.length;i+=8){var size=Math.min(8,str.length-i);var value=parseInt(str.substring(i,i+size),radix);if(size<8){var power=Long.fromNumber(Math.pow(radix,size));result=result.multiply(power).add(Long.fromNumber(value));}else{result=result.multiply(radixToPower);result=result.add(Long.fromNumber(value));}}
return result;};
Long.INT_CACHE_={};
Long.TWO_PWR_16_DBL_=1<<16;Long.TWO_PWR_24_DBL_=1<<24;Long.TWO_PWR_32_DBL_=Long.TWO_PWR_16_DBL_*Long.TWO_PWR_16_DBL_;Long.TWO_PWR_31_DBL_=Long.TWO_PWR_32_DBL_/2;Long.TWO_PWR_48_DBL_=Long.TWO_PWR_32_DBL_*Long.TWO_PWR_16_DBL_;Long.TWO_PWR_64_DBL_=Long.TWO_PWR_32_DBL_*Long.TWO_PWR_32_DBL_;Long.TWO_PWR_63_DBL_=Long.TWO_PWR_64_DBL_/2;Long.ZERO=Long.fromInt(0);Long.ONE=Long.fromInt(1);Long.NEG_ONE=Long.fromInt(-1);Long.MAX_VALUE=Long.fromBits(0xFFFFFFFF|0,0x7FFFFFFF|0);Long.MIN_VALUE=Long.fromBits(0,0x80000000|0);Long.TWO_PWR_24_=Long.fromInt(1<<24);exports.Long=Long;},'max_key':function(module,exports,global,require,undefined){function MaxKey(){if(!(this instanceof MaxKey))return new MaxKey();this._bsontype='MaxKey';}
exports.MaxKey=MaxKey;},'min_key':function(module,exports,global,require,undefined){function MinKey(){if(!(this instanceof MinKey))return new MinKey();this._bsontype='MinKey';}
exports.MinKey=MinKey;},'objectid':function(module,exports,global,require,undefined){var BinaryParser=require('./binary_parser').BinaryParser;var MACHINE_ID=parseInt(Math.random()*0xFFFFFF,10);var checkForHexRegExp=new RegExp("^[0-9a-fA-F]{24}$");var ObjectID=function ObjectID(id,_hex){if(!(this instanceof ObjectID))return new ObjectID(id,_hex);this._bsontype='ObjectID';var __id=null; if(id!=null&&'number'!=typeof id&&(id.length!=12&&id.length!=24))
throw new Error("Argument passed in must be a single String of 12 bytes or a string of 24 hex characters"); if(id==null||typeof id=='number'){ this.id=this.generate(id);}else if(id!=null&&id.length===12){ this.id=id;}else if(checkForHexRegExp.test(id)){return ObjectID.createFromHexString(id);}else{throw new Error("Value passed in is not a valid 24 character hex string");}
if(ObjectID.cacheHexString)this.__id=this.toHexString();};var ObjectId=ObjectID;var hexTable=[];for(var i=0;i<256;i++){hexTable[i]=(i<=15?'0':'')+i.toString(16);}
ObjectID.prototype.toHexString=function(){if(ObjectID.cacheHexString&&this.__id)return this.__id;var hexString='';for(var i=0;i<this.id.length;i++){hexString+=hexTable[this.id.charCodeAt(i)];}
if(ObjectID.cacheHexString)this.__id=hexString;return hexString;};ObjectID.prototype.get_inc=function(){return ObjectID.index=(ObjectID.index+1)%0xFFFFFF;};ObjectID.prototype.getInc=function(){return this.get_inc();};ObjectID.prototype.generate=function(time){if('number'==typeof time){var time4Bytes=BinaryParser.encodeInt(time,32,true,true);var machine3Bytes=BinaryParser.encodeInt(MACHINE_ID,24,false);var pid2Bytes=BinaryParser.fromShort(typeof process==='undefined'?Math.floor(Math.random()*100000):process.pid);var index3Bytes=BinaryParser.encodeInt(this.get_inc(),24,false,true);}else{var unixTime=parseInt(Date.now()/1000,10);var time4Bytes=BinaryParser.encodeInt(unixTime,32,true,true);var machine3Bytes=BinaryParser.encodeInt(MACHINE_ID,24,false);var pid2Bytes=BinaryParser.fromShort(typeof process==='undefined'?Math.floor(Math.random()*100000):process.pid);var index3Bytes=BinaryParser.encodeInt(this.get_inc(),24,false,true);}
return time4Bytes+machine3Bytes+pid2Bytes+index3Bytes;};ObjectID.prototype.toString=function(){return this.toHexString();};ObjectID.prototype.inspect=ObjectID.prototype.toString;ObjectID.prototype.toJSON=function(){return this.toHexString();};ObjectID.prototype.equals=function equals(otherID){var id=(otherID instanceof ObjectID||otherID.toHexString)?otherID.id:ObjectID.createFromHexString(otherID).id;return this.id===id;}
ObjectID.prototype.getTimestamp=function(){var timestamp=new Date();timestamp.setTime(Math.floor(BinaryParser.decodeInt(this.id.substring(0,4),32,true,true))*1000);return timestamp;}
ObjectID.index=parseInt(Math.random()*0xFFFFFF,10);ObjectID.createPk=function createPk(){return new ObjectID();};ObjectID.createFromTime=function createFromTime(time){var id=BinaryParser.encodeInt(time,32,true,true)+
BinaryParser.encodeInt(0,64,true,true);return new ObjectID(id);};ObjectID.createFromHexString=function createFromHexString(hexString){ if(typeof hexString==='undefined'||hexString!=null&&hexString.length!=24)
throw new Error("Argument passed in must be a single String of 12 bytes or a string of 24 hex characters");var len=hexString.length;if(len>12*2){throw new Error('Id cannot be longer than 12 bytes');}
var result='',string,number;for(var index=0;index<len;index+=2){string=hexString.substr(index,2);number=parseInt(string,16);result+=BinaryParser.fromByte(number);}
return new ObjectID(result,hexString);};Object.defineProperty(ObjectID.prototype,"generationTime",{enumerable:true,get:function(){return Math.floor(BinaryParser.decodeInt(this.id.substring(0,4),32,true,true));},set:function(value){var value=BinaryParser.encodeInt(value,32,true,true);this.id=value+this.id.substr(4);this.toHexString();}});exports.ObjectID=ObjectID;exports.ObjectId=ObjectID;},'symbol':function(module,exports,global,require,undefined){function Symbol(value){if(!(this instanceof Symbol))return new Symbol(value);this._bsontype='Symbol';this.value=value;}
Symbol.prototype.valueOf=function(){return this.value;};Symbol.prototype.toString=function(){return this.value;}
Symbol.prototype.inspect=function(){return this.value;}
Symbol.prototype.toJSON=function(){return this.value;}
exports.Symbol=Symbol;},'timestamp':function(module,exports,global,require,undefined){



 function Timestamp(low,high){if(!(this instanceof Timestamp))return new Timestamp(low,high);this._bsontype='Timestamp';this.low_=low|0;this.high_=high|0;};Timestamp.prototype.toInt=function(){return this.low_;};Timestamp.prototype.toNumber=function(){return this.high_*Timestamp.TWO_PWR_32_DBL_+
this.getLowBitsUnsigned();};Timestamp.prototype.toJSON=function(){return this.toString();}
Timestamp.prototype.toString=function(opt_radix){var radix=opt_radix||10;if(radix<2||36<radix){throw Error('radix out of range: '+radix);}
if(this.isZero()){return'0';}
if(this.isNegative()){if(this.equals(Timestamp.MIN_VALUE)){
var radixTimestamp=Timestamp.fromNumber(radix);var div=this.div(radixTimestamp);var rem=div.multiply(radixTimestamp).subtract(this);return div.toString(radix)+rem.toInt().toString(radix);}else{return'-'+this.negate().toString(radix);}}

var radixToPower=Timestamp.fromNumber(Math.pow(radix,6));var rem=this;var result='';while(true){var remDiv=rem.div(radixToPower);var intval=rem.subtract(remDiv.multiply(radixToPower)).toInt();var digits=intval.toString(radix);rem=remDiv;if(rem.isZero()){return digits+result;}else{while(digits.length<6){digits='0'+digits;}
result=''+digits+result;}}};Timestamp.prototype.getHighBits=function(){return this.high_;};Timestamp.prototype.getLowBits=function(){return this.low_;};Timestamp.prototype.getLowBitsUnsigned=function(){return(this.low_>=0)?this.low_:Timestamp.TWO_PWR_32_DBL_+this.low_;};Timestamp.prototype.getNumBitsAbs=function(){if(this.isNegative()){if(this.equals(Timestamp.MIN_VALUE)){return 64;}else{return this.negate().getNumBitsAbs();}}else{var val=this.high_!=0?this.high_:this.low_;for(var bit=31;bit>0;bit--){if((val&(1<<bit))!=0){break;}}
return this.high_!=0?bit+33:bit+1;}};Timestamp.prototype.isZero=function(){return this.high_==0&&this.low_==0;};Timestamp.prototype.isNegative=function(){return this.high_<0;};Timestamp.prototype.isOdd=function(){return(this.low_&1)==1;};Timestamp.prototype.equals=function(other){return(this.high_==other.high_)&&(this.low_==other.low_);};Timestamp.prototype.notEquals=function(other){return(this.high_!=other.high_)||(this.low_!=other.low_);};Timestamp.prototype.lessThan=function(other){return this.compare(other)<0;};Timestamp.prototype.lessThanOrEqual=function(other){return this.compare(other)<=0;};Timestamp.prototype.greaterThan=function(other){return this.compare(other)>0;};Timestamp.prototype.greaterThanOrEqual=function(other){return this.compare(other)>=0;};Timestamp.prototype.compare=function(other){if(this.equals(other)){return 0;}
var thisNeg=this.isNegative();var otherNeg=other.isNegative();if(thisNeg&&!otherNeg){return-1;}
if(!thisNeg&&otherNeg){return 1;} 
if(this.subtract(other).isNegative()){return-1;}else{return 1;}};Timestamp.prototype.negate=function(){if(this.equals(Timestamp.MIN_VALUE)){return Timestamp.MIN_VALUE;}else{return this.not().add(Timestamp.ONE);}};Timestamp.prototype.add=function(other){var a48=this.high_>>>16;var a32=this.high_&0xFFFF;var a16=this.low_>>>16;var a00=this.low_&0xFFFF;var b48=other.high_>>>16;var b32=other.high_&0xFFFF;var b16=other.low_>>>16;var b00=other.low_&0xFFFF;var c48=0,c32=0,c16=0,c00=0;c00+=a00+b00;c16+=c00>>>16;c00&=0xFFFF;c16+=a16+b16;c32+=c16>>>16;c16&=0xFFFF;c32+=a32+b32;c48+=c32>>>16;c32&=0xFFFF;c48+=a48+b48;c48&=0xFFFF;return Timestamp.fromBits((c16<<16)|c00,(c48<<16)|c32);};Timestamp.prototype.subtract=function(other){return this.add(other.negate());};Timestamp.prototype.multiply=function(other){if(this.isZero()){return Timestamp.ZERO;}else if(other.isZero()){return Timestamp.ZERO;}
if(this.equals(Timestamp.MIN_VALUE)){return other.isOdd()?Timestamp.MIN_VALUE:Timestamp.ZERO;}else if(other.equals(Timestamp.MIN_VALUE)){return this.isOdd()?Timestamp.MIN_VALUE:Timestamp.ZERO;}
if(this.isNegative()){if(other.isNegative()){return this.negate().multiply(other.negate());}else{return this.negate().multiply(other).negate();}}else if(other.isNegative()){return this.multiply(other.negate()).negate();} 
if(this.lessThan(Timestamp.TWO_PWR_24_)&&other.lessThan(Timestamp.TWO_PWR_24_)){return Timestamp.fromNumber(this.toNumber()*other.toNumber());}
var a48=this.high_>>>16;var a32=this.high_&0xFFFF;var a16=this.low_>>>16;var a00=this.low_&0xFFFF;var b48=other.high_>>>16;var b32=other.high_&0xFFFF;var b16=other.low_>>>16;var b00=other.low_&0xFFFF;var c48=0,c32=0,c16=0,c00=0;c00+=a00*b00;c16+=c00>>>16;c00&=0xFFFF;c16+=a16*b00;c32+=c16>>>16;c16&=0xFFFF;c16+=a00*b16;c32+=c16>>>16;c16&=0xFFFF;c32+=a32*b00;c48+=c32>>>16;c32&=0xFFFF;c32+=a16*b16;c48+=c32>>>16;c32&=0xFFFF;c32+=a00*b32;c48+=c32>>>16;c32&=0xFFFF;c48+=a48*b00+a32*b16+a16*b32+a00*b48;c48&=0xFFFF;return Timestamp.fromBits((c16<<16)|c00,(c48<<16)|c32);};Timestamp.prototype.div=function(other){if(other.isZero()){throw Error('division by zero');}else if(this.isZero()){return Timestamp.ZERO;}
if(this.equals(Timestamp.MIN_VALUE)){if(other.equals(Timestamp.ONE)||other.equals(Timestamp.NEG_ONE)){return Timestamp.MIN_VALUE;}else if(other.equals(Timestamp.MIN_VALUE)){return Timestamp.ONE;}else{var halfThis=this.shiftRight(1);var approx=halfThis.div(other).shiftLeft(1);if(approx.equals(Timestamp.ZERO)){return other.isNegative()?Timestamp.ONE:Timestamp.NEG_ONE;}else{var rem=this.subtract(other.multiply(approx));var result=approx.add(rem.div(other));return result;}}}else if(other.equals(Timestamp.MIN_VALUE)){return Timestamp.ZERO;}
if(this.isNegative()){if(other.isNegative()){return this.negate().div(other.negate());}else{return this.negate().div(other).negate();}}else if(other.isNegative()){return this.div(other.negate()).negate();}




var res=Timestamp.ZERO;var rem=this;while(rem.greaterThanOrEqual(other)){
var approx=Math.max(1,Math.floor(rem.toNumber()/other.toNumber()));
var log2=Math.ceil(Math.log(approx)/Math.LN2);var delta=(log2<=48)?1:Math.pow(2,log2-48);
var approxRes=Timestamp.fromNumber(approx);var approxRem=approxRes.multiply(other);while(approxRem.isNegative()||approxRem.greaterThan(rem)){approx-=delta;approxRes=Timestamp.fromNumber(approx);approxRem=approxRes.multiply(other);}

if(approxRes.isZero()){approxRes=Timestamp.ONE;}
res=res.add(approxRes);rem=rem.subtract(approxRem);}
return res;};Timestamp.prototype.modulo=function(other){return this.subtract(this.div(other).multiply(other));};Timestamp.prototype.not=function(){return Timestamp.fromBits(~this.low_,~this.high_);};Timestamp.prototype.and=function(other){return Timestamp.fromBits(this.low_&other.low_,this.high_&other.high_);};Timestamp.prototype.or=function(other){return Timestamp.fromBits(this.low_|other.low_,this.high_|other.high_);};Timestamp.prototype.xor=function(other){return Timestamp.fromBits(this.low_^other.low_,this.high_^other.high_);};Timestamp.prototype.shiftLeft=function(numBits){numBits&=63;if(numBits==0){return this;}else{var low=this.low_;if(numBits<32){var high=this.high_;return Timestamp.fromBits(low<<numBits,(high<<numBits)|(low>>>(32-numBits)));}else{return Timestamp.fromBits(0,low<<(numBits-32));}}};Timestamp.prototype.shiftRight=function(numBits){numBits&=63;if(numBits==0){return this;}else{var high=this.high_;if(numBits<32){var low=this.low_;return Timestamp.fromBits((low>>>numBits)|(high<<(32-numBits)),high>>numBits);}else{return Timestamp.fromBits(high>>(numBits-32),high>=0?0:-1);}}};Timestamp.prototype.shiftRightUnsigned=function(numBits){numBits&=63;if(numBits==0){return this;}else{var high=this.high_;if(numBits<32){var low=this.low_;return Timestamp.fromBits((low>>>numBits)|(high<<(32-numBits)),high>>>numBits);}else if(numBits==32){return Timestamp.fromBits(high,0);}else{return Timestamp.fromBits(high>>>(numBits-32),0);}}};Timestamp.fromInt=function(value){if(-128<=value&&value<128){var cachedObj=Timestamp.INT_CACHE_[value];if(cachedObj){return cachedObj;}}
var obj=new Timestamp(value|0,value<0?-1:0);if(-128<=value&&value<128){Timestamp.INT_CACHE_[value]=obj;}
return obj;};Timestamp.fromNumber=function(value){if(isNaN(value)||!isFinite(value)){return Timestamp.ZERO;}else if(value<=-Timestamp.TWO_PWR_63_DBL_){return Timestamp.MIN_VALUE;}else if(value+1>=Timestamp.TWO_PWR_63_DBL_){return Timestamp.MAX_VALUE;}else if(value<0){return Timestamp.fromNumber(-value).negate();}else{return new Timestamp((value%Timestamp.TWO_PWR_32_DBL_)|0,(value/Timestamp.TWO_PWR_32_DBL_)|0);}};Timestamp.fromBits=function(lowBits,highBits){return new Timestamp(lowBits,highBits);};Timestamp.fromString=function(str,opt_radix){if(str.length==0){throw Error('number format error: empty string');}
var radix=opt_radix||10;if(radix<2||36<radix){throw Error('radix out of range: '+radix);}
if(str.charAt(0)=='-'){return Timestamp.fromString(str.substring(1),radix).negate();}else if(str.indexOf('-')>=0){throw Error('number format error: interior "-" character: '+str);}

var radixToPower=Timestamp.fromNumber(Math.pow(radix,8));var result=Timestamp.ZERO;for(var i=0;i<str.length;i+=8){var size=Math.min(8,str.length-i);var value=parseInt(str.substring(i,i+size),radix);if(size<8){var power=Timestamp.fromNumber(Math.pow(radix,size));result=result.multiply(power).add(Timestamp.fromNumber(value));}else{result=result.multiply(radixToPower);result=result.add(Timestamp.fromNumber(value));}}
return result;};
Timestamp.INT_CACHE_={};
Timestamp.TWO_PWR_16_DBL_=1<<16;Timestamp.TWO_PWR_24_DBL_=1<<24;Timestamp.TWO_PWR_32_DBL_=Timestamp.TWO_PWR_16_DBL_*Timestamp.TWO_PWR_16_DBL_;Timestamp.TWO_PWR_31_DBL_=Timestamp.TWO_PWR_32_DBL_/2;Timestamp.TWO_PWR_48_DBL_=Timestamp.TWO_PWR_32_DBL_*Timestamp.TWO_PWR_16_DBL_;Timestamp.TWO_PWR_64_DBL_=Timestamp.TWO_PWR_32_DBL_*Timestamp.TWO_PWR_32_DBL_;Timestamp.TWO_PWR_63_DBL_=Timestamp.TWO_PWR_64_DBL_/2;Timestamp.ZERO=Timestamp.fromInt(0);Timestamp.ONE=Timestamp.fromInt(1);Timestamp.NEG_ONE=Timestamp.fromInt(-1);Timestamp.MAX_VALUE=Timestamp.fromBits(0xFFFFFFFF|0,0x7FFFFFFF|0);Timestamp.MIN_VALUE=Timestamp.fromBits(0,0x80000000|0);Timestamp.TWO_PWR_24_=Timestamp.fromInt(1<<24);exports.Timestamp=Timestamp;},});if(typeof module!='undefined'&&module.exports){module.exports=bson;if(!module.parent){bson();}}
if(typeof window!='undefined'&&typeof require=='undefined'){window.require=bson.require;}







(function(){var root=this;var OnelineTransport;if(typeof exports!=='undefined')
OnelineTransport=window.OnelineTransport||{};else
OnelineTransport=root.OnelineTransport=window.OnelineTransport||{};OnelineTransport.WebSockets={};Oneline=window.Oneline||{};OnelineTransport.WebSockets.Ctor=function(settings){return window.WebSocket?new window.WebSocket(settings):new window.MozWebSocket(settings);};OnelineTransport.WebSockets.detect=function(){if(window.WebSocket){return true;}


 
if(window.MozWebSocket){return true;}
return false;};OnelineTransport.XHR={};OnelineTransport.XHR.key=null;OnelineTransport.XHR.Ctor=function(xhrurl,modurl){ if(!OnelineTransport.XHR.key){OnelineTransport.XHR.key=Oneline.uuid();}
return OnelineTransport.XHR.reform(xhrurl,modurl);};OnelineTransport.XHR.opened=false;OnelineTransport.XHR.reform=function(xhrurl,modurl){OnelineTransport.XHR.dataPost="modUrl="+modurl;var xhr=new XMLHttpRequest();
 var modurl=Oneline.settings.server;xhr.open("POST",xhrurl,true);xhr.readyState=0;xhr.close=OnelineTransport.XHR.close;xhr.sendProto=xhr.send;xhr.send=OnelineTransport.XHR.send;xhr.onmessage=OnelineTransport.XHR.onmessage;xhr.setRequestHeader('Content-type','application/x-www-form-urlencoded');xhr.setRequestHeader("X-XHR-Websockets-Oneline",true);return xhr;};OnelineTransport.XHR.close=function(){};OnelineTransport.XHR.send=function(msg){if(!Oneline.socket.loaded){Oneline.socket=OnelineTransport.XHR.reform(Oneline.settings.xhrurl,Oneline.settings.server);Oneline.loaded=false;}
if(!OnelineTransport.XHR.opened){OnelineTransport.XHR.opened=true;}
Oneline.socket.onreadystatechange=function(){Oneline.socket.readyState=this.readyState;if(this.readyState===4&&this.code>=200&&this.code<=299){

 OnelineTransport.XHR.onmessage({"data":this.responseText});}};
OnelineTransport.XHR.dataPost+="&data="+msg+"&key="+OnelineTransport.XHR.key;Oneline.socket.sendProto(OnelineTransport.XHR.dataPost);};OnelineTransport.XHR.onmessage=function(evt){Oneline.socket.onmessage(evt);};OnelineTransport.XHR.detect=function(){if(window.XMLHttpRequest){return true;}




return false;};}).call(this);
(function(){var root=this;var Oneline;if(typeof exports!=='undefined')
Oneline=window.Oneline||{};else
Oneline=root.Oneline=window.Oneline||{};
 min=Math.min,max=Math.max,pow=Math.pow,sqrt=Math.sqrt,log=Math.log,floor=Math.floor; slice=Array.slice,splice=Array.splice,every=Array.every;websocket={};navigator=window.navigator?window.navigator:[];window.BSON=window.BSON||bson().BSON;BSON.stringify=function(packet){return O.uint8ToString(BSON.serialize(packet));};BSON.parse=function(message){return BSON.deserialize(O.stringToUint8(message));};Oneline.interop=BSON;Oneline.socket=Oneline.socket||[];Oneline.settings=Oneline.settings||{};Oneline.freq=Oneline.freq=Oneline.freq||1000;Oneline.host=Oneline.host||'localhost';Oneline.port=Oneline.port||9000;Oneline.protoline=Oneline.protoline||[];Oneline.objects=Oneline.objects||[];Oneline.after=Date.now();Oneline.signature="";Oneline.running=0;Oneline.update=0; Oneline.asyncs={}; Oneline.asyncCallbacks={};Oneline.readyIntervalFreq=100; Oneline.acceptAfter=function(time){Oneline.after=time;clearInterval(Oneline.t);clearTimeout(Oneline.t);clearInterval(Oneline.oot);clearTimeout(Oneline.oot);clearInterval(Oneline.ooot);clearTimeout(Oneline.ooot);};Oneline.setAsync=function(key,data,fn){var currentAsyncs=Oneline._getAsyncs();var foundAsync=0;Oneline.asyncCallbacks[key]=fn;for(var i in currentAsyncs){if(currentAsyncs[i].key===key){ currentAsyncs[i].state=1;foundAsync=1;}}
if(!foundAsync){ currentAsyncs[key]={"data":data,state:1};}
Oneline.asyncs=currentAsyncs;};Oneline._getAsyncs=function(){return Oneline.asyncs;};Oneline._getActiveAsyncs=function(){var initial=Oneline._getAsyncs();var full=initial;for(var i in initial){if(initial[i].state===1){}else{delete full[i];}}
return Object.keys(full);};Oneline._collectAsyncNames=function(listOfAsyncs){var names=[];for(var i in listOfAsyncs){names.push(i);}
return names;};Oneline.callAsync=function(asyncName){var theAsync=Oneline.getAsync(asyncName);if(theAsync){Oneline.asyncCallbacks[asyncName](theAsync);}};Oneline.getAsync=function(key){if(typeof Oneline.asyncs[key]!=='undefined'&&Oneline.asyncs[key].state===1){Oneline.asyncs[key].state=0;return Oneline.asyncs[key].data;}
return false;};Oneline.newSignature=function(){Oneline.signature=Oneline.uuid();};Oneline.allReady=function(){var countOfObjects=Oneline.objects.length;var countReady=0;for(var i in Oneline.objects){if(Oneline.objects[i].state===1){countReady++;}}
return countReady===countOfObjects-1?true:false;};Oneline.collectAll=function(){var packet={};for(var i in Oneline.objects){packet[Oneline.objects[i].type]=Oneline.objects[i].m;}
return packet;};Oneline.joinOrNew=function(obj){var needsMerge=0;Oneline.signature=Oneline.uuid();for(var i in Oneline.objects){if(Oneline.objects[i].type===obj.type){delete Oneline.objects[i];Oneline.objects[i]=obj;Oneline.objects[i].state=0;Oneline.update=1;needsMerge=1;}}
if(!needsMerge){Oneline.objects.push(obj);}}; Oneline.once=function(event_type,message){var m_={};var packet={};if(typeof event_type==="object"){packet[event_type.obj]={};packet[event_type.obj]['type']=event_type.data.type;packet[event_type.obj]['data']=event_type.data.data;}else{message['type']=event_type;message['data']={}; var keys=Object.keys(message);for(var i in keys){message['data'][keys[i]]=message[keys[i]];delete message[i];}}
packet["generic"]=message;t=Date.now();m_.packet=packet;m_.packet.order=[];m_.packet.interop=O.interop;m_.uuid=O.uuid();m_.timestamp=t;m_.connection_uuid=O.connection_uuid;
 Oneline.socket.send(Oneline.interop.stringify(m_));};Oneline.alwaysConnect=function(){ Oneline.alwaysConnectInterval=setInterval(function(){if(Oneline.socket.readyState===2||Oneline.socket.readyState===3){Oneline.connector.connect();}else{}},0);};Oneline.ready=function(callback){var readyInterval=setInterval(function(){if(Oneline.socket.readyState===1){callback();clearInterval(readyInterval);}else{
Oneline.connector.connect();}},Oneline.readyIntervalFreq);};Oneline.clearCurrent=function(instance){for(var i in Oneline.objects){if(Oneline.objects[i]instanceof instance){delete Oneline.objects[i];}}};Oneline.getAfter=function(){return Oneline.after;};Oneline.setup=function(options,signature){Oneline.settings=options;Oneline.port=options.port||Oneline.port;Oneline.host=options.host||Oneline.host;Oneline.type=options.type==='bind'?'bind':'auto';Oneline.on=options.on||'click';Oneline.target=options.target;Oneline.signalStop=false;Oneline.connection_uuid=Oneline.connection_uuid||Oneline.uuid();if(typeof signature==='undefined'){Oneline.signature=Oneline.uuid();}
options.server=options.module||options.server;Oneline.settings.alwaysConnect=typeof Oneline.settings.alwaysConnect==='undefined'?false:(Oneline.settings.alwaysConnect?true:false);if(options.server.match(/ws\:\/\//))
Oneline.settings.server=options.server;else
Oneline.settings.server=options.server='ws://'+Oneline.host+':'+Oneline.port+'/'+options.server;if(OnelineTransport.WebSockets.detect()){Oneline.socket=OnelineTransport.WebSockets.Ctor(Oneline.settings.server);}else{
 if(OnelineTransport.XHR.detect()){Oneline.settings.xhrurl="http://"+Oneline.host+":"+((parseInt(Oneline.port)+1)).toString();Oneline.socket=OnelineTransport.XHR.Ctor(Oneline.settings.xhrurl,Oneline.settings.server);Oneline.loaded=true;}else{ console.log("Neither XHR or WebSocket transport is available in this browser");}}
Oneline.interop=typeof options.interop!=='undefined'?options.interop==='json'?JSON:BSON:BSON;Oneline.freq=typeof options.freq!=='undefined'?options.freq:Oneline.freq;Oneline.socket.onopen=function(){};Oneline.socket.onmessage=function(evt){var data=Oneline.interop.parse(evt.data);var collectedAsyncs=[]; for(var i in data.asyncs){Oneline.callAsync(data.asyncs[i]);}
if(typeof Oneline.callback==='function'){Oneline.callback(data);}
};if(typeof options.order!=='undefined'){Oneline.order=options.order;}else{Oneline.order=[];}
Oneline.target=document.getElementById(Oneline.target);

 Oneline.connector.connect();};Oneline.contextOptions={"geolocation":{"lat_field":{"default":"lat"},"lng_field":{"default":"lng"},"every":{"default":0.0},"limit":{"default":512},"range":{"default":40.00},"bidirectional":{"default":false}},"time":{"sfield":{"default":"stime"},"efield":{"default":"etime"}}};Oneline.fetchOptional=function(mod,option,value){if(typeof value==='undefined'){return Oneline.contextOptions[mod][option]['default'];}
return value;};Oneline.isMe=function(response){if(response){if(typeof response.connection_uuid!=='undefined'){if(Oneline.connection_uuid===response.connection_uuid){return true;}}
if(typeof response==='string'){if(Oneline.connection_uuid===response){return true;}}}
if(Oneline.lastResponse){if(Oneline.lastResponse.connection_uuid===Oneline.connection_uuid){return true;}}
return false;};Oneline.agent=function(options){};Oneline.nodes=function(options){};Oneline.stream=function(options){options=options||{};options.pipeline=options.pipeline||O.protoline;return O.pipeline({},options.pipeline,function(res){}).run();};Oneline.value=function(op,val){return{'op':op,'value':val};}; Oneline.moment=function(start,end){return{'start':0000,'end':3600};}; Oneline.echo=Oneline.echo=function(options,ready){Oneline.echo.options=options;if(!ready){var obj=clone(Oneline.echo(options,1));obj.signature=Oneline.signature;Oneline.joinOrNew(obj);}
return{ run:function(m){this.m=m||{};this.m.echo={};this.m.echo.limit=O.echo.options.limit;this.state=1;}}};Oneline.geolocation=Oneline.geo=function(options,ready){Oneline.geolocation.options=options;if(!ready){var obj=clone(Oneline.geolocation(options,1));obj.type="geolocation";obj.signature=Oneline.signature;obj.options=Oneline.geolocation.options;obj.last={"lng":0.0,"lat":0.0};Oneline.joinOrNew(obj);}
return{ run:function(m)
{if(this.state!=1){this.m=m||{};this.m.geo={};this.m.geo.every=O.fetchOptional("geolocation","every",O.geolocation.options.every);this.m.geo.range=O.fetchOptional("geolocation","range",O.geolocation.options.range);this.m.geo.limit=O.fetchOptional("geolocation","limit",O.geolocation.options.limit);this.m.geo.lat_field=O.fetchOptional("geolocation","lat_field",O.geolocation.options.lat_field);this.m.geo.lng_field=O.fetchOptional("geolocation","lng_field",O.geolocation.options.lng_field);var that=this;navigator.geolocation.getCurrentPosition(function(res){if(res.coords&&typeof res.coords!=='undefined'){if(that.last.lng===0.0&&that.last.lat===0.0){that.last.lng=res.coords.longitude;that.last.lat=res.coords.latitude;}
if(that.last.lng>res.coords.longitude){that.diff.lat=that.last.lng-res.coords.longitude;}else if(that.last.lng<res.coords.longtitude){that.diff.lat=res.coords.longtitude-that.last.lng;}
if(that.last.lat>res.coords.latitude){that.diff.lat=that.last.lat-res.coords.latitude;}else if(that.last.lat<res.coords.latitude){that.diff.lat=res.coords.latitude-that.last.lat;}
if(that.m.geo.every!==0.0){if(that.last.lat>=that.m.every||that.last.lng>=that.m.every){that.last.lat=res.coords.latitude;that.last.lng=res.coords.longitude;that.m.geo.lat=res.coords.latitude;that.m.geo.lng=res.coords.longitude;that.state=1;}}else{that.m.geo.lat=res.coords.latitude;that.m.geo.lng=res.coords.longitude;that.state=1;}}});}}};};Oneline.event=function(options,ready){Oneline.event.options=options;if(!ready){var obj=clone(Oneline.event(options,1));obj.type="event";obj.signature=Oneline.signature;obj.options=Oneline.event.options;Oneline.joinOrNew(obj);}
return{ run:function(m)
{this.m=m||{};this.m.event=Oneline.event.options;this.state=1;}}};Oneline.generic=function(options,ready){Oneline.generic.options=options;if(!ready){var obj=clone(Oneline.generic(options,1));obj.type="generic";obj.signature=Oneline.signature;obj.options=Oneline.generic.options;Oneline.joinOrNew(obj);}
return{ run:function(m)
{this.m=m||{};this.m.generic={};this.m.generic.type=Oneline.generic.options.type;this.m.generic.data=Oneline.generic.options.data;this.state=1;}}};Oneline.time=function(options,ready){Oneline.time.options=options;if(!ready){var obj=clone(Oneline.time(options,1));obj.type="time";obj.signature=Oneline.signature;obj.options=Oneline.time.options;Oneline.joinOrNew(obj);}
return{run:function(m)
{this.m=m||{};this.m.time={};if(typeof Oneline.time.options.start!=='undefined'){this.m.time.start=Oneline.time.options.start;this.m.time.end=Oneline.time.options.end;}else if(typeof Oneline.time.options.moment!=='undefined'){this.m.time.start=Oneline.time.options.moment.start;this.m.time.end=Oneline.time.options.moment.end;}
this.m.time.sfield=Oneline.fetchOptional("time","sfield",Oneline.time.options.sfield);this.m.time.efield=Oneline.fetchOptional("time","efield",Oneline.time.options.efield);this.state=1;}};};Oneline.random=function(options,ready){Oneline.random.options=options;if(!ready){var obj=clone(Oneline.random(options,1));obj.type="random";obj.signature=Oneline.signature;obj.options=Oneline.random.options;Oneline.joinOrNew(obj);}
return{run:function(m)
{this.m=m||{};this.m.random={};this.m.random.amount=Oneline.random.options.amount;this.state=1;}};};Oneline.pipeline=function(agent,objects,callback){if(typeof agent!=='undefined'&&typeof agent!=='function')
O.agent=agent;else
O.agent={};if(typeof objects!=='undefined'&&typeof objects!=='function')
O.objects=objects;O.callback=arguments[arguments.length-1];O.protoline.push(this);O.linetype=Oneline.type;O.provider=O.linetype==='bind'?'Timeout':'Interval';O.runner='Interval';return{ stop:function()
{return O.signalStop=1;},run:function()
{Oneline.signalStop=false;Oneline.update=0;Oneline.connector.connect();this.runtimeSignature=Oneline.signature;var runtimeObject=this;O.t=window['set'+O.provider](function(){if(Oneline.update){Oneline.running=0;O.connector.clear();O.newSignature();return O.pipeline(O.agent,O.objects,O.callback).run();}
if(Oneline.running||runtimeObject.runtimeSignature!==O.signature){return;}
if(Oneline.signalStop||O.socket.readyState===2||O.socket.readyState===3){return O.connector.disconnect();}
O.running=1;var m={},c=0,m_={},ii=0,t,i=0;for(var i in O.objects){O.objects[parseInt(i)].run(m);O.oot=window['set'+O.runner](function(){if(O.objects.length>1){if(c!==0&&O.objects[c-1].state!==1)
return;if(typeof O.objects[c]!=='object')
return;if(O.objects[c].state===1){m=collect(m,O.objects[c].m);c++;window['clear'+O.runner](O.oot);}}else{if(O.objects[c].state===1){m=collect(m,O.objects[c].m);c++;window['clear'+O.runner](O.oot);}}},1);}
O.ooot=window['set'+O.runner](function(){if(c===O.objects.length){m_.packet=m;t=new Date().getTime();m_.timestamp=t;m_.uuid=O.uuid();m_.connection_uuid=O.connection_uuid;if(t>Oneline.after){O.socket.send(O.interop.stringify(m_));}
window['clear'+O.runner](O.ooot);O.running=0;}},1);},O.freq);}};};Oneline.sound=function(options,ready){Oneline.sound.options=options;if(!ready){var obj=clone(Oneline.sound(options,1));obj.signature=Oneline.signature;obj.type="sound";obj.options=Oneline.sound.options;Oneline.joinOrNew(obj);}
return{run:function(m)
{this.m=m||{};this.m.sound={};this.m.sound.length=Oneline.sound.options.length||60;this.m.sound.field=Oneline.sound.options.field;var that=this;Oneline.speech=new webkitSpeechRecognition();Oneline.speech.onstart=function(){};Oneline.speech.onresult=function(e){console.log(e);that.state=1;};Oneline.speech.lang=Oneline.sound.options.lang||"en-GB";Oneline.speech.start();}};};Oneline.connector={connect:function()
{if(O.socket.readyState===0||O.socket.readyState===1)
return;return O.setup(O.settings,false);},disconnect:function()
{if(O.socket.readyState===2||O.socket.readyState===3)
return;O.connector.clear();return O.socket.close();},clear:function(){window['clear'+O.provider](O.t);window['clear'+O.runner](O.oot);window['clear'+O.runner](O.ooot);}};Oneline.uuid=function()
{return("0000"+(Math.random()*Math.pow(36,4)<<0).toString(36)).slice(-4)};Oneline.uint8ToString=function(arr)
{var o="[";for(var i in arr)
o+=i==arr.length-1?arr[i].toString()+"]":arr[i].toString()+", ";return o;}; Oneline.stringToUint8=function(str)
{var ds=str.match(/(\d+)/g),o=[];for(var i=0;i!=ds.length;i++)
o.push(parseInt(ds[i]));return o;}; function collect(a,b,c){for(property in b)
a[property]=b[property];for(property in c)
a[property]=c[property];return a;}; window.O=window.ol=Oneline;}).call(this);function clone(src,_visited){if(src==null||typeof(src)!=='object'){return src;}
 
if(_visited==undefined){_visited=[];} 
else{var i,len=_visited.length;for(i=0;i<len;i++){ if(src===_visited[i]){return src;}}} 
_visited.push(src); if(typeof src.clone=='function'){return src.clone(true);} 
if(Object.prototype.toString.call(src)=='[object Array]'){ ret=src.slice();var i=ret.length;while(i--){ret[i]=clone(ret[i],_visited);}
return ret;} 
if(src instanceof Date){return new Date(src.getTime());} 
if(src instanceof RegExp){return new RegExp(src);} 
if(src.nodeType&&typeof src.cloneNode=='function'){return src.cloneNode(true);}
 
var proto=(Object.getPrototypeOf?Object.getPrototypeOf(src):src.__proto__);if(!proto){proto=src.constructor.prototype;}
var ret=object_create(proto);for(var key in src){ ret[key]=clone(src[key],_visited);}
return ret;}
var object_create=Object.create;if(typeof object_create!=='function'){object_create=function(o){function F(){}
F.prototype=o;return new F();};}