# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .image_template_source_py3 import ImageTemplateSource


class ImageTemplateSharedImageVersionSource(ImageTemplateSource):
    """Describes an image source that is an image version in a shared image
    gallery.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param image_version_id: Required. ARM resource id of the image version in
     the shared image gallery
    :type image_version_id: str
    """

    _validation = {
        'type': {'required': True},
        'image_version_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'image_version_id': {'key': 'imageVersionId', 'type': 'str'},
    }

    def __init__(self, *, image_version_id: str, **kwargs) -> None:
        super(ImageTemplateSharedImageVersionSource, self).__init__(**kwargs)
        self.image_version_id = image_version_id
        self.type = 'SharedImageVersion'
