# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .image_template_source import ImageTemplateSource


class ImageTemplateManagedImageSource(ImageTemplateSource):
    """Describes an image source that is a managed image in customer subscription.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param image_id: Required. ARM resource id of the managed image in
     customer subscription
    :type image_id: str
    """

    _validation = {
        'type': {'required': True},
        'image_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'image_id': {'key': 'imageId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImageTemplateManagedImageSource, self).__init__(**kwargs)
        self.image_id = kwargs.get('image_id', None)
        self.type = 'ManagedImage'
