# -*- coding: utf-8 -*-
# Generated by the windmill services transformer
from windmill.authoring import WindmillTestClient

"""These tests must be loaded by Windmill.
Command example: $ windmill shell firefox http://localhost:8080 loadtest=field_creation.py

CAUTION: there is a bug in Windmill 1.3 while changing the value of a select.
The new value of a select that must be changed is not set. It causes a bug in
the test suite, which can't finish normally.

SOLUTION: After the script is loaded, and before launching it, change manually
the value of this select (the only one), setting its value (val) to CLOSE.
"""

def test_login():
    """Some parameters must be modified (user, password, Plone URL).
    """
    client = WindmillTestClient(__name__)

    client.click(link=u'View your Plone site.')
    client.waits.forPageLoad(timeout=u'20000')
    client.waits.forElement(timeout=u'8000', id=u'__ac_name')
    client.type(text=u'admin', id=u'__ac_name') # To replace with the corrects username and password
    client.type(text=u'password', id=u'__ac_password')
    client.click(name=u'submit')
    client.waits.forPageLoad(timeout=u'20000')

def test_createDB():
    client = WindmillTestClient(__name__)

    client.click(link=u'Home')
    client.waits.forPageLoad(timeout=u'20000')
    client.waits.forElement(xpath=u"//dl[@id='plone-contentmenu-factories']/dt/a/span[1]", timeout=u'8000')
    client.click(xpath=u"//dl[@id='plone-contentmenu-factories']/dt/a/span[1]")
    client.click(xpath=u"//a[@id='plominodatabase']/span")
    client.waits.forPageLoad(timeout=u'20000')
    client.type(text=u'testdb', id=u'title')
    client.click(name=u'form.button.save')
    client.waits.forPageLoad(timeout=u'20000')

def test_createForm():
    client = WindmillTestClient(__name__)

    client.click(xpath=u"//dl[@id='plone-contentmenu-factories']/dt/a/span[1]")
    client.click(xpath=u"//a[@id='plominoform']/span")
    client.waits.forPageLoad(timeout=u'20000')
    client.waits.forElement(timeout=u'8000', id=u'id')
    client.type(text=u'testform', id=u'id')
    client.type(text=u'testform', id=u'title')
    client.click(name=u'form.button.save')
    client.waits.forPageLoad(timeout=u'20000')

def test_createField():
    client = WindmillTestClient(__name__)

    client.click(link=u'Edit')
    client.waits.forPageLoad(timeout=u'20000')
    client.waits.forElement(xpath=u"//body[@id='content']", timeout=u'8000')
    client.click(xpath=u"//body[@id='content']")
    client.click(id=u'FormLayout_plominofield')
    client.waits.forElement(timeout=u'5000', id=u'plominoFieldId')
    client.type(text=u'field1', id=u'plominoFieldId')
    client.click(id=u'insert')
    client.click(name=u'form.button.save')
    client.waits.forPageLoad(timeout=u'20000')

def test_createAction():
    client = WindmillTestClient(__name__)

    client.waits.forElement(link=u'Edit', timeout=u'8000')
    client.click(link=u'Edit')
    client.waits.forPageLoad(timeout=u'20000')
    client.waits.forElement(xpath=u"//body[@id='content']", timeout=u'8000')
    client.click(xpath=u"//body[@id='content']/p")
    client.click(xpath=u"//a[@id='FormLayout_plominoaction']/img")
    client.waits.forElement(timeout=u'5000', id=u'actionid')
    client.type(text=u'action1', id=u'actionid')
    client.select(val=u'CLOSE', id=u'actionTypesList')
    client.click(id=u'insert')
    client.click(name=u'form.button.save')
    client.waits.forPageLoad(timeout=u'20000')

def test_createHidewhen():
    client = WindmillTestClient(__name__)

    client.click(link=u'Edit')
    client.waits.forPageLoad(timeout=u'20000')
    client.waits.forElement(xpath=u"//body[@id='content']", timeout=u'8000')
    client.click(xpath=u"//body[@id='content']")
    client.click(id=u'FormLayout_plominohidewhen')
    client.waits.forElement(timeout=u'5000', id=u'hidewhenid')
    client.type(text=u'hidewhen1', id=u'hidewhenid')
    client.waits.forElement(timeout=u'5000', id=u'hidewhenFormula')
    client.type(text=u'False', id=u'hidewhenFormula')
    client.click(id=u'insert')
    client.click(name=u'form.button.save')
    client.waits.forPageLoad(timeout=u'20000')

def test_fieldCreated():
    client = WindmillTestClient(__name__)

    client.click(link=u'Contents')
    client.waits.forPageLoad(timeout=u'20000')
    client.waits.forElement(xpath=u"//a[contains(@href, 'testform/field1')]", timeout=u'8000')

def test_actionCreated():
    client = WindmillTestClient(__name__)

    client.click(link=u'Contents')
    client.waits.forPageLoad(timeout=u'20000')
    client.waits.forElement(xpath=u"//a[contains(@href, 'testform/action1')]", timeout=u'8000')

def test_hidewhenCreated():
    client = WindmillTestClient(__name__)

    client.click(link=u'Contents')
    client.waits.forPageLoad(timeout=u'20000')
    client.waits.forElement(xpath=u"//a[contains(@href, 'testform/hidewhen1')]", timeout=u'8000')
