# DT Flickr Methods
#
# Douglas Thrift
#
# $Id: _methods.py 38 2009-08-16 09:39:58Z douglas $

namespaces = (
	('activity', (
		('userComments', 'flickr.activity.userComments\n\n  Returns a list of recent activity on photos commented on by the calling user. <b>Do not poll this method more than once an hour</b>.\n\n  Arguments:\n\n    per_page (Optional)\n      Number of items to return per page. If this argument is omitted, it defaults to 10. The maximum allowed value is 50.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('userPhotos', "flickr.activity.userPhotos\n\n  Returns a list of recent activity on photos belonging to the calling user. <b>Do not poll this method more than once an hour</b>.\n\n  Arguments:\n\n    timeframe (Optional)\n      The timeframe in which to return updates for. This can be specified in days (<code>'2d'</code>) or hours (<code>'4h'</code>). The default behavoir is to return changes since the beginning of the previous user session.\n\n    per_page (Optional)\n      Number of items to return per page. If this argument is omitted, it defaults to 10. The maximum allowed value is 50.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1."),
	)),
	('auth', (
		('checkToken', 'flickr.auth.checkToken\n\n  Returns the credentials attached to an authentication token. This call <b>must</b> be signed as specified in the <a href="/services/api/auth.spec.html">authentication API spec</a>.\n\n  Arguments:\n\n    auth_token (Required)\n      The authentication token to check.'),
		('getFrob', 'flickr.auth.getFrob\n\n  Returns a frob to be used during authentication. <b>This method call must be signed</b>.'),
		('getFullToken', 'flickr.auth.getFullToken\n\n  Get the full authentication token for a mini-token. <b>This method call must be signed.</b>\n\n  Arguments:\n\n    mini_token (Required)\n      The mini-token typed in by a user. It should be 9 digits long. It may optionally contain dashes.'),
		('getToken', 'flickr.auth.getToken\n\n  Returns the auth token for the given frob, if one has been attached. <b>This method call must be signed.</b>\n\n  Arguments:\n\n    frob (Required)\n      The frob to check.'),
	)),
	('blogs', (
		('getList', 'flickr.blogs.getList\n\n  Get a list of configured blogs for the calling user.\n\n  Arguments:\n\n    service (Optional)\n      Optionally only return blogs for a given service id.  You can get a list of from <a href="/services/api/flickr.blogs.getServices.html">flickr.blogs.getServices()</a>.'),
		('getServices', 'flickr.blogs.getServices\n\n  Return a list of Flickr supported blogging services'),
		('postPhoto', "flickr.blogs.postPhoto\n\n  \n\n  Arguments:\n\n    blog_id (Optional)\n      The id of the blog to post to.\n\n    photo_id (Required)\n      The id of the photo to blog\n\n    title (Required)\n      The blog post title\n\n    description (Required)\n      The blog post body\n\n    blog_password (Optional)\n      The password for the blog (used when the blog does not have a stored password).\n\n    service (Optional)\n      A Flickr supported blogging service.  Instead of passing a blog id you can pass a service id and we'll post to the first blog of that service we find."),
	)),
	('collections', (
		('getInfo', 'flickr.collections.getInfo\n\n  Returns information for a single collection.  Currently can only be called by the collection owner, this may change.\n\n  Arguments:\n\n    collection_id (Required)\n      The ID of the collection to fetch information for.'),
		('getTree', 'flickr.collections.getTree\n\n  Returns a tree (or sub tree) of collections belonging to a given user.\n\n  Arguments:\n\n    collection_id (Optional)\n      The ID of the collection to fetch a tree for, or zero to fetch the root collection. Defaults to zero.\n\n    user_id (Optional)\n      The ID of the account to fetch the collection tree for. Deafults to the calling user.'),
	)),
	('commons', (
		('getInstitutions', 'flickr.commons.getInstitutions\n\n  Retrieves a list of the current Commons institutions.'),
	)),
	('contacts', (
		('getList', 'flickr.contacts.getList\n\n  Get a list of contacts for the calling user.\n\n  Arguments:\n\n    filter (Optional)\n      An optional filter of the results. The following values are valid:<br />\r\n&nbsp;\r\n<dl>\r\n\t<dt><b><code>friends</code></b></dt>\r\n\t<dl>Only contacts who are friends (and not family)</dl>\r\n\r\n\t<dt><b><code>family</code></b></dt>\r\n\t<dl>Only contacts who are family (and not friends)</dl>\r\n\r\n\t<dt><b><code>both</code></b></dt>\r\n\t<dl>Only contacts who are both friends and family</dl>\r\n\r\n\t<dt><b><code>neither</code></b></dt>\r\n\t<dl>Only contacts who are neither friends nor family</dl>\r\n</dl>\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 1000. The maximum allowed value is 1000.'),
		('getListRecentlyUploaded', 'flickr.contacts.getListRecentlyUploaded\n\n  Return a list of contacts for a user who have recently uploaded photos along with the total count of photos uploaded.<br /><br />\r\n\r\nThis method is still considered experimental. We don\'t plan for it to change or to go away but so long as this notice is present you should write your code accordingly.\n\n  Arguments:\n\n    date_lastupload (Optional)\n      Limits the resultset to contacts that have uploaded photos since this date. The date should be in the form of a Unix timestamp.\r\n\r\nThe default offset is (1) hour and the maximum (24) hours. \n\n    filter (Optional)\n      Limit the result set to all contacts or only those who are friends or family. Valid options are:\r\n\r\n<ul>\r\n<li><strong>ff</strong> friends and family</li>\r\n<li><strong>all</strong> all your contacts</li>\r\n</ul>\r\nDefault value is "all".'),
		('getPublicList', 'flickr.contacts.getPublicList\n\n  Get the contact list for a user.\n\n  Arguments:\n\n    user_id (Required)\n      The NSID of the user to fetch the contact list for.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 1000. The maximum allowed value is 1000.'),
	)),
	('favorites', (
		('add', "flickr.favorites.add\n\n  Adds a photo to a user's favorites list.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to add to the user's favorites."),
		('getList', "flickr.favorites.getList\n\n  Returns a list of the user's favorite photos. Only photos which the calling user has permission to see are returned.\n\n  Arguments:\n\n    user_id (Optional)\n      The NSID of the user to fetch the favorites list for. If this argument is omitted, the favorites list for the calling user is returned.\n\n    min_fave_date (Optional)\n      Minimum date that a photo was favorited on. The date should be in the form of a unix timestamp.\n\n    max_fave_date (Optional)\n      Maximum date that a photo was favorited on. The date should be in the form of a unix timestamp.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1."),
		('getPublicList', 'flickr.favorites.getPublicList\n\n  Returns a list of favorite public photos for the given user.\n\n  Arguments:\n\n    user_id (Required)\n      The user to fetch the favorites list for.\n\n    min_fave_date (Optional)\n      Minimum date that a photo was favorited on. The date should be in the form of a unix timestamp.\n\n    max_fave_date (Optional)\n      Maximum date that a photo was favorited on. The date should be in the form of a unix timestamp.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('remove', "flickr.favorites.remove\n\n  Removes a photo from a user's favorites list.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to remove from the user's favorites."),
	)),
	('groups', (
		('browse', 'flickr.groups.browse\n\n  Browse the group category tree, finding groups and sub-categories.\n\n  Arguments:\n\n    cat_id (Optional)\n      The category id to fetch a list of groups and sub-categories for. If not specified, it defaults to zero, the root of the category tree.'),
		('getInfo', 'flickr.groups.getInfo\n\n  Get information about a group.\n\n  Arguments:\n\n    group_id (Required)\n      The NSID of the group to fetch information for.\n\n    lang (Optional)\n      The language of the group name and description to fetch.  If the language is not found, the primary language of the group will be returned.\r\n\r\nValid values are the same as <a href="/services/feeds/">in feeds</a>.'),
		('search', 'flickr.groups.search\n\n  Search for groups. 18+ groups will only be returned for authenticated calls where the authenticated user is over 18.\n\n  Arguments:\n\n    text (Required)\n      The text to search for.\n\n    per_page (Optional)\n      Number of groups to return per page. If this argument is ommited, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is ommited, it defaults to 1. '),
	)),
	('groups.members', (
		('getList', 'flickr.groups.members.getList\n\n  Get a list of the members of a group.  The call must be signed on behalf of a Flickr member, and the ability to see the group membership will be determined by the Flickr member\'s group privileges.\n\n  Arguments:\n\n    group_id (Required)\n      Return a list of members for this group.  The group must be viewable by the Flickr member on whose behalf the API call is made.\n\n    membertypes (Optional)\n      Comma separated list of member types\r\n<ul>\r\n<li>2: member</li>\r\n<li>3: moderator</li>\r\n<li>4: admin</li>\r\n</ul>\r\nBy default returns all types.  (Returning super rare member type "1: narwhal" isn\'t supported by this API method)\n\n    per_page (Optional)\n      Number of members to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
	)),
	('groups.pools', (
		('add', "flickr.groups.pools.add\n\n  Add a photo to a group's pool.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to add to the group pool. The photo must belong to the calling user.\n\n    group_id (Required)\n      The NSID of the group who's pool the photo is to be added to."),
		('getContext', "flickr.groups.pools.getContext\n\n  Returns next and previous photos for a photo in a group pool.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to fetch the context for.\n\n    group_id (Required)\n      The nsid of the group who's pool to fetch the photo's context for."),
		('getGroups', 'flickr.groups.pools.getGroups\n\n  Returns a list of groups to which you can add photos.\n\n  Arguments:\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.\n\n    per_page (Optional)\n      Number of groups to return per page. If this argument is omitted, it defaults to 400. The maximum allowed value is 400.'),
		('getPhotos', "flickr.groups.pools.getPhotos\n\n  Returns a list of pool photos for a given group, based on the permissions of the group and the user logged in (if any).\n\n  Arguments:\n\n    group_id (Required)\n      The id of the group who's pool you which to get the photo list for.\n\n    tags (Optional)\n      A tag to filter the pool with. At the moment only one tag at a time is supported.\n\n    user_id (Optional)\n      The nsid of a user. Specifiying this parameter will retrieve for you only those photos that the user has contributed to the group pool.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1."),
		('remove', "flickr.groups.pools.remove\n\n  Remove a photo from a group pool.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to remove from the group pool. The photo must either be owned by the calling user of the calling user must be an administrator of the group.\n\n    group_id (Required)\n      The NSID of the group who's pool the photo is to removed from."),
	)),
	('interestingness', (
		('getList', 'flickr.interestingness.getList\n\n  Returns the list of interesting photos for the most recent day or a user-specified date.\n\n  Arguments:\n\n    date (Optional)\n      A specific date, formatted as YYYY-MM-DD, to return interesting photos for.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
	)),
	('machinetags', (
		('getNamespaces', 'flickr.machinetags.getNamespaces\n\n  Return a list of unique namespaces, optionally limited by a given predicate, in alphabetical order.\n\n  Arguments:\n\n    predicate (Optional)\n      Limit the list of namespaces returned to those that have the following predicate.\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('getPairs', 'flickr.machinetags.getPairs\n\n  Return a list of unique namespace and predicate pairs, optionally limited by predicate or namespace, in alphabetical order.\n\n  Arguments:\n\n    namespace (Optional)\n      Limit the list of pairs returned to those that have the following namespace.\n\n    predicate (Optional)\n      Limit the list of pairs returned to those that have the following predicate.\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('getPredicates', 'flickr.machinetags.getPredicates\n\n  Return a list of unique predicates, optionally limited by a given namespace.\n\n  Arguments:\n\n    namespace (Optional)\n      Limit the list of predicates returned to those that have the following namespace.\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('getRecentValues', 'flickr.machinetags.getRecentValues\n\n  Fetch recently used (or created) machine tags values.\n\n  Arguments:\n\n    namespace (Optional)\n      A namespace that all values should be restricted to.\n\n    predicate (Optional)\n      A predicate that all values should be restricted to.\n\n    added_since (Optional)\n      Only return machine tags values that have been added since this timestamp, in epoch seconds.  '),
		('getValues', 'flickr.machinetags.getValues\n\n  Return a list of unique values for a namespace and predicate.\n\n  Arguments:\n\n    namespace (Required)\n      The namespace that all values should be restricted to.\n\n    predicate (Required)\n      The predicate that all values should be restricted to.\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
	)),
	('panda', (
		('getList', 'flickr.panda.getList\n\n  Return a list of <a href="http://www.flickr.com/explore/panda">Flickr pandas</a>, from whom you can request photos using the <a href="/services/api/flickr.panda.getPhotos.htm">flickr.panda.getPhotos</a> API method.'),
		('getPhotos', 'flickr.panda.getPhotos\n\n  Ask the <a href="http://www.flickr.com/explore/panda">Flickr Pandas</a> for a list of recent public (and "safe") photos.\n\n  Arguments:\n\n    panda_name (Required)\n      The name of the panda to ask for photos from. There are currently three pandas named:<br /><br />\r\n\r\n<ul>\r\n<li><strong><a href="http://flickr.com/photos/ucumari/126073203/">ling ling</a></strong></li>\r\n<li><strong><a href="http://flickr.com/photos/lynnehicks/136407353">hsing hsing</a></strong></li>\r\n<li><strong><a href="http://flickr.com/photos/perfectpandas/1597067182/">wang wang</a></strong></li>\r\n</ul>\r\n\r\n<br />You can fetch a list of all the current pandas using the <a href="/services/api/flickr.panda.getList.html">flickr.panda.getList</a> API method.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
	)),
	('people', (
		('findByEmail', "flickr.people.findByEmail\n\n  Return a user's NSID, given their email address\n\n  Arguments:\n\n    find_email (Required)\n      The email address of the user to find  (may be primary or secondary)."),
		('findByUsername', "flickr.people.findByUsername\n\n  Return a user's NSID, given their username.\n\n  Arguments:\n\n    username (Required)\n      The username of the user to lookup."),
		('getInfo', 'flickr.people.getInfo\n\n  Get information about a user.\n\n  Arguments:\n\n    user_id (Required)\n      The NSID of the user to fetch information about.'),
		('getPublicGroups', 'flickr.people.getPublicGroups\n\n  Returns the list of public groups a user is a member of.\n\n  Arguments:\n\n    user_id (Required)\n      The NSID of the user to fetch groups for.'),
		('getPublicPhotos', "flickr.people.getPublicPhotos\n\n  Get a list of public photos for the given user.\n\n  Arguments:\n\n    user_id (Required)\n      The NSID of the user who's photos to return.\n\n    safe_search (Optional)\n      Safe search setting:\r\n\r\n<ul>\r\n<li>1 for safe.</li>\r\n<li>2 for moderate.</li>\r\n<li>3 for restricted.</li>\r\n</ul>\r\n\r\n(Please note: Un-authed calls can only see Safe content.)\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1."),
		('getUploadStatus', 'flickr.people.getUploadStatus\n\n  Returns information for the calling user related to photo uploads.'),
	)),
	('photos', (
		('addTags', 'flickr.photos.addTags\n\n  Add tags to a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to add tags to.\n\n    tags (Required)\n      The tags to add to the photo.'),
		('delete', 'flickr.photos.delete\n\n  Delete a photo from flickr.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to delete.'),
		('getAllContexts', 'flickr.photos.getAllContexts\n\n  Returns all visible sets and pools the photo belongs to.\n\n  Arguments:\n\n    photo_id (Required)\n      The photo to return information for.'),
		('getContactsPhotos', "flickr.photos.getContactsPhotos\n\n  Fetch a list of recent photos from the calling users' contacts.\n\n  Arguments:\n\n    count (Optional)\n      Number of photos to return. Defaults to 10, maximum 50. This is only used if <code>single_photo</code> is not passed.\n\n    just_friends (Optional)\n      set as 1 to only show photos from friends and family (excluding regular contacts).\n\n    single_photo (Optional)\n      Only fetch one photo (the latest) per contact, instead of all photos in chronological order.\n\n    include_self (Optional)\n      Set to 1 to include photos from the calling user.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: license, date_upload, date_taken, owner_name, icon_server, original_format, last_update."),
		('getContactsPublicPhotos', "flickr.photos.getContactsPublicPhotos\n\n  Fetch a list of recent public photos from a users' contacts.\n\n  Arguments:\n\n    user_id (Required)\n      The NSID of the user to fetch photos for.\n\n    count (Optional)\n      Number of photos to return. Defaults to 10, maximum 50. This is only used if <code>single_photo</code> is not passed.\n\n    just_friends (Optional)\n      set as 1 to only show photos from friends and family (excluding regular contacts).\n\n    single_photo (Optional)\n      Only fetch one photo (the latest) per contact, instead of all photos in chronological order.\n\n    include_self (Optional)\n      Set to 1 to include photos from the user specified by user_id.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: license, date_upload, date_taken, owner_name, icon_server, original_format, last_update."),
		('getContext', 'flickr.photos.getContext\n\n  Returns next and previous photos for a photo in a photostream.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to fetch the context for.'),
		('getCounts', 'flickr.photos.getCounts\n\n  Gets a list of photo counts for the given date ranges for the calling user.\n\n  Arguments:\n\n    dates (Optional)\n      A comma delimited list of unix timestamps, denoting the periods to return counts for. They should be specified <b>smallest first</b>.\n\n    taken_dates (Optional)\n      A comma delimited list of mysql datetimes, denoting the periods to return counts for. They should be specified <b>smallest first</b>.'),
		('getExif', "flickr.photos.getExif\n\n  Retrieves a list of EXIF/TIFF/GPS tags for a given photo. The calling user must have permission to view the photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to fetch information for.\n\n    secret (Optional)\n      The secret for the photo. If the correct secret is passed then permissions checking is skipped. This enables the 'sharing' of individual photos by passing around the id and secret."),
		('getFavorites', 'flickr.photos.getFavorites\n\n  Returns the list of people who have favorited a given photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The ID of the photo to fetch the favoriters list for.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.\n\n    per_page (Optional)\n      Number of usres to return per page. If this argument is omitted, it defaults to 10. The maximum allowed value is 50.'),
		('getInfo', "flickr.photos.getInfo\n\n  Get information about a photo. The calling user must have permission to view the photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to get information for.\n\n    secret (Optional)\n      The secret for the photo. If the correct secret is passed then permissions checking is skipped. This enables the 'sharing' of individual photos by passing around the id and secret."),
		('getNotInSet', 'flickr.photos.getNotInSet\n\n  Returns a list of your photos that are not part of any sets.\n\n  Arguments:\n\n    min_upload_date (Optional)\n      Minimum upload date. Photos with an upload date greater than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    max_upload_date (Optional)\n      Maximum upload date. Photos with an upload date less than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    min_taken_date (Optional)\n      Minimum taken date. Photos with an taken date greater than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    max_taken_date (Optional)\n      Maximum taken date. Photos with an taken date less than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    privacy_filter (Optional)\n      Return photos only matching a certain privacy level. Valid values are:\r\n<ul>\r\n<li>1 public photos</li>\r\n<li>2 private photos visible to friends</li>\r\n<li>3 private photos visible to family</li>\r\n<li>4 private photos visible to friends & family</li>\r\n<li>5 completely private photos</li>\r\n</ul>\r\n\n\n    media (Optional)\n      Filter results by media type. Possible values are <code>all</code> (default), <code>photos</code> or <code>videos</code>\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('getPerms', 'flickr.photos.getPerms\n\n  Get permissions for a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to get permissions for.'),
		('getRecent', 'flickr.photos.getRecent\n\n  Returns a list of the latest public photos uploaded to flickr.\n\n  Arguments:\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('getSizes', 'flickr.photos.getSizes\n\n  Returns the available sizes for a photo.  The calling user must have permission to view the photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to fetch size information for.'),
		('getUntagged', 'flickr.photos.getUntagged\n\n  Returns a list of your photos with no tags.\n\n  Arguments:\n\n    min_upload_date (Optional)\n      Minimum upload date. Photos with an upload date greater than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    max_upload_date (Optional)\n      Maximum upload date. Photos with an upload date less than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    min_taken_date (Optional)\n      Minimum taken date. Photos with an taken date greater than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    max_taken_date (Optional)\n      Maximum taken date. Photos with an taken date less than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    privacy_filter (Optional)\n      Return photos only matching a certain privacy level. Valid values are:\r\n<ul>\r\n<li>1 public photos</li>\r\n<li>2 private photos visible to friends</li>\r\n<li>3 private photos visible to family</li>\r\n<li>4 private photos visible to friends & family</li>\r\n<li>5 completely private photos</li>\r\n</ul>\r\n\n\n    media (Optional)\n      Filter results by media type. Possible values are <code>all</code> (default), <code>photos</code> or <code>videos</code>\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('getWithGeoData', 'flickr.photos.getWithGeoData\n\n  Returns a list of your geo-tagged photos.\n\n  Arguments:\n\n    min_upload_date (Optional)\n      Minimum upload date. Photos with an upload date greater than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    max_upload_date (Optional)\n      Maximum upload date. Photos with an upload date less than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    min_taken_date (Optional)\n      Minimum taken date. Photos with an taken date greater than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    max_taken_date (Optional)\n      Maximum taken date. Photos with an taken date less than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    privacy_filter (Optional)\n      Return photos only matching a certain privacy level. Valid values are:\r\n<ul>\r\n<li>1 public photos</li>\r\n<li>2 private photos visible to friends</li>\r\n<li>3 private photos visible to family</li>\r\n<li>4 private photos visible to friends & family</li>\r\n<li>5 completely private photos</li>\r\n</ul>\r\n\n\n    sort (Optional)\n      The order in which to sort returned photos. Deafults to date-posted-desc. The possible values are: date-posted-asc, date-posted-desc, date-taken-asc, date-taken-desc, interestingness-desc, and interestingness-asc.\n\n    media (Optional)\n      Filter results by media type. Possible values are <code>all</code> (default), <code>photos</code> or <code>videos</code>\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('getWithoutGeoData', "flickr.photos.getWithoutGeoData\n\n  Returns a list of your photos which haven't been geo-tagged.\n\n  Arguments:\n\n    min_upload_date (Optional)\n      Minimum upload date. Photos with an upload date greater than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    max_upload_date (Optional)\n      Maximum upload date. Photos with an upload date less than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    min_taken_date (Optional)\n      Minimum taken date. Photos with an taken date greater than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    max_taken_date (Optional)\n      Maximum taken date. Photos with an taken date less than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    privacy_filter (Optional)\n      Return photos only matching a certain privacy level. Valid values are:\r\n<ul>\r\n<li>1 public photos</li>\r\n<li>2 private photos visible to friends</li>\r\n<li>3 private photos visible to family</li>\r\n<li>4 private photos visible to friends & family</li>\r\n<li>5 completely private photos</li>\r\n</ul>\r\n\n\n    sort (Optional)\n      The order in which to sort returned photos. Deafults to date-posted-desc. The possible values are: date-posted-asc, date-posted-desc, date-taken-asc, date-taken-desc, interestingness-desc, and interestingness-asc.\n\n    media (Optional)\n      Filter results by media type. Possible values are <code>all</code> (default), <code>photos</code> or <code>videos</code>\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1."),
		('recentlyUpdated', "flickr.photos.recentlyUpdated\n\n  <p>Return a list of your photos that have been recently created or which have been recently modified.</p>\r\n\r\n<p>Recently modified may mean that the photo's metadata (title, description, tags) may have been changed or a comment has been added (or just modified somehow :-)</p>\n\n  Arguments:\n\n    min_date (Required)\n      A Unix timestamp indicating the date from which modifications should be compared.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1."),
		('removeTag', 'flickr.photos.removeTag\n\n  Remove a tag from a photo.\n\n  Arguments:\n\n    tag_id (Required)\n      The tag to remove from the photo. This parameter should contain a tag id, as returned by <a href="/services/api/flickr.photos.getInfo.html">flickr.photos.getInfo</a>.'),
		('search', 'flickr.photos.search\n\n  Return a list of photos matching some criteria. Only photos visible to the calling user will be returned. To return private or semi-private photos, the caller must be authenticated with \'read\' permissions, and have permission to view the photos. Unauthenticated calls will only return public photos.\n\n  Arguments:\n\n    user_id (Optional)\n      The NSID of the user who\'s photo to search. If this parameter isn\'t passed then everybody\'s public photos will be searched. A value of "me" will search against the calling user\'s photos for authenticated calls.\n\n    tags (Optional)\n      A comma-delimited list of tags. Photos with one or more of the tags listed will be returned.\n\n    tag_mode (Optional)\n      Either \'any\' for an OR combination of tags, or \'all\' for an AND combination. Defaults to \'any\' if not specified.\n\n    text (Optional)\n      A free text search. Photos who\'s title, description or tags contain the text will be returned.\n\n    min_upload_date (Optional)\n      Minimum upload date. Photos with an upload date greater than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    max_upload_date (Optional)\n      Maximum upload date. Photos with an upload date less than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    min_taken_date (Optional)\n      Minimum taken date. Photos with an taken date greater than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    max_taken_date (Optional)\n      Maximum taken date. Photos with an taken date less than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    license (Optional)\n      The license id for photos (for possible values see the flickr.photos.licenses.getInfo method). Multiple licenses may be comma-separated.\n\n    sort (Optional)\n      The order in which to sort returned photos. Deafults to date-posted-desc (unless you are doing a radial geo query, in which case the default sorting is by ascending distance from the point specified). The possible values are: date-posted-asc, date-posted-desc, date-taken-asc, date-taken-desc, interestingness-desc, interestingness-asc, and relevance.\n\n    privacy_filter (Optional)\n      Return photos only matching a certain privacy level. This only applies when making an authenticated call to view photos you own. Valid values are:\r\n<ul>\r\n<li>1 public photos</li>\r\n<li>2 private photos visible to friends</li>\r\n<li>3 private photos visible to family</li>\r\n<li>4 private photos visible to friends & family</li>\r\n<li>5 completely private photos</li>\r\n</ul>\r\n\n\n    bbox (Optional)\n      A comma-delimited list of 4 values defining the Bounding Box of the area that will be searched.\r\n<br /><br />\r\nThe 4 values represent the bottom-left corner of the box and the top-right corner, minimum_longitude, minimum_latitude, maximum_longitude, maximum_latitude.\r\n<br /><br />\r\nLongitude has a range of -180 to 180 , latitude of -90 to 90. Defaults to -180, -90, 180, 90 if not specified.\r\n<br /><br />\r\nUnlike standard photo queries, geo (or bounding box) queries will only return 250 results per page.\r\n<br /><br />\r\nGeo queries require some sort of limiting agent in order to prevent the database from crying. This is basically like the check against "parameterless searches" for queries without a geo component.\r\n<br /><br />\r\nA tag, for instance, is considered a limiting agent as are user defined min_date_taken and min_date_upload parameters &#8212; If no limiting factor is passed we return only photos added in the last 12 hours (though we may extend the limit in the future).\n\n    accuracy (Optional)\n      Recorded accuracy level of the location information.  Current range is 1-16 : \r\n\r\n<ul>\r\n<li>World level is 1</li>\r\n<li>Country is ~3</li>\r\n<li>Region is ~6</li>\r\n<li>City is ~11</li>\r\n<li>Street is ~16</li>\r\n</ul>\r\n\r\nDefaults to maximum value if not specified.\n\n    safe_search (Optional)\n      Safe search setting:\r\n\r\n<ul>\r\n<li>1 for safe.</li>\r\n<li>2 for moderate.</li>\r\n<li>3 for restricted.</li>\r\n</ul>\r\n\r\n(Please note: Un-authed calls can only see Safe content.)\n\n    content_type (Optional)\n      Content Type setting:\r\n<ul>\r\n<li>1 for photos only.</li>\r\n<li>2 for screenshots only.</li>\r\n<li>3 for \'other\' only.</li>\r\n<li>4 for photos and screenshots.</li>\r\n<li>5 for screenshots and \'other\'.</li>\r\n<li>6 for photos and \'other\'.</li>\r\n<li>7 for photos, screenshots, and \'other\' (all).</li>\r\n</ul>\n\n    machine_tags (Optional)\n      Aside from passing in a fully formed machine tag, there is a special syntax for searching on specific properties :\r\n\r\n<ul>\r\n  <li>Find photos using the \'dc\' namespace :    <code>"machine_tags" => "dc:"</code></li>\r\n\r\n  <li> Find photos with a title in the \'dc\' namespace : <code>"machine_tags" => "dc:title="</code></li>\r\n\r\n  <li>Find photos titled "mr. camera" in the \'dc\' namespace : <code>"machine_tags" => "dc:title=\\"mr. camera\\"</code></li>\r\n\r\n  <li>Find photos whose value is "mr. camera" : <code>"machine_tags" => "*:*=\\"mr. camera\\""</code></li>\r\n\r\n  <li>Find photos that have a title, in any namespace : <code>"machine_tags" => "*:title="</code></li>\r\n\r\n  <li>Find photos that have a title, in any namespace, whose value is "mr. camera" : <code>"machine_tags" => "*:title=\\"mr. camera\\""</code></li>\r\n\r\n  <li>Find photos, in the \'dc\' namespace whose value is "mr. camera" : <code>"machine_tags" => "dc:*=\\"mr. camera\\""</code></li>\r\n\r\n </ul>\r\n\r\nMultiple machine tags may be queried by passing a comma-separated list. The number of machine tags you can pass in a single query depends on the tag mode (AND or OR) that you are querying with. "AND" queries are limited to (16) machine tags. "OR" queries are limited\r\nto (8).\n\n    machine_tag_mode (Required)\n      Either \'any\' for an OR combination of tags, or \'all\' for an AND combination. Defaults to \'any\' if not specified.\n\n    group_id (Optional)\n      The id of a group who\'s pool to search.  If specified, only matching photos posted to the group\'s pool will be returned.\n\n    contacts (Optional)\n      Search your contacts. Either \'all\' or \'ff\' for just friends and family. (Experimental)\n\n    woe_id (Optional)\n      A 32-bit identifier that uniquely represents spatial entities. (not used if bbox argument is present). \r\n<br /><br />\r\nGeo queries require some sort of limiting agent in order to prevent the database from crying. This is basically like the check against "parameterless searches" for queries without a geo component.\r\n<br /><br />\r\nA tag, for instance, is considered a limiting agent as are user defined min_date_taken and min_date_upload parameters &emdash; If no limiting factor is passed we return only photos added in the last 12 hours (though we may extend the limit in the future).\n\n    place_id (Optional)\n      A Flickr place id.  (not used if bbox argument is present).\r\n<br /><br />\r\nGeo queries require some sort of limiting agent in order to prevent the database from crying. This is basically like the check against "parameterless searches" for queries without a geo component.\r\n<br /><br />\r\nA tag, for instance, is considered a limiting agent as are user defined min_date_taken and min_date_upload parameters &emdash; If no limiting factor is passed we return only photos added in the last 12 hours (though we may extend the limit in the future).\n\n    media (Optional)\n      Filter results by media type. Possible values are <code>all</code> (default), <code>photos</code> or <code>videos</code>\n\n    has_geo (Optional)\n      Any photo that has been geotagged, or if the value is "0" any photo that has <i>not</i> been geotagged.\r\n<br /><br />\r\nGeo queries require some sort of limiting agent in order to prevent the database from crying. This is basically like the check against "parameterless searches" for queries without a geo component.\r\n<br /><br />\r\nA tag, for instance, is considered a limiting agent as are user defined min_date_taken and min_date_upload parameters &emdash; If no limiting factor is passed we return only photos added in the last 12 hours (though we may extend the limit in the future).\n\n    geo_context (Optional)\n      Geo context is a numeric value representing the photo\'s geotagginess beyond latitude and longitude. For example, you may wish to search for photos that were taken "indoors" or "outdoors". <br /><br />\r\nThe current list of context IDs is :<br /><br/>\r\n<ul>\r\n<li><strong>0</strong>, not defined.</li>\r\n<li><strong>1</strong>, indoors.</li>\r\n<li><strong>2</strong>, outdoors.</li>\r\n</ul>\r\n<br /><br />\r\nGeo queries require some sort of limiting agent in order to prevent the database from crying. This is basically like the check against "parameterless searches" for queries without a geo component.\r\n<br /><br />\r\nA tag, for instance, is considered a limiting agent as are user defined min_date_taken and min_date_upload parameters &emdash; If no limiting factor is passed we return only photos added in the last 12 hours (though we may extend the limit in the future).\n\n    lat (Optional)\n      A valid latitude, in decimal format, for doing radial geo queries.\r\n<br /><br />\r\nGeo queries require some sort of limiting agent in order to prevent the database from crying. This is basically like the check against "parameterless searches" for queries without a geo component.\r\n<br /><br />\r\nA tag, for instance, is considered a limiting agent as are user defined min_date_taken and min_date_upload parameters &emdash; If no limiting factor is passed we return only photos added in the last 12 hours (though we may extend the limit in the future).\n\n    lon (Optional)\n      A valid longitude, in decimal format, for doing radial geo queries.\r\n<br /><br />\r\nGeo queries require some sort of limiting agent in order to prevent the database from crying. This is basically like the check against "parameterless searches" for queries without a geo component.\r\n<br /><br />\r\nA tag, for instance, is considered a limiting agent as are user defined min_date_taken and min_date_upload parameters &emdash; If no limiting factor is passed we return only photos added in the last 12 hours (though we may extend the limit in the future).\n\n    radius (Optional)\n      A valid radius used for geo queries, greater than zero and less than 20 miles (or 32 kilometers), for use with point-based geo queries. The default value is 5 (km).\n\n    radius_units (Optional)\n      The unit of measure when doing radial geo queries. Valid options are "mi" (miles) and "km" (kilometers). The default is "km".\n\n    is_commons (Optional)\n      Limit the scope of the search to only photos that are part of the <a href="http://flickr.com/commons">Flickr Commons project</a>. Default is false.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('setContentType', 'flickr.photos.setContentType\n\n  Set the content type of a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to set the adultness of.\n\n    content_type (Required)\n      The content type of the photo. Must be one of: 1 for Photo, 2 for Screenshot, and 3 for Other.'),
		('setDates', 'flickr.photos.setDates\n\n  Set one or both of the dates for a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to edit dates for.\n\n    date_posted (Optional)\n      The date the photo was uploaded to flickr (see the <a href="/services/api/misc.dates.html">dates documentation</a>)\n\n    date_taken (Optional)\n      The date the photo was taken (see the <a href="/services/api/misc.dates.html">dates documentation</a>)\n\n    date_taken_granularity (Optional)\n      The granularity of the date the photo was taken (see the <a href="/services/api/misc.dates.html">dates documentation</a>)'),
		('setMeta', 'flickr.photos.setMeta\n\n  Set the meta information for a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to set information for.\n\n    title (Required)\n      The title for the photo.\n\n    description (Required)\n      The description for the photo.'),
		('setPerms', "flickr.photos.setPerms\n\n  Set permissions for a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to set permissions for.\n\n    is_public (Required)\n      1 to set the photo to public, 0 to set it to private.\n\n    is_friend (Required)\n      1 to make the photo visible to friends when private, 0 to not.\n\n    is_family (Required)\n      1 to make the photo visible to family when private, 0 to not.\n\n    perm_comment (Required)\n      who can add comments to the photo and it's notes. one of:<br />\r\n<code>0</code>: nobody<br />\r\n<code>1</code>: friends &amp; family<br />\r\n<code>2</code>: contacts<br />\r\n<code>3</code>: everybody\n\n    perm_addmeta (Required)\n      who can add notes and tags to the photo. one of:<br />\r\n<code>0</code>: nobody / just the owner<br />\r\n<code>1</code>: friends & family<br />\r\n<code>2</code>: contacts<br />\r\n<code>3</code>: everybody\r\n"),
		('setSafetyLevel', 'flickr.photos.setSafetyLevel\n\n  Set the safety level of a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to set the adultness of.\n\n    safety_level (Optional)\n      The safety level of the photo.  Must be one of:\r\n\r\n1 for Safe, 2 for Moderate, and 3 for Restricted.\n\n    hidden (Optional)\n      Whether or not to additionally hide the photo from public searches.  Must be either 1 for Yes or 0 for No.'),
		('setTags', 'flickr.photos.setTags\n\n  Set the tags for a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to set tags for.\r\n\n\n    tags (Required)\n      All tags for the photo (as a single space-delimited string).'),
	)),
	('photos.comments', (
		('addComment', 'flickr.photos.comments.addComment\n\n  Add comment to a photo as the currently authenticated user.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to add a comment to.\n\n    comment_text (Required)\n      Text of the comment'),
		('deleteComment', 'flickr.photos.comments.deleteComment\n\n  Delete a comment as the currently authenticated user.\n\n  Arguments:\n\n    comment_id (Required)\n      The id of the comment to edit.'),
		('editComment', 'flickr.photos.comments.editComment\n\n  Edit the text of a comment as the currently authenticated user.\n\n  Arguments:\n\n    comment_id (Required)\n      The id of the comment to edit.\n\n    comment_text (Required)\n      Update the comment to this text.'),
		('getList', 'flickr.photos.comments.getList\n\n  Returns the comments for a photo\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to fetch comments for.\n\n    min_comment_date (Optional)\n      Minimum date that a a comment was added. The date should be in the form of a unix timestamp.\n\n    max_comment_date (Optional)\n      Maximum date that a comment was added. The date should be in the form of a unix timestamp.'),
		('getRecentForContacts', 'flickr.photos.comments.getRecentForContacts\n\n  Return the list of photos belonging to your contacts that have been commented on recently.\n\n  Arguments:\n\n    date_lastcomment (Optional)\n      Limits the resultset to photos that have been commented on since this date. The date should be in the form of a Unix timestamp.<br /><br />\r\nThe default, and maximum, offset is (1) hour.\r\n\r\n\r\n\n\n    contacts_filter (Optional)\n      A comma-separated list of contact NSIDs to limit the scope of the query to.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
	)),
	('photos.geo', (
		('batchCorrectLocation', "flickr.photos.geo.batchCorrectLocation\n\n  Correct the places hierarchy for all the photos for a user at a given latitude, longitude and accuracy.<br /><br />\r\n\r\nBatch corrections are processed in a delayed queue so it may take a few minutes before the changes are reflected in a user's photos.\n\n  Arguments:\n\n    lat (Required)\n      The latitude of the photos to be update whose valid range is -90 to 90. Anything more than 6 decimal places will be truncated.\n\n    lon (Required)\n      The longitude of the photos to be updated whose valid range is -180 to 180. Anything more than 6 decimal places will be truncated.\n\n    accuracy (Required)\n      Recorded accuracy level of the photos to be updated. World level is 1, Country is ~3, Region ~6, City ~11, Street ~16. Current range is 1-16. Defaults to 16 if not specified.\n\n    place_id (Optional)\n      A Flickr Places ID. (While optional, you must pass either a valid Places ID or a WOE ID.)\n\n    woe_id (Optional)\n      A Where On Earth (WOE) ID. (While optional, you must pass either a valid Places ID or a WOE ID.)"),
		('correctLocation', 'flickr.photos.geo.correctLocation\n\n  \n\n  Arguments:\n\n    photo_id (Required)\n      The ID of the photo whose WOE location is being corrected.\n\n    place_id (Optional)\n      A Flickr Places ID. (While optional, you must pass either a valid Places ID or a WOE ID.)\n\n    woe_id (Optional)\n      A Where On Earth (WOE) ID. (While optional, you must pass either a valid Places ID or a WOE ID.)'),
		('getLocation', 'flickr.photos.geo.getLocation\n\n  Get the geo data (latitude and longitude and the accuracy level) for a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo you want to retrieve location data for.'),
		('getPerms', 'flickr.photos.geo.getPerms\n\n  Get permissions for who may view geo data for a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to get permissions for.'),
		('photosForLocation', 'flickr.photos.geo.photosForLocation\n\n  Return a list of photos for a user at a specific latitude, longitude and accuracy\n\n  Arguments:\n\n    lat (Required)\n      The latitude whose valid range is -90 to 90. Anything more than 6 decimal places will be truncated.\n\n    lon (Required)\n      The longitude whose valid range is -180 to 180. Anything more than 6 decimal places will be truncated.\n\n    accuracy (Optional)\n      Recorded accuracy level of the location information. World level is 1, Country is ~3, Region ~6, City ~11, Street ~16. Current range is 1-16. Defaults to 16 if not specified.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: <code>license</code>, <code>date_upload</code>, <code>date_taken</code>, <code>owner_name</code>, <code>icon_server</code>, <code>original_format</code>, <code>last_update</code>, <code>geo</code>, <code>tags</code>, <code>machine_tags</code>, <code>o_dims</code>, <code>views</code>, <code>media</code>, <code>path_alias</code>, <code>url_sq</code>, <code>url_t</code>, <code>url_s</code>, <code>url_m</code>, <code>url_o</code>\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.'),
		('removeLocation', 'flickr.photos.geo.removeLocation\n\n  Removes the geo data associated with a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo you want to remove location data from.'),
		('setContext', 'flickr.photos.geo.setContext\n\n  Indicate the state of a photo\'s geotagginess beyond latitude and longitude.<br /><br />\r\nNote : photos passed to this method must already be geotagged (using the <q>flickr.photos.geo.setLocation</q> method).\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to set context data for.\n\n    context (Required)\n      Context is a numeric value representing the photo\'s geotagginess beyond latitude and longitude. For example, you may wish to indicate that a photo was taken "indoors" or "outdoors". <br /><br />\r\nThe current list of context IDs is :<br /><br/>\r\n<ul>\r\n<li><strong>0</strong>, not defined.</li>\r\n<li><strong>1</strong>, indoors.</li>\r\n<li><strong>2</strong>, outdoors.</li>\r\n</ul>'),
		('setLocation', 'flickr.photos.geo.setLocation\n\n  Sets the geo data (latitude and longitude and, optionally, the accuracy level) for a photo.\r\n\r\nBefore users may assign location data to a photo they must define who, by default, may view that information. Users can edit this preference at <a href="http://www.flickr.com/account/geo/privacy/">http://www.flickr.com/account/geo/privacy/</a>. If a user has not set this preference, the API method will return an error.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to set location data for.\n\n    lat (Required)\n      The latitude whose valid range is -90 to 90. Anything more than 6 decimal places will be truncated.\n\n    lon (Required)\n      The longitude whose valid range is -180 to 180. Anything more than 6 decimal places will be truncated.\n\n    accuracy (Optional)\n      Recorded accuracy level of the location information. World level is 1, Country is ~3, Region ~6, City ~11, Street ~16. Current range is 1-16. Defaults to 16 if not specified.\n\n    context (Optional)\n      Context is a numeric value representing the photo\'s geotagginess beyond latitude and longitude. For example, you may wish to indicate that a photo was taken "indoors" or "outdoors". <br /><br />\r\nThe current list of context IDs is :<br /><br/>\r\n<ul>\r\n<li><strong>0</strong>, not defined.</li>\r\n<li><strong>1</strong>, indoors.</li>\r\n<li><strong>2</strong>, outdoors.</li>\r\n</ul><br />\r\nThe default context for geotagged photos is 0, or "not defined"\r\n'),
		('setPerms', "flickr.photos.geo.setPerms\n\n  Set the permission for who may view the geo data associated with a photo.\n\n  Arguments:\n\n    is_public (Required)\n      1 to set viewing permissions for the photo's location data to public, 0 to set it to private.\n\n    is_contact (Required)\n      1 to set viewing permissions for the photo's location data to contacts, 0 to set it to private.\n\n    is_friend (Required)\n      1 to set viewing permissions for the photo's location data to friends, 0 to set it to private.\n\n    is_family (Required)\n      1 to set viewing permissions for the photo's location data to family, 0 to set it to private.\n\n    photo_id (Required)\n      The id of the photo to get permissions for."),
	)),
	('photos.licenses', (
		('getInfo', 'flickr.photos.licenses.getInfo\n\n  Fetches a list of available photo licenses for Flickr.'),
		('setLicense', 'flickr.photos.licenses.setLicense\n\n  Sets the license for a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The photo to update the license for.\n\n    license_id (Required)\n      The license to apply, or 0 (zero) to remove the current license. Note : as of this writing the "no known copyright restrictions" license (7) is not a valid argument.'),
	)),
	('photos.notes', (
		('add', 'flickr.photos.notes.add\n\n  Add a note to a photo. Coordinates and sizes are in pixels, based on the 500px image size shown on individual photo pages.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to add a note to\n\n    note_x (Required)\n      The left coordinate of the note\n\n    note_y (Required)\n      The top coordinate of the note\n\n    note_w (Required)\n      The width of the note\n\n    note_h (Required)\n      The height of the note\n\n    note_text (Required)\n      The description of the note'),
		('delete', 'flickr.photos.notes.delete\n\n  Delete a note from a photo.\n\n  Arguments:\n\n    note_id (Required)\n      The id of the note to delete'),
		('edit', 'flickr.photos.notes.edit\n\n  Edit a note on a photo. Coordinates and sizes are in pixels, based on the 500px image size shown on individual photo pages.\n\n  Arguments:\n\n    note_id (Required)\n      The id of the note to edit\n\n    note_x (Required)\n      The left coordinate of the note\n\n    note_y (Required)\n      The top coordinate of the note\n\n    note_w (Required)\n      The width of the note\n\n    note_h (Required)\n      The height of the note\n\n    note_text (Required)\n      The description of the note'),
	)),
	('photos.transform', (
		('rotate', "flickr.photos.transform.rotate\n\n  Rotate a photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to rotate.\n\n    degrees (Required)\n      The amount of degrees by which to rotate the photo (clockwise) from it's current orientation. Valid values are 90, 180 and 270."),
	)),
	('photos.upload', (
		('checkTickets', 'flickr.photos.upload.checkTickets\n\n  Checks the status of one or more asynchronous photo upload tickets.\n\n  Arguments:\n\n    tickets (Required)\n      A comma-delimited list of ticket ids'),
	)),
	('photosets', (
		('addPhoto', 'flickr.photosets.addPhoto\n\n  Add a photo to the end of an existing photoset.\n\n  Arguments:\n\n    photoset_id (Required)\n      The id of the photoset to add a photo to.\n\n    photo_id (Required)\n      The id of the photo to add to the set.'),
		('create', 'flickr.photosets.create\n\n  Create a new photoset for the calling user.\n\n  Arguments:\n\n    title (Required)\n      A title for the photoset.\n\n    description (Optional)\n      A description of the photoset. May contain limited html.\n\n    primary_photo_id (Required)\n      The id of the photo to represent this set. The photo must belong to the calling user.'),
		('delete', 'flickr.photosets.delete\n\n  Delete a photoset.\n\n  Arguments:\n\n    photoset_id (Required)\n      The id of the photoset to delete. It must be owned by the calling user.'),
		('editMeta', 'flickr.photosets.editMeta\n\n  Modify the meta-data for a photoset.\n\n  Arguments:\n\n    photoset_id (Required)\n      The id of the photoset to modify.\n\n    title (Required)\n      The new title for the photoset.\n\n    description (Optional)\n      A description of the photoset. May contain limited html.'),
		('editPhotos', "flickr.photosets.editPhotos\n\n  Modify the photos in a photoset. Use this method to add, remove and re-order photos.\n\n  Arguments:\n\n    photoset_id (Required)\n      The id of the photoset to modify. The photoset must belong to the calling user.\n\n    primary_photo_id (Required)\n      The id of the photo to use as the 'primary' photo for the set. This id must also be passed along in photo_ids list argument.\n\n    photo_ids (Required)\n      A comma-delimited list of photo ids to include in the set. They will appear in the set in the order sent. This list <b>must</b> contain the primary photo id. All photos must belong to the owner of the set. This list of photos replaces the existing list. Call flickr.photosets.addPhoto to append a photo to a set."),
		('getContext', "flickr.photosets.getContext\n\n  Returns next and previous photos for a photo in a set.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to fetch the context for.\n\n    photoset_id (Required)\n      The id of the photoset for which to fetch the photo's context."),
		('getInfo', 'flickr.photosets.getInfo\n\n  Gets information about a photoset.\n\n  Arguments:\n\n    photoset_id (Required)\n      The ID of the photoset to fetch information for.'),
		('getList', 'flickr.photosets.getList\n\n  Returns the photosets belonging to the specified user.\n\n  Arguments:\n\n    user_id (Optional)\n      The NSID of the user to get a photoset list for. If none is specified, the calling user is assumed.'),
		('getPhotos', 'flickr.photosets.getPhotos\n\n  Get the list of photos in a set.\n\n  Arguments:\n\n    photoset_id (Required)\n      The id of the photoset to return the photos for.\n\n    extras (Optional)\n      A comma-delimited list of extra information to fetch for each returned record. Currently supported fields are: license, date_upload, date_taken, owner_name, icon_server, original_format, last_update, geo, tags, machine_tags, o_dims, views, media, path_alias, url_sq, url_t, url_s, url_m, url_o\n\n    privacy_filter (Optional)\n      Return photos only matching a certain privacy level. This only applies when making an authenticated call to view a photoset you own. Valid values are:\r\n<ul>\r\n<li>1 public photos</li>\r\n<li>2 private photos visible to friends</li>\r\n<li>3 private photos visible to family</li>\r\n<li>4 private photos visible to friends & family</li>\r\n<li>5 completely private photos</li>\r\n</ul>\r\n\n\n    per_page (Optional)\n      Number of photos to return per page. If this argument is omitted, it defaults to 500. The maximum allowed value is 500.\n\n    page (Optional)\n      The page of results to return. If this argument is omitted, it defaults to 1.\n\n    media (Optional)\n      Filter results by media type. Possible values are <code>all</code> (default), <code>photos</code> or <code>videos</code>'),
		('orderSets', 'flickr.photosets.orderSets\n\n  Set the order of photosets for the calling user.\n\n  Arguments:\n\n    photoset_ids (Required)\n      A comma delimited list of photoset IDs, ordered with the set to show first, first in the list. Any set IDs not given in the list will be set to appear at the end of the list, ordered by their IDs.'),
		('removePhoto', 'flickr.photosets.removePhoto\n\n  Remove a photo from a photoset.\n\n  Arguments:\n\n    photoset_id (Required)\n      The id of the photoset to remove a photo from.\n\n    photo_id (Required)\n      The id of the photo to remove from the set.'),
	)),
	('photosets.comments', (
		('addComment', 'flickr.photosets.comments.addComment\n\n  Add a comment to a photoset.\n\n  Arguments:\n\n    photoset_id (Required)\n      The id of the photoset to add a comment to.\n\n    comment_text (Required)\n      Text of the comment'),
		('deleteComment', 'flickr.photosets.comments.deleteComment\n\n  Delete a photoset comment as the currently authenticated user.\n\n  Arguments:\n\n    comment_id (Required)\n      The id of the comment to delete from a photoset.'),
		('editComment', 'flickr.photosets.comments.editComment\n\n  Edit the text of a comment as the currently authenticated user.\n\n  Arguments:\n\n    comment_id (Required)\n      The id of the comment to edit.\n\n    comment_text (Required)\n      Update the comment to this text.'),
		('getList', 'flickr.photosets.comments.getList\n\n  Returns the comments for a photoset.\n\n  Arguments:\n\n    photoset_id (Required)\n      The id of the photoset to fetch comments for.'),
	)),
	('places', (
		('find', 'flickr.places.find\n\n  Return a list of place IDs for a query string.<br /><br />\r\nThe flickr.places.find method is <b>not</b> a geocoder. It will round <q>up</q> to the nearest place type to which place IDs apply. For example, if you pass it a street level address it will return the city that contains the address rather than the street, or building, itself.\n\n  Arguments:\n\n    query (Required)\n      The query string to use for place ID lookups'),
		('findByLatLon', 'flickr.places.findByLatLon\n\n  Return a place ID for a latitude, longitude and accuracy triple.<br /><br />\r\nThe flickr.places.findByLatLon method is not meant to be a (reverse) geocoder in the traditional sense. It is designed to allow users to find photos for "places" and will round up to the nearest place type to which corresponding place IDs apply.<br /><br />\r\nFor example, if you pass it a street level coordinate it will return the city that contains the point rather than the street, or building, itself.<br /><br />\r\nIt will also truncate latitudes and longitudes to three decimal points.\n\n  Arguments:\n\n    lat (Required)\n      The latitude whose valid range is -90 to 90. Anything more than 4 decimal places will be truncated.\n\n    lon (Required)\n      The longitude whose valid range is -180 to 180. Anything more than 4 decimal places will be truncated.\n\n    accuracy (Optional)\n      Recorded accuracy level of the location information. World level is 1, Country is ~3, Region ~6, City ~11, Street ~16. Current range is 1-16. The default is 16.'),
		('getChildrenWithPhotosPublic', 'flickr.places.getChildrenWithPhotosPublic\n\n  Return a list of locations with public photos that are parented by a Where on Earth (WOE) or Places ID.\n\n  Arguments:\n\n    place_id (Optional)\n      A Flickr Places ID. (While optional, you must pass either a valid Places ID or a WOE ID.)\n\n    woe_id (Optional)\n      A Where On Earth (WOE) ID. (While optional, you must pass either a valid Places ID or a WOE ID.)'),
		('getInfo', 'flickr.places.getInfo\n\n  Get informations about a place.\n\n  Arguments:\n\n    place_id (Optional)\n      A Flickr Places ID. <span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>\n\n    woe_id (Optional)\n      A Where On Earth (WOE) ID. <span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>'),
		('getInfoByUrl', 'flickr.places.getInfoByUrl\n\n  Lookup information about a place, by its flickr.com/places URL.\n\n  Arguments:\n\n    url (Required)\n      A flickr.com/places URL in the form of /country/region/city. For example: /Canada/Quebec/Montreal'),
		('getPlaceTypes', 'flickr.places.getPlaceTypes\n\n  Fetches a list of available place types for Flickr.'),
		('getShapeHistory', 'flickr.places.getShapeHistory\n\n  Return an historical list of all the shape data generated for a Places or Where on Earth (WOE) ID.\n\n  Arguments:\n\n    place_id (Optional)\n      A Flickr Places ID. <span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>\n\n    woe_id (Optional)\n      A Where On Earth (WOE) ID. <span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>'),
		('getTopPlacesList', 'flickr.places.getTopPlacesList\n\n  Return the top 100 most geotagged places for a day.\n\n  Arguments:\n\n    place_type_id (Required)\n      The numeric ID for a specific place type to cluster photos by. <br /><br />\r\n\r\nValid place type IDs are :\r\n\r\n<ul>\r\n<li><strong>22</strong>: neighbourhood</li>\r\n<li><strong>7</strong>: locality</li>\r\n<li><strong>8</strong>: region</li>\r\n<li><strong>12</strong>: country</li>\r\n<li><strong>29</strong>: continent</li>\r\n</ul>\n\n    date (Optional)\n      A valid date in YYYY-MM-DD format. The default is yesterday.\n\n    woe_id (Optional)\n      Limit your query to only those top places belonging to a specific Where on Earth (WOE) identifier.\n\n    place_id (Optional)\n      Limit your query to only those top places belonging to a specific Flickr Places identifier.'),
		('placesForBoundingBox', 'flickr.places.placesForBoundingBox\n\n  Return all the locations of a matching place type for a bounding box.<br /><br />\r\n\r\nThe maximum allowable size of a bounding box (the distance between the SW and NE corners) is governed by the place type you are requesting. Allowable sizes are as follows:\r\n\r\n<ul>\r\n<li><strong>neighbourhood</strong>: 3km (1.8mi)</li>\r\n<li><strong>locality</strong>: 7km (4.3mi)</li>\r\n<li><strong>county</strong>: 50km (31mi)</li>\r\n<li><strong>region</strong>: 200km (124mi)</li>\r\n<li><strong>country</strong>: 500km (310mi)</li>\r\n<li><strong>continent</strong>: 1500km (932mi)</li>\r\n</ul>\n\n  Arguments:\n\n    bbox (Required)\n      A comma-delimited list of 4 values defining the Bounding Box of the area that will be searched. The 4 values represent the bottom-left corner of the box and the top-right corner, minimum_longitude, minimum_latitude, maximum_longitude, maximum_latitude.\n\n    place_type (Optional)\n      The name of place type to using as the starting point to search for places in a bounding box. Valid placetypes are:\r\n\r\n<ul>\r\n<li>neighbourhood</li>\r\n<li>locality</li>\r\n<li>county</li>\r\n<li>region</li>\r\n<li>country</li>\r\n<li>continent</li>\r\n</ul>\r\n<br />\r\n<span style="font-style:italic;">The "place_type" argument has been deprecated in favor of the "place_type_id" argument. It won\'t go away but it will not be added to new methods. A complete list of place type IDs is available using the <a href="http://www.flickr.com/services/api/flickr.places.getPlaceTypes.html">flickr.places.getPlaceTypes</a> method. (While optional, you must pass either a valid place type or place type ID.)</span>\n\n    place_type_id (Optional)\n      The numeric ID for a specific place type to cluster photos by. <br /><br />\r\n\r\nValid place type IDs are :\r\n\r\n<ul>\r\n<li><strong>22</strong>: neighbourhood</li>\r\n<li><strong>7</strong>: locality</li>\r\n<li><strong>8</strong>: region</li>\r\n<li><strong>12</strong>: country</li>\r\n<li><strong>29</strong>: continent</li>\r\n</ul>\r\n<br /><span style="font-style:italic;">(While optional, you must pass either a valid place type or place type ID.)</span>\r\n'),
		('placesForContacts', 'flickr.places.placesForContacts\n\n  Return a list of the top 100 unique places clustered by a given placetype for a user\'s contacts.\n\n  Arguments:\n\n    place_type (Optional)\n      A specific place type to cluster photos by. <br /><br />\r\n\r\nValid place types are :\r\n\r\n<ul>\r\n<li><strong>neighbourhood</strong> (and neighborhood)</li>\r\n<li><strong>locality</strong></li>\r\n<li><strong>region</strong></li>\r\n<li><strong>country</strong></li>\r\n<li><strong>continent</strong></li>\r\n</ul>\r\n<br />\r\n<span style="font-style:italic;">The "place_type" argument has been deprecated in favor of the "place_type_id" argument. It won\'t go away but it will not be added to new methods. A complete list of place type IDs is available using the <a href="http://www.flickr.com/services/api/flickr.places.getPlaceTypes.html">flickr.places.getPlaceTypes</a> method. (While optional, you must pass either a valid place type or place type ID.)</span>\n\n    place_type_id (Optional)\n      The numeric ID for a specific place type to cluster photos by. <br /><br />\r\n\r\nValid place type IDs are :\r\n\r\n<ul>\r\n<li><strong>22</strong>: neighbourhood</li>\r\n<li><strong>7</strong>: locality</li>\r\n<li><strong>8</strong>: region</li>\r\n<li><strong>12</strong>: country</li>\r\n<li><strong>29</strong>: continent</li>\r\n</ul>\r\n<br /><span style="font-style:italic;">(While optional, you must pass either a valid place type or place type ID.)</span>\n\n    woe_id (Optional)\n      A Where on Earth identifier to use to filter photo clusters. For example all the photos clustered by <strong>locality</strong> in the United States (WOE ID <strong>23424977</strong>).<br /><br />\r\n<span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>\n\n    place_id (Optional)\n      A Flickr Places identifier to use to filter photo clusters. For example all the photos clustered by <strong>locality</strong> in the United States (Place ID <strong>4KO02SibApitvSBieQ</strong>).\r\n<br /><br />\r\n<span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>\n\n    threshold (Optional)\n      The minimum number of photos that a place type must have to be included. If the number of photos is lowered then the parent place type for that place will be used.<br /><br />\r\n\r\nFor example if your contacts only have <strong>3</strong> photos taken in the locality of Montreal</strong> (WOE ID 3534) but your threshold is set to <strong>5</strong> then those photos will be "rolled up" and included instead with a place record for the region of Quebec (WOE ID 2344924).\n\n    contacts (Optional)\n      Search your contacts. Either \'all\' or \'ff\' for just friends and family. (Default is all)\n\n    min_upload_date (Optional)\n      Minimum upload date. Photos with an upload date greater than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    max_upload_date (Optional)\n      Maximum upload date. Photos with an upload date less than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    min_taken_date (Optional)\n      Minimum taken date. Photos with an taken date greater than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    max_taken_date (Optional)\n      Maximum taken date. Photos with an taken date less than or equal to this value will be returned. The date should be in the form of a mysql datetime.'),
		('placesForTags', 'flickr.places.placesForTags\n\n  Return a list of the top 100 unique places clustered by a given placetype for set of tags or machine tags.\n\n  Arguments:\n\n    place_type_id (Required)\n      The numeric ID for a specific place type to cluster photos by. <br /><br />\r\n\r\nValid place type IDs are :\r\n\r\n<ul>\r\n<li><strong>22</strong>: neighbourhood</li>\r\n<li><strong>7</strong>: locality</li>\r\n<li><strong>8</strong>: region</li>\r\n<li><strong>12</strong>: country</li>\r\n<li><strong>29</strong>: continent</li>\r\n</ul>\n\n    woe_id (Optional)\n      A Where on Earth identifier to use to filter photo clusters. For example all the photos clustered by <strong>locality</strong> in the United States (WOE ID <strong>23424977</strong>).\r\n<br /><br />\r\n<span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>\n\n    place_id (Optional)\n      A Flickr Places identifier to use to filter photo clusters. For example all the photos clustered by <strong>locality</strong> in the United States (Place ID <strong>4KO02SibApitvSBieQ</strong>).\r\n<br /><br />\r\n<span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>\n\n    threshold (Optional)\n      The minimum number of photos that a place type must have to be included. If the number of photos is lowered then the parent place type for that place will be used.<br /><br />\r\n\r\nFor example if you only have <strong>3</strong> photos taken in the locality of Montreal</strong> (WOE ID 3534) but your threshold is set to <strong>5</strong> then those photos will be "rolled up" and included instead with a place record for the region of Quebec (WOE ID 2344924).\n\n    tags (Optional)\n      A comma-delimited list of tags. Photos with one or more of the tags listed will be returned.\n\n    tag_mode (Optional)\n      Either \'any\' for an OR combination of tags, or \'all\' for an AND combination. Defaults to \'any\' if not specified.\n\n    machine_tags (Optional)\n      Aside from passing in a fully formed machine tag, there is a special syntax for searching on specific properties :\r\n\r\n<ul>\r\n  <li>Find photos using the \'dc\' namespace :    <code>"machine_tags" => "dc:"</code></li>\r\n\r\n  <li> Find photos with a title in the \'dc\' namespace : <code>"machine_tags" => "dc:title="</code></li>\r\n\r\n  <li>Find photos titled "mr. camera" in the \'dc\' namespace : <code>"machine_tags" => "dc:title=\\"mr. camera\\"</code></li>\r\n\r\n  <li>Find photos whose value is "mr. camera" : <code>"machine_tags" => "*:*=\\"mr. camera\\""</code></li>\r\n\r\n  <li>Find photos that have a title, in any namespace : <code>"machine_tags" => "*:title="</code></li>\r\n\r\n  <li>Find photos that have a title, in any namespace, whose value is "mr. camera" : <code>"machine_tags" => "*:title=\\"mr. camera\\""</code></li>\r\n\r\n  <li>Find photos, in the \'dc\' namespace whose value is "mr. camera" : <code>"machine_tags" => "dc:*=\\"mr. camera\\""</code></li>\r\n\r\n </ul>\r\n\r\nMultiple machine tags may be queried by passing a comma-separated list. The number of machine tags you can pass in a single query depends on the tag mode (AND or OR) that you are querying with. "AND" queries are limited to (16) machine tags. "OR" queries are limited\r\nto (8).\n\n    machine_tag_mode (Optional)\n      Either \'any\' for an OR combination of tags, or \'all\' for an AND combination. Defaults to \'any\' if not specified.\n\n    min_upload_date (Optional)\n      Minimum upload date. Photos with an upload date greater than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    max_upload_date (Optional)\n      Maximum upload date. Photos with an upload date less than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    min_taken_date (Optional)\n      Minimum taken date. Photos with an taken date greater than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    max_taken_date (Optional)\n      Maximum taken date. Photos with an taken date less than or equal to this value will be returned. The date should be in the form of a mysql datetime.'),
		('placesForUser', 'flickr.places.placesForUser\n\n  Return a list of the top 100 unique places clustered by a given placetype for a user.\n\n  Arguments:\n\n    place_type_id (Optional)\n      The numeric ID for a specific place type to cluster photos by. <br /><br />\r\n\r\nValid place type IDs are :\r\n\r\n<ul>\r\n<li><strong>22</strong>: neighbourhood</li>\r\n<li><strong>7</strong>: locality</li>\r\n<li><strong>8</strong>: region</li>\r\n<li><strong>12</strong>: country</li>\r\n<li><strong>29</strong>: continent</li>\r\n</ul>\r\n<br />\r\n<span style="font-style:italic;">The "place_type" argument has been deprecated in favor of the "place_type_id" argument. It won\'t go away but it will not be added to new methods. A complete list of place type IDs is available using the <a href="http://www.flickr.com/services/api/flickr.places.getPlaceTypes.html">flickr.places.getPlaceTypes</a> method. (While optional, you must pass either a valid place type or place type ID.)</span>\n\n    place_type (Optional)\n      A specific place type to cluster photos by. <br /><br />\r\n\r\nValid place types are :\r\n\r\n<ul>\r\n<li><strong>neighbourhood</strong> (and neighborhood)</li>\r\n<li><strong>locality</strong></li>\r\n<li><strong>region</strong></li>\r\n<li><strong>country</strong></li>\r\n<li><strong>continent</strong></li>\r\n</ul>\r\n<br /><span style="font-style:italic;">(While optional, you must pass either a valid place type or place type ID.)</span>\n\n    woe_id (Optional)\n      A Where on Earth identifier to use to filter photo clusters. For example all the photos clustered by <strong>locality</strong> in the United States (WOE ID <strong>23424977</strong>).<br /><br />\r\n<span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>\n\n    place_id (Optional)\n      A Flickr Places identifier to use to filter photo clusters. For example all the photos clustered by <strong>locality</strong> in the United States (Place ID <strong>4KO02SibApitvSBieQ</strong>).<br /><br />\r\n<span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>\n\n    threshold (Optional)\n      The minimum number of photos that a place type must have to be included. If the number of photos is lowered then the parent place type for that place will be used.<br /><br />\r\n\r\nFor example if you only have <strong>3</strong> photos taken in the locality of Montreal</strong> (WOE ID 3534) but your threshold is set to <strong>5</strong> then those photos will be "rolled up" and included instead with a place record for the region of Quebec (WOE ID 2344924).\n\n    min_upload_date (Optional)\n      Minimum upload date. Photos with an upload date greater than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    max_upload_date (Optional)\n      Maximum upload date. Photos with an upload date less than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    min_taken_date (Optional)\n      Minimum taken date. Photos with an taken date greater than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    max_taken_date (Optional)\n      Maximum taken date. Photos with an taken date less than or equal to this value will be returned. The date should be in the form of a mysql datetime.'),
		('resolvePlaceId', 'flickr.places.resolvePlaceId\n\n  Find Flickr Places information by Place ID.<br /><br />\r\nThis method has been deprecated. It won\'t be removed but you should use <a href="/services/api/flickr.places.getInfo.html">flickr.places.getInfo</a> instead.\n\n  Arguments:\n\n    place_id (Required)\n      A Flickr Places ID'),
		('resolvePlaceURL', 'flickr.places.resolvePlaceURL\n\n  Find Flickr Places information by Place URL.<br /><br />\r\nThis method has been deprecated. It won\'t be removed but you should use <a href="/services/api/flickr.places.getInfoByUrl.html">flickr.places.getInfoByUrl</a> instead.\n\n  Arguments:\n\n    url (Required)\n      A Flickr Places URL.  \r\n<br /><br />\r\nFlickr Place URLs are of the form /country/region/city'),
		('tagsForPlace', 'flickr.places.tagsForPlace\n\n  Return a list of the top 100 unique tags for a Flickr Places or Where on Earth (WOE) ID\n\n  Arguments:\n\n    woe_id (Optional)\n      A Where on Earth identifier to use to filter photo clusters.<br /><br />\r\n<span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>\n\n    place_id (Optional)\n      A Flickr Places identifier to use to filter photo clusters.<br /><br />\r\n<span style="font-style:italic;">(While optional, you must pass either a valid Places ID or a WOE ID.)</span>\n\n    min_upload_date (Optional)\n      Minimum upload date. Photos with an upload date greater than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    max_upload_date (Optional)\n      Maximum upload date. Photos with an upload date less than or equal to this value will be returned. The date should be in the form of a unix timestamp.\n\n    min_taken_date (Optional)\n      Minimum taken date. Photos with an taken date greater than or equal to this value will be returned. The date should be in the form of a mysql datetime.\n\n    max_taken_date (Optional)\n      Maximum taken date. Photos with an taken date less than or equal to this value will be returned. The date should be in the form of a mysql datetime.'),
	)),
	('prefs', (
		('getContentType', 'flickr.prefs.getContentType\n\n  Returns the default content type preference for the user.'),
		('getGeoPerms', 'flickr.prefs.getGeoPerms\n\n  Returns the default privacy level for geographic information attached to the user\'s photos and whether or not the user has chosen to use geo-related EXIF information to automatically geotag their photos.\r\n\r\nPossible values, for viewing geotagged photos, are:\r\n\r\n<ul>\r\n<li>0 : <i>No default set</i></li>\r\n<li>1 : Public</li>\r\n<li>2 : Contacts only</li>\r\n<li>3 : Friends and Family only</li>\r\n<li>4 : Friends only</li>\r\n<li>5 : Family only</li>\r\n<li>6 : Private</li>\r\n</ul>\r\n\r\nUsers can edit this preference at <a href="http://www.flickr.com/account/geo/privacy/">http://www.flickr.com/account/geo/privacy/</a>.\r\n<br /><br />\r\nPossible values for whether or not geo-related EXIF information will be used to geotag a photo are:\r\n\r\n<ul>\r\n<li>0: Geo-related EXIF information will be ignored</li>\r\n<li>1: Geo-related EXIF information will be used to try and geotag photos on upload</li>\r\n</ul>\r\n\r\nUsers can edit this preference at <a href="http://www.flickr.com/account/geo/exif/?from=privacy">http://www.flickr.com/account/geo/exif/?from=privacy</a>'),
		('getHidden', 'flickr.prefs.getHidden\n\n  Returns the default hidden preference for the user.'),
		('getPrivacy', 'flickr.prefs.getPrivacy\n\n  Returns the default privacy level preference for the user.\r\n\r\nPossible values are:\r\n<ul>\r\n<li>1 : Public</li>\r\n<li>2 : Friends only</li>\r\n<li>3 : Family only</li>\r\n<li>4 : Friends and Family</li>\r\n<li>5 : Private</li>\r\n</ul>'),
		('getSafetyLevel', 'flickr.prefs.getSafetyLevel\n\n  Returns the default safety level preference for the user.'),
	)),
	('reflection', (
		('getMethodInfo', 'flickr.reflection.getMethodInfo\n\n  Returns information for a given flickr API method.\n\n  Arguments:\n\n    method_name (Required)\n      The name of the method to fetch information for.'),
		('getMethods', 'flickr.reflection.getMethods\n\n  Returns a list of available flickr API methods.'),
	)),
	('tags', (
		('getClusterPhotos', 'flickr.tags.getClusterPhotos\n\n  Returns the first 24 photos for a given tag cluster\n\n  Arguments:\n\n    tag (Required)\n      The tag that this cluster belongs to.\n\n    cluster_id (Required)\n      The top three tags for the cluster, separated by dashes (just like the url).'),
		('getClusters', 'flickr.tags.getClusters\n\n  Gives you a list of tag clusters for the given tag.\n\n  Arguments:\n\n    tag (Required)\n      The tag to fetch clusters for.'),
		('getHotList', 'flickr.tags.getHotList\n\n  Returns a list of hot tags for the given period.\n\n  Arguments:\n\n    period (Optional)\n      The period for which to fetch hot tags. Valid values are <code>day</code> and <code>week</code> (defaults to <code>day</code>).\n\n    count (Optional)\n      The number of tags to return. Defaults to 20. Maximum allowed value is 200.'),
		('getListPhoto', 'flickr.tags.getListPhoto\n\n  Get the tag list for a given photo.\n\n  Arguments:\n\n    photo_id (Required)\n      The id of the photo to return tags for.'),
		('getListUser', 'flickr.tags.getListUser\n\n  Get the tag list for a given user (or the currently logged in user).\n\n  Arguments:\n\n    user_id (Optional)\n      The NSID of the user to fetch the tag list for. If this argument is not specified, the currently logged in user (if any) is assumed.'),
		('getListUserPopular', 'flickr.tags.getListUserPopular\n\n  Get the popular tags for a given user (or the currently logged in user).\n\n  Arguments:\n\n    user_id (Optional)\n      The NSID of the user to fetch the tag list for. If this argument is not specified, the currently logged in user (if any) is assumed.\n\n    count (Optional)\n      Number of popular tags to return. defaults to 10 when this argument is not present.'),
		('getListUserRaw', 'flickr.tags.getListUserRaw\n\n  Get the raw versions of a given tag (or all tags) for the currently logged-in user.\n\n  Arguments:\n\n    tag (Optional)\n      The tag you want to retrieve all raw versions for.'),
		('getRelated', "flickr.tags.getRelated\n\n  Returns a list of tags 'related' to the given tag, based on clustered usage analysis.\n\n  Arguments:\n\n    tag (Required)\n      The tag to fetch related tags for."),
	)),
	('test', (
		('echo', "flickr.test.echo\n\n  A testing method which echo's all parameters back in the response."),
		('login', 'flickr.test.login\n\n  A testing method which checks if the caller is logged in then returns their username.'),
		('null', 'flickr.test.null\n\n  Null test'),
	)),
	('urls', (
		('getGroup', "flickr.urls.getGroup\n\n  Returns the url to a group's page.\n\n  Arguments:\n\n    group_id (Required)\n      The NSID of the group to fetch the url for."),
		('getUserPhotos', "flickr.urls.getUserPhotos\n\n  Returns the url to a user's photos.\n\n  Arguments:\n\n    user_id (Optional)\n      The NSID of the user to fetch the url for. If omitted, the calling user is assumed."),
		('getUserProfile', "flickr.urls.getUserProfile\n\n  Returns the url to a user's profile.\n\n  Arguments:\n\n    user_id (Optional)\n      The NSID of the user to fetch the url for. If omitted, the calling user is assumed."),
		('lookupGroup', "flickr.urls.lookupGroup\n\n  Returns a group NSID, given the url to a group's page or photo pool.\n\n  Arguments:\n\n    url (Required)\n      The url to the group's page or photo pool."),
		('lookupUser', "flickr.urls.lookupUser\n\n  Returns a user NSID, given the url to a user's photos or profile.\n\n  Arguments:\n\n    url (Required)\n      The url to the user's profile or photos page."),
	)),
)

def namespace(namespace):
	return namespace.title().replace('.', '')
