/*
 * Decompiled with CFR 0.152.
 */
package be.re.xml.sax;

import be.re.xml.ExpandedName;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class BalanceChecker
extends XMLFilterImpl {
    private Stack elements = new Stack();
    private File file;
    private int indent = 0;
    private PrintStream out;

    public BalanceChecker(File file) {
        this.file = file;
    }

    public BalanceChecker(File file, XMLReader parent) {
        super(parent);
        this.file = file;
    }

    public void endDocument() throws SAXException {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            this.write("Element " + this.elements.get(i).toString() + " is not closed.");
        }
        this.out.close();
        super.endDocument();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        ExpandedName element = new ExpandedName(namespaceURI, localName);
        if (this.elements.isEmpty()) {
            this.write("Closing " + element.toString() + " while no open elements are left.");
        } else {
            ExpandedName name = (ExpandedName)this.elements.pop();
            if (!name.equals(element)) {
                this.write("Closing " + element.toString() + " while expecting " + name.toString() + ".");
            }
        }
        this.indent -= 2;
        this.write("</" + element.toString() + ">");
        super.endElement(namespaceURI, localName, qName);
    }

    public void startDocument() throws SAXException {
        try {
            this.out = new PrintStream(new FileOutputStream(this.file));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        super.startDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        ExpandedName name = new ExpandedName(namespaceURI, localName);
        this.write("<" + name.toString() + ">");
        this.indent += 2;
        this.elements.push(name);
        super.startElement(namespaceURI, localName, qName, atts);
    }

    private void write(String s) {
        if (this.indent > 0) {
            char[] c = new char[this.indent];
            Arrays.fill(c, ' ');
            this.out.print(c);
        }
        this.out.println(s);
        this.out.flush();
    }
}

