/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.ds;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.Variant;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.ow2.proactive.authentication.ConnectionInfo;
import org.ow2.proactive.http.HttpClientBuilder;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.task.dataspaces.FileSystemException;
import org.ow2.proactive.scheduler.common.task.dataspaces.RemoteSpace;
import org.ow2.proactive.scheduler.rest.ISchedulerClient;
import org.ow2.proactive.scheduler.rest.SchedulerClient;
import org.ow2.proactive.scheduler.rest.ds.IDataSpaceClient;
import org.ow2.proactive.scheduler.rest.ds.LocalDestination;
import org.ow2.proactive.scheduler.rest.ds.LocalDirSource;
import org.ow2.proactive.scheduler.rest.ds.LocalFileSource;
import org.ow2.proactive.scheduler.rest.ds.RemoteDestination;
import org.ow2.proactive.scheduler.rest.ds.RemoteSource;
import org.ow2.proactive_grid_cloud_portal.dataspace.dto.ListFile;

public class DataSpaceClient
implements IDataSpaceClient {
    private static final Logger log = Logger.getLogger(DataSpaceClient.class);
    private String restDataspaceUrl;
    private String sessionId;
    private ClientHttpEngine httpEngine;
    private ISchedulerClient schedulerClient;

    public DataSpaceClient() {
    }

    public DataSpaceClient(String restServerUrl, ClientHttpEngine httpEngine) {
        this.httpEngine = httpEngine;
        this.restDataspaceUrl = this.restDataspaceUrl(restServerUrl);
    }

    public void init(String restServerUrl, ISchedulerClient client) {
        this.httpEngine = new ApacheHttpClient4Engine((HttpClient)new HttpClientBuilder().disableContentCompression().insecure(client.getConnectionInfo().isInsecure()).useSystemProperties().build());
        this.restDataspaceUrl = this.restDataspaceUrl(restServerUrl);
        this.sessionId = client.getSession();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Error : trying to retrieve session from disconnected client.");
        }
        this.schedulerClient = client;
    }

    public void init(ConnectionInfo connectionInfo) throws Exception {
        ISchedulerClient client = SchedulerClient.createInstance();
        client.init(connectionInfo);
        this.init(connectionInfo.getUrl(), client);
    }

    @Override
    public boolean upload(final IDataSpaceClient.ILocalSource source, IDataSpaceClient.IRemoteDestination destination) throws NotConnectedException, PermissionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Uploading from " + source + " to " + destination));
        }
        StringBuffer uriTmpl = new StringBuffer().append(this.restDataspaceUrl).append(destination.getDataspace().value());
        ResteasyClient client = new ResteasyClientBuilder().httpEngine(this.httpEngine).build();
        ResteasyWebTarget target = client.target(uriTmpl.toString()).path(destination.getPath());
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)this.sessionId).put(Entity.entity((Object)new StreamingOutput(){

                public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                    source.writeTo(outputStream);
                }
            }, (Variant)new Variant(MediaType.APPLICATION_OCTET_STREAM_TYPE, (Locale)null, source.getEncoding())));
            if (response.getStatus() != 201) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedException("User not authenticated or session timeout.");
                }
                throw new RuntimeException("File upload failed. Status code:" + response.getStatus());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Upload from " + source + " to " + destination + " performed with success"));
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(IDataSpaceClient.IRemoteSource source) throws NotConnectedException, PermissionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to create file " + source));
        }
        StringBuffer uriTmpl = new StringBuffer().append(this.restDataspaceUrl).append(source.getDataspace().value());
        ResteasyClient client = new ResteasyClientBuilder().httpEngine(this.httpEngine).build();
        ResteasyWebTarget target = client.target(uriTmpl.toString()).path(source.getPath());
        try (Response response = null;){
            Invocation.Builder request = target.request();
            request.header("sessionid", (Object)this.sessionId);
            Form form = new Form();
            form.param("mimetype", source.getType().getMimeType());
            response = request.post(Entity.form((Form)form));
            if (response.getStatus() != 200) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedException("User not authenticated or session timeout.");
                }
                throw new RuntimeException("Cannot create file(s). Status code:" + response.getStatus());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("File creation " + source + " performed with success"));
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean download(IDataSpaceClient.IRemoteSource source, IDataSpaceClient.ILocalDestination destination) throws NotConnectedException, PermissionException {
        List<String> excludes;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Downloading from " + source + " to " + destination));
        }
        StringBuffer uriTmpl = new StringBuffer().append(this.restDataspaceUrl).append(source.getDataspace().value());
        ResteasyClient client = new ResteasyClientBuilder().httpEngine(this.httpEngine).build();
        ResteasyWebTarget target = client.target(uriTmpl.toString()).path(source.getPath());
        List<String> includes = source.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            target = target.queryParam("includes", includes.toArray(new Object[includes.size()]));
        }
        if ((excludes = source.getExcludes()) != null && !excludes.isEmpty()) {
            target = target.queryParam("excludes", excludes.toArray(new Object[excludes.size()]));
        }
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)this.sessionId).acceptEncoding(new String[]{"*", "gzip", "zip"}).get();
            if (response.getStatus() != 200) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedException("User not authenticated or session timeout.");
                }
                throw new RuntimeException(String.format("Cannot retrieve the file. Status code: %s", response.getStatus()));
            }
            if (!response.hasEntity()) {
                throw new RuntimeException(String.format("%s in %s is empty.", new Object[]{source.getDataspace(), source.getPath()}));
            }
            InputStream is22 = (InputStream)response.readEntity(InputStream.class);
            destination.readFrom(is22, response.getHeaderString("Content-Encoding"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Download from " + source + " to " + destination + " performed with success"));
            }
            boolean is22 = true;
            return is22;
        }
    }

    @Override
    public RemoteSpace getGlobalSpace() {
        return new RestRemoteSpace(IDataSpaceClient.Dataspace.GLOBAL);
    }

    @Override
    public RemoteSpace getUserSpace() {
        return new RestRemoteSpace(IDataSpaceClient.Dataspace.USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFile list(IDataSpaceClient.IRemoteSource source) throws NotConnectedException, PermissionException {
        List<String> excludes;
        StringBuffer uriTmpl = new StringBuffer().append(this.restDataspaceUrl).append(source.getDataspace().value());
        ResteasyClient client = new ResteasyClientBuilder().httpEngine(this.httpEngine).build();
        ResteasyWebTarget target = client.target(uriTmpl.toString()).path(source.getPath()).queryParam("comp", new Object[]{"list"});
        List<String> includes = source.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            target = target.queryParam("includes", includes.toArray(new Object[includes.size()]));
        }
        if ((excludes = source.getExcludes()) != null && !excludes.isEmpty()) {
            target = target.queryParam("excludes", excludes.toArray(new Object[excludes.size()]));
        }
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)this.sessionId).get();
            if (response.getStatus() != 200) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedException("User not authenticated or session timeout.");
                }
                throw new RuntimeException(String.format("Cannot list the specified location: %s", source.getPath()));
            }
            ListFile listFile = (ListFile)response.readEntity(ListFile.class);
            return listFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(IDataSpaceClient.IRemoteSource source) throws NotConnectedException, PermissionException {
        List<String> excludes;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to delete " + source));
        }
        StringBuffer uriTmpl = new StringBuffer().append(this.restDataspaceUrl).append(source.getDataspace().value());
        ResteasyClient client = new ResteasyClientBuilder().httpEngine(this.httpEngine).build();
        ResteasyWebTarget target = client.target(uriTmpl.toString()).path(source.getPath());
        List<String> includes = source.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            target = target.queryParam("includes", includes.toArray(new Object[includes.size()]));
        }
        if ((excludes = source.getExcludes()) != null && !excludes.isEmpty()) {
            target = target.queryParam("excludes", excludes.toArray(new Object[excludes.size()]));
        }
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)this.sessionId).delete();
            boolean noContent = false;
            if (response.getStatus() != 204) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedException("User not authenticated or session timeout.");
                }
                throw new RuntimeException("Cannot delete file(s). Status :" + response.getStatusInfo() + " Entity : " + response.getEntity());
            }
            noContent = true;
            log.debug((Object)("No action performed for deletion since source " + source + " was not found remotely"));
            if (!noContent && log.isDebugEnabled()) {
                log.debug((Object)("Removal of " + source + " performed with success"));
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> metadata(IDataSpaceClient.IRemoteSource source) throws NotConnectedException, PermissionException {
        StringBuffer uriTmpl = new StringBuffer().append(this.restDataspaceUrl).append(source.getDataspace().value());
        ResteasyClient client = new ResteasyClientBuilder().httpEngine(this.httpEngine).build();
        ResteasyWebTarget target = client.target(uriTmpl.toString()).path(source.getPath());
        try (Response response = null;){
            response = target.request().header("sessionid", (Object)this.sessionId).head();
            if (response.getStatus() != 200) {
                if (response.getStatus() == 401) {
                    throw new NotConnectedException("User not authenticated or session timeout.");
                }
                throw new RuntimeException(String.format("Cannot get metadata from %s in '%s' dataspace.", new Object[]{source.getPath(), source.getDataspace()}));
            }
            MultivaluedMap headers = response.getHeaders();
            HashMap metaMap = Maps.newHashMap();
            if (headers.containsKey((Object)"Last-Modified")) {
                metaMap.put("Last-Modified", String.valueOf(headers.getFirst((Object)"Last-Modified")));
            }
            HashMap hashMap = metaMap;
            return hashMap;
        }
    }

    private String restDataspaceUrl(String restServerUrl) {
        return new StringBuffer().append(restServerUrl).append(restServerUrl.endsWith("/") ? "" : "/").append("data/").toString();
    }

    class RestRemoteSpace
    implements RemoteSpace {
        IDataSpaceClient.Dataspace space;

        public RestRemoteSpace(IDataSpaceClient.Dataspace space) {
            this.space = space;
        }

        public List<String> listFiles(String remotePath, String pattern) throws FileSystemException {
            RemoteSource source = new RemoteSource(this.space, remotePath);
            source.setIncludes(pattern);
            return this.findFiles(source);
        }

        private List<String> findFiles(RemoteSource source) throws FileSystemException {
            LinkedList<String> answer = new LinkedList<String>();
            try {
                ListFile listFiles = DataSpaceClient.this.list(source);
                for (String fileOrDirectory : listFiles.getFullListing()) {
                    answer.add(fileOrDirectory);
                }
                return answer;
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }

        public void pushFile(File localPath, String remotePath) throws FileSystemException {
            if (!localPath.exists()) {
                throw new FileSystemException("" + localPath + " does not exist");
            }
            IDataSpaceClient.ILocalSource source = localPath.isDirectory() ? new LocalDirSource(localPath) : new LocalFileSource(localPath);
            try {
                DataSpaceClient.this.upload(source, new RemoteDestination(this.space, remotePath));
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }

        public void pushFiles(File localDirectory, String pattern, String remotePath) throws FileSystemException {
            if (!localDirectory.exists()) {
                throw new FileSystemException("" + localDirectory + " does not exist");
            }
            if (!localDirectory.isDirectory()) {
                throw new FileSystemException("" + localDirectory + " is not a directory");
            }
            LocalDirSource source = new LocalDirSource(localDirectory);
            source.setIncludes(pattern);
            try {
                DataSpaceClient.this.upload(source, new RemoteDestination(this.space, remotePath));
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }

        public File pullFile(String remotePath, File localPath) throws FileSystemException {
            RemoteSource source = new RemoteSource(this.space, remotePath);
            LocalDestination dest = new LocalDestination(localPath);
            try {
                DataSpaceClient.this.download(source, dest);
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
            if (!localPath.exists()) {
                throw new IllegalStateException("File not present after download : " + localPath);
            }
            return localPath;
        }

        public Set<File> pullFiles(String remotePath, String pattern, File localPath) throws FileSystemException {
            RemoteSource source = new RemoteSource(this.space, remotePath);
            source.setIncludes(pattern);
            LocalDestination dest = new LocalDestination(localPath);
            try {
                DataSpaceClient.this.download(source, dest);
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
            LinkedHashSet<File> answer = new LinkedHashSet<File>();
            try {
                for (Path foundFile : Files.newDirectoryStream(localPath.toPath(), pattern)) {
                    answer.add(foundFile.toFile());
                }
            }
            catch (IOException e) {
                throw new FileSystemException((Throwable)e);
            }
            return answer;
        }

        public void deleteFile(String remotePath) throws FileSystemException {
            RemoteSource source = new RemoteSource(this.space, remotePath);
            try {
                DataSpaceClient.this.delete(source);
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }

        public void deleteFiles(String remotePath, String pattern) throws FileSystemException {
            RemoteSource source = new RemoteSource(this.space, remotePath);
            source.setIncludes(pattern);
            try {
                DataSpaceClient.this.delete(source);
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }

        public List<String> getSpaceURLs() throws FileSystemException {
            if (this.space == IDataSpaceClient.Dataspace.GLOBAL) {
                try {
                    return DataSpaceClient.this.schedulerClient.getGlobalSpaceURIs();
                }
                catch (Exception e) {
                    throw new FileSystemException((Throwable)e);
                }
            }
            try {
                return DataSpaceClient.this.schedulerClient.getUserSpaceURIs();
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }

        public InputStream getInputStream(String remotePath) throws FileSystemException {
            throw new UnsupportedOperationException();
        }

        public OutputStream getOutputStream(String remotePath) throws FileSystemException {
            throw new UnsupportedOperationException();
        }
    }
}

