/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.opencv.core.CvType;
import org.opencv.imgproc.Imgproc;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.natives.Mat;
import org.sikuli.natives.Vision;
import org.sikuli.script.ImageGroup;
import org.sikuli.script.ImagePath;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.TextRecognizer;

public class Image {
    static RunTime runTime = RunTime.get();
    private static String me = "Image: ";
    private static int lvl = 3;
    private static List<Image> images = Collections.synchronizedList(new ArrayList());
    private static Map<URL, Image> imageFiles = Collections.synchronizedMap(new HashMap());
    private static Map<String, URL> imageNames = Collections.synchronizedMap(new HashMap());
    private static int KB = 1024;
    private static int MB = KB * KB;
    private static final String isBImg = "__BufferedImage__";
    private static long currentMemory = 0L;
    private String imageName = null;
    private URL fileURL = null;
    private String imageAsFile = null;
    private BufferedImage bimg = null;
    private int bsize = 0;
    private int bwidth = -1;
    private int bheight = -1;
    private ImageGroup group = null;
    private boolean imageIsText = false;
    private boolean imageIsAbsolute = false;
    private boolean imageIsBundled = false;
    private boolean imageIsPattern = false;
    private int waitAfter;
    private Location offset = new Location(0, 0);
    private float similarity = (float)Settings.MinSimilarity;
    private Rectangle lastSeen = null;
    private double lastScore = 0.0;
    private boolean beSilent = false;
    private int rows = 0;
    private int cols = 0;
    private int rowH = 0;
    private int colW = 0;
    private int rowHd = 0;
    private int colWd = 0;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private static synchronized long currentMemoryChange(long size, long max) {
        long maxMemory = max;
        if (max < 0L) {
            maxMemory = Settings.getImageCache() * MB;
            currentMemory += size;
        }
        if (currentMemory > maxMemory) {
            while (images.size() > 0 && currentMemory > maxMemory) {
                Image first = images.remove(0);
                first.bimg = null;
                currentMemory -= (long)first.bsize;
            }
            currentMemory = maxMemory == 0L ? 0L : Math.max(0L, currentMemory);
        }
        if (size < 0L) {
            currentMemory = Math.max(0L, currentMemory);
        }
        return currentMemory;
    }

    private static long currentMemoryUp(long size) {
        return Image.currentMemoryChange(size, -1L);
    }

    private static long currentMemoryDown(long size) {
        currentMemory -= size;
        currentMemory = Math.max(0L, currentMemory);
        return Image.currentMemoryChange(-size, -1L);
    }

    private static long currentMemoryDownUp(int sizeOld, int sizeNew) {
        Image.currentMemoryDown(sizeOld);
        return Image.currentMemoryUp(sizeNew);
    }

    private static boolean isCaching() {
        return Settings.getImageCache() > 0;
    }

    public static void clearCache(int maxSize) {
        Image.currentMemoryChange(0L, maxSize);
    }

    public static void reload(String fpImage) {
        URL uImage = FileManager.makeURL(fpImage);
        if (imageFiles.containsKey(uImage)) {
            Image image = imageFiles.get(uImage);
            int sizeOld = image.bsize;
            if (null != image.loadAgain()) {
                Image.currentMemoryDownUp(sizeOld, image.bsize);
            }
        }
    }

    public String getImageName() {
        return this.imageName;
    }

    public Image setImageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public Image setFileURL(URL fileURL) {
        this.fileURL = fileURL;
        return this;
    }

    protected Image setBimg(BufferedImage bimg) {
        this.bimg = bimg;
        if (bimg != null) {
            this.bwidth = bimg.getWidth();
            this.bheight = bimg.getHeight();
            this.bsize = bimg.getData().getDataBuffer().getSize();
        } else {
            this.bsize = 0;
            this.bwidth = -1;
            this.bheight = -1;
        }
        return this;
    }

    public boolean isText() {
        return this.imageIsText;
    }

    public Image setIsText(boolean val) {
        this.imageIsText = val;
        return this;
    }

    public boolean isAbsolute() {
        return this.imageIsAbsolute;
    }

    public Image setIsAbsolute(boolean val) {
        this.imageIsAbsolute = val;
        return this;
    }

    public Image setIsBundled(boolean imageIsBundled) {
        this.imageIsBundled = imageIsBundled;
        return this;
    }

    public boolean isBundled() {
        return this.imageIsBundled;
    }

    public boolean isPattern() {
        return this.imageIsPattern;
    }

    public Image setIsPattern(boolean imageIsPattern) {
        this.imageIsPattern = imageIsPattern;
        return this;
    }

    public int getWaitAfter() {
        return this.waitAfter;
    }

    public Image setWaitAfter(int waitAfter) {
        this.waitAfter = waitAfter;
        return this;
    }

    public Location getOffset() {
        return this.offset;
    }

    public Image setOffset(Location offset) {
        this.offset = offset;
        return this;
    }

    public float getSimilarity() {
        return this.similarity;
    }

    public Image setSimilarity(float similarity) {
        this.similarity = similarity;
        return this;
    }

    public Rectangle getLastSeen() {
        return this.lastSeen;
    }

    public double getLastSeenScore() {
        return this.lastScore;
    }

    protected Image setLastSeen(Rectangle lastSeen, double sim) {
        this.lastSeen = lastSeen;
        this.lastScore = sim;
        if (this.group != null) {
            this.group.addImageFacts(this, lastSeen, sim);
        }
        return this;
    }

    public String toString() {
        return String.format((this.imageName != null ? this.imageName : "__UNKNOWN__") + ": (%dx%d)", this.bwidth, this.bheight) + (this.lastSeen == null ? "" : String.format(" seen at (%d, %d) with %.2f", this.lastSeen.x, this.lastSeen.y, this.lastScore));
    }

    private Image() {
    }

    private Image(String fname, URL fURL) {
        this.init(fname, fURL, true);
    }

    private Image(String fname, URL fURL, boolean silent) {
        this.init(fname, fURL, silent);
    }

    private void init(String fileName, URL fURL, boolean silent) {
        this.imageName = fileName;
        if (this.imageName.isEmpty() || fURL == null) {
            return;
        }
        this.fileURL = fURL;
        if (ImagePath.isImageBundled(fURL)) {
            this.imageIsBundled = true;
            this.imageName = new File(this.imageName).getName();
        }
        this.beSilent = silent;
        this.load();
    }

    private BufferedImage load() {
        BufferedImage bImage = null;
        if (this.fileURL != null) {
            this.bimg = null;
            try {
                bImage = ImageIO.read(this.fileURL);
            }
            catch (Exception e) {
                if (!this.beSilent) {
                    Image.log(-1, "could not be loaded: %s", this.fileURL);
                }
                this.fileURL = null;
                return null;
            }
            if (this.imageName != null) {
                if (!imageFiles.containsKey(this.fileURL)) {
                    imageFiles.put(this.fileURL, this);
                    imageNames.put(this.imageName, this.fileURL);
                    this.bwidth = bImage.getWidth();
                    this.bheight = bImage.getHeight();
                    this.bsize = bImage.getData().getDataBuffer().getSize();
                }
                Image.log(lvl, "loaded: %s (%s)", this.imageName, this.fileURL);
                if (Image.isCaching()) {
                    int maxMemory = Settings.getImageCache() * MB;
                    Image.currentMemoryUp(this.bsize);
                    this.bimg = bImage;
                    images.add(this);
                    Image.log(lvl, "cached: %s (%d KB) (# %d KB %d -- %d %% of %d MB)", this.imageName, this.getKB(), images.size(), (int)(currentMemory / (long)KB), (int)(100L * currentMemory / (long)maxMemory), maxMemory / MB);
                }
            } else {
                Image.log(-1, "invalid! not loaded! %s", this.fileURL);
            }
        }
        return bImage;
    }

    private BufferedImage loadAgain() {
        BufferedImage bImage = null;
        if (this.fileURL != null) {
            this.bimg = null;
            try {
                bImage = ImageIO.read(this.fileURL);
            }
            catch (Exception e) {
                if (!this.beSilent) {
                    Image.log(-1, "could not be loaded again: %s", this.fileURL);
                }
                imageFiles.remove(this.fileURL);
                return null;
            }
            imageFiles.put(this.fileURL, this);
            imageNames.put(this.imageName, this.fileURL);
            this.bwidth = bImage.getWidth();
            this.bheight = bImage.getHeight();
            this.bsize = bImage.getData().getDataBuffer().getSize();
            Image.log(lvl, "loaded again: %s (%s)", this.imageName, this.fileURL);
        }
        return bImage;
    }

    private Image copy() {
        Image imgTarget = new Image();
        imgTarget.setImageName(this.imageName);
        imgTarget.setFileURL(this.fileURL);
        imgTarget.setBimg(this.bimg);
        imgTarget.setGroup(this.group);
        imgTarget.setIsAbsolute(this.imageIsAbsolute);
        imgTarget.setIsText(this.imageIsText);
        imgTarget.setIsBundled(this.imageIsBundled);
        imgTarget.setLastSeen(this.getLastSeen(), this.getLastSeenScore());
        if (this.isPattern()) {
            imgTarget.setSimilarity(this.similarity);
            imgTarget.setOffset(this.offset);
            imgTarget.setWaitAfter(this.waitAfter);
            imgTarget.setIsPattern(true);
        }
        return imgTarget;
    }

    public static Image create(Image imgSrc) {
        return imgSrc.copy();
    }

    public static Image create(String fName) {
        Image img = Image.get(fName, false);
        return Image.createImageValidate(img, true);
    }

    public static Image create(Pattern p) {
        Image img = p.getImage().copy();
        img.setIsPattern(true);
        img.setSimilarity(p.getSimilar());
        img.setOffset(p.getTargetOffset());
        img.setWaitAfter(p.getTimeAfter());
        return img;
    }

    public static Image create(URL url) {
        Image img = Image.get(url);
        if (img == null) {
            img = new Image(url);
        }
        return Image.createImageValidate(img, true);
    }

    protected static Image createFromObject(Object obj) {
        if (obj instanceof String) {
            return Image.create((String)obj);
        }
        if (obj instanceof Image) {
            return (Image)obj;
        }
        if (obj instanceof Pattern) {
            return Image.create((Pattern)obj);
        }
        return new Image();
    }

    public static Image createThumbNail(String fName) {
        Image img = Image.get(fName, true);
        return Image.createImageValidate(img, false);
    }

    private static Image createImageValidate(Image img, boolean verbose) {
        if (img == null) {
            Image.log(-1, "Image not valid, creating empty Image", new Object[0]);
            return new Image("", null);
        }
        if (!img.isValid()) {
            if (Settings.OcrTextSearch) {
                img.setIsText(true);
            } else if (verbose) {
                Image.log(-1, "Image not valid, but TextSearch is switched off!", new Object[0]);
            }
        }
        return img;
    }

    public String asFile() {
        if (this.imageAsFile == null && this.bimg != null) {
            this.imageAsFile = FileManager.saveTmpImage(this.bimg);
        }
        return this.imageAsFile;
    }

    protected static Image get(String fName) {
        return Image.get(fName, false);
    }

    private static Image get(String fName, boolean silent) {
        File imgFile;
        if (fName == null || fName.isEmpty()) {
            return null;
        }
        fName = FileManager.slashify(fName, false);
        Image img = null;
        URL fURL = null;
        String fileName = Settings.getValidImageFilename(fName);
        if (fileName.isEmpty()) {
            Image.log(-1, "not a valid image type: " + fName, new Object[0]);
            fileName = fName;
        }
        if ((imgFile = new File(fileName)).isAbsolute()) {
            if (imgFile.exists()) {
                fURL = FileManager.makeURL(fileName);
            }
        } else {
            fURL = imageNames.get(fileName);
            if (fURL == null) {
                fURL = ImagePath.find(fileName);
            }
        }
        if (fURL != null && (img = imageFiles.get(fURL)) != null && null == imageNames.get(img.imageName)) {
            imageNames.put(img.imageName, fURL);
        }
        if (img == null) {
            img = new Image(fileName, fURL, silent);
            img.setIsAbsolute(imgFile.isAbsolute());
        } else if (img.bimg != null) {
            Image.log(3, "reused: %s (%s)", img.imageName, img.fileURL);
        } else if (Settings.getImageCache() > 0) {
            img.load();
        }
        return img;
    }

    protected static Image get(URL imgURL) {
        return imageFiles.get(imgURL);
    }

    private Image(URL fURL) {
        if ("file".equals(fURL.getProtocol())) {
            this.init(fURL.getPath(), fURL, true);
        } else {
            this.init(Image.getNameFromURL(fURL), fURL, true);
        }
    }

    private static String getNameFromURL(URL fURL) {
        if ("jar".equals(fURL.getProtocol())) {
            int n = fURL.getPath().lastIndexOf(".jar!/");
            int k = fURL.getPath().substring(0, n).lastIndexOf("/");
            if (n > -1) {
                return "JAR:" + fURL.getPath().substring(k + 1, n) + fURL.getPath().substring(n + 5);
            }
        }
        return "???:" + fURL.getPath();
    }

    public Image(BufferedImage img) {
        this(img, null);
    }

    public Image(BufferedImage img, String name) {
        this.imageName = isBImg;
        if (name != null) {
            this.imageName = this.imageName + name;
        }
        this.bimg = img;
        this.bwidth = this.bimg.getWidth();
        this.bheight = this.bimg.getHeight();
        Image.log(lvl, "BufferedImage: (%d, %d)%s", this.bwidth, this.bheight, name == null ? "" : " with name: " + name);
    }

    public Image(ScreenImage img) {
        this(img.getImage(), null);
    }

    public Image(ScreenImage img, String name) {
        this(img.getImage(), name);
    }

    public static void purge(String bundlePath) {
        if (imageFiles.isEmpty() || ImagePath.getPaths().get(0) == null) {
            return;
        }
        URL pathURL = FileManager.makeURL(bundlePath);
        if (!ImagePath.getPaths().get((int)0).pathURL.equals(pathURL)) {
            Image.log(-1, "purge: not current bundlepath: " + pathURL, new Object[0]);
            return;
        }
        Image.purge(pathURL);
    }

    protected static void purge(ImagePath.PathEntry path) {
        if (path == null) {
            return;
        }
        Image.purge(path.pathURL);
    }

    protected static synchronized void purge(URL pathURL) {
        Image img;
        ArrayList<Image> imagePurgeList = new ArrayList<Image>();
        ArrayList<String> imageNamePurgeList = new ArrayList<String>();
        Image.log(lvl, "purge: ImagePath: %s", pathURL.getPath());
        Iterator<Map.Entry<URL, Image>> it = imageFiles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<URL, Image> entry = it.next();
            URL imgURL = entry.getKey();
            if (!imgURL.toString().startsWith(pathURL.toString())) continue;
            Image.log(lvl + 1, "purge: URL: %s", imgURL.toString());
            img = entry.getValue();
            imagePurgeList.add(img);
            imageNamePurgeList.add(img.imageName);
            it.remove();
        }
        if (!imagePurgeList.isEmpty()) {
            Iterator<Image> bit = images.iterator();
            while (bit.hasNext()) {
                img = bit.next();
                if (!imagePurgeList.contains(img)) continue;
                bit.remove();
                Image.log(lvl + 1, "purge: bimg: %s", img);
                Image.currentMemoryDown(img.bsize);
            }
        }
        for (String name : imageNamePurgeList) {
            imageNames.remove(name);
        }
    }

    public static void unCacheBundledImage(String imgFileName) {
        URL imgURL = FileManager.makeURL(new File(imgFileName).getAbsolutePath());
        Image.unCacheImage(imgURL);
    }

    public static void unCacheImage(URL imgURL) {
        Image img = imageFiles.get(imgURL);
        if (img == null) {
            return;
        }
        img.bimg = null;
        images.remove(img);
    }

    public static void dump() {
        Image.dump(0);
    }

    public static void dump(int lvl) {
        Image.log(lvl, "--- start of Image dump ---", new Object[0]);
        ImagePath.dump(lvl);
        Image.log(lvl, "ImageFiles entries: %d", imageFiles.size());
        for (Map.Entry<URL, Image> entry : imageFiles.entrySet()) {
            Image.log(lvl, entry.getKey().toString(), new Object[0]);
        }
        Image.log(lvl, "ImageNames entries: %d", imageNames.size());
        for (Map.Entry<String, URL> name : imageNames.entrySet()) {
            Image.log(lvl, "%s %d KB (%s)", new File(name.getKey()).getName(), imageFiles.get(name.getValue()).getKB(), name.getValue());
        }
        if (Settings.getImageCache() == 0) {
            Image.log(lvl, "Cache state: switched off!", new Object[0]);
        } else {
            Image.log(lvl, "Cache state: Max %d MB (entries: %d  used: %d %% %d KB)", Settings.getImageCache(), images.size(), (int)(100L * currentMemory / (long)(Settings.getImageCache() * MB)), (int)(currentMemory / (long)KB));
        }
        Image.log(lvl, "--- end of Image dump ---", new Object[0]);
    }

    public static void reset() {
        Image.clearCache(0);
        imageNames.clear();
        imageFiles.clear();
    }

    public String getName() {
        return this.imageName;
    }

    public ImageGroup getGroup() {
        return this.group;
    }

    public void setGroup(ImageGroup group) {
        this.group = group;
    }

    public boolean isValid() {
        return this.fileURL != null || this.imageName.contains(isBImg);
    }

    public boolean isUseable() {
        return this.isValid() || this.imageIsPattern;
    }

    public URL getURL() {
        return this.fileURL;
    }

    public String getFilename() {
        if (this.fileURL != null && "file".equals(this.fileURL.getProtocol())) {
            return new File(this.fileURL.getPath()).getAbsolutePath();
        }
        return this.imageName;
    }

    public BufferedImage get() {
        if (this.bimg != null) {
            if (this.fileURL == null) {
                Image.log(lvl + 1, "getImage inMemory: %s", this.imageName);
            } else {
                Image.log(lvl + 1, "getImage from cache: %s", this.imageName);
            }
            return this.bimg;
        }
        return this.load();
    }

    public Dimension getSize() {
        return new Dimension(this.bwidth, this.bheight);
    }

    private int getKB() {
        if (this.bimg == null) {
            return 0;
        }
        return this.bsize / KB;
    }

    public BufferedImage resize(float factor) {
        BufferedImage bufimg = this.get();
        int type = bufimg.getType() == 0 ? 2 : bufimg.getType();
        int width = (int)(this.getSize().getWidth() * (double)factor);
        int height = (int)(this.getSize().getHeight() * (double)factor);
        BufferedImage resizedImage = new BufferedImage(width, height, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(bufimg, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    public Image getSub(int x, int y, int w, int h) {
        BufferedImage bi = Image.createBufferedImage(w, h);
        Graphics2D g = bi.createGraphics();
        g.drawImage((java.awt.Image)this.get().getSubimage(x, y, w, h), 0, 0, null);
        g.dispose();
        return new Image(bi);
    }

    public Image getSub(int part) {
        Rectangle r = Region.getRectangle(new Rectangle(0, 0, this.getSize().width, this.getSize().height), part);
        return this.getSub(r.x, r.y, r.width, r.height);
    }

    public Image setRows(int n) {
        return this.setRaster(n, 0);
    }

    public Image setCols(int n) {
        return this.setRaster(0, n);
    }

    public int getRows() {
        return this.rows;
    }

    public int getRowH() {
        return this.rowH;
    }

    public int getCols() {
        return this.cols;
    }

    public int getColW() {
        return this.colW;
    }

    public Image setRaster(int r, int c) {
        this.rows = r;
        this.cols = c;
        if (r > 0) {
            this.rowH = this.getSize().height / r;
            this.rowHd = this.getSize().height - r * this.rowH;
        }
        if (c > 0) {
            this.colW = this.getSize().width / c;
            this.colWd = this.getSize().width - c * this.colW;
        }
        return this.getCell(0, 0);
    }

    public Image getRow(int r) {
        if (this.rows == 0) {
            return this;
        }
        if (r < 0) {
            r = this.rows + r;
        }
        r = Math.max(0, r);
        r = Math.min(r, this.rows - 1);
        return this.getSub(0, r * this.rowH, this.getSize().width, this.rowH);
    }

    public Image getCol(int c) {
        if (this.cols == 0) {
            return this;
        }
        if (c < 0) {
            c = this.cols + c;
        }
        c = Math.max(0, c);
        c = Math.min(c, this.cols - 1);
        return this.getSub(c * this.colW, 0, this.colW, this.getSize().height);
    }

    public Image getCell(int r, int c) {
        if (this.rows == 0) {
            return this.getCol(c);
        }
        if (this.cols == 0) {
            return this.getRow(r);
        }
        if (this.rows == 0 && this.cols == 0) {
            return this;
        }
        if (r < 0) {
            r = this.rows - r;
        }
        if (c < 0) {
            c = this.cols - c;
        }
        r = Math.max(0, r);
        r = Math.min(r, this.rows - 1);
        c = Math.max(0, c);
        c = Math.min(c, this.cols - 1);
        return this.getSub(c * this.colW, r * this.rowH, this.colW, this.rowH);
    }

    public org.opencv.core.Mat getMat() {
        return Image.createMat(this.get());
    }

    protected static org.opencv.core.Mat createMat(BufferedImage img) {
        if (img != null) {
            Debug timer = Debug.startTimer("Mat create\t (%d x %d) from \n%s", img.getWidth(), img.getHeight(), img);
            org.opencv.core.Mat mat_ref = new org.opencv.core.Mat(img.getHeight(), img.getWidth(), CvType.CV_8UC4);
            timer.lap("init");
            ColorSpace cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8, 8};
            ComponentColorModel cm = new ComponentColorModel(cs, nBits, true, false, 3, 0);
            SampleModel sm = ((ColorModel)cm).createCompatibleSampleModel(img.getWidth(), img.getHeight());
            DataBufferByte db = new DataBufferByte(img.getWidth() * img.getHeight() * 4);
            WritableRaster r = WritableRaster.createWritableRaster(sm, db, new Point(0, 0));
            BufferedImage cvImg = new BufferedImage(cm, r, false, null);
            timer.lap("empty");
            Graphics2D g = cvImg.createGraphics();
            g.drawImage((java.awt.Image)img, 0, 0, null);
            g.dispose();
            timer.lap("created");
            byte[] data = ((DataBufferByte)cvImg.getRaster().getDataBuffer()).getData();
            mat_ref.put(0, 0, data);
            org.opencv.core.Mat mat = new org.opencv.core.Mat();
            timer.lap("filled");
            Imgproc.cvtColor(mat_ref, mat, 3, 3);
            timer.end();
            return mat;
        }
        return null;
    }

    @Deprecated
    protected Mat getMatNative() {
        return Image.convertBufferedImageToMat(this.get());
    }

    protected static Mat convertBufferedImageToMat(BufferedImage img) {
        if (img != null) {
            long theMatTime = new Date().getTime();
            byte[] data = Image.convertBufferedImageToByteArray(img);
            Mat theMat = Vision.createMat(img.getHeight(), img.getWidth(), data);
            if (Settings.FindProfiling) {
                Debug.logp("[FindProfiling] createCVMat [%d x %d]: %d msec", img.getWidth(), img.getHeight(), new Date().getTime() - theMatTime);
            }
            return theMat;
        }
        return null;
    }

    protected static byte[] convertBufferedImageToByteArray(BufferedImage img) {
        if (img != null) {
            BufferedImage cvImg = Image.createBufferedImage(img.getWidth(), img.getHeight());
            Graphics2D g = cvImg.createGraphics();
            g.drawImage((java.awt.Image)img, 0, 0, null);
            g.dispose();
            return ((DataBufferByte)cvImg.getRaster().getDataBuffer()).getData();
        }
        return null;
    }

    protected static BufferedImage createBufferedImage(int w, int h) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, true, false, 3, 0);
        SampleModel sm = ((ColorModel)cm).createCompatibleSampleModel(w, h);
        DataBufferByte db = new DataBufferByte(w * h * 4);
        WritableRaster r = WritableRaster.createWritableRaster(sm, db, new Point(0, 0));
        BufferedImage bm = new BufferedImage(cm, r, false, null);
        return bm;
    }

    public static ByteBuffer convertImageData(BufferedImage bi) {
        DataBuffer buff = bi.getRaster().getDataBuffer();
        if (!(buff instanceof DataBufferByte)) {
            bi = Image.convertImageToGrayscale(bi);
            buff = bi.getRaster().getDataBuffer();
        }
        byte[] pixelData = ((DataBufferByte)buff).getData();
        ByteBuffer buf = ByteBuffer.allocateDirect(pixelData.length);
        buf.order(ByteOrder.nativeOrder());
        buf.put(pixelData);
        buf.flip();
        return buf;
    }

    public static BufferedImage convertImageToGrayscale(BufferedImage image) {
        BufferedImage tmp = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        Graphics2D g2 = tmp.createGraphics();
        g2.drawImage((java.awt.Image)image, 0, 0, null);
        g2.dispose();
        return tmp;
    }

    public Match find(Image img) {
        Image.log(-1, "find: not implemented yet", new Object[0]);
        return null;
    }

    public Iterator<Match> findAll(Image img) {
        Image.log(-1, "findAll: not implemented yet", new Object[0]);
        return null;
    }

    public String text() {
        if (Settings.OcrTextRead) {
            TextRecognizer tr = TextRecognizer.getInstance();
            if (tr == null) {
                Debug.error("text: text recognition is now switched off", new Object[0]);
                return null;
            }
            String textRead = tr.recognize(this.get());
            Image.log(lvl, "text: #(" + textRead + ")#", new Object[0]);
            return textRead;
        }
        Debug.error("text: text recognition is currently switched off", new Object[0]);
        return null;
    }

    public static String text(String imgFile) {
        return Image.create(imgFile).text();
    }
}

