/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.sikuli.basics.Settings;
import org.sikuli.script.RunTime;

public class VDictProxy<T> {
    private long _instance;
    private Map<Integer, T> _i2obj = new HashMap<Integer, T>();

    public VDictProxy() {
        this._instance = this.getInstance();
    }

    private native long getInstance();

    private String getAbsolutePath(String filename) throws FileNotFoundException {
        if (new File(filename).exists()) {
            return filename;
        }
        filename = Settings.BundlePath + File.separator + filename;
        if (new File(filename).exists()) {
            return filename;
        }
        throw new FileNotFoundException("No such file: " + filename);
    }

    public void insert(String imagekey_filename, T value) throws FileNotFoundException {
        imagekey_filename = this.getAbsolutePath(imagekey_filename);
        int hash = value.hashCode();
        while (true) {
            if (hash != -1 && !this._i2obj.containsKey(hash)) break;
            hash += (int)(Math.random() * 100.0);
        }
        this._i2obj.put(hash, value);
        this._insert(this._instance, imagekey_filename, hash);
    }

    public native void _insert(long var1, String var3, int var4);

    public T lookup(String imagekey_filename) throws FileNotFoundException {
        int hash = this._lookup(this._instance, imagekey_filename = this.getAbsolutePath(imagekey_filename));
        if (hash == -1) {
            return null;
        }
        return this._i2obj.get(hash);
    }

    private native int _lookup(long var1, String var3);

    public T lookup_similar(String imagekey_filename, double similarity_threshold) throws FileNotFoundException {
        int hash = this._lookup_similar(this._instance, imagekey_filename = this.getAbsolutePath(imagekey_filename), similarity_threshold);
        if (hash == -1) {
            return null;
        }
        return this._i2obj.get(hash);
    }

    private native int _lookup_similar(long var1, String var3, double var4);

    public List<T> lookup_similar_n(String imagekey_filename, double similarity_threshold, int n) throws FileNotFoundException {
        imagekey_filename = this.getAbsolutePath(imagekey_filename);
        int[] h = this._lookup_similar_n(this._instance, imagekey_filename, similarity_threshold, n);
        Vector<T> ret = new Vector<T>(h.length);
        for (int i = 0; i < h.length; ++i) {
            if (h[i] == -1) {
                ret.add(i, null);
                continue;
            }
            ret.add(i, this._i2obj.get(h[i]));
        }
        return ret;
    }

    private native int[] _lookup_similar_n(long var1, String var3, double var4, int var6);

    public void erase(String imagekey_filename) throws FileNotFoundException {
        int h = this._lookup(this._instance, imagekey_filename = this.getAbsolutePath(imagekey_filename));
        if (h != -1) {
            this._i2obj.remove(h);
        }
        this._erase(this._instance, imagekey_filename);
    }

    private native void _erase(long var1, String var3);

    public int size() {
        return this._size(this._instance);
    }

    private native int _size(long var1);

    public boolean empty() {
        return this._empty(this._instance);
    }

    private native boolean _empty(long var1);

    static {
        RunTime.loadLibrary("VDictProxy");
    }
}

