/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.bridj.CLong;
import org.bridj.NativeConstants;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.SizeT;

class EllipsisHelper {
    static ThreadLocal<IntBuffer[]> holders = new ThreadLocal<IntBuffer[]>(){

        @Override
        protected IntBuffer[] initialValue() {
            return new IntBuffer[1];
        }
    };

    EllipsisHelper() {
    }

    public static IntBuffer unrollEllipsis(Object[] args) {
        IntBuffer[] holder = holders.get();
        int n = args.length;
        IntBuffer buf = holder[0];
        if (buf == null || buf.capacity() < n) {
            buf = ByteBuffer.allocateDirect(n * 4).asIntBuffer();
        }
        for (int i = 0; i < n; ++i) {
            NativeConstants.ValueType type;
            Object arg = args[i];
            if (arg == null || arg instanceof Pointer) {
                type = NativeConstants.ValueType.ePointerValue;
            } else if (arg instanceof Integer) {
                type = NativeConstants.ValueType.eIntValue;
            } else if (arg instanceof Long) {
                type = NativeConstants.ValueType.eLongValue;
            } else if (arg instanceof Short) {
                type = NativeConstants.ValueType.eShortValue;
            } else if (arg instanceof Double) {
                type = NativeConstants.ValueType.eDoubleValue;
            } else if (arg instanceof Float) {
                type = NativeConstants.ValueType.eFloatValue;
            } else if (arg instanceof Byte) {
                type = NativeConstants.ValueType.eByteValue;
            } else if (arg instanceof Boolean) {
                type = NativeConstants.ValueType.eBooleanValue;
            } else if (arg instanceof Character) {
                type = NativeConstants.ValueType.eWCharValue;
            } else if (arg instanceof SizeT) {
                type = NativeConstants.ValueType.eSizeTValue;
                args[i] = arg = Long.valueOf(((SizeT)arg).longValue());
            } else if (arg instanceof CLong) {
                type = NativeConstants.ValueType.eCLongValue;
                args[i] = arg = Long.valueOf(((CLong)arg).longValue());
            } else if (arg instanceof NativeObject) {
                type = NativeConstants.ValueType.eNativeObjectValue;
            } else {
                throw new IllegalArgumentException("Argument type not handled in variable argument calls  : " + arg + " (" + arg.getClass().getName() + ")");
            }
            buf.put(i, type.ordinal());
        }
        return buf;
    }
}

