/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.util.IO;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileFactory;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationExisting;
import ucar.nc2.ncml.AggregationExistingOne;
import ucar.nc2.ncml.AggregationFmrc;
import ucar.nc2.ncml.AggregationFmrcSingle;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.ncml.AggregationNew;
import ucar.nc2.ncml.AggregationUnion;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.NetworkUtils;
import ucar.unidata.util.StringUtil;

public class NcMLReader {
    public static final Namespace ncNS = Namespace.getNamespace((String)"nc", (String)"http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
    private static Logger log = LoggerFactory.getLogger(NcMLReader.class);
    private static boolean debugURL = false;
    private static boolean debugXML = false;
    private static boolean showParsedXML = false;
    private static boolean debugOpen = false;
    private static boolean debugConstruct = false;
    private static boolean debugCmd = false;
    private static boolean debugAggDetail = false;
    private static boolean validate = false;
    private boolean explicit = false;
    private boolean hasFatalError = false;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugURL = debugFlag.isSet("NcML/debugURL");
        debugXML = debugFlag.isSet("NcML/debugXML");
        showParsedXML = debugFlag.isSet("NcML/showParsedXML");
        debugCmd = debugFlag.isSet("NcML/debugCmd");
        debugOpen = debugFlag.isSet("NcML/debugOpen");
        debugConstruct = debugFlag.isSet("NcML/debugConstruct");
        debugAggDetail = debugFlag.isSet("NcML/debugAggDetail");
    }

    public static void wrapNcMLresource(NetcdfDataset ncDataset, String ncmlResourceLocation, CancelTask cancelTask) throws IOException {
        Document doc;
        ClassLoader cl = ncDataset.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(ncmlResourceLocation);
        if (is == null) {
            throw new FileNotFoundException(ncmlResourceLocation);
        }
        if (debugXML) {
            System.out.println(" NetcdfDataset URL = <" + ncmlResourceLocation + ">");
            InputStream is2 = cl.getResourceAsStream(ncmlResourceLocation);
            System.out.println(" contents=\n" + IO.readContents(is2));
        }
        try {
            SAXBuilder builder = new SAXBuilder(validate);
            if (debugURL) {
                System.out.println(" NetcdfDataset URL = <" + ncmlResourceLocation + ">");
            }
            doc = builder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element netcdfElem = doc.getRootElement();
        NcMLReader reader = new NcMLReader();
        reader.readNetcdf(ncDataset.getLocation(), ncDataset, ncDataset, netcdfElem, cancelTask);
        if (debugOpen) {
            System.out.println("***NcMLReader.wrapNcML result= \n" + ncDataset);
        }
    }

    public static void wrapNcML(NetcdfDataset ncDataset, String ncmlLocation, CancelTask cancelTask) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder(validate);
            if (debugURL) {
                System.out.println(" NetcdfDataset URL = <" + ncmlLocation + ">");
            }
            doc = builder.build(ncmlLocation);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element netcdfElem = doc.getRootElement();
        NcMLReader reader = new NcMLReader();
        reader.readNetcdf(ncmlLocation, ncDataset, ncDataset, netcdfElem, cancelTask);
        if (debugOpen) {
            System.out.println("***NcMLReader.wrapNcML result= \n" + ncDataset);
        }
    }

    public static NetcdfDataset readNcML(String ncmlLocation, CancelTask cancelTask) throws IOException {
        return NcMLReader.readNcML(ncmlLocation, (String)null, cancelTask);
    }

    public static NetcdfDataset readNcML(String ncmlLocation, String referencedDatasetUri, CancelTask cancelTask) throws IOException {
        Document doc;
        URL url = new URL(ncmlLocation);
        if (debugURL) {
            System.out.println(" NcMLReader open " + ncmlLocation);
            System.out.println("   URL = " + url.toString());
            System.out.println("   external form = " + url.toExternalForm());
            System.out.println("   protocol = " + url.getProtocol());
            System.out.println("   host = " + url.getHost());
            System.out.println("   path = " + url.getPath());
            System.out.println("  file = " + url.getFile());
        }
        try {
            SAXBuilder builder = new SAXBuilder(validate);
            if (debugURL) {
                System.out.println(" NetcdfDataset URL = <" + url + ">");
            }
            doc = builder.build(url);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element netcdfElem = doc.getRootElement();
        if (referencedDatasetUri == null && (referencedDatasetUri = netcdfElem.getAttributeValue("location")) == null) {
            referencedDatasetUri = netcdfElem.getAttributeValue("uri");
        }
        NcMLReader reader = new NcMLReader();
        NetcdfDataset ncd = reader.readNcML(ncmlLocation, referencedDatasetUri, netcdfElem, cancelTask);
        if (debugOpen) {
            System.out.println("***NcMLReader.readNcML result= \n" + ncd);
        }
        return ncd;
    }

    public static NetcdfDataset readNcML(InputStream ins, CancelTask cancelTask) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder(validate);
            doc = builder.build(ins);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element netcdfElem = doc.getRootElement();
        NetcdfDataset ncd = NcMLReader.readNcML(null, netcdfElem, cancelTask);
        if (debugOpen) {
            System.out.println("***NcMLReader.readNcML (stream) result= \n" + ncd);
        }
        return ncd;
    }

    public static NetcdfDataset readNcML(String ncmlLocation, Element netcdfElem, CancelTask cancelTask) throws IOException {
        String referencedDatasetUri = netcdfElem.getAttributeValue("location");
        if (referencedDatasetUri == null) {
            referencedDatasetUri = netcdfElem.getAttributeValue("uri");
        }
        NcMLReader reader = new NcMLReader();
        return reader.readNcML(ncmlLocation, referencedDatasetUri, netcdfElem, cancelTask);
    }

    private NetcdfDataset readNcML(String ncmlLocation, String referencedDatasetUri, Element netcdfElem, CancelTask cancelTask) throws IOException {
        NetcdfDataset targetDS;
        Element elemE;
        if ((referencedDatasetUri = NetworkUtils.resolve(ncmlLocation, referencedDatasetUri)) != null && referencedDatasetUri.equals(ncmlLocation)) {
            throw new IllegalArgumentException("NcML location attribute refers to the NcML document itself" + referencedDatasetUri);
        }
        String iospS = netcdfElem.getAttributeValue("iosp");
        String iospParam = netcdfElem.getAttributeValue("iospParam");
        String bufferSizeS = netcdfElem.getAttributeValue("buffer_size");
        int buffer_size = -1;
        if (bufferSizeS != null) {
            buffer_size = Integer.parseInt(bufferSizeS);
        }
        NetcdfDataset refds = null;
        if (referencedDatasetUri != null) {
            if (iospS != null) {
                NcMLNetcdfFile ncfile;
                try {
                    ncfile = new NcMLNetcdfFile(iospS, iospParam, referencedDatasetUri, buffer_size, cancelTask);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                refds = new NetcdfDataset((NetcdfFile)ncfile, false);
            } else {
                refds = NetcdfDataset.openDataset(referencedDatasetUri, false, buffer_size, cancelTask, (Object)iospParam);
            }
        }
        boolean bl = this.explicit = (elemE = netcdfElem.getChild("explicit", ncNS)) != null;
        if (this.explicit || refds == null) {
            targetDS = new NetcdfDataset();
            if (refds == null) {
                refds = targetDS;
            } else {
                targetDS.setReferencedFile(refds);
            }
        } else {
            targetDS = refds;
        }
        this.readNetcdf(ncmlLocation, targetDS, refds, netcdfElem, cancelTask);
        return targetDS;
    }

    public void readNetcdf(String ncmlLocation, NetcdfDataset targetDS, NetcdfDataset refds, Element netcdfElem, CancelTask cancelTask) throws IOException {
        String addRecords;
        boolean enhance;
        if (debugOpen) {
            System.out.println("NcMLReader.readNetcdf ncml= " + ncmlLocation + " referencedDatasetUri= " + refds.getLocation());
        }
        if (ncmlLocation != null) {
            targetDS.setLocation(ncmlLocation);
        }
        targetDS.setId(netcdfElem.getAttributeValue("id"));
        targetDS.setTitle(netcdfElem.getAttributeValue("title"));
        Element aggElem = netcdfElem.getChild("aggregation", ncNS);
        if (aggElem != null) {
            Aggregation agg = this.readAgg(aggElem, ncmlLocation, targetDS, cancelTask);
            targetDS.setAggregation(agg);
            agg.finish(cancelTask);
        }
        this.readGroup(targetDS, refds, null, null, netcdfElem);
        if (this.hasFatalError) {
            throw new IllegalArgumentException("NcML had fatal errors - see logs");
        }
        targetDS.finish();
        String enhanceS = netcdfElem.getAttributeValue("enhance");
        boolean bl = enhance = enhanceS != null && enhanceS.equalsIgnoreCase("true");
        if (enhance) {
            targetDS.enhance();
            targetDS.finish();
        }
        if ((addRecords = netcdfElem.getAttributeValue("addRecords")) != null && addRecords.equalsIgnoreCase("true")) {
            targetDS.sendIospMessage("AddRecordStructure");
        }
    }

    private void readAtt(Object parent, Object refParent, Element attElem) {
        boolean newName;
        String name = attElem.getAttributeValue("name");
        if (name == null) {
            log.warn("NcML Attribute name is required (" + attElem + ")");
            this.hasFatalError = true;
            return;
        }
        String nameInFile = attElem.getAttributeValue("orgName");
        boolean bl = newName = nameInFile != null && !nameInFile.equals(name);
        if (nameInFile == null) {
            nameInFile = name;
        } else if (null == this.findAttribute(refParent, nameInFile)) {
            log.warn("NcML attribute orgName '" + nameInFile + "' doesnt exist. att=" + name + " in=" + parent);
            this.hasFatalError = true;
            return;
        }
        Attribute att = this.findAttribute(refParent, nameInFile);
        if (att == null) {
            if (debugConstruct) {
                System.out.println(" add new att = " + name);
            }
            try {
                Array values = this.readAttributeValues(attElem);
                this.addAttribute(parent, new Attribute(name, values));
            }
            catch (RuntimeException e) {
                log.warn("NcML new Attribute Exception: " + e.getMessage() + " att=" + name + " in=" + parent);
                this.hasFatalError = true;
            }
        } else {
            boolean hasValue;
            if (debugConstruct) {
                System.out.println(" modify existing att = " + name);
            }
            boolean bl2 = hasValue = attElem.getAttribute("value") != null;
            if (hasValue) {
                try {
                    Array values = this.readAttributeValues(attElem);
                    this.addAttribute(parent, new Attribute(name, values));
                }
                catch (RuntimeException e) {
                    log.warn("NcML existing Attribute Exception: " + e.getMessage() + " att=" + name + " in=" + parent);
                    this.hasFatalError = true;
                    return;
                }
            } else {
                this.addAttribute(parent, new Attribute(name, att.getValues()));
            }
            if (newName && !this.explicit) {
                this.removeAttribute(parent, att);
                if (debugConstruct) {
                    System.out.println(" remove old att = " + nameInFile);
                }
            }
        }
    }

    private Array readAttributeValues(Element s) throws IllegalArgumentException {
        String sep;
        DataType dtype;
        String valString = s.getAttributeValue("value");
        if (valString == null) {
            throw new IllegalArgumentException("No value specified");
        }
        valString = StringUtil.unquoteXmlAttribute(valString);
        String type = s.getAttributeValue("type");
        DataType dataType = dtype = type == null ? DataType.STRING : DataType.getType(type);
        if (dtype == DataType.CHAR) {
            dtype = DataType.STRING;
        }
        if ((sep = s.getAttributeValue("separator")) == null && dtype == DataType.STRING) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(valString);
            return NetcdfDataset.makeArray(dtype, list);
        }
        if (sep == null) {
            sep = " ";
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        StringTokenizer tokn = new StringTokenizer(valString, sep);
        while (tokn.hasMoreTokens()) {
            stringValues.add(tokn.nextToken());
        }
        return NetcdfDataset.makeArray(dtype, stringValues);
    }

    private Attribute findAttribute(Object parent, String name) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof Group) {
            return ((Group)parent).findAttribute(name);
        }
        if (parent instanceof Variable) {
            return ((Variable)parent).findAttribute(name);
        }
        return null;
    }

    private void addAttribute(Object parent, Attribute att) {
        if (parent instanceof Group) {
            ((Group)parent).addAttribute(att);
        } else if (parent instanceof Variable) {
            ((Variable)parent).addAttribute(att);
        }
    }

    private void removeAttribute(Object parent, Attribute att) {
        if (parent instanceof Group) {
            ((Group)parent).remove(att);
        } else if (parent instanceof Variable) {
            ((Variable)parent).remove(att);
        }
    }

    private void readDim(Group g, Group refg, Element dimElem) {
        Dimension dim;
        String name = dimElem.getAttributeValue("name");
        if (name == null) {
            log.info("NcML Dimension name is required (" + dimElem + ")");
            this.hasFatalError = true;
            return;
        }
        String nameInFile = dimElem.getAttributeValue("orgName");
        if (nameInFile == null) {
            nameInFile = name;
        }
        if ((dim = refg.findDimension(nameInFile)) == null) {
            String lengthS = dimElem.getAttributeValue("length");
            String isUnlimitedS = dimElem.getAttributeValue("isUnlimited");
            String isSharedS = dimElem.getAttributeValue("isShared");
            String isUnknownS = dimElem.getAttributeValue("isVariableLength");
            boolean isUnlimited = isUnlimitedS != null && isUnlimitedS.equalsIgnoreCase("true");
            boolean isUnknown = isUnknownS != null && isUnknownS.equalsIgnoreCase("true");
            boolean isShared = true;
            if (isSharedS != null && isSharedS.equalsIgnoreCase("false")) {
                isShared = false;
            }
            int len = Integer.parseInt(lengthS);
            if (isUnknownS != null && isUnknownS.equalsIgnoreCase("false")) {
                len = Dimension.VLEN.getLength();
            }
            if (debugConstruct) {
                System.out.println(" add new dim = " + name);
            }
            g.addDimension(new Dimension(name, len, isShared, isUnlimited, isUnknown));
        } else {
            dim.setName(name);
            String lengthS = dimElem.getAttributeValue("length");
            String isUnlimitedS = dimElem.getAttributeValue("isUnlimited");
            String isSharedS = dimElem.getAttributeValue("isShared");
            String isUnknownS = dimElem.getAttributeValue("isVariableLength");
            if (isUnlimitedS != null) {
                dim.setUnlimited(isUnlimitedS.equalsIgnoreCase("true"));
            }
            if (isSharedS != null) {
                dim.setShared(!isSharedS.equalsIgnoreCase("false"));
            }
            if (isUnknownS != null) {
                dim.setVariableLength(isUnknownS.equalsIgnoreCase("true"));
            }
            if (lengthS != null && !dim.isVariableLength()) {
                int len = Integer.parseInt(lengthS);
                dim.setLength(len);
            }
            if (debugConstruct) {
                System.out.println(" modify existing dim = " + name);
            }
            if (g != refg) {
                g.addDimension(dim);
            }
        }
    }

    private void readGroup(NetcdfDataset newds, NetcdfDataset refds, Group parent, Group refParent, Element groupElem) {
        Group refg;
        Group g;
        if (parent == null) {
            g = newds.getRootGroup();
            refg = refds.getRootGroup();
            if (debugConstruct) {
                System.out.println(" root group ");
            }
        } else {
            String name = groupElem.getAttributeValue("name");
            if (name == null) {
                log.info("NcML Group name is required (" + groupElem + ")");
                this.hasFatalError = true;
                return;
            }
            String nameInFile = groupElem.getAttributeValue("orgName");
            if (nameInFile == null) {
                nameInFile = name;
            }
            if ((refg = refParent.findGroup(nameInFile)) == null) {
                g = new Group(newds, parent, name);
                parent.addGroup(g);
                if (debugConstruct) {
                    System.out.println(" add new group = " + name);
                }
            } else if (parent != refParent) {
                g = new Group(newds, parent, name);
                parent.addGroup(g);
                if (debugConstruct) {
                    System.out.println(" transfer existing group = " + name);
                }
            } else {
                g = refg;
                if (!nameInFile.equals(name)) {
                    g.setName(name);
                }
                if (debugConstruct) {
                    System.out.println(" modify existing group = " + name);
                }
            }
        }
        List attList = groupElem.getChildren("attribute", ncNS);
        for (Element attElem : attList) {
            this.readAtt(g, refg, attElem);
        }
        List dimList = groupElem.getChildren("dimension", ncNS);
        for (Element dimElem : dimList) {
            this.readDim(g, refg, dimElem);
        }
        List varList = groupElem.getChildren("variable", ncNS);
        for (Element varElem : varList) {
            this.readVariable(newds, g, refg, varElem);
        }
        List removeList = groupElem.getChildren("remove", ncNS);
        for (Element e : removeList) {
            this.cmdRemove(g, e.getAttributeValue("type"), e.getAttributeValue("name"));
        }
        List groupList = groupElem.getChildren("group", ncNS);
        for (Element gElem : groupList) {
            this.readGroup(newds, refds, g, refg, gElem);
            if (!debugConstruct) continue;
            System.out.println(" add group = " + g.getName());
        }
    }

    private void readVariable(NetcdfDataset ds, Group g, Group refg, Element varElem) {
        Variable v;
        Variable refv;
        String name = varElem.getAttributeValue("name");
        if (name == null) {
            log.info("NcML Variable name is required (" + varElem + ")");
            this.hasFatalError = true;
            return;
        }
        String nameInFile = varElem.getAttributeValue("orgName");
        if (nameInFile == null) {
            nameInFile = name;
        }
        if ((refv = refg.findVariable(nameInFile)) == null) {
            if (debugConstruct) {
                System.out.println(" add new var = " + name);
            }
            g.addVariable(this.readVariableNew(ds, g, null, varElem));
            return;
        }
        String typeS = varElem.getAttributeValue("type");
        DataType dtype = typeS != null ? DataType.getType(typeS) : refv.getDataType();
        String shape = varElem.getAttributeValue("shape");
        if (shape == null) {
            shape = refv.getDimensionsString();
        }
        if (refg == g) {
            v = refv;
            v.setName(name);
            v.setDataType(dtype);
            v.setDimensions(shape);
            if (debugConstruct) {
                System.out.println(" modify existing var = " + nameInFile);
            }
        } else {
            if (refv instanceof Structure) {
                v = new StructureDS(g, (Structure)refv, true);
                v.setName(name);
                v.setDimensions(shape);
            } else {
                v = new VariableDS(g, refv, false);
                v.setName(name);
                v.setDataType(dtype);
                v.setDimensions(shape);
            }
            if (debugConstruct) {
                System.out.println(" modify explicit var = " + nameInFile);
            }
            g.addVariable(v);
        }
        List attList = varElem.getChildren("attribute", ncNS);
        for (Element attElem : attList) {
            this.readAtt(v, refv, attElem);
        }
        List removeList = varElem.getChildren("remove", ncNS);
        for (Element remElem : removeList) {
            this.cmdRemove(v, remElem.getAttributeValue("type"), remElem.getAttributeValue("name"));
        }
        if (v.getDataType() == DataType.STRUCTURE) {
            StructureDS s = (StructureDS)v;
            StructureDS refS = (StructureDS)refv;
            List varList = varElem.getChildren("variable", ncNS);
            for (Element vElem : varList) {
                this.readVariableNested(ds, s, refS, vElem);
            }
        } else {
            Element valueElem = varElem.getChild("values", ncNS);
            if (valueElem != null) {
                this.readValues(ds, v, varElem, valueElem);
            } else if (v.hasCachedData()) {
                Array data;
                try {
                    data = v.read();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                if (data.getClass() != v.getDataType().getPrimitiveClassType()) {
                    Array newData = Array.factory(v.getDataType(), v.getShape());
                    MAMath.copy(newData, data);
                    v.setCachedData(newData, false);
                }
            }
        }
    }

    private Variable readVariableNew(NetcdfDataset ds, Group g, Structure parentS, Element varElem) {
        Variable v;
        String name = varElem.getAttributeValue("name");
        if (name == null) {
            log.info("NcML Variable name is required (" + varElem + ")");
            this.hasFatalError = true;
            return null;
        }
        String type = varElem.getAttributeValue("type");
        String shape = varElem.getAttributeValue("shape");
        DataType dtype = DataType.getType(type);
        if (dtype == DataType.STRUCTURE) {
            StructureDS s = new StructureDS(ds, g, parentS, name, shape, null, null);
            v = s;
            List varList = varElem.getChildren("variable", ncNS);
            for (Element vElem : varList) {
                this.readVariableNested(ds, s, s, vElem);
            }
        } else {
            v = new VariableDS(ds, g, parentS, name, dtype, shape, null, null);
            Element valueElem = varElem.getChild("values", ncNS);
            if (valueElem != null) {
                this.readValues(ds, v, varElem, valueElem);
            }
        }
        List attList = varElem.getChildren("attribute", ncNS);
        for (Element attElem : attList) {
            this.readAtt(v, null, attElem);
        }
        return v;
    }

    private void readVariableNested(NetcdfDataset ds, Structure parentS, Structure refStruct, Element varElem) {
        String shape;
        String typeS;
        Variable v;
        Variable refv;
        String name = varElem.getAttributeValue("name");
        if (name == null) {
            log.info("NcML Variable name is required (" + varElem + ")");
            this.hasFatalError = true;
            return;
        }
        String nameInFile = varElem.getAttributeValue("orgName");
        if (nameInFile == null) {
            nameInFile = name;
        }
        if ((refv = refStruct.findVariable(nameInFile)) == null) {
            if (debugConstruct) {
                System.out.println(" add new var = " + name);
            }
            Variable nested = this.readVariableNew(ds, parentS.getParentGroup(), parentS, varElem);
            parentS.addMemberVariable(nested);
            return;
        }
        if (parentS == refStruct) {
            v = refv;
            v.setName(name);
        } else {
            if (refv instanceof Structure) {
                v = new StructureDS(parentS.getParentGroup(), (Structure)refv, true);
                v.setName(name);
                v.setParentStructure(parentS);
            } else {
                v = new VariableDS(parentS.getParentGroup(), refv, false);
                v.setName(name);
                v.setParentStructure(parentS);
            }
            parentS.addMemberVariable(v);
        }
        if (debugConstruct) {
            System.out.println(" modify existing var = " + nameInFile);
        }
        if ((typeS = varElem.getAttributeValue("type")) != null) {
            DataType dtype = DataType.getType(typeS);
            v.setDataType(dtype);
        }
        if ((shape = varElem.getAttributeValue("shape")) != null) {
            v.setDimensions(shape);
        }
        List attList = varElem.getChildren("attribute", ncNS);
        for (Element attElem : attList) {
            this.readAtt(v, refv, attElem);
        }
        List removeList = varElem.getChildren("remove", ncNS);
        for (Element remElem : removeList) {
            this.cmdRemove(v, remElem.getAttributeValue("type"), remElem.getAttributeValue("name"));
        }
        if (v.getDataType() == DataType.STRUCTURE) {
            StructureDS s = (StructureDS)v;
            StructureDS refS = (StructureDS)refv;
            List varList = varElem.getChildren("variable", ncNS);
            for (Element vElem : varList) {
                this.readVariableNested(ds, s, refS, vElem);
            }
        } else {
            Element valueElem = varElem.getChild("values", ncNS);
            if (valueElem != null) {
                this.readValues(ds, v, varElem, valueElem);
            }
        }
    }

    private void readValues(NetcdfDataset ds, Variable v, Element varElem, Element valuesElem) {
        int npts;
        ArrayList<String> valList = new ArrayList<String>();
        String startS = valuesElem.getAttributeValue("start");
        String incrS = valuesElem.getAttributeValue("increment");
        String nptsS = valuesElem.getAttributeValue("npts");
        int n = npts = nptsS == null ? (int)v.getSize() : Integer.parseInt(nptsS);
        if (startS != null && incrS != null) {
            double start = Double.parseDouble(startS);
            double incr = Double.parseDouble(incrS);
            ds.setValues(v, npts, start, incr);
            return;
        }
        String values = varElem.getChildText("values", ncNS);
        String sep = valuesElem.getAttributeValue("separator");
        if (sep == null) {
            sep = " ";
        }
        if (v.getDataType() == DataType.CHAR) {
            int nhave = values.length();
            int nwant = (int)v.getSize();
            char[] data = new char[nwant];
            int min = Math.min(nhave, nwant);
            for (int i = 0; i < min; ++i) {
                data[i] = values.charAt(i);
            }
            Array dataArray = Array.factory(DataType.CHAR.getPrimitiveClassType(), v.getShape(), (Object)data);
            v.setCachedData(dataArray, true);
        } else {
            StringTokenizer tokn = new StringTokenizer(values, sep);
            while (tokn.hasMoreTokens()) {
                valList.add(tokn.nextToken());
            }
            ds.setValues(v, valList);
        }
    }

    private Aggregation readAgg(Element aggElem, String ncmlLocation, NetcdfDataset newds, CancelTask cancelTask) throws IOException {
        String fmrcDefinition;
        String timeUnitsChange;
        Aggregation agg;
        String dimName = aggElem.getAttributeValue("dimName");
        String type = aggElem.getAttributeValue("type");
        String recheck = aggElem.getAttributeValue("recheckEvery");
        if (type.equals("joinExisting")) {
            agg = new AggregationExisting(newds, dimName, recheck);
        } else if (type.equals("joinExistingOne")) {
            agg = new AggregationExistingOne(newds, dimName, recheck);
        } else if (type.equals("joinNew")) {
            agg = new AggregationNew(newds, dimName, recheck);
        } else if (type.equals("union")) {
            agg = new AggregationUnion(newds, dimName, recheck);
        } else if (type.equals("forecastModelRunCollection")) {
            AggregationFmrc aggc = new AggregationFmrc(newds, dimName, recheck);
            agg = aggc;
            timeUnitsChange = aggElem.getAttributeValue("timeUnitsChange");
            if (timeUnitsChange != null) {
                aggc.setTimeUnitsChange(timeUnitsChange.equalsIgnoreCase("true"));
            }
            if ((fmrcDefinition = aggElem.getAttributeValue("fmrcDefinition")) != null) {
                aggc.setInventoryDefinition(fmrcDefinition);
            }
        } else if (type.equals("forecastModelRunSingleCollection")) {
            AggregationFmrcSingle aggh = new AggregationFmrcSingle(newds, dimName, recheck);
            agg = aggh;
            timeUnitsChange = aggElem.getAttributeValue("timeUnitsChange");
            if (timeUnitsChange != null) {
                aggh.setTimeUnitsChange(timeUnitsChange.equalsIgnoreCase("true"));
            }
            if ((fmrcDefinition = aggElem.getAttributeValue("fmrcDefinition")) != null) {
                aggh.setInventoryDefinition(fmrcDefinition);
            }
            List scan2List = aggElem.getChildren("scanFmrc", ncNS);
            for (Element scanElem : scan2List) {
                String dirLocation = scanElem.getAttributeValue("location");
                String suffix = scanElem.getAttributeValue("suffix");
                String regexpPatternString = scanElem.getAttributeValue("regExp");
                String runMatcher = scanElem.getAttributeValue("runDateMatcher");
                String forecastMatcher = scanElem.getAttributeValue("forecastDateMatcher");
                String offsetMatcher = scanElem.getAttributeValue("forecastOffsetMatcher");
                String subdirs = scanElem.getAttributeValue("subdirs");
                String olderS = scanElem.getAttributeValue("olderThan");
                aggh.addDirectoryScanFmrc(dirLocation, suffix, regexpPatternString, subdirs, olderS, runMatcher, forecastMatcher, offsetMatcher);
                if (cancelTask != null && cancelTask.isCancel()) {
                    return null;
                }
                if (!debugAggDetail) continue;
                System.out.println(" debugAgg: nested dirLocation = " + dirLocation);
            }
        } else {
            throw new IllegalArgumentException("Unknown aggregation type=" + type);
        }
        List list = aggElem.getChildren("variableAgg", ncNS);
        for (Element vaggElem : list) {
            String varName = vaggElem.getAttributeValue("name");
            agg.addVariable(varName);
        }
        List ncList = aggElem.getChildren("netcdf", ncNS);
        for (Element netcdfElemNested : ncList) {
            String location = netcdfElemNested.getAttributeValue("location");
            if (location == null) {
                location = netcdfElemNested.getAttributeValue("uri");
            }
            if (agg.getType() == AggregationIF.Type.UNION) {
                NetcdfDataset unionDs = this.readNcML(ncmlLocation, location, netcdfElemNested, cancelTask);
                ((AggregationUnion)agg).addUnionDataset(unionDs);
                DatasetConstructor.transferDataset(unionDs, newds, null);
            } else {
                String ncoords = netcdfElemNested.getAttributeValue("ncoords");
                String coordValueS = netcdfElemNested.getAttributeValue("coordValue");
                NcmlElementReader reader = new NcmlElementReader(ncmlLocation, location, netcdfElemNested);
                String cacheName = ncmlLocation + "#" + Integer.toString(netcdfElemNested.hashCode());
                agg.addExplicitDataset(cacheName, location, ncoords, coordValueS, reader, cancelTask);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            if (!debugAggDetail) continue;
            System.out.println(" debugAgg: nested dataset = " + location);
        }
        List dirList = aggElem.getChildren("scan", ncNS);
        for (Element scanElem : dirList) {
            String dirLocation = scanElem.getAttributeValue("location");
            String suffix = scanElem.getAttributeValue("suffix");
            String regexpPatternString = scanElem.getAttributeValue("regExp");
            String dateFormatMark = scanElem.getAttributeValue("dateFormatMark");
            String enhance = scanElem.getAttributeValue("enhance");
            String subdirs = scanElem.getAttributeValue("subdirs");
            String olderS = scanElem.getAttributeValue("olderThan");
            agg.addDirectoryScan(dirLocation, suffix, regexpPatternString, dateFormatMark, enhance, subdirs, olderS);
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            if (!debugAggDetail) continue;
            System.out.println(" debugAgg: nested dirLocation = " + dirLocation);
        }
        return agg;
    }

    private void cmdRemove(Group g, String type, String name) {
        if (type.equals("dimension")) {
            Dimension dim = g.findDimension(name);
            if (dim != null) {
                g.remove(dim);
                if (debugCmd) {
                    System.out.println("CMD remove " + type + " " + name);
                }
            } else {
                System.out.println("CMD remove " + type + " CANT find " + name);
            }
        } else if (type.equals("variable")) {
            Variable v = g.findVariable(name);
            if (v != null) {
                g.remove(v);
                if (debugCmd) {
                    System.out.println("CMD remove " + type + " " + name);
                }
            } else {
                System.out.println("CMD remove " + type + " CANT find " + name);
            }
        } else if (type.equals("attribute")) {
            Attribute a = g.findAttribute(name);
            if (a != null) {
                g.remove(a);
                if (debugCmd) {
                    System.out.println("CMD remove " + type + " " + name);
                }
            } else {
                System.out.println("CMD remove " + type + " CANT find " + name);
            }
        }
    }

    private void cmdRemove(Variable v, String type, String name) {
        if (type.equals("attribute")) {
            Attribute a = v.findAttribute(name);
            if (a != null) {
                v.remove(a);
                if (debugCmd) {
                    System.out.println("CMD remove " + type + " " + name);
                }
            } else {
                System.out.println("CMD remove " + type + " CANT find " + name);
            }
        } else if (type.equals("variable") && v instanceof Structure) {
            Structure s = (Structure)v;
            Variable nested = s.findVariable(name);
            if (nested != null) {
                s.removeMemberVariable(nested);
                if (debugCmd) {
                    System.out.println("CMD remove " + type + " " + name);
                }
            } else {
                System.out.println("CMD remove " + type + " CANT find " + name);
            }
        }
    }

    public static void writeNcMLToFile(String ncmlLocation, String fileOutName) throws IOException {
        NetcdfDataset ncd = (NetcdfDataset)NetcdfDataset.acquireFile(ncmlLocation, null);
        NetcdfFile ncdnew = FileWriter.writeToFile(ncd, fileOutName);
        ncd.close();
        ncdnew.close();
    }

    public static void writeNcMLToFile(InputStream ncml, String fileOutName) throws IOException {
        NetcdfDataset ncd = NcMLReader.readNcML(ncml, null);
        NetcdfFile ncdnew = FileWriter.writeToFile(ncd, fileOutName, true);
        ncd.close();
        ncdnew.close();
    }

    public static void main(String[] arg) {
        String ncmlFile = "C:/dev/netcdf-java-2.2/test/data/ncml/aggDirectory.xml";
        String ncmlFileOut = "C:\\TEMP\\New Folder\\aggDirectory.nc";
        try {
            FileInputStream in = new FileInputStream(ncmlFile);
            NcMLReader.writeNcMLToFile(in, ncmlFileOut);
        }
        catch (Exception ioe) {
            System.out.println("error = " + ncmlFile);
            ioe.printStackTrace();
        }
    }

    private class NcmlElementReader
    implements NetcdfFileFactory {
        private Element netcdfElem;
        private String ncmlLocation;
        private String location;

        NcmlElementReader(String ncmlLocation, String location, Element netcdfElem) {
            this.ncmlLocation = ncmlLocation;
            this.location = location;
            this.netcdfElem = netcdfElem;
        }

        public NetcdfFile open(String cacheName, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            if (debugAggDetail) {
                System.out.println(" NcmlElementReader open nested dataset " + cacheName);
            }
            return NcMLReader.this.readNcML(this.ncmlLocation, this.location, this.netcdfElem, cancelTask);
        }
    }

    private static class NcMLNetcdfFile
    extends NetcdfFile {
        NcMLNetcdfFile(String iospClassName, String iospParam, String location, int buffer_size, CancelTask cancelTask) throws IOException, IllegalAccessException, ClassNotFoundException, InstantiationException {
            super(iospClassName, iospParam, location, buffer_size, cancelTask);
        }
    }
}

