/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.dbengine;

import java.sql.SQLException;
import mdbtools.dbengine.Data;
import mdbtools.dbengine.DataSource;
import mdbtools.dbengine.Engine;
import mdbtools.dbengine.Table;
import mdbtools.dbengine.functions.Aggregate;
import mdbtools.dbengine.functions.ConCat;
import mdbtools.dbengine.functions.Count;
import mdbtools.dbengine.functions.Function;
import mdbtools.dbengine.functions.Length;
import mdbtools.dbengine.functions.Lower;
import mdbtools.dbengine.functions.Max;
import mdbtools.dbengine.functions.Min;
import mdbtools.dbengine.functions.Upper;
import mdbtools.dbengine.sql.Condition;
import mdbtools.dbengine.sql.Equation;
import mdbtools.dbengine.sql.FQColumn;
import mdbtools.dbengine.sql.FunctionDef;
import mdbtools.dbengine.sql.Join;
import mdbtools.dbengine.sql.OrderBy;
import mdbtools.dbengine.sql.SQL;
import mdbtools.dbengine.sql.Select;

public class Tests {
    private Test[] tests = new Test[38];
    private static final int TABLE_CARS = 0;
    private static final int FIELD_CARS_ID = 0;
    private static final int FIELD_CARS_MAKE = 1;
    private static final int FIELD_CARS_MODEL = 2;
    private static final int FIELD_CARS_OWNER = 3;
    private static final int TABLE_PERSON = 1;
    private static final int FIELD_PERSON_ID = 0;
    private static final int FIELD_PERSON_NAME = 1;
    private static final int FIELD_PERSON_LOCATION = 3;
    private static final int TABLE_A = 2;
    private static final int FIELD_A_ID = 0;
    private static final int FIELD_A_S = 1;
    private static final int TABLE_LOCATION = 3;
    private static final int FIELD_LOCATION_ID = 0;
    private static final int FIELD_LOCATION_CITY = 1;
    private static final int FIELD_LOCATION_STATE = 2;

    public static void main(String[] args) {
        new Tests().go();
    }

    private void go() {
        try {
            this.buildTestCases();
            this.runAllTests();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean runTest(int index) throws SQLException {
        Test test = this.tests[index];
        System.out.println("executing: " + test.sql.toString());
        Engine engine = new Engine();
        Data data = engine.execute((SQL)test.sql);
        for (int i = 0; i < test.data.length; ++i) {
            data.next();
            for (int j = 0; j < test.data[i].length; ++j) {
                if (test.data[i][j].equals(data.get(j))) continue;
                System.out.println("failed at: " + i + "," + j + "," + test.data[i][j] + "," + data.get(j));
                return false;
            }
        }
        return !data.next();
    }

    private void runAllTests() throws SQLException {
        this.runTests(0, this.tests.length - 1);
    }

    private void runTests(int from, int to) throws SQLException {
        int failureCount = 0;
        for (int i = from; i <= to; ++i) {
            boolean status;
            try {
                status = this.runTest(i);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                status = false;
            }
            if (status) continue;
            ++failureCount;
            System.out.println("failed test: " + i);
        }
        if (failureCount == 0) {
            System.out.println("all tests passed");
        } else {
            System.out.println(failureCount + " tests failed");
        }
    }

    private void buildTestCases() {
        for (int i = 0; i < this.tests.length; ++i) {
            this.tests[i] = new Test();
        }
        DataSource simpleDS = this.buildDB();
        this.tests[0].sql = this.buildSelect(new Object[]{new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[0].data = new Object[][]{{"contour"}, {"viper"}, {"stratus"}, {"ram"}, {"F-150"}};
        this.tests[1].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[1].data = new Object[][]{{new Integer(1), "ford", "contour"}, {new Integer(2), "dodge", "viper"}, {new Integer(3), "dodge", "stratus"}, {new Integer(4), "dodge", "ram"}, {new Integer(5), "ford", "F-150"}};
        this.tests[2].sql = this.buildSelect(new Object[]{new FQColumn(0, 2), new Integer(1)}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[2].data = new Object[][]{{"contour", new Integer(1)}, {"viper", new Integer(1)}, {"stratus", new Integer(1)}, {"ram", new Integer(1)}, {"F-150", new Integer(1)}};
        this.tests[3].sql = this.buildSelect(new Object[]{this.buildFunction(new Length(), (Object)new FQColumn(0, 2))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[3].data = new Object[][]{{new Integer(7)}, {new Integer(5)}, {new Integer(7)}, {new Integer(3)}, {new Integer(5)}};
        this.tests[4].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), this.buildFunction(new Length(), (Object)new FQColumn(0, 2))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[4].data = new Object[][]{{"ford", new Integer(7)}, {"dodge", new Integer(5)}, {"dodge", new Integer(7)}, {"dodge", new Integer(3)}, {"ford", new Integer(5)}};
        this.tests[5].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), this.buildFunction(new Upper(), (Object)new FQColumn(0, 2))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[5].data = new Object[][]{{new Integer(1), "ford", "CONTOUR"}, {new Integer(2), "dodge", "VIPER"}, {new Integer(3), "dodge", "STRATUS"}, {new Integer(4), "dodge", "RAM"}, {new Integer(5), "ford", "F-150"}};
        this.tests[6].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), this.buildFunction(new Lower(), (Object)new FQColumn(0, 2))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[6].data = new Object[][]{{new Integer(1), "ford", "contour"}, {new Integer(2), "dodge", "viper"}, {new Integer(3), "dodge", "stratus"}, {new Integer(4), "dodge", "ram"}, {new Integer(5), "ford", "f-150"}};
        this.tests[7].sql = this.buildSelect(new Object[]{this.buildFunction(new Count(), (Object)new Integer(1))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[7].data = new Object[][]{{new Integer(5)}};
        this.tests[8].sql = this.buildSelect(new Object[]{this.buildFunction(new Count(), (Object)new Integer(1)), new Integer(1)}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[8].data = new Object[][]{{new Integer(5), new Integer(1)}};
        this.tests[9].sql = this.buildSelect(new Object[]{this.buildFunction(new Max(), (Object)new FQColumn(0, 2))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[9].data = new Object[][]{{"viper"}};
        this.tests[10].sql = this.buildSelect(new Object[]{this.buildFunction(new Max(), (Object)new FQColumn(0, 0))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[10].data = new Object[][]{{new Integer(5)}};
        this.tests[11].sql = this.buildSelect(new Object[]{this.buildFunction(new Min(), (Object)new FQColumn(0, 0))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[11].data = new Object[][]{{new Integer(1)}};
        this.tests[12].sql = this.buildSelect(new Object[]{this.buildFunction(new Min(), (Object)new FQColumn(0, 2))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[12].data = new Object[][]{{"F-150"}};
        this.tests[13].sql = this.buildSelect(new Object[]{this.buildFunction(new Min(), (Object)this.buildFunction(new Lower(), (Object)new FQColumn(0, 2)))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[13].data = new Object[][]{{"contour"}};
        this.tests[14].sql = this.buildSelect(new Object[]{this.buildFunction(new Max(), (Object)this.buildFunction(new Length(), (Object)new FQColumn(0, 2)))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[14].data = new Object[][]{{new Integer(7)}};
        this.tests[15].sql = this.buildSelect(new Object[]{this.buildFunction(new Min(), (Object)this.buildFunction(new Length(), (Object)new FQColumn(0, 2)))}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[15].data = new Object[][]{{new Integer(3)}};
        this.tests[16].sql = this.buildSelect(new Object[]{this.buildFunction(new Count(), (Object)new Integer(1)), new FQColumn(0, 1)}, new Object[]{simpleDS.getTable(0)}, null, new FQColumn[]{new FQColumn(0, 1)}, null);
        this.tests[16].data = new Object[][]{{new Integer(3), "dodge"}, {new Integer(2), "ford"}};
        this.tests[17].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new Integer(1), new Boolean(true)}});
        this.tests[17].data = new Object[][]{{"dodge", "viper"}, {"dodge", "stratus"}, {"dodge", "ram"}, {"ford", "contour"}, {"ford", "F-150"}};
        this.tests[18].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new Integer(1), new Boolean(true)}, {new Integer(2), new Boolean(true)}});
        this.tests[18].data = new Object[][]{{"dodge", "ram"}, {"dodge", "stratus"}, {"dodge", "viper"}, {"ford", "F-150"}, {"ford", "contour"}};
        this.tests[19].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), this.buildFunction(new Lower(), (Object)new FQColumn(0, 2))}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new Integer(1), new Boolean(true)}, {new Integer(2), new Boolean(true)}});
        this.tests[19].data = new Object[][]{{"dodge", "ram"}, {"dodge", "stratus"}, {"dodge", "viper"}, {"ford", "contour"}, {"ford", "f-150"}};
        this.tests[20].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new FQColumn(0, 1), new Boolean(true)}, {new FQColumn(0, 2), new Boolean(true)}});
        this.tests[20].data = new Object[][]{{"dodge", "ram"}, {"dodge", "stratus"}, {"dodge", "viper"}, {"ford", "F-150"}, {"ford", "contour"}};
        this.tests[21].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new FQColumn(0, 1), new Boolean(true)}, {new FQColumn(0, 2), new Boolean(true)}});
        this.tests[21].data = new Object[][]{{"dodge", "ram"}, {"dodge", "stratus"}, {"dodge", "viper"}, {"ford", "F-150"}, {"ford", "contour"}};
        this.tests[22].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new FQColumn(0, 1), new Boolean(true)}, {new FQColumn(0, 2), new Boolean(true)}});
        this.tests[22].data = new Object[][]{{"dodge", "ram"}, {"dodge", "stratus"}, {"dodge", "viper"}, {"ford", "F-150"}, {"ford", "contour"}};
        this.tests[23].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new FQColumn(0, 1), new Boolean(true)}, {new FQColumn(0, 2), new Boolean(true)}});
        this.tests[23].data = new Object[][]{{"dodge", "ram"}, {"dodge", "stratus"}, {"dodge", "viper"}, {"ford", "F-150"}, {"ford", "contour"}};
        this.tests[24].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new FQColumn(0, 1), new Boolean(true)}, {new FQColumn(0, 2), new Boolean(true)}});
        this.tests[24].data = new Object[][]{{new Integer(4), "dodge", "ram"}, {new Integer(3), "dodge", "stratus"}, {new Integer(2), "dodge", "viper"}, {new Integer(5), "ford", "F-150"}, {new Integer(1), "ford", "contour"}};
        this.tests[25].sql = this.buildSelect(new Object[]{new FQColumn(0, 0)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new FQColumn(0, 1), new Boolean(true)}});
        this.tests[25].data = new Object[][]{{new Integer(2)}, {new Integer(3)}, {new Integer(4)}, {new Integer(1)}, {new Integer(5)}};
        this.tests[26].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new Integer(1), new Boolean(true)}, {new FQColumn(0, 2), new Boolean(true)}});
        this.tests[26].data = new Object[][]{{"dodge", "ram"}, {"dodge", "stratus"}, {"dodge", "viper"}, {"ford", "F-150"}, {"ford", "contour"}};
        this.tests[27].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new FQColumn(0, 2), new Boolean(false)}});
        this.tests[27].data = new Object[][]{{"dodge", "viper"}, {"dodge", "stratus"}, {"dodge", "ram"}, {"ford", "contour"}, {"ford", "F-150"}};
        this.tests[28].sql = this.buildSelect(new Object[]{new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, null, null, new Object[][]{{new FQColumn(0, 1), new Boolean(false)}, {new FQColumn(0, 3), new Boolean(true)}});
        this.tests[28].data = new Object[][]{{"ford", "contour"}, {"ford", "F-150"}, {"dodge", "stratus"}, {"dodge", "viper"}, {"dodge", "ram"}};
        this.tests[29].sql = this.buildSelect(new Object[]{this.buildFunction(new Count(), (Object)new Integer(1)), new FQColumn(0, 1)}, new Object[]{simpleDS.getTable(0)}, null, new FQColumn[]{new FQColumn(0, 1)}, new Object[][]{{new Integer(2), new Boolean(false)}});
        this.tests[29].data = new Object[][]{{new Integer(2), "ford"}, {new Integer(3), "dodge"}};
        this.tests[30].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, this.buildEquation(new FQColumn(0, 1), 0, "dodge"), null, null);
        this.tests[30].data = new Object[][]{{new Integer(2), "dodge", "viper"}, {new Integer(3), "dodge", "stratus"}, {new Integer(4), "dodge", "ram"}};
        this.tests[31].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, this.buildEquation(new FQColumn(0, 1), 3, "dodge"), null, null);
        this.tests[31].data = new Object[][]{{new Integer(1), "ford", "contour"}, {new Integer(5), "ford", "F-150"}};
        this.tests[32].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, this.buildEquation(new Integer(1), 0, new Integer(0)), null, null);
        this.tests[32].data = new Object[0][];
        this.tests[33].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, this.buildEquation(new Integer(10), 1, new Integer(9)), null, null);
        this.tests[33].data = new Object[0][];
        this.tests[34].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, this.buildEquation(new Integer(1), 2, new Integer(4)), null, null);
        this.tests[34].data = new Object[0][];
        this.tests[35].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, this.buildCondition(this.buildEquation(new FQColumn(0, 1), 0, "dodge"), 0, this.buildEquation(new FQColumn(0, 2), 0, "stratus")), null, null);
        this.tests[35].data = new Object[][]{{new Integer(3), "dodge", "stratus"}};
        this.tests[36].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), new FQColumn(0, 1), new FQColumn(0, 2)}, new Object[]{simpleDS.getTable(0)}, this.buildCondition(this.buildEquation(new FQColumn(0, 1), 0, "ford"), 1, this.buildEquation(new FQColumn(0, 2), 0, "stratus")), null, null);
        this.tests[36].data = new Object[][]{{new Integer(1), "ford", "contour"}, {new Integer(3), "dodge", "stratus"}, {new Integer(5), "ford", "F-150"}};
        this.tests[37].sql = this.buildSelect(new Object[]{new FQColumn(0, 0), this.buildFunction(new ConCat(), (Object)new FQColumn[]{new FQColumn(0, 1), new FQColumn(0, 2)})}, new Object[]{simpleDS.getTable(0)}, null, null, null);
        this.tests[37].data = new Object[][]{{new Integer(1), "fordcontour"}, {new Integer(2), "dodgeviper"}, {new Integer(3), "dodgestratus"}, {new Integer(4), "dodgeram"}, {new Integer(5), "fordF-150"}};
    }

    private DataSource buildDB() {
        SimpleDataSource ds = new SimpleDataSource();
        SimpleDataSource.access$202(ds, new SimpleDataSourceTable[4]);
        ((SimpleDataSource)ds).tables[0] = new SimpleDataSourceTable();
        ds.tables[0].name = "cars";
        ((SimpleDataSource)ds).tables[0].columnNames = new String[]{"id", "make", "model", "owner"};
        ((SimpleDataSource)ds).tables[0].data = new Object[][]{{new Integer(1), "ford", "contour", new Integer(1)}, {new Integer(2), "dodge", "viper", new Integer(3)}, {new Integer(3), "dodge", "stratus", new Integer(2)}, {new Integer(4), "dodge", "ram", new Integer(3)}, {new Integer(5), "ford", "F-150", new Integer(1)}};
        ((SimpleDataSource)ds).tables[1] = new SimpleDataSourceTable();
        ds.tables[1].name = "person";
        ((SimpleDataSource)ds).tables[1].columnNames = new String[]{"id", "name", "location"};
        ((SimpleDataSource)ds).tables[1].data = new Object[][]{{new Integer(1), "billy", new Integer(1)}, {new Integer(2), "george", new Integer(2)}, {new Integer(3), "susan", new Integer(2)}, {new Integer(4), "mary", new Integer(3)}};
        ((SimpleDataSource)ds).tables[2] = new SimpleDataSourceTable();
        ds.tables[2].name = "a";
        ((SimpleDataSource)ds).tables[2].columnNames = new String[]{"id", "s"};
        ((SimpleDataSource)ds).tables[2].data = new Object[][]{{new Integer(1), "testing"}, {new Integer(2), "hi"}};
        ((SimpleDataSource)ds).tables[3] = new SimpleDataSourceTable();
        ds.tables[3].name = "location";
        ((SimpleDataSource)ds).tables[3].columnNames = new String[]{"id", "city", "state"};
        ((SimpleDataSource)ds).tables[3].data = new Object[][]{{"1", "salt lake", "UT"}, {"2", "new york", "NY"}, {"3", "vegas", "NV"}};
        return ds;
    }

    private Select buildSelect(Object[] columnList, Object[] tableList, Object where, FQColumn[] groupBy, Object[][] orderBy) {
        int i;
        Select result = new Select();
        for (i = 0; i < columnList.length; ++i) {
            result.addColumn(columnList[i]);
        }
        for (i = 0; i < tableList.length; ++i) {
            result.addTable(tableList[i]);
        }
        if (where != null) {
            result.setWhere(where);
        }
        if (groupBy != null) {
            for (i = 0; i < groupBy.length; ++i) {
                result.addGroupBy(groupBy[i]);
            }
        }
        if (orderBy != null) {
            for (i = 0; i < orderBy.length; ++i) {
                OrderBy ob = new OrderBy();
                ob.setSort(orderBy[i][0]);
                ob.setAscending((Boolean)orderBy[i][1]);
                result.addOrderBy(ob);
            }
        }
        return result;
    }

    public FunctionDef buildFunction(Function function, Object argument) {
        FunctionDef result = new FunctionDef();
        result.setFunction(function);
        result.setArgument(argument);
        return result;
    }

    public FunctionDef buildFunction(Aggregate function, Object argument) {
        FunctionDef result = new FunctionDef();
        result.setFunction(function);
        result.setArgument(argument);
        return result;
    }

    private Equation buildEquation(Object left, int operator, Object right) {
        Equation result = new Equation();
        result.setLeft(left);
        result.setOperator(operator);
        result.setRight(right);
        return result;
    }

    private Condition buildCondition(Object left, int operator, Object right) {
        Condition c = new Condition();
        c.setLeft(left);
        c.setOperator(operator);
        c.setRight(right);
        return c;
    }

    private Join buildJoin(Object left, int type, Table right, Equation eq) {
        Join join = new Join();
        join.setLeft(left);
        join.setType(type);
        join.setRight(right);
        join.setEquation(eq);
        return join;
    }

    private class SimpleData
    implements Data {
        int currentRow = -1;
        Object[][] data;

        public SimpleData(Object[][] data) {
            this.data = data;
        }

        public boolean next() {
            if (this.currentRow + 1 < this.data.length) {
                ++this.currentRow;
                return true;
            }
            return false;
        }

        public Object get(int index) {
            return this.data[this.currentRow][index];
        }
    }

    private class SimpleDataSourceTable
    implements Table {
        private String name;
        String[] columnNames;
        Object[][] data;

        private SimpleDataSourceTable() {
        }

        public String getName() {
            return this.name;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        public Data getData() {
            return new SimpleData(this.data);
        }

        public String toString() {
            return this.name;
        }
    }

    private class SimpleDataSource
    implements DataSource {
        private SimpleDataSourceTable[] tables;

        private SimpleDataSource() {
        }

        public int getTableCount() {
            return this.tables.length;
        }

        public Table getTable(int index) {
            return this.tables[index];
        }

        static /* synthetic */ SimpleDataSourceTable[] access$202(SimpleDataSource x0, SimpleDataSourceTable[] x1) {
            x0.tables = x1;
            return x1;
        }
    }

    private class Test {
        Select sql;
        Object[][] data;

        private Test() {
        }
    }
}

