/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class ScenarioProtectRecord
extends Record {
    public static final short sid = 221;
    private short field_1_protect;

    public ScenarioProtectRecord() {
    }

    public ScenarioProtectRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 221) {
            throw new RecordFormatException("NOT A SCENARIOPROTECT RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_protect = in.readShort();
    }

    public void setProtect(boolean protect) {
        this.field_1_protect = protect ? (short)1 : 0;
    }

    public boolean getProtect() {
        return this.field_1_protect == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SCENARIOPROTECT]\n");
        buffer.append("    .protect         = ").append(this.getProtect()).append("\n");
        buffer.append("[/SCENARIOPROTECT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)221);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_protect);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 221;
    }

    public Object clone() {
        ScenarioProtectRecord rec = new ScenarioProtectRecord();
        rec.field_1_protect = this.field_1_protect;
        return rec;
    }
}

