/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.IJ;
import ij.gui.GenericDialog;
import loci.common.Location;
import loci.formats.FilePattern;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;

public class FilePatternDialog
extends ImporterDialog {
    public FilePatternDialog(ImportProcess process) {
        super(process);
    }

    protected boolean needPrompt() {
        return !this.process.isWindowless() && this.options.isGroupFiles();
    }

    protected GenericDialog constructDialog() {
        Location idLoc = new Location(this.options.getId());
        String id = FilePattern.findPattern(idLoc);
        if (id == null) {
            if (!this.options.isQuiet()) {
                IJ.showMessage((String)"Bio-Formats", (String)"Warning: Bio-Formats was unable to determine a grouping that\nincludes the file you chose. The most common reason for this\nsituation is that the folder contains extraneous files with\nsimilar names and numbers that confuse the detection algorithm.\n \nFor example, if you have multiple datasets in the same folder\nnamed series1_z*_c*.tif, series2_z*_c*.tif, etc., Bio-Formats\nmay try to group all such files into a single series.\n \nFor best results, put each image series's files in their own\nfolder, or type in a file pattern manually.\n");
            }
            id = idLoc.getAbsolutePath();
        }
        GenericDialog gd = new GenericDialog("Bio-Formats File Stitching");
        int len = id.length() + 1;
        if (len > 80) {
            len = 80;
        }
        gd.addStringField("Pattern: ", id, len);
        return gd;
    }

    protected boolean harvestResults(GenericDialog gd) {
        String id = gd.getNextString();
        this.options.setId(id);
        return true;
    }
}

