/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;

public class CellSensReader
extends FormatReader {
    private static final int TILE_SIZE = 512;
    private String[] usedFiles;
    private TiffParser parser;
    private IFDList ifds;
    private Long[][] tileOffsets;
    private boolean jpeg = false;
    private int[] rows;
    private int[] cols;

    public CellSensReader() {
        super("CellSens VSI", "vsi");
        this.domains = new String[]{"Histology"};
        this.suffixSufficient = true;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.usedFiles;
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int currentSeries = this.getSeries();
        if (currentSeries >= this.usedFiles.length - 1) {
            return super.openThumbBytes(no);
        }
        this.setSeries(this.usedFiles.length);
        byte[] thumb = FormatTools.openThumbBytes(this, 0);
        this.setSeries(currentSeries);
        return thumb;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.getSeries() < this.getSeriesCount() - this.ifds.size()) {
            int tileRows = this.rows[this.getSeries()];
            int tileCols = this.cols[this.getSeries()];
            Region image = new Region(x, y, w, h);
            int outputRow = 0;
            int outputCol = 0;
            Region intersection = null;
            byte[] tileBuf = null;
            int pixel = this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType());
            int outputRowLen = w * pixel;
            for (int row = 0; row < tileRows; ++row) {
                for (int col = 0; col < tileCols; ++col) {
                    Region tile = new Region(col * 512, row * 512, 512, 512);
                    if (!tile.intersects(image)) continue;
                    intersection = tile.intersection(image);
                    int tileIndex = no * tileRows * tileCols + row * tileCols + col;
                    tileBuf = this.decodeTile(tileIndex);
                    int rowLen = pixel * Math.min(intersection.width, 512);
                    int outputOffset = outputRow * outputRowLen + outputCol;
                    for (int trow = 0; trow < intersection.height; ++trow) {
                        int realRow = trow + intersection.y - tile.y;
                        System.arraycopy(tileBuf, realRow * 512 * pixel, buf, outputOffset, rowLen);
                        outputOffset += outputRowLen;
                    }
                    outputCol += rowLen;
                }
                if (intersection == null) continue;
                outputRow += intersection.height;
                outputCol = 0;
            }
            return buf;
        }
        int ifdIndex = this.getSeries() - (this.usedFiles.length - 1);
        return this.parser.getSamples((IFD)this.ifds.get(ifdIndex), buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.parser = null;
            this.ifds = null;
            this.usedFiles = null;
            this.tileOffsets = null;
            this.jpeg = false;
            this.rows = null;
            this.cols = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] stackDirs;
        super.initFile(id);
        this.parser = new TiffParser(id);
        this.ifds = this.parser.getIFDs();
        RandomAccessInputStream vsi = new RandomAccessInputStream(id);
        vsi.order(this.parser.getStream().isLittleEndian());
        vsi.seek(this.parser.getStream().getFilePointer());
        vsi.skipBytes(273);
        ArrayList<String> files = new ArrayList<String>();
        Location file2 = new Location(id).getAbsoluteFile();
        Location dir = file2.getParentFile();
        String name = file2.getName();
        name = name.substring(0, name.lastIndexOf("."));
        Location pixelsDir = new Location(dir, "_" + name + "_");
        for (String f : stackDirs = pixelsDir.list(true)) {
            Location stackDir = new Location(pixelsDir, f);
            String[] pixelsFiles = stackDir.list(true);
            if (pixelsFiles == null) continue;
            for (String pixelsFile : pixelsFiles) {
                if (!CellSensReader.checkSuffix(pixelsFile, "ets")) continue;
                files.add(new Location(stackDir, pixelsFile).getAbsolutePath());
            }
        }
        files.add(file2.getAbsolutePath());
        this.usedFiles = files.toArray(new String[files.size()]);
        this.core = new CoreMetadata[files.size() - 1 + this.ifds.size()];
        this.tileOffsets = new Long[files.size() - 1][];
        this.rows = new int[files.size() - 1];
        this.cols = new int[files.size() - 1];
        IFDList exifs = this.parser.getExifIFDs();
        for (int s = 0; s < this.core.length; ++s) {
            this.core[s] = new CoreMetadata();
            if (s < files.size() - 1) {
                RandomAccessInputStream etsFile = new RandomAccessInputStream((String)files.get(s));
                ArrayList<Long> offsets = new ArrayList<Long>();
                byte[] buf = new byte[8192];
                etsFile.read(buf);
                while (etsFile.getFilePointer() < etsFile.length()) {
                    for (int i = 0; i < buf.length - 3; ++i) {
                        if (buf[i] == -1 && buf[i + 1] == 79 && buf[i + 2] == -1 && buf[i + 3] == 81) {
                            long fp = etsFile.getFilePointer();
                            etsFile.seek(fp - (long)buf.length + (long)i + 8L);
                            if (etsFile.readInt() == 512 && etsFile.readInt() == 512) {
                                offsets.add(fp - (long)buf.length + (long)i);
                            }
                            etsFile.seek(fp);
                            continue;
                        }
                        if (buf[i] != -1 || buf[i + 1] != -40) continue;
                        offsets.add(etsFile.getFilePointer() - (long)buf.length + (long)i);
                        this.jpeg = true;
                    }
                    buf[0] = buf[buf.length - 3];
                    buf[1] = buf[buf.length - 2];
                    buf[2] = buf[buf.length - 1];
                    etsFile.read(buf, 3, buf.length - 3);
                }
                this.tileOffsets[s] = offsets.toArray(new Long[offsets.size()]);
                byte[] b = this.decodeTile(0);
                int diff = 0;
                if (b != null) {
                    diff = b.length / 262144;
                }
                switch (diff) {
                    case 0: 
                    case 1: {
                        this.core[s].pixelType = 1;
                        this.core[s].sizeC = 1;
                        break;
                    }
                    case 2: {
                        this.core[s].pixelType = 3;
                        this.core[s].sizeC = 1;
                        break;
                    }
                    case 3: {
                        this.core[s].pixelType = 1;
                        this.core[s].sizeC = 3;
                    }
                }
                etsFile.close();
                boolean adjustedDimensions = false;
                if (s < exifs.size() && ((IFD)exifs.get(s)).containsKey(40962)) {
                    this.core[s].sizeX = ((IFD)exifs.get(s)).getIFDIntValue(40962);
                    this.core[s].sizeY = ((IFD)exifs.get(s)).getIFDIntValue(40963);
                    int maxTiles = (int)(0.75 * (double)this.tileOffsets[s].length);
                    int tileSize = 262144;
                    double ratio = (double)this.core[s].sizeY / (double)this.core[s].sizeX;
                    while ((long)this.core[s].sizeX * (long)this.core[s].sizeY / (long)tileSize > (long)maxTiles) {
                        adjustedDimensions = true;
                        this.core[s].sizeX -= 512;
                        this.core[s].sizeY -= (int)(ratio * 512.0);
                    }
                } else {
                    this.core[s].sizeX = vsi.readInt();
                    this.core[s].sizeY = vsi.readInt();
                }
                int tileRows = this.getSizeY() / 512;
                int tileCols = this.getSizeX() / 512;
                if (tileCols * 512 < this.getSizeX()) {
                    ++tileCols;
                }
                if (tileRows * 512 < this.getSizeY()) {
                    ++tileRows;
                }
                int c = 1;
                if (!adjustedDimensions) {
                    int totalTiles = 0;
                    while (totalTiles == 0 || this.tileOffsets[s].length % this.tileOffsets[s].length != 0) {
                        int row = tileRows;
                        int col = tileCols;
                        while (row > 1 || col > 1) {
                            totalTiles += row * col;
                            row = row / 2 + row % 2;
                            col = col / 2 + col % 2;
                        }
                        if (this.tileOffsets[s].length % ++totalTiles == 0) continue;
                        totalTiles = 0;
                        ++tileCols;
                    }
                    c = this.tileOffsets[s].length / totalTiles;
                }
                this.rows[s] = tileRows;
                this.cols[s] = tileCols;
                this.core[s].rgb = this.core[s].sizeC > 1;
                this.core[s].sizeC *= c;
                this.core[s].sizeZ = 1;
                this.core[s].sizeT = 1;
                this.core[s].imageCount = this.core[s].sizeZ * this.core[s].sizeT * c;
                this.core[s].littleEndian = false;
                this.core[s].interleaved = this.core[s].rgb;
            } else {
                IFD ifd = (IFD)this.ifds.get(s - files.size() + 1);
                PhotoInterp p = ifd.getPhotometricInterpretation();
                int samples = ifd.getSamplesPerPixel();
                this.core[s].rgb = samples > 1 || p == PhotoInterp.RGB;
                this.core[s].sizeX = (int)ifd.getImageWidth();
                this.core[s].sizeY = (int)ifd.getImageLength();
                this.core[s].sizeZ = 1;
                this.core[s].sizeT = 1;
                this.core[s].sizeC = this.core[s].rgb ? samples : 1;
                this.core[s].littleEndian = ifd.isLittleEndian();
                this.core[s].indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
                this.core[s].imageCount = 1;
                this.core[s].pixelType = ifd.getPixelType();
                this.core[s].interleaved = false;
                this.core[s].falseColor = false;
                this.core[s].thumbnail = s != 0;
            }
            this.core[s].dimensionOrder = "XYCZT";
            this.core[s].metadataComplete = true;
        }
        vsi.close();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private int getTileSize() {
        int channels = this.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        return bpp * channels * 512 * 512;
    }

    private byte[] decodeTile(int index) throws FormatException, IOException {
        if (index >= this.tileOffsets[this.getSeries()].length) {
            return null;
        }
        Long offset = this.tileOffsets[this.getSeries()][index];
        RandomAccessInputStream ets = new RandomAccessInputStream(this.usedFiles[this.getSeries()]);
        ets.seek(offset);
        BaseCodec codec = null;
        CodecOptions options = new CodecOptions();
        options.interleaved = this.isInterleaved();
        options.littleEndian = this.isLittleEndian();
        int tileSize = this.getTileSize();
        if (tileSize == 0) {
            tileSize = 0x280000;
        }
        options.maxBytes = (int)(offset + (long)tileSize);
        codec = this.jpeg ? new JPEGCodec() : new JPEG2000Codec();
        byte[] buf = codec.decompress(ets, options);
        ets.close();
        return buf;
    }
}

