/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.ByteVector;
import loci.formats.codec.CodecOptions;

public class ZlibCodec
extends BaseCodec {
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("No data to compress");
        }
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        byte[] buf = new byte[8192];
        ByteVector bytes = new ByteVector();
        int r = 0;
        while ((r = deflater.deflate(buf, 0, buf.length)) > 0) {
            bytes.add(buf, 0, r);
        }
        return bytes.toByteArray();
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        InflaterInputStream i = new InflaterInputStream(in);
        ByteVector bytes = new ByteVector();
        byte[] buf = new byte[8192];
        int r = 0;
        try {
            while ((r = i.read(buf, 0, buf.length)) > 0) {
                bytes.add(buf, 0, r);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        return bytes.toByteArray();
    }
}

