/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.PageHeader;

final class DataPage
extends PageHeader {
    private static final short O_FIRST = 18;
    static final short O_DATA = 20;
    final short DATA_PER_PAGE;

    DataPage(BlockIo block, int blockSize) {
        super(block);
        this.DATA_PER_PAGE = (short)(blockSize - 20);
    }

    static DataPage getDataPageView(BlockIo block, int blockSize) {
        BlockView view = block.getView();
        if (view != null && view instanceof DataPage) {
            return (DataPage)view;
        }
        return new DataPage(block, blockSize);
    }

    short getFirst() {
        return this.block.readShort(18);
    }

    void setFirst(short value) {
        this.paranoiaMagicOk();
        if (value > 0 && value < 20) {
            throw new Error("DataPage.setFirst: offset " + value + " too small");
        }
        this.block.writeShort(18, value);
    }
}

