/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.IOError;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import jdbm.PrimaryMap;
import jdbm.PrimaryStoreMap;
import jdbm.RecordListener;
import jdbm.RecordManager;
import jdbm.Serializer;
import jdbm.helper.AbstractPrimaryMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryStoreMapImpl<K extends Long, V>
extends AbstractPrimaryMap<Long, V>
implements PrimaryStoreMap<K, V> {
    protected final PrimaryMap<Long, String> map;
    protected final Serializer<V> valueSerializer;
    protected final List<RecordListener<Long, V>> listeners = new CopyOnWriteArrayList<RecordListener<Long, V>>();

    public PrimaryStoreMapImpl(PrimaryMap<Long, String> map, Serializer<V> valueSerializer2) {
        this.map = map;
        this.valueSerializer = valueSerializer2;
        map.addRecordListener(new RecordListener<Long, String>(){

            @Override
            public void recordInserted(Long key, String value) throws IOException {
                Object v = PrimaryStoreMapImpl.this.getRecordManager().fetch(key, PrimaryStoreMapImpl.this.valueSerializer);
                for (RecordListener l : PrimaryStoreMapImpl.this.listeners) {
                    l.recordInserted(key, v);
                }
            }

            @Override
            public void recordRemoved(Long key, String value) throws IOException {
                Object deletedValue = PrimaryStoreMapImpl.this.getRecordManager().fetch(key, PrimaryStoreMapImpl.this.valueSerializer);
                for (RecordListener l : PrimaryStoreMapImpl.this.listeners) {
                    l.recordRemoved(key, deletedValue);
                }
                PrimaryStoreMapImpl.this.getRecordManager().delete(key);
            }

            @Override
            public void recordUpdated(Long key, String oldValue, String newValue) throws IOException {
                throw new InternalError("should not be here");
            }
        });
    }

    @Override
    public Long putValue(V v) {
        try {
            Long recid = this.getRecordManager().insert(v, this.valueSerializer);
            this.map.put(recid, "");
            return recid;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void addRecordListener(RecordListener<Long, V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public RecordManager getRecordManager() {
        return this.map.getRecordManager();
    }

    @Override
    public void removeRecordListener(RecordListener<Long, V> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return new AbstractSet<Map.Entry<Long, V>>(){

            protected Map.Entry<Long, V> newEntry(Long k, V v) {
                return new AbstractMap.SimpleEntry<Long, V>(k, v){

                    @Override
                    public V setValue(V arg0) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Long, V> e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(Object o) {
                Map.Entry e;
                return o instanceof Map.Entry && (e = (Map.Entry)o).getKey() != null && PrimaryStoreMapImpl.this.get(e.getKey()) != null;
            }

            @Override
            public Iterator<Map.Entry<Long, V>> iterator() {
                return new Iterator<Map.Entry<Long, V>>(){
                    final Iterator<Long> keyIter;
                    {
                        this.keyIter = PrimaryStoreMapImpl.this.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIter.hasNext();
                    }

                    @Override
                    public Map.Entry<Long, V> next() {
                        Long k = this.keyIter.next();
                        return this.newEntry(k, PrimaryStoreMapImpl.this.get(k));
                    }

                    @Override
                    public void remove() {
                        this.keyIter.remove();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    if (e.getKey() == null || e.getValue() == null) {
                        return false;
                    }
                    Object v = PrimaryStoreMapImpl.this.get(e.getKey());
                    if (v == null || !e.getValue().equals(v)) {
                        return false;
                    }
                    return PrimaryStoreMapImpl.this.remove(e.getKey()) != null;
                }
                return false;
            }

            @Override
            public int size() {
                return PrimaryStoreMapImpl.this.size();
            }
        };
    }

    @Override
    public V get(Object key) {
        if (!this.map.containsKey(key)) {
            return null;
        }
        try {
            return this.getRecordManager().fetch((Long)key, this.valueSerializer);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public Set<Long> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(Long key, V value) {
        if (this.containsKey(key)) {
            try {
                V oldVal = this.getRecordManager().fetch(key, this.valueSerializer, true);
                this.getRecordManager().update(key, value, this.valueSerializer);
                for (RecordListener<Long, V> listener : this.listeners) {
                    listener.recordUpdated(key, oldVal, value);
                }
                return oldVal;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        throw new UnsupportedOperationException("Can not update, key not found, use putValue(val) instead.");
    }

    @Override
    public V remove(Object key) {
        if (!this.map.containsKey(key)) {
            return null;
        }
        try {
            V v = this.getRecordManager().fetch((Long)key, this.valueSerializer);
            this.map.remove(key);
            return v;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

